/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexItemH264;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IMediaReaderCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunker;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.MediaReaderH264;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import java.util.ArrayList;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class MediaReaderH264Cupertino
extends MediaReaderH264
implements IMediaReaderCupertino {
    private int chunkDurationTolerance = 500;
    private int chunkDurationTarget = 10000;
    private int audioGroupCount = 3;
    private LiveStreamPacketizerCupertinoChunker chunker = null;
    private boolean init = true;
    private boolean reportVideoCodecInfo = true;
    private boolean reportAudioCodecInfo = true;
    private boolean forceH264BaselineProfile = false;
    private boolean debugAACTimecodes = false;
    private int aacAudioSampleRate = -1;
    private int aacAudioSampleCount = -1;
    private boolean debugMP3Timecodes = false;
    private int mp3AudioSampleRate = -1;
    private int mp3AudioSampleCount = -1;
    private byte[] mp3HeaderBuf = null;
    private MP3HeaderData mp3HeaderData = null;
    private long lastAACSampleRate = -1L;
    private long lastAACTimecode = -1L;
    private long lastMP3SampleRate = -1L;
    private long lastMP3Timecode = -1L;

    private void init(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        if (this.init) {
            IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = iHTTPStreamerCupertinoIndex.getApplicationContext();
            if (iHTTPStreamerApplicationContext != null) {
                WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
                WMSProperties wMSProperties2 = iHTTPStreamerApplicationContext.getAppInstance().getHTTPStreamerProperties();
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.audioGroupCount = wMSProperties.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
                this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties2.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties2.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
                this.debugAACTimecodes = wMSProperties.getPropertyBoolean("cupertinoDebugAACTimecodes", this.debugAACTimecodes);
                this.debugAACTimecodes = wMSProperties2.getPropertyBoolean("cupertinoDebugAACTimecodes", this.debugAACTimecodes);
                this.debugMP3Timecodes = wMSProperties.getPropertyBoolean("cupertinoDebugMP3Timecodes", this.debugMP3Timecodes);
                this.debugMP3Timecodes = wMSProperties2.getPropertyBoolean("cupertinoDebugMP3Timecodes", this.debugMP3Timecodes);
            }
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFile(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        this.init(iHTTPStreamerCupertinoIndex);
        Object object = this.lock;
        synchronized (object) {
            try {
                int n;
                long l;
                QTAtomtrak qTAtomtrak;
                Object object2;
                Object object3;
                AVCCData aVCCData;
                MediaCodecInfoAudio mediaCodecInfoAudio;
                long l2;
                long l3;
                iHTTPStreamerCupertinoIndex.setAudioCodec(this.audioCodec);
                QTAtommoov qTAtommoov = this.container.getMoovAtom();
                QTAtomtrak qTAtomtrak2 = qTAtommoov.getAudioTrack(this.trackIndexAudio);
                if (qTAtomtrak2 != null) {
                    QTAtomstbl qTAtomstbl;
                    double d = 0.0;
                    l3 = qTAtomtrak2.getMdiaAtom().getTimescale();
                    l2 = qTAtomtrak2.getMdiaAtom().getDuration();
                    d = (double)l2 / (double)l3;
                    long l4 = this.cursor.audioGetTotalTrackSize();
                    if (d >= 0.0) {
                        iHTTPStreamerCupertinoIndex.setAudioBitrate((int)Math.round((double)(l4 * 8L) / d));
                    }
                    QTAtomstbl qTAtomstbl2 = qTAtomstbl = qTAtomtrak2 == null ? null : qTAtomtrak2.getMdiaAtom().getMinfAtom().getStblAtom();
                    if (qTAtomstbl != null) {
                        mediaCodecInfoAudio = iHTTPStreamerCupertinoIndex.getCodecInfoAudio();
                        mediaCodecInfoAudio.setCodecId(this.audioCodec);
                        mediaCodecInfoAudio.setAudioChannels(qTAtomstbl.getAudioChannels());
                        mediaCodecInfoAudio.setAudioSampleFrequency((int)qTAtomtrak2.getMdiaAtom().getTimescale());
                        mediaCodecInfoAudio.setAudioSamplesPerFrame(1024);
                        mediaCodecInfoAudio.setAudioObjectType(2);
                        aVCCData = qTAtomstbl.getAVCCData();
                        if (aVCCData != null && (object3 = (Object)aVCCData.getAvccBytes()) != null) {
                            mediaCodecInfoAudio.setCodecConfig((byte[])object3);
                            if (this.audioCodec == 10 && (object2 = (Object)AACUtils.decodeAACCodecConfig((byte[])object3, (int)0)) != null) {
                                mediaCodecInfoAudio.setAudioObjectType(object2.getProfileObjectType());
                                mediaCodecInfoAudio.setAudioSamplesPerFrame(object2.getSampleCount());
                                mediaCodecInfoAudio.setAudioChannels(object2.getChannels());
                                mediaCodecInfoAudio.setAudioSampleFrequency(object2.getSampleRate());
                            }
                        }
                    }
                }
                if ((qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo)) != null) {
                    double d = 0.0;
                    long l5 = qTAtomtrak.getMdiaAtom().getTimescale();
                    l = qTAtomtrak.getMdiaAtom().getDuration();
                    d = (double)l / (double)l5;
                    long l6 = this.cursor.videoGetTotalTrackSize();
                    if (d >= 0.0) {
                        iHTTPStreamerCupertinoIndex.setVideoBitrate((int)Math.round((double)(l6 * 8L) / d));
                    }
                    QTAtomstbl qTAtomstbl = mediaCodecInfoAudio = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
                    if (mediaCodecInfoAudio != null && (aVCCData = mediaCodecInfoAudio.getAVCCData()) != null) {
                        object3 = iHTTPStreamerCupertinoIndex.getCodecInfoVideo();
                        object3.setCodecId(7);
                        object3.setVideoLevel(aVCCData.getAvcLevel());
                        object3.setVideoProfile(aVCCData.getAvcProfile());
                        object3.setVideoWidth(mediaCodecInfoAudio.getFrameWidth());
                        object3.setVideoHeight(mediaCodecInfoAudio.getFrameHeight());
                        object2 = aVCCData.getAvccBytes();
                        if (object2 != null) {
                            object3.setCodecConfig(object2);
                        }
                    }
                }
                if ((n = this.cursor.getVideoKeyFrameCount()) > 0) {
                    l3 = 0L;
                    l2 = 0L;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        long l7;
                        long l8;
                        long l9 = this.cursor.getVideoKeyFrameSample(i);
                        if (l9 < 0L || (l8 = this.cursor.videoTimecodeToTimeMillis(l7 = this.cursor.videoSampleToTimecode(l9))) - l3 < (long)(this.chunkDurationTarget - this.chunkDurationTolerance)) continue;
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n2);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l3);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(l8);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(l2);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(l9);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                        l3 = l8;
                        l2 = l9;
                    }
                    if (n > 0) {
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n2);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l3);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(this.duration);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(l2);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(-1L);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                    }
                } else {
                    iHTTPStreamerCupertinoIndex.setStreamMode(this.audioCodec == 2 ? 2 : 3);
                    l3 = 0L;
                    int n3 = 0;
                    do {
                        if (l3 + (l = (long)this.chunkDurationTarget) > this.duration) {
                            l = this.duration - l3;
                        }
                        if (l <= 0L) break;
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n3);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l3);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(l3 + l);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(-1L);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(-1L);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                    } while ((l3 += l) < this.duration);
                }
                IHTTPStreamerSession iHTTPStreamerSession = iHTTPStreamerCupertinoIndex.getHttpStreamerSession();
                if (iHTTPStreamerSession != null) {
                    HTTPStreamerFileInfo hTTPStreamerFileInfo = new HTTPStreamerFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), this.length, (double)this.duration / 1000.0);
                    iHTTPStreamerSession.putFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), hTTPStreamerFileInfo);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderH264Cupertino.class).error("MediaReaderH264Cupertino.indexFile:" + exception.toString());
            }
        }
    }

    private LiveStreamPacketizerCupertinoChunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new LiveStreamPacketizerCupertinoChunker();
            this.chunker.setAudioGroupCount(this.audioGroupCount);
            this.chunker.setForceH264BaselineProfile(this.forceH264BaselineProfile);
            if (this.forceH264BaselineProfile) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.getChunker[" + this.appInstance.getContextStr() + "/" + this.mediaName + "]: Forcing H.264 profile to Baseline level 3.0");
            }
        }
        return this.chunker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            block64: {
                try {
                    long l;
                    LiveStreamPacketizerCupertinoChunker liveStreamPacketizerCupertinoChunker = this.getChunker();
                    long l2 = iHTTPStreamerCupertinoIndexItem.getStartTimecode();
                    long l3 = iHTTPStreamerCupertinoIndexItem.getStopTimecode();
                    long l4 = ((HTTPStreamerCupertinoIndexItemH264)iHTTPStreamerCupertinoIndexItem).getStartVideoSample();
                    long l5 = ((HTTPStreamerCupertinoIndexItemH264)iHTTPStreamerCupertinoIndexItem).getLastVideoSample();
                    liveStreamPacketizerCupertinoChunk.setStartTimecode(l2);
                    liveStreamPacketizerCupertinoChunk.setDuration(l3 - l2);
                    if (!bl && l4 >= 0L) {
                        long l6 = this.cursor.getVideoSample();
                        if (l6 != l4) {
                            long l7 = this.cursor.videoSampleToTimecode(l4);
                            long l8 = this.cursor.videoTimecodeToTimeMillis(l7);
                            long l9 = this.cursor.audioTimeMillisToTimecode(l8);
                            long l10 = this.cursor.audioTimecodeToSample(l9);
                            if ((l9 = this.cursor.audioSampleToTimecode(l10)) < l7 && this.cursor.getAudioSampleValid(l10 + 1L)) {
                                l9 = this.cursor.audioSampleToTimecode(++l10);
                            }
                            H264StreamPosition h264StreamPosition = new H264StreamPosition(l10, l4);
                            this.setStreamPosition((IMediaReaderStreamPosition)h264StreamPosition);
                            this.cursor.resetVideoAtEnd();
                            this.cursor.resetAudioAtEnd();
                        }
                        ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                        long l11 = -1L;
                        long l12 = -1L;
                        long l13 = this.cursor.getAudioTimescale();
                        do {
                            int n;
                            Object object2;
                            Object object3;
                            Object object4;
                            int n2 = this.cursor.isCurrentAudio() ? 8 : 9;
                            long l14 = this.cursor.getTimeMillis();
                            long l15 = this.cursor.getTimeScaled(90000);
                            long l16 = this.cursor.getSample();
                            long l17 = this.getSampleDesc(this.cursor, l16, n2);
                            AMFPacket aMFPacket = null;
                            int n3 = 1;
                            int n4 = 0;
                            switch (n2) {
                                case 8: {
                                    if (l11 != l17) {
                                        byte[] byArray = this.getAudioCodecConfig(l17);
                                        if (byArray != null) {
                                            aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
                                            aMFPacket.setAbsTimecode(l14);
                                            arrayList.add(new CupertinoPacketHolder(aMFPacket, l15));
                                            object4 = aMFPacket.getData();
                                            object4[0] = (H264ReadAheadPacket)-81;
                                            System.arraycopy(byArray, 0, object4, 2, byArray.length);
                                            if (this.reportAudioCodecInfo) {
                                                object3 = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0);
                                                if (object3 != null) {
                                                    this.aacAudioSampleRate = object3.getSampleRate();
                                                    this.aacAudioSampleCount = object3.getSampleCount();
                                                    object2 = "mp4a.40." + object3.getProfileObjectType();
                                                    if (object3.getChannels() > 2 || object3.getSampleRate() > 48000) {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket[" + this.stream.getContextStr() + "][" + (String)object2 + "]: AAC Audio encoding settings are beyond iPhone/iPod touch recommendations (48KHz/stereo): " + object3.toString());
                                                    } else {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket[" + this.stream.getContextStr() + "][" + (String)object2 + "]: AAC Audio info: " + object3.toString());
                                                    }
                                                }
                                                this.reportAudioCodecInfo = false;
                                            }
                                        }
                                        l11 = l17;
                                    }
                                    if (this.aacAudioSampleRate > 0 && l13 != (long)this.aacAudioSampleRate) {
                                        if (this.lastAACSampleRate == -1L || this.lastAACSampleRate != (long)this.aacAudioSampleRate) {
                                            this.lastAACSampleRate = this.aacAudioSampleRate;
                                            this.lastAACTimecode = Math.round((double)(l14 * this.lastAACSampleRate) / 1000.0);
                                        } else {
                                            long l18 = this.lastAACTimecode + (long)this.aacAudioSampleCount;
                                            long l19 = Math.round((double)l18 * 1000.0 / (double)this.lastAACSampleRate);
                                            n = (int)Math.abs(l19 - l14);
                                            if (this.debugAACTimecodes) {
                                                System.out.println("AAC[iOS].[" + n + "]: " + l19 + ":" + l14 + ":" + this.lastAACSampleRate);
                                            }
                                            if (n <= 1) {
                                                l15 = Math.round((double)(l18 * 90000L) / (double)this.lastAACSampleRate);
                                                this.lastAACTimecode = l18;
                                            } else {
                                                this.lastAACTimecode = Math.round((double)(l14 * this.lastAACSampleRate) / 1000.0);
                                                if (this.debugAACTimecodes) {
                                                    System.out.println("AAC[iOS].reset: " + this.lastAACTimecode);
                                                }
                                            }
                                        }
                                    }
                                    if (this.audioCodec != 10) break;
                                    ++n3;
                                    break;
                                }
                                case 9: {
                                    if (l12 != l17) {
                                        byte[] byArray = this.getVideoCodecConfig(l17);
                                        if (byArray != null) {
                                            aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
                                            aMFPacket.setAbsTimecode(l14);
                                            arrayList.add(new CupertinoPacketHolder(aMFPacket, l15));
                                            object4 = aMFPacket.getData();
                                            object4[0] = (H264ReadAheadPacket)23;
                                            System.arraycopy(byArray, 0, object4, 5, byArray.length);
                                            if (this.reportVideoCodecInfo) {
                                                try {
                                                    object3 = H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5);
                                                    if (object3 != null) {
                                                        object2 = "avc1." + object3.profileIDC + "." + object3.levelIDC;
                                                        if (object3.profileIDC != 66 || object3.levelIDC > 30) {
                                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket[" + this.stream.getContextStr() + "][" + (String)object2 + "]: H.264 Video encoding settings are beyond iPhone/iPod touch recommendations (Baseline/3.0): " + object3.toString());
                                                        } else {
                                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket[" + this.stream.getContextStr() + "][" + (String)object2 + "]: H.264 Video info: " + object3.toString());
                                                        }
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                this.reportVideoCodecInfo = false;
                                            }
                                        }
                                        l12 = l17;
                                    }
                                    n3 += 4;
                                    n4 = this.cursor.getCTTSMillis();
                                }
                            }
                            int n5 = 0;
                            object4 = this.getReadAheadPacket(n2, l16);
                            if (object4 != null) {
                                n5 = (int)object4.getSize();
                            }
                            if (n5 > 0) {
                                aMFPacket = new AMFPacket(n2, 0, n5 + n3);
                                aMFPacket.setAbsTimecode(l14);
                                object3 = aMFPacket.getData();
                                object3[0] = this.getFirstByte(this.cursor);
                                if (n3 > 1) {
                                    object3[1] = 1;
                                }
                                if (n3 > 2) {
                                    object3[2] = (byte)(n4 >> 16 & 0xFF);
                                    object3[3] = (byte)(n4 >> 8 & 0xFF);
                                    object3[4] = (byte)(n4 >> 0 & 0xFF);
                                }
                                object2 = object4.getBuffer();
                                n = object4.boffset;
                                System.arraycopy(object2, n, object3, n3, n5);
                                if (n5 >= 5 && n2 == 8 && this.audioCodec == 2) {
                                    if (this.reportAudioCodecInfo) {
                                        String string = "mp4a.40.34";
                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket[" + this.stream.getContextStr() + "][" + string + "]: MP3 Audio info");
                                        this.reportAudioCodecInfo = false;
                                    }
                                    if (this.mp3AudioSampleRate < 0) {
                                        if (this.mp3HeaderBuf == null) {
                                            this.mp3HeaderBuf = new byte[4];
                                            this.mp3HeaderData = new MP3HeaderData();
                                        }
                                        System.arraycopy(aMFPacket.getData(), 1, this.mp3HeaderBuf, 0, 4);
                                        int n6 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.mp3HeaderBuf, (MP3HeaderData)this.mp3HeaderData);
                                        if (n6 != 0) {
                                            MP3BufferedDecoder.decodeHeader((int)n6, (int)0, (MP3HeaderData)this.mp3HeaderData);
                                            this.mp3AudioSampleRate = MP3BufferedDecoder.frequency((MP3HeaderData)this.mp3HeaderData);
                                            this.mp3AudioSampleCount = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)this.mp3HeaderData);
                                        }
                                    }
                                    if (this.mp3AudioSampleRate > 0 && l13 != (long)this.mp3AudioSampleRate) {
                                        if (this.lastMP3SampleRate == -1L || this.lastMP3SampleRate != (long)this.mp3AudioSampleRate) {
                                            this.lastMP3SampleRate = this.mp3AudioSampleRate;
                                            this.lastMP3Timecode = Math.round((double)(l14 * this.lastMP3SampleRate) / 1000.0);
                                        } else {
                                            long l20 = this.lastMP3Timecode + (long)this.mp3AudioSampleCount;
                                            long l21 = Math.round((double)l20 * 1000.0 / (double)this.lastMP3SampleRate);
                                            int n7 = (int)Math.abs(l21 - l14);
                                            if (this.debugMP3Timecodes) {
                                                System.out.println("MP3[iOS].tc[" + n7 + "]: " + l21 + ":" + l14 + ":" + this.lastMP3SampleRate + ":" + l13);
                                            }
                                            if (n7 <= 1) {
                                                l15 = Math.round((double)(l20 * 90000L) / (double)this.lastMP3SampleRate);
                                                this.lastMP3Timecode = l20;
                                            } else {
                                                this.lastMP3Timecode = Math.round((double)(l14 * this.lastMP3SampleRate) / 1000.0);
                                                if (this.debugMP3Timecodes) {
                                                    System.out.println("MP3[iOS].reset: " + this.lastMP3Timecode);
                                                }
                                            }
                                        }
                                    }
                                }
                                arrayList.add(new CupertinoPacketHolder(aMFPacket, l15));
                            }
                            this.cursor.moveNextSample();
                            if (this.cursor.isAtEnd()) break;
                            l6 = this.cursor.getVideoSample();
                        } while (l5 < 0L || l6 < l5);
                        liveStreamPacketizerCupertinoChunker.fillChunk(liveStreamPacketizerCupertinoChunk, arrayList, this.videoCodec, this.audioCodec);
                        break block64;
                    }
                    liveStreamPacketizerCupertinoChunk.setStreamMode(this.audioCodec == 2 ? 2 : 3);
                    long l22 = this.cursor.isAtEnd() ? 0L : this.cursor.getTimeMillis();
                    long l23 = l = this.cursor.isAtEnd() ? 0L : this.cursor.getTimeScaled(90000);
                    if (l22 < l2 || l22 >= l2 + (long)(this.chunkDurationTarget / 2)) {
                        long l24 = this.cursor.audioTimeMillisToTimecode(l2);
                        long l25 = this.cursor.audioTimecodeToSample(l24);
                        this.cursor.setAudioSample(l25);
                    }
                    ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                    long l26 = -1L;
                    do {
                        int n = this.cursor.isCurrentAudio() ? 8 : 9;
                        long l27 = this.cursor.getTimeMillis();
                        long l28 = this.cursor.getTimeScaled(90000);
                        long l29 = this.cursor.getSample();
                        long l30 = this.getSampleDesc(this.cursor, l29, n);
                        AMFPacket aMFPacket = null;
                        int n8 = 1;
                        int n9 = 0;
                        if (n == 8) {
                            Object object5;
                            Object object6;
                            if (l26 != l30) {
                                byte[] byArray = this.getAudioCodecConfig(l30);
                                if (byArray != null) {
                                    aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
                                    aMFPacket.setAbsTimecode(l27);
                                    arrayList.add(new CupertinoPacketHolder(aMFPacket, l28));
                                    object6 = aMFPacket.getData();
                                    object6[0] = (H264ReadAheadPacket)-81;
                                    System.arraycopy(byArray, 0, object6, 2, byArray.length);
                                    if (this.reportAudioCodecInfo) {
                                        object5 = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0);
                                        if (object5 != null) {
                                            if (object5.getChannels() > 2 || object5.getSampleRate() > 48000) {
                                                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket: Audio encoding settings are beyond iPhone/iPod touch recommendations (48KHz/stereo) [" + this.stream.getContextStr() + "]: " + object5.toString());
                                            } else {
                                                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket: Audio info[" + this.stream.getContextStr() + "]: " + object5.toString());
                                            }
                                        }
                                        this.reportAudioCodecInfo = false;
                                    }
                                }
                                l26 = l30;
                            }
                            if (this.audioCodec == 10) {
                                ++n8;
                            }
                            int n10 = 0;
                            object6 = this.getReadAheadPacket(n, l29);
                            if (object6 != null) {
                                n10 = (int)object6.getSize();
                            }
                            if (n10 > 0) {
                                aMFPacket = new AMFPacket(n, 0, n10 + n8);
                                aMFPacket.setAbsTimecode(l27);
                                arrayList.add(new CupertinoPacketHolder(aMFPacket, l28));
                                object5 = aMFPacket.getData();
                                object5[0] = this.getFirstByte(this.cursor);
                                if (n8 > 1) {
                                    object5[1] = 1;
                                }
                                if (n8 > 2) {
                                    object5[2] = (byte)(n9 >> 16 & 0xFF);
                                    object5[3] = (byte)(n9 >> 8 & 0xFF);
                                    object5[4] = (byte)(n9 >> 0 & 0xFF);
                                }
                                byte[] byArray = object6.getBuffer();
                                int n11 = object6.boffset;
                                System.arraycopy(byArray, n11, object5, n8, n10);
                            }
                        }
                        this.cursor.moveNextSample();
                    } while (!this.cursor.isAtEnd() && this.cursor.getTimeMillis() < l3);
                    liveStreamPacketizerCupertinoChunker.fillChunk(liveStreamPacketizerCupertinoChunk, arrayList, -1, this.audioCodec);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderH264Cupertino.class).error("MediaReaderH264Cupertino.fillChunk: " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
    }
}

