/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

public class RolloverLong {
    private int bits;
    private long upperlevel;
    private long lowerlevel;
    private long mask;
    private int section = 1;
    private long value = 0L;
    private long base = 0L;

    public RolloverLong(int n) {
        this.bits = n;
        this.upperlevel = 1L << n - 1;
        this.lowerlevel = 1L << n / 2;
        this.mask = (1L << n) - 1L;
    }

    public long get() {
        return this.value;
    }

    public long setAbs(long l) {
        return this.set(l & this.mask);
    }

    public long set(long l) {
        switch (this.section) {
            case 0: {
                if (l < this.lowerlevel || l >= this.upperlevel) break;
                this.base += 1L << this.bits;
                this.section = 1;
                break;
            }
            case 1: {
                if (l < this.upperlevel) break;
                this.section = 2;
                break;
            }
            case 2: {
                if (l >= this.lowerlevel) break;
                this.section = 0;
            }
        }
        switch (this.section) {
            case 0: {
                if (l >= this.upperlevel) {
                    this.value = this.base + l;
                    break;
                }
                this.value = this.base + (1L << this.bits) + l;
                break;
            }
            case 1: {
                this.value = this.base + l;
                break;
            }
            case 2: {
                this.value = this.base + l;
            }
        }
        return this.value;
    }

    public String toString() {
        return this.value + "";
    }
}

