/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.application;

import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionCounterSimple;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.util.VHostUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostWatchdog;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements IApplication {
    private String name = "";
    private Map<String, IApplicationInstance> appInstanceMap = new HashMap<String, IApplicationInstance>();
    private IVHost vhost;
    protected WMSProperties properties = new WMSProperties();
    private List<IApplicationInstanceNotify> applicationInstanceListeners = new ArrayList<IApplicationInstanceNotify>();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private IOPerformanceCounter[] ioPerformanceCounters = new IOPerformanceCounter[6];
    private IOPerformanceCounter ioPerformanceCounterLast = null;
    private IOPerformanceCounter[] ioPerformanceCountersLast = new IOPerformanceCounter[6];
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionCounterSimple[] connectionCounters = new ConnectionCounterSimple[6];
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();

    public Application(String string, IVHost iVHost) {
        this.name = string;
        this.vhost = iVHost;
        for (int i = 0; i < this.ioPerformanceCounters.length; ++i) {
            this.ioPerformanceCounters[i] = new IOPerformanceCounter();
            this.connectionCounters[i] = new ConnectionCounterSimple();
        }
    }

    public static byte[] getX() {
        return SK.X;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            for (String string : this.appInstanceMap.keySet()) {
                arrayList.add(new String(string));
            }
            for (String string : arrayList) {
                IApplicationInstance iApplicationInstance = this.getAppInstance(string);
                VHostUtils.clearLoggingContext();
                if (iApplicationInstance != null) {
                    this.removeAppInstance(iApplicationInstance, bl);
                }
                VHostUtils.clearLoggingContext();
            }
            arrayList.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.shutdown: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownAppInstance(String string) {
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            String string2 = ApplicationInstance.fixName(string);
            ApplicationInstance applicationInstance = (ApplicationInstance)this.appInstanceMap.get(string2);
            if (applicationInstance == null) {
            } else {
                applicationInstance.disconnectAllClients();
                this.removeAppInstance(applicationInstance, false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.shutdownAppInstance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInstanceCount() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.appInstanceMap.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.getInstanceCount: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAppInstanceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.appInstanceMap.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.getAppInstanceNames: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return arrayList;
    }

    @Override
    public void removeAppInstance(IApplicationInstance iApplicationInstance) {
        this.removeAppInstance(iApplicationInstance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAppInstance(IApplicationInstance iApplicationInstance, boolean bl) {
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            String string = iApplicationInstance.getName();
            ((ApplicationInstance)iApplicationInstance).addIOPerformance(this.ioPerformanceCounter);
            WMSLoggerFactory.getLoggerObj(iApplicationInstance).info(this.getName() + "/" + string, null, "application", "app-stop", 200, string);
            iApplicationInstance.shutdown(bl, true);
            this.notifyApplicationInstanceDestroy(iApplicationInstance);
            this.appInstanceMap.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.removeAppInstance: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWatchdog() {
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = System.currentTimeMillis();
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.appInstanceMap.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog1: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        for (String string : arrayList) {
            IApplicationInstance iApplicationInstance;
            boolean bl;
            block19: {
                bl = false;
                iApplicationInstance = null;
                VHostUtils.clearLoggingContext();
                wMSReadWriteLock.writeLock().lock();
                try {
                    iApplicationInstance = this.appInstanceMap.get(string);
                    if (iApplicationInstance == null) break block19;
                    WMSReadWriteLock wMSReadWriteLock2 = iApplicationInstance.getClientsLockObj();
                    int n = 0;
                    int n2 = 0;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    long l5 = 0L;
                    long l6 = 0L;
                    long l7 = 0L;
                    wMSReadWriteLock2.writeLock().lock();
                    try {
                        n = iApplicationInstance.getClientCount();
                        n2 = iApplicationInstance.getClientCountTotal();
                        l2 = ((ApplicationInstance)iApplicationInstance).getClientRemoveTime();
                        l3 = iApplicationInstance.getMediaCasterStreams().getMediaCasterCount();
                        l4 = iApplicationInstance.getRTPSessionCount();
                        l5 = iApplicationInstance.getHTTPStreamerSessionCount();
                        l6 = iApplicationInstance.getPublisherCount();
                        l7 = iApplicationInstance.getLastTouchTime();
                        int n3 = iApplicationInstance.getApplicationInstanceTouchTimeout();
                        long l8 = l - l2;
                        long l9 = iApplicationInstance.getApplicationTimeout();
                        if (n == 0 && l3 == 0L && l4 == 0L && l5 == 0L && l6 == 0L && n2 > 0 && l9 > 0L && l2 > 0L && l8 > l9 && (l7 < 0L || l - l7 > (long)n3)) {
                            this.removeAppInstance(iApplicationInstance, false);
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: " + exception.toString());
                    }
                    finally {
                        wMSReadWriteLock2.writeLock().unlock();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog2: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
            }
            if (iApplicationInstance != null && !bl) {
                ((ApplicationInstance)iApplicationInstance).doWatchdog();
            }
            VHostUtils.clearLoggingContext();
        }
    }

    @Override
    public String getApplicationPath() {
        String string = this.vhost.getHomePath() + "/applications/" + this.name;
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("getApplicationPath: mkdir: " + exception.toString());
        }
        return string;
    }

    @Override
    public String getConfigPath() {
        String string = this.vhost.getHomePath() + "/conf/" + this.name + "/Application.xml";
        File file = new File(string);
        if (!file.exists()) {
            string = this.vhost.getHomePath() + "/conf/Application.xml";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAppInstanceLoaded(String string) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.appInstanceMap.containsKey(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.isAppInstanceLoaded: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IApplicationInstance getAppInstance(String string) {
        String string2 = ApplicationInstance.fixName(string);
        IApplicationInstance iApplicationInstance = null;
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            iApplicationInstance = this.appInstanceMap.get(string2);
            if (iApplicationInstance == null) {
                iApplicationInstance = new ApplicationInstance(string2, this);
                this.appInstanceMap.put(string2, iApplicationInstance);
                WMSLoggerFactory.initContextLogging(iApplicationInstance);
                ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
                iApplicationInstance.getConnectionCounter().addConnectionListener(connectionNotifier);
                ((ApplicationInstance)iApplicationInstance).init();
                ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
                moduleFunctions.onAppStart(iApplicationInstance);
                this.notifyApplicationInstanceCreate(iApplicationInstance);
                ((ApplicationInstance)iApplicationInstance).notifyModuleLoadAll();
                WMSLoggerFactory.getLoggerObj(iApplicationInstance).info(this.getName() + "/" + string2, null, "application", "app-start", 200, string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.getAppInstance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        return iApplicationInstance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IVHost getVHost() {
        return this.vhost;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationInstanceListener(IApplicationInstanceNotify iApplicationInstanceNotify) {
        List<IApplicationInstanceNotify> list = this.applicationInstanceListeners;
        synchronized (list) {
            this.applicationInstanceListeners.add(iApplicationInstanceNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationInstanceListener(IApplicationInstanceNotify iApplicationInstanceNotify) {
        List<IApplicationInstanceNotify> list = this.applicationInstanceListeners;
        synchronized (list) {
            this.applicationInstanceListeners.remove(iApplicationInstanceNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
        ArrayList<IApplicationInstanceNotify> arrayList = null;
        List<IApplicationInstanceNotify> list = this.applicationInstanceListeners;
        synchronized (list) {
            arrayList = new ArrayList<IApplicationInstanceNotify>(this.applicationInstanceListeners);
        }
        for (IApplicationInstanceNotify iApplicationInstanceNotify : arrayList) {
            iApplicationInstanceNotify.onApplicationInstanceCreate(iApplicationInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
        ArrayList<IApplicationInstanceNotify> arrayList = null;
        List<IApplicationInstanceNotify> list = this.applicationInstanceListeners;
        synchronized (list) {
            arrayList = new ArrayList<IApplicationInstanceNotify>(this.applicationInstanceListeners);
        }
        for (IApplicationInstanceNotify iApplicationInstanceNotify : arrayList) {
            iApplicationInstanceNotify.onApplicationInstanceDestroy(iApplicationInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter updateIOPerformance() {
        boolean bl = false;
        ArrayList<IApplicationInstance> arrayList = null;
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList = new ArrayList<IApplicationInstance>(this.appInstanceMap.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.updateIOPerformance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        if (arrayList != null) {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: updateIOPerformance: " + arrayList.size());
            }
            for (ApplicationInstance applicationInstance : arrayList) {
                if (bl) {
                    WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: updateIOPerformance: " + applicationInstance.getName());
                }
                applicationInstance.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        return this.ioPerformanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter updateIOPerformance(int n) {
        ArrayList<IApplicationInstance> arrayList = null;
        WMSReadWriteLock wMSReadWriteLock = this.vhost.getApplicationLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList = new ArrayList<IApplicationInstance>(this.appInstanceMap.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.updateIOPerformance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (ApplicationInstance applicationInstance : arrayList) {
                applicationInstance.addIOPerformance(n, this.ioPerformanceCounters[n]);
            }
        }
        return this.ioPerformanceCounters[n];
    }

    public IOPerformanceCounter addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        this.updateIOPerformance();
        IOPerformanceCounter iOPerformanceCounter2 = this.ioPerformanceCounter.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.ioPerformanceCounterLast);
        this.ioPerformanceCounterLast = iOPerformanceCounter2;
        return this.ioPerformanceCounter;
    }

    public IOPerformanceCounter addIOPerformance(int n, IOPerformanceCounter iOPerformanceCounter) {
        this.updateIOPerformance(n);
        IOPerformanceCounter iOPerformanceCounter2 = this.ioPerformanceCounters[n].clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.ioPerformanceCountersLast[n]);
        this.ioPerformanceCountersLast[n] = iOPerformanceCounter2;
        return this.ioPerformanceCounters[n];
    }

    public long getMessagesInCount() {
        return this.ioPerformanceCounter.getMessagesInCount();
    }

    public long getMessagesInCountRate() {
        return this.ioPerformanceCounter.getMessagesInCountRate();
    }

    public long getMessagesOutCount() {
        return this.ioPerformanceCounter.getMessagesOutCount();
    }

    public long getMessagesOutCountRate() {
        return this.ioPerformanceCounter.getMessagesOutCountRate();
    }

    public long getMessagesInBytes() {
        return this.ioPerformanceCounter.getMessagesInBytes();
    }

    public double getMessagesInBytesRate() {
        return this.ioPerformanceCounter.getMessagesInBytesRate();
    }

    public long getMessagesOutBytes() {
        return this.ioPerformanceCounter.getMessagesOutBytes();
    }

    public double getMessagesOutBytesRate() {
        return this.ioPerformanceCounter.getMessagesOutBytesRate();
    }

    @Override
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @Override
    public ConnectionCounterSimple getConnectionCounter(int n) {
        return this.connectionCounters[n];
    }

    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    @Override
    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @Override
    public IOPerformanceCounter getIoPerformanceCounter(int n) {
        return this.ioPerformanceCounters[n];
    }

    @Override
    public String readAppConfig(String string) {
        String string2 = this.getConfigPath();
        return Server.readXMLConfig(string2);
    }

    @Override
    public boolean writeAppConfig(String string, String string2) {
        String string3 = this.getConfigPath();
        return Server.writeXMLConfig(string3, string2);
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private Application application = null;
        private byte[] control = null;

        public ConnectionNotifier(Application application2) {
            this.application = application2;
            this.control = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray = bigInteger.toByteArray();
            for (int i = 0; i < this.control.length; ++i) {
                int n = i;
                this.control[n] = (byte)(this.control[n] ^ byArray[(i + 11) % byArray.length]);
            }
        }

        private void checkLicense(byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("Application exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(1);
            }
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.application.connectionCounter.incrementAccept(connectionHolder, date, l, byArray);
            Application.this.connectionCounters[connectionHolder.getConnectionType()].incrementAccept(connectionHolder, date, l);
            this.checkLicense(byArray);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.application.connectionCounter.incrementReject(connectionHolder, n, date, l, byArray);
            Application.this.connectionCounters[connectionHolder.getConnectionType()].incrementReject(connectionHolder, n, date, l);
            this.checkLicense(byArray);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.application.connectionCounter.decrement(connectionHolder, bl, date, l, byArray);
            Application.this.connectionCounters[connectionHolder.getConnectionType()].decrement(connectionHolder, bl, date, l);
            this.checkLicense(byArray);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private Application application = null;

        public ConnectionValidator(Application application2) {
            this.application = application2;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
            }
            return ((VHost)this.application.vhost).getConnectionValidator().validateConnection(connectionCounter, connectionHolder, byArray);
        }
    }

    static class SK {
        static byte[] X = new byte[]{61, -43, 86, 41, 69, 84, 34, 68, -92, -97, 115};

        SK() {
        }
    }
}

