/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.authentication;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.authentication.AuthenticationItem;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;

public class AuthenticationFactory {
    public static IAuthenticate createInstance(IApplicationInstance iApplicationInstance, String string) {
        IAuthenticate iAuthenticate = null;
        try {
            IVHost iVHost = iApplicationInstance.getVHost();
            if (iVHost != null) {
                AuthenticationItem authenticationItem = iVHost.getAuthenticationList().getAuthenticationItem(string);
                if (authenticationItem == null) {
                    WMSLoggerFactory.getLogger(AuthenticationFactory.class).warn("AuthenticationFactory.createInstance: Authentication method is missing: " + string);
                } else {
                    Class<?> clazz;
                    String string2 = authenticationItem.getBaseClass();
                    if (string2 != null && string2.length() != 0 && (iAuthenticate = (IAuthenticate)(clazz = Class.forName(string2)).newInstance()) != null) {
                        iAuthenticate.init(iApplicationInstance, authenticationItem);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AuthenticationFactory.class).error("AuthenticationFactory.createInstance: " + exception.toString());
            exception.printStackTrace();
        }
        return iAuthenticate;
    }

    public static IAuthenticate createInstance(IVHost iVHost, String string) {
        IAuthenticate iAuthenticate = null;
        try {
            if (iVHost != null) {
                AuthenticationItem authenticationItem = iVHost.getAuthenticationList().getAuthenticationItem(string);
                if (authenticationItem == null) {
                    WMSLoggerFactory.getLogger(AuthenticationFactory.class).warn("AuthenticationFactory.createInstance: Authentication method is missing: " + string);
                } else {
                    Class<?> clazz;
                    String string2 = authenticationItem.getBaseClass();
                    if (string2 != null && string2.length() != 0 && (iAuthenticate = (IAuthenticate)(clazz = Class.forName(string2)).newInstance()) != null) {
                        iAuthenticate.init(iVHost, authenticationItem);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AuthenticationFactory.class).error("AuthenticationFactory.createInstance: " + exception.toString());
            exception.printStackTrace();
        }
        return iAuthenticate;
    }
}

