/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessionBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessions;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamURL;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.VHostWorkerThread;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public abstract class HTTPStreamerAdapterBase
implements IHTTPStreamerAdapter {
    public static final String QUERYSTR_SESSIONID = "wowzasessionid";
    public static final String QUERYSTR_AUDIOONLY = "wowzaaudioonly";
    public static final String DATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss";
    protected WMSProperties properties = new WMSProperties();
    protected HTTPStreamerItem httpStreamerItem = null;
    protected IVHost vhost = null;
    protected List<QuickFilter> filters = new ArrayList<QuickFilter>();
    protected String liveStreamPacketizer = null;
    protected String liveStreamRepeater = null;
    protected int newSessionTimeout = 3000;
    protected int validSessionTimeout = 12000;
    protected String httpStreamerAdapterName = null;
    protected String ID = "";
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);

    public WMSProperties getProperties() {
        return this.properties;
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.properties.putAll(wMSProperties);
    }

    public HTTPStreamerItem getHTTPStreamerItem() {
        return this.httpStreamerItem;
    }

    public void setHTTPStreamerItem(HTTPStreamerItem hTTPStreamerItem) {
        this.httpStreamerItem = hTTPStreamerItem;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public void init() {
        String string;
        if (this.httpStreamerItem != null && (string = this.httpStreamerItem.getRequestFilter()) != null) {
            String[] stringArray = string.split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0) continue;
                this.filters.add(new QuickFilter(string2));
            }
        }
        this.liveStreamPacketizer = this.httpStreamerItem.getLiveStreamPacketizer();
        this.liveStreamRepeater = this.httpStreamerItem.getLiveStreamRepeater();
        this.httpStreamerAdapterName = this.httpStreamerItem.getName();
        this.newSessionTimeout = this.getProperties().getPropertyInt("newSessionTimeout", this.newSessionTimeout);
        this.validSessionTimeout = this.getProperties().getPropertyInt("validSessionTimeout", this.validSessionTimeout);
    }

    public String getAdapterName() {
        return this.httpStreamerAdapterName;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public boolean isLive(IApplicationInstance iApplicationInstance) {
        boolean bl = iApplicationInstance.containsLiveStreamPacketizer(this.liveStreamPacketizer);
        boolean bl2 = iApplicationInstance.containsLiveStreamPacketizer(this.liveStreamRepeater);
        return bl || bl2;
    }

    public boolean isRepeater(IApplicationInstance iApplicationInstance) {
        boolean bl = iApplicationInstance.containsLiveStreamPacketizer(this.liveStreamRepeater);
        return bl;
    }

    public boolean canHandle(String string) {
        for (QuickFilter quickFilter : this.filters) {
            if (!quickFilter.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    protected void startLiveStreamRepeat(IApplicationInstance iApplicationInstance, String string) {
        String string2 = this.getStreamTypeStr();
        this.startLiveStreamRepeat(iApplicationInstance, string, this.liveStreamPacketizer, this.liveStreamRepeater, string2);
    }

    protected String getStreamTypeStr() {
        String string = this.properties.getPropertyStr("streamStreamType");
        string = this.properties.getPropertyStr("repeaterStreamType", string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLiveStreamRepeat(IApplicationInstance iApplicationInstance, String string, String string2, String string3, String string4) {
        block11: {
            try {
                IVHost iVHost = iApplicationInstance.getVHost();
                StreamList streamList = iVHost.getStreamTypes();
                StreamItem streamItem = streamList.getStreamDef(string4);
                String string5 = "httprepeater";
                string5 = streamItem.getProperties().getPropertyStr("mediaCasterType", string5);
                string5 = iApplicationInstance.getStreamProperties().getPropertyStr("mediaCasterType", string5);
                MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string5);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).warn("HTTPStreamerAdapterBase.startLiveStreamRepeat: MediaCaster type not found: " + string5);
                    break block11;
                }
                WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string, string2, string3);
                    if (mediaCasterStreamItem != null) {
                    } else {
                        mediaCasterStreamItem = mediaCasterStreamMap.acquire(string, string2, string3, mediaCasterItem);
                        if (mediaCasterStreamItem != null) {
                            mediaCasterStreamItem.release();
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.startStream: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.startLiveStreamRepeat: " + exception.toString());
            }
        }
    }

    protected IMediaStream createStream(IApplicationInstance iApplicationInstance, String string) {
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        int n = mediaStreamMap.getNextStreamIndex();
        IMediaStream iMediaStream = mediaStreamMap.getStreamClientless(n, string);
        return iMediaStream;
    }

    protected void initStream(IMediaStream iMediaStream, String string, String string2, boolean bl) {
        MediaStreamMap mediaStreamMap = iMediaStream.getStreams();
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
        String string3 = null;
        String string4 = "flv";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string, string4);
        string = stringArray[0];
        string4 = stringArray[1];
        boolean bl2 = string.indexOf("://") >= 0;
        int n = string.indexOf("?");
        if (!bl2 && n >= 0) {
            string = string.substring(0, n);
        }
        iMediaStream.setOpen(true);
        iMediaStream.setPlay(true);
        iMediaStream.setName(string, string3, string4, string2, 0.0, -1.0, 1);
        iMediaStream.setIsPlaying(true);
        IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
        if (bl && iMediaStreamPlay != null) {
            iMediaStreamPlay.reset(true);
            iMediaStreamPlay.interruptPlay();
            iMediaStreamPlay.startPlay();
        }
        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
        WMSLoggerFactory.getLogger(null).info(null, iMediaStream, "stream", "create", 200, null);
    }

    protected void dumpHeaders(IHTTPRequest iHTTPRequest) {
        Set<String> set = iHTTPRequest.getHeaderNames();
        for (String string : set) {
            String string2 = iHTTPRequest.getHeader(string);
            System.out.println(string + ":" + string2);
        }
    }

    protected String parseSessionId(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("[&]");
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string3 = stringArray[i].trim();
                if (string3.length() <= 0 || !string3.startsWith(QUERYSTR_SESSIONID) || (n = string3.indexOf("=")) < 0) continue;
                string2 = string3.substring(n + 1);
                break;
            }
        }
        return string2;
    }

    protected byte[] acceptNewConnection(IApplicationInstance iApplicationInstance, IHTTPStreamerSession iHTTPStreamerSession) {
        byte[] byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
            }
            iApplicationInstance.getConnectionCounter().acceptConnection(iHTTPStreamerSession.getConnectionHolder(), byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    protected byte[] rejectNewConnection(IApplicationInstance iApplicationInstance, IHTTPStreamerSession iHTTPStreamerSession, int n) {
        byte[] byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[(i + 11) % byArray2.length]);
            }
            iApplicationInstance.getConnectionCounter().rejectConnection(iHTTPStreamerSession.getConnectionHolder(), n, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    protected byte[] disconnectConnection(IHTTPStreamerSession iHTTPStreamerSession) {
        byte[] byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            IApplicationInstance iApplicationInstance = iHTTPStreamerSession.getAppInstance();
            if (iApplicationInstance != null) {
                BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
                byte[] byArray2 = bigInteger.toByteArray();
                for (int i = 0; i < byArray.length; ++i) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
                }
                iApplicationInstance.getConnectionCounter().disconnect(iHTTPStreamerSession.getConnectionHolder(), byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    protected byte[] validateNewConnection(IApplicationInstance iApplicationInstance, IHTTPStreamerSession iHTTPStreamerSession) {
        boolean bl = false;
        byte[] byArray = null;
        try {
            byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
            bl = iApplicationInstance.getConnectionCounter().validateNewConnection(iHTTPStreamerSession.getConnectionHolder(), byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (byte[])(bl ? byArray : null);
    }

    public int getIdleFrequency() {
        return this.httpStreamerItem.getIdleFrequency();
    }

    public String getRepeaterName(IApplicationInstance iApplicationInstance, String string) {
        return MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)string);
    }

    public String extractResolvedName(IApplicationInstance iApplicationInstance, String string) {
        String string2 = string;
        try {
            MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString(string);
            string = mediaCasterStreamId.getName();
            if (string.indexOf("://") >= 0) {
                String string3 = LiveMediaStreamURL.decodeURLToStreamName(string);
                if (string3 != null) {
                    string2 = string3;
                }
            } else {
                string2 = string;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.extractResolvedName: " + exception.toString());
        }
        return string2;
    }

    public IHTTPStreamerApplicationContext getHTTPStreamerAppContext(IVHost iVHost, String string, String string2, String string3) {
        return this.getHTTPStreamerAppContext(iVHost, string, string2, string3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHTTPStreamerApplicationContext getHTTPStreamerAppContext(IVHost iVHost, String string, String string2, String string3, boolean bl) {
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = null;
        WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            if (!bl && !iVHost.isApplicationLoaded(string)) {
                return iHTTPStreamerApplicationContext;
            }
            iApplication = iVHost.getApplication(string);
            if (iApplication != null) {
                if (!bl && !iApplication.isAppInstanceLoaded(string2)) {
                    return iHTTPStreamerApplicationContext;
                }
                iApplicationInstance = iApplication.getAppInstance(string2);
            }
            if (iApplicationInstance == null) return iHTTPStreamerApplicationContext;
            if (!iApplicationInstance.containsHTTPStreamer(this.httpStreamerAdapterName)) {
                return iHTTPStreamerApplicationContext;
            }
            iHTTPStreamerApplicationContext = iApplicationInstance.getHTTPStreamerApplicationContext(string3, true);
            return iHTTPStreamerApplicationContext;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).info("HTTPStreamerAdapterBase.getAppInstance: " + exception.toString());
            return iHTTPStreamerApplicationContext;
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPStreamerSession iHTTPStreamerSession, IApplicationInstance iApplicationInstance, String string) {
        IVHost iVHost = iApplicationInstance.getVHost();
        HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
        HTTPStreamerSessions hTTPStreamerSessions = hTTPStreamerContext.getSessions();
        iHTTPStreamerSession.setSessionId(hTTPStreamerSessions.getNextSessionId(string));
        iHTTPStreamerSession.setVHost(iVHost);
        iHTTPStreamerSession.setSessionTimeout(this.newSessionTimeout);
        iHTTPStreamerSession.setTimeoutSession(true);
        iHTTPStreamerSession.setHTTPStreamerAdapter(this);
        iHTTPStreamerSession.setAppInstance(iApplicationInstance);
        hTTPStreamerSessions.addSession(iHTTPStreamerSession);
        return iHTTPStreamerSession;
    }

    protected void notifySessionCreate(IHTTPStreamerSession iHTTPStreamerSession, IApplicationInstance iApplicationInstance) {
        IVHost iVHost = iApplicationInstance.getVHost();
        HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
        HTTPStreamerSessions hTTPStreamerSessions = hTTPStreamerContext.getSessions();
        try {
            hTTPStreamerSessions.notifySessionCreate(iHTTPStreamerSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.notifySessionCreate: notifySessionCreate: " + exception.toString());
        }
        try {
            iApplicationInstance.getModFunctions().onHTTPSessionCreate(iHTTPStreamerSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.notifySessionCreate: onHTTPSessionCreate: " + exception.toString());
        }
        if (iHTTPStreamerSession instanceof HTTPStreamerSessionCupertino) {
            try {
                iApplicationInstance.getModFunctions().onHTTPCupertinoStreamingSessionCreate((HTTPStreamerSessionCupertino)iHTTPStreamerSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.notifySessionCreate: onHTTPCupertinoStreamingSessionCreate: " + exception.toString());
            }
        }
        if (iHTTPStreamerSession instanceof HTTPStreamerSessionSmoothStreamer) {
            try {
                iApplicationInstance.getModFunctions().onHTTPSmoothStreamingSessionCreate((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.notifySessionCreate: onHTTPSmoothStreamingSessionCreate: " + exception.toString());
            }
        }
        if (iHTTPStreamerSession.getSessionProtocol() == 2) {
            try {
                iApplicationInstance.getModFunctions().onHTTPSanJoseStreamingSessionCreate((HTTPStreamerSessionSanJose)iHTTPStreamerSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).error("HTTPStreamerAdapterBase.notifySessionCreate: onHTTPSanJoseStreamingSessionCreate: " + exception.toString());
            }
        }
    }

    public void shutdownSession(IHTTPStreamerSession iHTTPStreamerSession) {
        byte[] byArray;
        if (iHTTPStreamerSession.isActive() && (byArray = this.disconnectConnection(iHTTPStreamerSession)) != null) {
            HTTPStreamerAdapterBase.checkDisconnectLicense(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markSessionValid(IApplicationInstance iApplicationInstance, String string, String string2, String string3, String string4, IHTTPStreamerSession iHTTPStreamerSession, String string5) {
        iHTTPStreamerSession.setIpAddress(string5);
        if (iApplicationInstance == null) {
            iHTTPStreamerSession.setActive(false);
        } else {
            byte[] byArray = this.validateNewConnection(iApplicationInstance, iHTTPStreamerSession);
            if (byArray == null) {
                iHTTPStreamerSession.setActive(false);
                iHTTPStreamerSession.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(iApplicationInstance).info(null, null, string4, "connect", 413, iHTTPStreamerSession.getSessionId());
                iHTTPStreamerSession.clearLoggingValues();
            } else {
                HTTPStreamerAdapterBase.checkValidateLicense(byArray);
                byte[] byArray2 = this.acceptNewConnection(iApplicationInstance, iHTTPStreamerSession);
                if (byArray2 == null) {
                    iHTTPStreamerSession.setActive(false);
                    iHTTPStreamerSession.updateLoggingValues();
                    WMSLoggerFactory.getLoggerObj(iApplicationInstance).info(null, null, string4, "connect", 413, iHTTPStreamerSession.getSessionId());
                    iHTTPStreamerSession.clearLoggingValues();
                } else {
                    Object object;
                    HTTPStreamerAdapterBase.checkLicense(byArray2);
                    iApplicationInstance.addHTTPStreamerSession(iHTTPStreamerSession);
                    Object object2 = object = iHTTPStreamerSession.getLock();
                    synchronized (object2) {
                        iHTTPStreamerSession.setSessionTimeout(this.validSessionTimeout);
                        ((HTTPStreamerSessionBase)iHTTPStreamerSession).setValidated(true);
                    }
                    iHTTPStreamerSession.updateLoggingValues();
                    WMSLoggerFactory.getLoggerObj(iApplicationInstance).info(null, null, string4, "connect", 200, iHTTPStreamerSession.getSessionId());
                    iHTTPStreamerSession.clearLoggingValues();
                    boolean bl = this.isRepeater(iApplicationInstance);
                    String string6 = this.properties.getPropertyStr("streamStreamType");
                    if (bl) {
                        string6 = this.properties.getPropertyStr("repeaterStreamType", string6);
                    }
                    IMediaStream iMediaStream = this.createStream(iApplicationInstance, string6);
                    iMediaStream.setHTTPStreamerSession(iHTTPStreamerSession);
                    iMediaStream.setLiveStreamPacketizer(this.liveStreamPacketizer);
                    iMediaStream.setLiveStreamRepeater(this.liveStreamRepeater);
                    if (string2.equals("smil")) {
                        iMediaStream.setMediaCasterPlay(false);
                    }
                    this.initStream(iMediaStream, string, string3, bl);
                    iHTTPStreamerSession.setStream(iMediaStream);
                }
            }
        }
    }

    private static void checkValidateLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray4[(i + 3) % byArray4.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray3[(i + 8) % byArray3.length]);
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray4[(i + 2) % byArray4.length]);
            int n4 = i;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray3[(i + 1) % byArray3.length]);
            if (byArray2[i] == byArray[i]) continue;
            WMSLoggerFactory.getLogger(null).error("validateNewConnection exit:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    private static void checkDisconnectLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bail1:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    private static void checkLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            byte by = byArray2[i];
            int n = i;
            byte by2 = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            byArray2[n] = by2;
            byte by3 = by2;
            int n2 = i;
            byte by4 = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            byArray2[n2] = by4;
            byte by5 = by4;
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bail2[" + i + "]:" + byArray[i] + "!=" + byArray2[i] + " (" + by + ":" + by3 + ":" + by5 + ")" + " (" + byArray3.length + ":" + byArray4.length + ") (" + byArray.length + ":" + ModuleConnect.lc.length + ":" + byArray2.length + ")");
            System.exit(1);
        }
    }

    public HTTPStreamerStreamNameParts resolveStreamName(IHTTPStreamerSession iHTTPStreamerSession, IApplicationInstance iApplicationInstance, boolean bl, String string) {
        HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = null;
        if (iHTTPStreamerSession != null) {
            hTTPStreamerStreamNameParts = iHTTPStreamerSession.getStreamNameParts(string);
        }
        boolean bl2 = false;
        if (hTTPStreamerStreamNameParts == null) {
            hTTPStreamerStreamNameParts = new HTTPStreamerStreamNameParts();
            bl2 = true;
            hTTPStreamerStreamNameParts.originalName = string;
            hTTPStreamerStreamNameParts.streamExt = null;
            hTTPStreamerStreamNameParts.resolvedName = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string, iHTTPStreamerSession);
            String[] stringArray = ModuleUtils.decodeStreamExtension(hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt);
            hTTPStreamerStreamNameParts.resolvedName = stringArray[0];
            hTTPStreamerStreamNameParts.streamExt = stringArray[1];
            hTTPStreamerStreamNameParts.repeaterName = hTTPStreamerStreamNameParts.resolvedName;
            if (bl && hTTPStreamerStreamNameParts.repeaterName != null) {
                hTTPStreamerStreamNameParts.repeaterName = this.getRepeaterName(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
                hTTPStreamerStreamNameParts.resolvedName = this.extractResolvedName(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
            }
            if (hTTPStreamerStreamNameParts.streamExt == null) {
                String string2 = hTTPStreamerStreamNameParts.resolvedName.toLowerCase();
                hTTPStreamerStreamNameParts.streamExt = string2.endsWith(".smil") || string2.endsWith(".smi") ? "smil" : "mp4";
            }
        }
        if (bl2 && iHTTPStreamerSession != null) {
            iHTTPStreamerSession.putStreamNameParts(string, hTTPStreamerStreamNameParts);
        }
        return hTTPStreamerStreamNameParts;
    }

    public String getHTTPDate() {
        return this.fastDateFormat.format(new Date()) + " GMT";
    }

    public String getStreamDomainStr(IApplicationInstance iApplicationInstance, String string) {
        return iApplicationInstance.getVHost().getName() + ":" + iApplicationInstance.getContextStr() + "/" + string;
    }

    public void setThreadContext(IApplicationInstance iApplicationInstance) {
        if (Thread.currentThread() instanceof VHostWorkerThread) {
            ((VHostWorkerThread)Thread.currentThread()).setAppInstance(iApplicationInstance);
        }
    }

    class QuickFilter {
        public static final int FILTER_UNKNOWN = -1;
        public static final int FILTER_STARTSWITH = 1;
        public static final int FILTER_ENDSWITH = 2;
        public static final int FILTER_REGEX = 3;
        public static final int FILTER_MATCHALL = 4;
        private String filter = null;
        private String testStr = null;
        private int filterType = -1;

        public QuickFilter(String string) {
            this.filter = string;
            if (string.equals("*")) {
                this.filterType = 4;
            } else if (string.startsWith("*")) {
                this.filterType = 2;
                this.testStr = this.filter.substring(1);
            } else if (string.endsWith("*")) {
                this.filterType = 1;
                this.testStr = this.filter.substring(0, this.filter.length() - 1);
            } else {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterBase.class).warn("HTTPStreamerAdapterBase.QuickFilter: Cannot handle this filter: " + string);
            }
        }

        boolean isMatch(String string) {
            switch (this.filterType) {
                case 4: {
                    return true;
                }
                case 1: {
                    return string.startsWith(this.testStr);
                }
                case 2: {
                    return string.endsWith(this.testStr);
                }
            }
            return false;
        }
    }
}

