/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.model;

import com.wowza.util.BufferUtils;
import com.wowza.wms.media.model.MediaCodecInfoBase;

public class MediaCodecInfoAudio
extends MediaCodecInfoBase {
    protected int audioSampleFrequency = 0;
    protected int audioChannels = 0;
    protected int audioSamplesPerFrame = 0;
    protected int audioObjectType = 0;

    public MediaCodecInfoAudio() {
        this.type = 8;
    }

    public boolean equals(MediaCodecInfoAudio mediaCodecInfoAudio) {
        return super.equals(mediaCodecInfoAudio) && this.audioSampleFrequency == mediaCodecInfoAudio.audioSampleFrequency && this.audioChannels == mediaCodecInfoAudio.audioChannels && this.audioSamplesPerFrame == mediaCodecInfoAudio.audioSamplesPerFrame && this.audioObjectType == mediaCodecInfoAudio.audioObjectType;
    }

    public void deepCopy(MediaCodecInfoAudio mediaCodecInfoAudio) {
        super.deepCopy(mediaCodecInfoAudio);
        this.audioSampleFrequency = mediaCodecInfoAudio.audioSampleFrequency;
        this.audioChannels = mediaCodecInfoAudio.audioChannels;
        this.audioSamplesPerFrame = mediaCodecInfoAudio.audioSamplesPerFrame;
        this.audioObjectType = mediaCodecInfoAudio.audioObjectType;
    }

    public int getAudioSampleFrequency() {
        return this.audioSampleFrequency;
    }

    public void setAudioSampleFrequency(int n) {
        this.audioSampleFrequency = n;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int n) {
        this.audioChannels = n;
    }

    public int getAudioSamplesPerFrame() {
        return this.audioSamplesPerFrame;
    }

    public void setAudioSamplesPerFrame(int n) {
        this.audioSamplesPerFrame = n;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public void setAudioObjectType(int n) {
        this.audioObjectType = n;
    }

    public int getSerializeSize() {
        return super.getSerializeSize() + 16;
    }

    public int serialize(byte[] byArray, int n) {
        n = super.serialize(byArray, n);
        BufferUtils.intToByteArray(this.audioSampleFrequency, byArray, n, 4);
        BufferUtils.intToByteArray(this.audioChannels, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.audioSamplesPerFrame, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.audioObjectType, byArray, n += 4, 4);
        return n += 4;
    }

    public int deserialize(byte[] byArray, int n, int n2) {
        n = super.deserialize(byArray, n, n2);
        this.audioSampleFrequency = BufferUtils.byteArrayToInt(byArray, n, 4);
        this.audioChannels = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.audioSamplesPerFrame = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.audioObjectType = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        return n += 4;
    }
}

