/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.model;

import com.wowza.util.BufferUtils;
import com.wowza.wms.media.model.IMediaCodecInfo;
import java.util.Arrays;

public abstract class MediaCodecInfoBase
implements IMediaCodecInfo {
    protected int type = -1;
    protected int codecId = -1;
    protected byte[] codecConfig = null;

    public void deepCopy(MediaCodecInfoBase mediaCodecInfoBase) {
        this.type = mediaCodecInfoBase.type;
        this.codecId = mediaCodecInfoBase.codecId;
        this.codecConfig = null;
        if (mediaCodecInfoBase.codecConfig != null) {
            this.codecConfig = new byte[mediaCodecInfoBase.codecConfig.length];
            System.arraycopy(mediaCodecInfoBase.codecConfig, 0, this.codecConfig, 0, this.codecConfig.length);
        }
    }

    public boolean equals(MediaCodecInfoBase mediaCodecInfoBase) {
        return this.type == mediaCodecInfoBase.type && this.codecId == mediaCodecInfoBase.codecId && Arrays.equals(this.codecConfig, mediaCodecInfoBase.codecConfig);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAudio() {
        return this.type == 8;
    }

    public boolean isVideo() {
        return this.type == 9;
    }

    public int getCodecId() {
        return this.codecId;
    }

    public void setCodecId(int n) {
        this.codecId = n;
    }

    public byte[] getCodecConfig() {
        return this.codecConfig;
    }

    public void setCodecConfig(byte[] byArray) {
        this.codecConfig = byArray;
    }

    public int getSerializeSize() {
        return 9 + (3 + (this.codecConfig != null ? this.codecConfig.length : 0));
    }

    public int serialize(byte[] byArray, int n) {
        byArray[n] = 1;
        BufferUtils.intToByteArray(this.type, byArray, ++n, 4);
        BufferUtils.intToByteArray(this.codecId, byArray, n += 4, 4);
        n += 4;
        if (this.codecConfig != null) {
            BufferUtils.intToByteArray(this.codecConfig.length, byArray, n, 3);
            System.arraycopy(this.codecConfig, 0, byArray, n += 3, this.codecConfig.length);
            n += this.codecConfig.length;
        } else {
            BufferUtils.intToByteArray(0, byArray, n, 3);
            n += 3;
        }
        return n;
    }

    public int deserialize(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        this.type = BufferUtils.byteArrayToInt(byArray, ++n, 4);
        this.codecId = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        int n3 = BufferUtils.byteArrayToInt(byArray, n += 4, 3);
        n += 3;
        if (n3 > 0) {
            this.codecConfig = new byte[n3];
            System.arraycopy(byArray, n, this.codecConfig, 0, n3);
            n += n3;
        }
        return n;
    }
}

