/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.stream.MediaStreamBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RTPSessionDescriptionDataProviderBasicRTSPRequest {
    private static final String CRLF_STR = "\r\n";
    Map<String, String> headers = new HashMap<String, String>();
    List<String> headerOrder = new ArrayList<String>();
    byte[] content = null;
    String command = "OPTIONS";
    String target = "/";
    String protocol = "RTSP/1.0";
    boolean handled = false;
    boolean isAuthResponse = false;
    String trackId = null;

    public RTPSessionDescriptionDataProviderBasicRTSPRequest clone() {
        RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
        rTPSessionDescriptionDataProviderBasicRTSPRequest.headers.putAll(this.headers);
        rTPSessionDescriptionDataProviderBasicRTSPRequest.headerOrder.addAll(this.headerOrder);
        rTPSessionDescriptionDataProviderBasicRTSPRequest.content = this.content;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.command = this.command;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.target = this.target;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.protocol = this.protocol;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.handled = false;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.isAuthResponse = this.isAuthResponse;
        rTPSessionDescriptionDataProviderBasicRTSPRequest.trackId = this.trackId;
        return rTPSessionDescriptionDataProviderBasicRTSPRequest;
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
        if (!this.headerOrder.contains(string)) {
            this.headerOrder.add(string);
        }
    }

    public void setCSeq(int n) {
        this.addHeader("CSeq", n + "");
    }

    public boolean containsHeader(String string) {
        return this.headers.containsKey(string);
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public void setContent(String string) {
        this.content = string.getBytes();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string.toUpperCase();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.command + " " + this.target + " " + this.protocol + "\n");
        for (String string : this.headerOrder) {
            String string2 = this.headers.get(string);
            stringBuffer.append(string + ": " + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    public byte[] getMessage() {
        byte[] byArray = null;
        try {
            if (this.content != null) {
                this.addHeader("Content-Length", "" + this.content.length);
            }
            if (!this.containsHeader("User-Agent")) {
                this.addHeader("User-Agent", "Wowza Media Server Pro (" + MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber() + ")");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.command + " " + this.target + " " + this.protocol + CRLF_STR);
            for (String object2 : this.headerOrder) {
                String n = this.headers.get(object2);
                stringBuffer.append(object2 + ": " + n + CRLF_STR);
            }
            stringBuffer.append(CRLF_STR);
            byte[] byArray2 = stringBuffer.toString().getBytes();
            int n = byArray2.length + (this.content == null ? 0 : this.content.length);
            int n2 = 0;
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
            if (this.content != null) {
                System.arraycopy(this.content, 0, byArray, n2, this.content.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPRequest.class).error("RTPSessionDescriptionDataProviderBasicRTSPRequest.getMessage: " + exception.toString());
        }
        return byArray;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean bl) {
        this.handled = bl;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String string) {
        this.trackId = string;
    }

    public boolean isAuthResponse() {
        return this.isAuthResponse;
    }

    public void setAuthResponse(boolean bl) {
        this.isAuthResponse = bl;
    }
}

