/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTCPEventNotify;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.model.RTPPort;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCPHandler {
    public static final int RTCPPACKETTYPE_SR = 200;
    public static final int RTCPPACKETTYPE_SDES = 202;
    private long timeSyncLastNTP = -1L;
    private long timeSyncLastRTP = -1L;
    private long timeSyncLastRTPMillis = -1L;
    private List<IRTCPEventNotify> eventListeners = new ArrayList<IRTCPEventNotify>();
    private long waitForSRTimecode = -1L;
    private long earliestTimecode = -1L;
    private long debugDebugBaseTimeMillis = -1L;
    private long debugDebugRtpTime = -1L;
    private RTPTrack rtpTrack = null;
    private RolloverLong rtpTime = new RolloverLong(32);
    private boolean isFirstFakeRR = true;
    private boolean sendRTCPRR = false;
    private IRTPDePacketizer depacketizer = null;
    private boolean reportTimescaleProblem = true;

    public RTCPHandler(IRTPDePacketizer iRTPDePacketizer) {
        this.depacketizer = iRTPDePacketizer;
    }

    private void sendRTCPRR(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        try {
            long l = 0L;
            if (n2 >= 8) {
                l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
            }
            RTPPort rTPPort = rTPTrack.getRTCPPort();
            byte[] byArray2 = new byte[8];
            byArray2[0] = 80;
            byArray2[1] = -55;
            byArray2[2] = 0;
            byArray2[3] = 1;
            BufferUtils.longToByteArray(l, byArray2, 4, 4);
            if (this.isFirstFakeRR) {
                WMSLoggerFactory.getLogger(RTCPHandler.class).info("RTCPHandler.sendFirstRTCPRR[" + l + "," + (rTPPort == null ? 0 : rTPPort.getInPort()) + "," + socketAddress + "]");
                this.isFirstFakeRR = false;
            }
            if (rTPPort != null) {
                rTPPort.sendResponse(byArray2, 0, byArray2.length, socketAddress);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTCPHandler.class).error("RTCPHandler.sendRTCPRR: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.rtpTrack == null) {
            RTPPort rTPPort;
            this.rtpTrack = rTPTrack;
            this.sendRTCPRR = true;
            if (this.depacketizer != null) {
                this.sendRTCPRR = this.depacketizer.getProperties().getPropertyBoolean("sendRTCPRR", this.sendRTCPRR);
            }
            if ((rTPPort = rTPTrack.getRTPPort()) != null && rTPPort.isMulticast()) {
                this.sendRTCPRR = false;
            }
        }
        try {
            rTPTrack.getRTPStream().touch();
            int n3 = 0;
            while (n2 - n3 >= 4) {
                int n4 = byArray[n + n3 + 1] & 0xFF;
                int n5 = byArray[n + n3 + 2] & 0xFF;
                n5 <<= 8;
                n5 += byArray[n + n3 + 3] & 0xFF;
                ++n5;
                n5 *= 4;
                RTPStream rTPStream = rTPTrack.getRTPStream();
                synchronized (rTPStream) {
                    if (n4 == 200) {
                        byte[] byArray2 = new byte[9];
                        byArray2[0] = 0;
                        System.arraycopy(byArray, n + n3 + 8, byArray2, 1, 8);
                        BigInteger bigInteger = new BigInteger(byArray2);
                        BigDecimal bigDecimal = new BigDecimal(bigInteger);
                        bigDecimal = bigDecimal.divide(new BigDecimal(4.294967296E9));
                        double d = bigDecimal.doubleValue();
                        long l = Math.round(d * 1000.0);
                        long l2 = BufferUtils.byteArrayToLong(byArray, n + n3 + 16, 4);
                        this.rtpTime.set(l2);
                        if (rTPTrack.getRTPStream().getAVSyncMethod() == 1) {
                            this.setTimeSyncValues(rTPTrack, l, this.rtpTime.get());
                        }
                        WMSLoggerFactory.getLogger(RTCPHandler.class).debug("RTCPPACKETTYPE_SR[" + rTPTrack.getTrackId() + "]: base:" + l + " rtp:" + this.rtpTime.get());
                    } else if (n4 == 202) {
                        int n6 = byArray[n + n3 + 0] & 0x1F;
                        WMSLoggerFactory.getLogger(RTCPHandler.class).debug("RTCPPACKETTYPE_SDES: " + n6);
                        int n7 = 4;
                        for (int i = 0; i < n6; ++i) {
                            long l = BufferUtils.byteArrayToLong(byArray, n + n3 + n7, 4);
                            n7 += 4;
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
                            do {
                                int n8 = BufferUtils.byteArrayToInt(byArray, n + n3 + n7, 1);
                                ++n7;
                                if (n8 == 0) {
                                    if (n7 % 4 != 0) {
                                        n7 += 4 - n7 % 4;
                                    }
                                    break;
                                }
                                String string = this.SDESItemIdToKey(n8, hashMap2);
                                String string2 = "";
                                int n9 = BufferUtils.byteArrayToInt(byArray, n + n3 + n7, 1);
                                ++n7;
                                if (n9 > 0) {
                                    string2 = BufferUtils.byteArrayToString(byArray, n + n3 + n7, n9);
                                    n7 += n9;
                                }
                                WMSLoggerFactory.getLogger(RTCPHandler.class).debug("RTCPPACKETTYPE_SDES: val: " + string + "=" + string2);
                                hashMap.put(string, string2);
                            } while (n3 + n7 < n2);
                            this.notifyEventSDES(rTPTrack, l, hashMap);
                        }
                    }
                }
                if ((n3 += n5) < n2) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTCPHandler.class).warn("RTCPHandler.handleMessage: " + exception.toString());
            exception.printStackTrace();
        }
        if (this.isSendRTCPRR() && socketAddress != null) {
            this.sendRTCPRR(socketAddress, rTPTrack, byArray, n, n2);
        }
    }

    private String SDESItemIdToKey(int n, Map<Integer, Integer> map) {
        String string = "UNKNOWN";
        switch (n) {
            case 1: {
                string = "CNAME";
                break;
            }
            case 2: {
                string = "NAME";
                break;
            }
            case 3: {
                string = "EMAIL";
                break;
            }
            case 4: {
                string = "PHONE";
                break;
            }
            case 5: {
                string = "LOC";
                break;
            }
            case 6: {
                string = "TOOL";
                break;
            }
            case 7: {
                string = "NOTE";
                break;
            }
            case 8: {
                string = "PRIV";
                break;
            }
            default: {
                string = "ITEM" + n;
            }
        }
        Integer n2 = new Integer(n);
        Integer n3 = map.get(n2);
        if (n3 != null) {
            int n4 = n3;
            string = string + "[" + ++n4 + "]";
            map.put(n2, n4);
        } else {
            map.put(n2, 0);
        }
        return string;
    }

    public synchronized void setTimeSyncValuesNow(long l) {
        this.timeSyncLastNTP = System.currentTimeMillis();
        this.timeSyncLastRTP = l;
        this.timeSyncLastRTPMillis = -1L;
    }

    public synchronized void setTimeSyncValuesRTPTimecode(long l) {
        this.timeSyncLastNTP = 0L;
        this.timeSyncLastRTP = 0L;
        this.timeSyncLastRTPMillis = 0L;
    }

    public synchronized void setTimeSyncValues(RTPTrack rTPTrack, long l, long l2) {
        if (this.timeSyncLastNTP == -1L || rTPTrack.getRTPStream().isResyncAudioVideoOnSR()) {
            this.timeSyncLastNTP = l;
            this.timeSyncLastRTP = l2;
            this.timeSyncLastRTPMillis = -1L;
        }
    }

    public synchronized boolean isTimeSyncReady(RTPTrack rTPTrack, long l) {
        boolean bl;
        if (this.earliestTimecode == -1L || l < this.earliestTimecode) {
            this.earliestTimecode = l;
        }
        if (rTPTrack.getRTPStream().isAVSyncNonSR()) {
            int n = rTPTrack.getRTPStream().getAVSyncMethod();
            if (this.timeSyncLastNTP == -1L) {
                if (n == 2) {
                    this.setTimeSyncValuesNow(l);
                } else if (n == 3) {
                    this.setTimeSyncValuesRTPTimecode(this.earliestTimecode);
                }
            }
            return true;
        }
        boolean bl2 = bl = this.timeSyncLastNTP != -1L;
        if (!bl) {
            if (this.waitForSRTimecode == -1L) {
                this.waitForSRTimecode = System.currentTimeMillis();
            } else {
                int n = rTPTrack.getRTPStream().getMaxRTCPWaitTime();
                if (n > 0 && System.currentTimeMillis() - this.waitForSRTimecode > (long)n) {
                    WMSLoggerFactory.getLogger(RTCPHandler.class).warn("RTCPHandler.isTimeSyncReady: Hit MaxRTCPWaitTime synchronizing on system clock.");
                    rTPTrack.getRTPStream().setAVSyncMethod(3);
                    this.setTimeSyncValuesRTPTimecode(this.earliestTimecode);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public synchronized long convertTimeSyncTimecode(long l, long l2) {
        if (l2 <= 0L) {
            if (this.reportTimescaleProblem) {
                WMSLoggerFactory.getLogger(RTCPHandler.class).warn("RTCPHandler.convertTimeSyncTimecode: Invalid timescale value: " + l2);
                this.reportTimescaleProblem = false;
            }
            l2 = 1000L;
        }
        if (this.timeSyncLastRTPMillis == -1L) {
            this.timeSyncLastRTPMillis = Math.round((double)this.timeSyncLastRTP * 1000.0 / (double)l2);
        }
        return this.timeSyncLastNTP + l * 1000L / l2 - this.timeSyncLastRTPMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IRTCPEventNotify iRTCPEventNotify) {
        List<IRTCPEventNotify> list = this.eventListeners;
        synchronized (list) {
            this.eventListeners.add(iRTCPEventNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(IRTCPEventNotify iRTCPEventNotify) {
        List<IRTCPEventNotify> list = this.eventListeners;
        synchronized (list) {
            this.eventListeners.remove(iRTCPEventNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEventSDES(RTPTrack rTPTrack, long l, Map<String, String> map) {
        ArrayList<IRTCPEventNotify> arrayList = null;
        List<IRTCPEventNotify> list = this.eventListeners;
        synchronized (list) {
            arrayList = new ArrayList<IRTCPEventNotify>(this.eventListeners);
        }
        for (IRTCPEventNotify iRTCPEventNotify : arrayList) {
            iRTCPEventNotify.onSDES(rTPTrack, l, map);
        }
    }

    public boolean isSendRTCPRR() {
        return this.sendRTCPRR;
    }

    public void setSendRTCPRR(boolean bl) {
        this.sendRTCPRR = bl;
    }

    class RTCPTests {
        long baseTimecode = 0L;
        long rtpTimecode = 0L;

        public RTCPTests(long l, long l2) {
            this.baseTimecode = l;
            this.rtpTimecode = l2;
        }
    }
}

