/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.logging.WMSLoggingThrottle;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.ITranscode;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentListReader;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.util.RTPUtils;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class RTPDePacketizerMPEGTS
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    public static final String MPEGTSTRACKNAME_VIDEO = "mpegts-video";
    public static final String MPEGTSTRACKNAME_AUDIO = "mpegts-audio";
    public static final String MPEGTSTRACKNAME_TRANSPORT = "mpegts-transport";
    public static final int TS_PACKETLEN = 188;
    public static final int TS_RTPHEADER = 12;
    public static final int TS_SYNCBYTE = 71;
    public static final int TS_CONTINUITYOFFSET = 3;
    public static final int SPLICECOMMANDTYPE_SPLICENULL = 0;
    public static final int SPLICECOMMANDTYPE_SPLICESCHEDULE = 4;
    public static final int SPLICECOMMANDTYPE_SPLICEINSERT = 5;
    public static final int SPLICECOMMANDTYPE_TIMESIGNAL = 6;
    public static final int SPLICECOMMANDTYPE_BANDWIDTHRESERVATION = 7;
    public static final int SPLICECOMMANDTYPE_PRIVATECOMMAND = 255;
    private RTPSequence seq = new RTPSequence();
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private long lastTimecode = -1L;
    private long lastSeq = -1L;
    private boolean waitForEnd = true;
    private int waitForDropped = 0;
    private int networkPID = -1;
    private int programMapPID = -1;
    private int videoPID = -1;
    private int audioPID = -1;
    private int videoPIDFilter = -1;
    private int audioPIDFilter = -1;
    private boolean debugDetails = false;
    private boolean debugPackets = false;
    private RTPTrack audioRTPtrack = null;
    private RTPTrack videoRTPtrack = null;
    private boolean videoTrackIsMPEG2 = false;
    private int audioCodec = -1;
    private int audioBufferSize = -1;
    private int audioBufferPos = 0;
    private boolean audioFirstPacket = true;
    private RolloverLong audioTC = new RolloverLong(33);
    private RTPPacket audioWorkingPacket = new RTPPacket();
    private int audioBytesToSkip = 0;
    private int audioCodecStreamRate = -1;
    private int audioCodecChannels = -1;
    private boolean audioSendCodeConfig = false;
    private int audioIsMultiplePerPacket = 0;
    private boolean audioIsAligned = true;
    private byte[] audioBuffer = null;
    private byte[] audioBufferLeftover = null;
    private int audioBufferMaxSize = -1;
    private boolean reportedMPEGTSoverRTP = false;
    private int audioNextContinuityCounter = -1;
    private boolean audioContinuityCounterGood = true;
    private int videoNextContinuityCounter = -1;
    private boolean videoContinuityCounterGood = true;
    private boolean dropIncompleteVideoFrames = false;
    private boolean logIncompleteVideoFrames = false;
    private int videoCodec = -1;
    private int videoBufferSize = -1;
    private int videoBufferPos = 0;
    private boolean videoFirstPacket = true;
    private RolloverLong videoTC = new RolloverLong(33);
    private RolloverLong videoPTS = new RolloverLong(33);
    private boolean isVideoPTS = false;
    private RolloverLong videoDTS = new RolloverLong(33);
    private boolean isVideoDTS = false;
    private RTPPacket videoWorkingPacket = new RTPPacket();
    private int videoStartCodes = 0;
    private PendingFragment videoPendingFragment = new PendingFragment();
    private RTPPacketFragment videoNALSizeFragment = null;
    private int videoNALSize = 0;
    private boolean videoInNALUnit = false;
    private List<Integer> pids = new ArrayList<Integer>();
    private List<TempChunk> videoTempChunks = new ArrayList<TempChunk>();
    private int videoTempChunkLen = 0;
    private ITranscode videoTranscode = null;
    private int lastContinuity = -1;
    private int lastSyncPtr = -1;
    private byte[] lastSyncBuffer = null;
    private int lastSyncOffset = 0;
    private long debugLastVideoTC = -1L;
    private long debugLastAudioTC = -1L;
    private boolean adjustBFrameTimecodes = false;
    private RTPPacket videoAdjustBFramePacket = null;
    private long lastAdjustBFrameTimecode = -1L;
    private boolean scte35ProcessingEnable = false;
    private RolloverLong scte35TC = new RolloverLong(33);
    private byte[] scte35Buffer = null;
    private int scte35BufferSize = -1;
    private int scte35BufferPos = 0;
    private int scte35PID = -1;
    private WMSLoggingThrottle logThrottle = new WMSLoggingThrottle();
    private MP3HeaderData mp3HeaderData = null;
    private byte[] mp3HeaderBuffer = null;
    public static long debugTSOffset = 0L;

    public static void setDebugTSOffset(long l) {
        System.out.println("RTPDePacketizerMPEGTS.setDebugTSOffset: " + l);
        debugTSOffset = l;
    }

    private void dumpLastSyncBlock() {
        if (this.lastSyncBuffer != null) {
            System.out.println(DebugUtils.formatBytes(this.lastSyncBuffer, this.lastSyncOffset + this.lastSyncPtr, 188));
        }
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.init");
        }
        this.audioWorkingPacket.setType(8);
        this.audioWorkingPacket.setCodec(10);
        this.audioWorkingPacket.setFrameType(15);
        this.audioWorkingPacket.setDebugLog(this.debugLog);
        this.videoWorkingPacket.setType(9);
        this.videoWorkingPacket.setCodec(7);
        this.videoWorkingPacket.setDebugLog(this.debugLog);
        this.audioIsAligned = this.properties.getPropertyBoolean("audioIsAligned", this.audioIsAligned);
        this.adjustBFrameTimecodes = this.properties.getPropertyBoolean("adjustBFrameTimecodes", this.adjustBFrameTimecodes);
        this.scte35ProcessingEnable = this.properties.getPropertyBoolean("scte35ProcessingEnable", this.scte35ProcessingEnable);
        this.dropIncompleteVideoFrames = this.properties.getPropertyBoolean("dropIncompleteMPEGTSVideoFrames", this.dropIncompleteVideoFrames);
        this.logIncompleteVideoFrames = this.properties.getPropertyBoolean("logIncompleteMPEGTSVideoFrames", this.logIncompleteVideoFrames);
        if (!this.audioIsAligned) {
            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.init: audioIsAligned: " + this.audioIsAligned);
        }
        if (this.adjustBFrameTimecodes) {
            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.init: adjustBFrameTimecodes: " + this.adjustBFrameTimecodes);
        }
        if (this.dropIncompleteVideoFrames) {
            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.init: Drop incomplete video frames");
        }
        if (this.logIncompleteVideoFrames) {
            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.init: Log incomplete video frames");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string = rTPTrack.getSampleType();
        return string != null && (string.toLowerCase().startsWith("mpeg-ts") || string.toLowerCase().startsWith("mp2t"));
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
        RTPStream rTPStream = rTPTrack.getRTPStream();
        this.audioPIDFilter = rTPStream.getMPEGTSAudioPID();
        this.videoPIDFilter = rTPStream.getMPEGTSVideoPID();
    }

    private H222Descriptor getDescriptor(byte[] byArray, int n) {
        H222Descriptor h222Descriptor = new H222Descriptor();
        int n2 = 0;
        int n3 = 0;
        h222Descriptor.descriptorTag = byArray[n + n3 + n2] & 0xFF;
        h222Descriptor.descriptorLen = byArray[n + n3 + ++n2] & 0xFF;
        int n4 = 0;
        h222Descriptor.systemId = BufferUtils.byteArrayToInt(byArray, n + n3 + ++n2, 2);
        n2 += 2;
        if ((n4 += 2) < h222Descriptor.descriptorLen) {
            h222Descriptor.pid = BufferUtils.byteArrayToInt(byArray, n + n3 + n2, 2);
            h222Descriptor.pid &= 0x1FFF;
            n2 += 2;
            if ((n4 += 2) < h222Descriptor.descriptorLen) {
                int n5 = h222Descriptor.descriptorLen - 4;
                h222Descriptor.data = new byte[n5];
                System.arraycopy(byArray, n + n3 + n2, h222Descriptor.data, 0, n5);
                n2 += n5;
            }
        }
        h222Descriptor.totalLen = n2;
        return h222Descriptor;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (byArray[n] != 71 && n2 >= 200 && byArray[n + 12] == 71) {
            n += 12;
            n2 -= 12;
            if (!this.reportedMPEGTSoverRTP) {
                WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.handleRTPPacket: MPEG-TS over RTP");
                this.reportedMPEGTSoverRTP = true;
            }
        }
        this.handleRTPPacketInner(socketAddress, rTPTrack, byArray, n, n2);
    }

    protected SpliceTime splice_time(byte[] byArray, int n) {
        boolean bl;
        SpliceTime spliceTime = new SpliceTime();
        int n2 = 0;
        boolean bl2 = bl = (byArray[n + n2] & 0x80) == 128;
        if (bl) {
            spliceTime.pts_time = byArray[n + n2] & 1;
            spliceTime.pts_time <<= 8;
            spliceTime.pts_time += (long)(byArray[n + ++n2] & 0xFF);
            spliceTime.pts_time <<= 8;
            spliceTime.pts_time += (long)(byArray[n + ++n2] & 0xFF);
            spliceTime.pts_time <<= 8;
            spliceTime.pts_time += (long)(byArray[n + ++n2] & 0xFF);
            spliceTime.pts_time <<= 8;
            spliceTime.pts_time += (long)(byArray[n + ++n2] & 0xFF);
            ++n2;
        } else {
            ++n2;
        }
        spliceTime.bytes = n2;
        return spliceTime;
    }

    protected SpliceDescriptor splice_descriptor(byte[] byArray, int n) {
        SpliceDescriptor spliceDescriptor = new SpliceDescriptor();
        int n2 = 0;
        spliceDescriptor.splice_descriptor_tag = byArray[n + n2] & 0xFF;
        spliceDescriptor.descriptor_length = byArray[n + ++n2] & 0xFF;
        spliceDescriptor.identifier = byArray[n + ++n2] & 0xFF;
        spliceDescriptor.identifier <<= 8;
        spliceDescriptor.identifier += (long)(byArray[n + ++n2] & 0xFF);
        spliceDescriptor.identifier <<= 8;
        spliceDescriptor.identifier += (long)(byArray[n + ++n2] & 0xFF);
        spliceDescriptor.identifier <<= 8;
        spliceDescriptor.identifier += (long)(byArray[n + ++n2] & 0xFF);
        ++n2;
        if (spliceDescriptor.descriptor_length > 4) {
            spliceDescriptor.privateBytes = new byte[spliceDescriptor.descriptor_length - 4];
            System.arraycopy(byArray, n + n2, spliceDescriptor.privateBytes, 0, spliceDescriptor.descriptor_length - 4);
            n2 += spliceDescriptor.descriptor_length - 4;
        }
        spliceDescriptor.bytes = n2;
        return spliceDescriptor;
    }

    /*
     * Could not resolve type clashes
     */
    protected void handleRTPPacketInner(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        block128: {
            int n3 = 0;
            do {
                int n4;
                int n5 = n4 = 0;
                this.lastSyncPtr = n3 + n4;
                this.lastSyncBuffer = byArray;
                this.lastSyncOffset = n;
                byte by = byArray[n + n3 + n4];
                ++n4;
                if (by != 71) {
                    if (this.logThrottle.doLog()) {
                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: Out of sync: 0x" + Integer.toHexString(0xFF & by));
                    }
                } else {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    boolean bl = (byArray[n + n3 + n4] & 0x80) == 128;
                    boolean bl2 = (byArray[n + n3 + n4] & 0x40) == 64;
                    boolean bl3 = (byArray[n + n3 + n4] & 0x20) == 32;
                    int n11 = byArray[n + n3 + n4] & 0x1F;
                    n11 <<= 8;
                    n11 += byArray[n + n3 + ++n4] & 0xFF;
                    int n12 = byArray[n + n3 + ++n4] >> 6 & 3;
                    int n13 = byArray[n + n3 + n4] >> 4 & 3;
                    int n14 = byArray[n + n3 + n4] >> 0 & 0xF;
                    ++n4;
                    if (this.debugDetails) {
                        System.out.println("tsPID: 0x" + Integer.toHexString(n11));
                        System.out.println("tsSyncByte: 0x" + Integer.toHexString(by));
                        System.out.println("tsErrorIdr: " + bl);
                        System.out.println("tsPayloadUnitStartIdr: " + bl2);
                        System.out.println("tsTransportPriority: " + bl3);
                        System.out.println("tsScramblingCtrl: " + n12);
                        System.out.println("tsAdaptionFieldCtrl: " + n13);
                        System.out.println("tsContinutityCounter: " + n14);
                    }
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    if (n13 == 0 && this.logThrottle.doLog()) {
                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: Adaption field control is zero, strange.");
                    }
                    if ((n13 & 2) == 2) {
                        n10 = byArray[n + n3 + n4] & 0xFF;
                        ++n4;
                        if (n10 > 0) {
                            n9 = n4;
                            if (this.debugDetails) {
                                System.out.println("AdaptionField[" + n10 + "]\n" + DebugUtils.formatBytes(byArray, n + n3 + n4, n10));
                            }
                            n8 = byArray[n + n3 + n4] & 0xFF;
                            bl4 = (byArray[n + n3 + n4] & 0x80) == 128;
                            bl5 = (byArray[n + n3 + n4] & 0x40) == 64;
                            bl6 = (byArray[n + n3 + n4] & 0x20) == 32;
                            bl7 = (byArray[n + n3 + n4] & 0x10) == 16;
                            bl8 = (byArray[n + n3 + n4] & 8) == 8;
                            bl9 = (byArray[n + n3 + n4] & 4) == 4;
                            bl10 = (byArray[n + n3 + n4] & 2) == 2;
                            bl11 = (byArray[n + n3 + n4] & 1) == 1;
                            l = 0L;
                            l2 = 0L;
                            l3 = 0L;
                            l4 = 0L;
                            ++n4;
                            if (this.debugDetails) {
                                System.out.println("  afLen: " + n10);
                                System.out.println("  fByte: 0x" + Integer.toHexString(n8));
                                System.out.println("  afDiscontinuityIdr: " + bl4);
                                System.out.println("  afRandomAccessIdr: " + bl5);
                                System.out.println("  afElementaryStreamPriorityIdr: " + bl6);
                                System.out.println("  afPCRFlag: " + bl7);
                                System.out.println("  afOPCRFlag: " + bl8);
                                System.out.println("  afSplicingPointFlag: " + bl9);
                                System.out.println("  afTransportPrivateDataFlag: " + bl10);
                                System.out.println("  afAdaptionFieldExtFlag: " + bl11);
                            }
                            if (bl7) {
                                n7 = n + n3 + n4;
                                l = BufferUtils.byteArrayToLong(byArray, n + n3 + n4, 5);
                                l >>= 7;
                                l2 = BufferUtils.byteArrayToLong(byArray, n + n3 + (n4 += 4), 2);
                                l2 &= 0x1FFL;
                                n4 += 2;
                            }
                            if (bl8) {
                                l3 = BufferUtils.byteArrayToLong(byArray, n + n3 + n4, 5);
                                l3 >>= 7;
                                l4 = BufferUtils.byteArrayToLong(byArray, n + n3 + (n4 += 4), 2);
                                l4 &= 0x1FFL;
                                n4 += 2;
                            }
                            if (this.debugDetails) {
                                System.out.println("  afProgramClockReferenceBase: " + l);
                                System.out.println("  afProgramClockReferenceExt: " + l2);
                                System.out.println("  afOrigProgramClockReferenceBase: " + l3);
                                System.out.println("  afOrigProgramClockReferenceExt: " + l4);
                            }
                            n7 = 0;
                            if (bl9) {
                                n7 = byArray[n + n3 + n4] & 0xFF;
                                ++n4;
                            }
                            if (this.debugDetails) {
                                System.out.println("  sfSplicingCountdown: " + n7);
                            }
                            byte[] byArray2 = null;
                            if (bl10) {
                                n6 = byArray[n + n3 + n4] & 0xFF;
                                byArray2 = new byte[n6];
                                System.arraycopy(byArray, n + n3 + ++n4, byArray2, 0, n6);
                                n4 += n6;
                            }
                            if (this.debugDetails && byArray2 != null) {
                                System.out.println("  afTransportPrivateData[" + byArray2.length + "]: " + DebugUtils.formatBytesShort(byArray2));
                            }
                            if (bl11) {
                                n6 = byArray[n + n3 + n4] & 0xFF;
                                ++n4;
                                n4 += n6;
                            }
                            n4 = n9 + n10;
                        }
                    }
                    if ((n13 & 1) == 1) {
                        int n15;
                        int n16;
                        boolean bl12;
                        int n17;
                        int n18;
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        int n26;
                        if (n11 == 0) {
                            if (this.debugDetails) {
                                System.out.println("**** PAT ****");
                            }
                            n10 = byArray[n + n3 + n4] & 0xFF;
                            ++n4;
                            n9 = byArray[n + n3 + (n4 += n10)] & 0xFF;
                            n8 = (byArray[n + n3 + ++n4] & 0x80) == 128 ? 1 : 0;
                            n7 = byArray[n + n3 + n4] & 0xF;
                            n7 <<= 8;
                            n7 += byArray[n + n3 + ++n4] & 0xFF;
                            int n27 = BufferUtils.byteArrayToInt(byArray, n + n3 + ++n4, 2);
                            n6 = byArray[n + n3 + (n4 += 2)] >> 1 & 0x1F;
                            n26 = (byArray[n + n3 + n4] & 1) == 1 ? 1 : 0;
                            n25 = byArray[n + n3 + ++n4] & 0xFF;
                            int n28 = byArray[n + n3 + ++n4] & 0xFF;
                            ++n4;
                            if (this.debugDetails) {
                                System.out.println("  patTableId: " + n9);
                                System.out.println("  patSectionSyntaxIdr: " + (n8 != 0));
                                System.out.println("  patSectionLen: " + n7);
                                System.out.println("  patTransportStreamId: " + n27);
                                System.out.println("  patVersion: " + n6);
                                System.out.println("  patCurrentNextIdr: " + (n26 != 0));
                                System.out.println("  patSection: " + n25);
                                System.out.println("  patLastSection: " + n28);
                            }
                            n24 = (n7 - 9) / 4;
                            for (n23 = 0; n23 < n24; n23 += 1) {
                                n22 = BufferUtils.byteArrayToInt(byArray, n + n3 + n4, 2);
                                n21 = BufferUtils.byteArrayToInt(byArray, n + n3 + (n4 += 2), 2);
                                n21 &= 0x1FFF;
                                n4 += 2;
                                if (n22 == 0) {
                                    this.networkPID = n21;
                                } else {
                                    this.programMapPID = n21;
                                }
                                if (!this.debugDetails) continue;
                                System.out.println("    program: " + n22);
                                System.out.println("    pid: 0x" + Integer.toHexString(n21));
                            }
                        } else if (this.programMapPID != -1 && n11 == this.programMapPID) {
                            if (this.debugDetails) {
                                System.out.println("**** ProgramMAP ****");
                            }
                            n10 = byArray[n + n3 + n4] & 0xFF;
                            ++n4;
                            n9 = byArray[n + n3 + (n4 += n10)] & 0xFF;
                            n8 = (byArray[n + n3 + ++n4] & 0x80) == 128 ? 1 : 0;
                            n7 = byArray[n + n3 + n4] & 0xF;
                            n7 <<= 8;
                            n7 += byArray[n + n3 + ++n4] & 0xFF;
                            int n29 = ++n4;
                            n6 = BufferUtils.byteArrayToInt(byArray, n + n3 + n4, 2);
                            n26 = byArray[n + n3 + (n4 += 2)] >> 1 & 0x1F;
                            n25 = (byArray[n + n3 + n4] & 1) == 1 ? 1 : 0;
                            int n30 = byArray[n + n3 + ++n4] & 0xFF;
                            n24 = byArray[n + n3 + ++n4] & 0xFF;
                            n23 = BufferUtils.byteArrayToInt(byArray, n + n3 + ++n4, 2);
                            n23 &= 0x1FFF;
                            n22 = BufferUtils.byteArrayToInt(byArray, n + n3 + (n4 += 2), 2);
                            n22 &= 0xFFF;
                            n4 += 2;
                            if (this.debugDetails) {
                                System.out.println("  pmapTableId: " + n9);
                                System.out.println("  pmapSectionSyntaxIdr: " + (n8 != 0));
                                System.out.println("  pmapSectionLen: " + n7);
                                System.out.println("  pmapProgramNumber: " + n6);
                                System.out.println("  pmapCurrentNextIdr: " + (n25 != 0));
                                System.out.println("  pmapSection: " + n30);
                                System.out.println("  pmapLastSection: " + n24);
                                System.out.println("  pmapPCRPID: 0x" + Integer.toHexString(n23));
                                System.out.println("  pmapProgramInfoLen: " + n22);
                            }
                            n21 = n4 - n29;
                            n20 = 0;
                            if (n22 > 0) {
                                n4 += n22;
                            }
                            if ((n19 = n7 - n21 - n22 - 4) > 0) {
                                n18 = n4;
                                n17 = 0;
                                do {
                                    String string;
                                    List<String> list;
                                    RTPTrack rTPTrack2;
                                    bl12 = byArray[n + n3 + n4] & 0xFF;
                                    n16 = BufferUtils.byteArrayToInt(byArray, n + n3 + ++n4, 2);
                                    n16 &= 0x1FFF;
                                    n15 = BufferUtils.byteArrayToInt(byArray, n + n3 + (n4 += 2), 2);
                                    n15 &= 0xFFF;
                                    n4 += 2;
                                    if (this.debugLog) {
                                        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.handleRTPPacket: PID: 0x" + Integer.toHexString(n16) + " streamType:" + Integer.toHexString(bl12 ? 1 : 0));
                                    }
                                    if (bl12 || bl12 || bl12 || bl12) {
                                        if (!this.pids.contains(n16)) {
                                            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.handleRTPPacket: audioPID[" + (bl12 || bl12 ? "MP3" : "AAC") + "]: 0x" + Integer.toHexString(n16));
                                            this.pids.add(n16);
                                        }
                                        if (this.audioPID == -1 && (this.audioPIDFilter < 0 || this.audioPIDFilter == n16)) {
                                            rTPTrack.getStream().setMPEGTSAudioPID(this.audioPID);
                                            this.audioPID = n16;
                                            this.audioRTPtrack = new RTPTrack(MPEGTSTRACKNAME_AUDIO);
                                            rTPTrack.getStream().addTrackInternal(this.audioRTPtrack);
                                            this.audioRTPtrack.setStream(rTPTrack.getStream());
                                            this.audioRTPtrack.setTrackType(8);
                                            this.audioCodec = bl12 || bl12 ? 2 : 10;
                                            this.setAudioCodecId(rTPTrack, this.audioCodec);
                                            this.audioWorkingPacket.setCodec(this.audioCodec);
                                            rTPTrack2 = rTPTrack.getStream().getTrack("audio");
                                            if (rTPTrack2 != null) {
                                                list = rTPTrack2.getTrackInfoKeys();
                                                for (String string2 : list) {
                                                    string = rTPTrack2.getTrackInfo(string2);
                                                    this.audioRTPtrack.addTrackInfo(string2, string);
                                                }
                                                this.audioRTPtrack.extractCodecConfigFromTrackInfo();
                                            }
                                        }
                                    } else if (bl12) {
                                        if (!this.pids.contains(n16)) {
                                            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.handleRTPPacket: videoPID[H264]: 0x" + Integer.toHexString(n16));
                                            this.pids.add(n16);
                                        }
                                        if (this.videoPID == -1 && (this.videoPIDFilter < 0 || this.videoPIDFilter == n16)) {
                                            rTPTrack.getStream().setMPEGTSVideoPID(this.audioPID);
                                            this.videoPID = n16;
                                            this.videoRTPtrack = new RTPTrack(MPEGTSTRACKNAME_VIDEO);
                                            rTPTrack.getStream().addTrackInternal(this.videoRTPtrack);
                                            this.videoRTPtrack.setStream(rTPTrack.getStream());
                                            this.videoRTPtrack.setTrackType(9);
                                            this.videoTrackIsMPEG2 = bl12;
                                            this.videoCodec = 7;
                                            this.setVideoCodecId(rTPTrack, this.videoCodec);
                                            this.videoWorkingPacket.setCodec(this.videoCodec);
                                            rTPTrack2 = rTPTrack.getStream().getTrack("video");
                                            if (rTPTrack2 != null) {
                                                list = rTPTrack2.getTrackInfoKeys();
                                                for (String string2 : list) {
                                                    string = rTPTrack2.getTrackInfo(string2);
                                                    this.videoRTPtrack.addTrackInfo(string2, string);
                                                }
                                                this.videoRTPtrack.extractCodecConfigFromTrackInfo();
                                            }
                                        }
                                    } else if (this.scte35ProcessingEnable && bl12) {
                                        if (!this.pids.contains(n16)) {
                                            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerMPEGTS.handleRTPPacket: scte35PID: 0x" + Integer.toHexString(n16));
                                            this.pids.add(n16);
                                        }
                                        if (this.scte35PID == -1) {
                                            this.scte35PID = n16;
                                        }
                                    } else if (!this.pids.contains(n16)) {
                                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket[0x" + Integer.toHexString(n16) + "]: streamType: 0x" + Integer.toHexString(bl12 ? 1 : 0));
                                        this.pids.add(n16);
                                    }
                                    if (this.debugDetails) {
                                        System.out.println("  streamType[" + n17 + "]: 0x" + Integer.toHexString(bl12 ? 1 : 0));
                                        System.out.println("  pid[" + n17 + "]: 0x" + Integer.toHexString(n16));
                                        System.out.println("  streamInfoLen[" + n17 + "]: " + n15);
                                        if (n15 > 0) {
                                            System.out.println("streamInfoLen: " + DebugUtils.formatBytesShort(byArray, n + n3 + n4, n15));
                                        }
                                    }
                                    if (n15 > 0) {
                                        n4 += n15;
                                    }
                                    ++n17;
                                } while (n4 - n18 < n19);
                                if (n4 - n18 > n19 && this.logThrottle.doLog()) {
                                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: ProgramMAP stream info len incorrect: " + (n4 - n18) + ":" + (int)n19);
                                }
                            }
                        } else if (this.networkPID != -1 && n11 == this.networkPID) {
                            if (this.debugDetails) {
                                System.out.println("**** Network ****");
                            }
                        } else if (this.scte35PID != -1 && n11 == this.scte35PID) {
                            System.out.println(DebugUtils.formatBytes(byArray, n + n3 + n4, 188 - n4));
                            n10 = byArray[n + n3 + n4] & 0xFF;
                            ++n4;
                            n9 = byArray[n + n3 + (n4 += n10)] & 0xFF;
                            System.out.println("patTableId: 0xfc == 0x" + Integer.toHexString(0xFF & n9));
                            n8 = (byArray[n + n3 + ++n4] & 0x80) == 128 ? 1 : 0;
                            n7 = (byArray[n + n3 + n4] & 0x40) == 64 ? 1 : 0;
                            int n31 = byArray[n + n3 + n4] & 0xF;
                            n31 <<= 8;
                            n31 += byArray[n + n3 + ++n4] & 0xFF;
                            System.out.println("section_syntax_indicator: " + (n8 != 0));
                            System.out.println("private_indicator: " + (n7 != 0));
                            System.out.println("section_length: " + n31);
                            n6 = byArray[n + n3 + ++n4] & 0xFF;
                            System.out.println("protocol_version: " + n6);
                            n26 = (byArray[n + n3 + ++n4] & 0x80) == 128 ? 1 : 0;
                            n25 = byArray[n + n3 + n4] >> 1 & 0x3F;
                            System.out.println("encrypted_packet: " + (n26 != 0));
                            System.out.println("encryption_algorithm: " + n25);
                            long l5 = byArray[n + n3 + n4] & 1;
                            l5 <<= 8;
                            l5 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                            l5 <<= 8;
                            l5 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                            l5 <<= 8;
                            l5 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                            l5 <<= 8;
                            l5 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                            System.out.println("pts_adjustment: " + l5);
                            n23 = byArray[n + n3 + ++n4] & 0xFF;
                            ++n4;
                            System.out.println("cw_index: " + n23);
                            n22 = byArray[n + n3 + ++n4] & 0xF;
                            n22 <<= 8;
                            n22 += byArray[n + n3 + ++n4] & 0xFF;
                            System.out.println("splice_command_length: " + n22);
                            n21 = byArray[n + n3 + ++n4] & 0xFF;
                            ++n4;
                            System.out.println("splice_command_type: " + n21);
                            n20 = 1;
                            if (n21 == 5) {
                                long l6 = byArray[n + n3 + n4] & 0xFF;
                                l6 <<= 8;
                                l6 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                l6 <<= 8;
                                l6 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                l6 <<= 8;
                                l6 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                System.out.println(" splice_event_id: " + l6);
                                n17 = byArray[n + n3 + ++n4] >> 7 & 1;
                                ++n4;
                                System.out.println(" splice_event_cancel_indicator: " + n17);
                                if (n17 == 0) {
                                    int n32;
                                    bl12 = (byArray[n + n3 + n4] & 0x80) == 128;
                                    n16 = (byArray[n + n3 + n4] & 0x40) == 64;
                                    n15 = (byArray[n + n3 + n4] & 0x20) == 32 ? 1 : 0;
                                    boolean bl13 = (byArray[n + n3 + n4] & 0x10) == 16;
                                    ++n4;
                                    System.out.println("  out_of_network_indicator: " + bl12);
                                    System.out.println("  program_splice_flag: " + n16);
                                    System.out.println("  duration_flag: " + (n15 != 0));
                                    System.out.println("  splice_immediate_flag: " + bl13);
                                    if (n16 && !bl13) {
                                        SpliceTime spliceTime = this.splice_time(byArray, n + n3 + n4);
                                        n4 += spliceTime.bytes;
                                        System.out.println("  splice_time: " + spliceTime.pts_time);
                                    }
                                    if (!n16) {
                                        int n33 = byArray[n + n3 + n4] & 0xFF;
                                        ++n4;
                                        System.out.println("   component_count: " + n33);
                                        for (int i = 0; i < n33; ++i) {
                                            n32 = byArray[n + n3 + n4] & 0xFF;
                                            ++n4;
                                            System.out.println("   component_tag[" + i + "]: " + n32);
                                            if (bl13) continue;
                                            SpliceTime spliceTime = this.splice_time(byArray, n + n3 + n4);
                                            n4 += spliceTime.bytes;
                                            System.out.println("   splice_time: " + spliceTime.pts_time);
                                        }
                                    }
                                    if (n15 != 0) {
                                        boolean bl14 = (byArray[n + n3 + n4] & 0x80) == 128;
                                        System.out.println("   auto_return: " + bl14);
                                        long l7 = byArray[n + n3 + n4] & 1;
                                        l7 <<= 8;
                                        l7 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        l7 <<= 8;
                                        l7 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        l7 <<= 8;
                                        l7 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        l7 <<= 8;
                                        l7 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        ++n4;
                                        System.out.println("   duration: " + l7);
                                    }
                                    int n34 = byArray[n + n3 + n4] & 0xFF;
                                    n34 <<= 8;
                                    n34 += byArray[n + n3 + ++n4] & 0xFF;
                                    System.out.println("  unique_program_id: " + n34);
                                    int n35 = byArray[n + n3 + ++n4] & 0xFF;
                                    System.out.println("  avail_num: " + n35);
                                    n32 = byArray[n + n3 + n4] & 0xFF;
                                    System.out.println("  avails_expected: " + n32);
                                }
                            } else {
                                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerH222.handleRTPPacket: Unsupported splice command type: splice_command_type: " + n21);
                                n20 = 0;
                            }
                            if (n20 != 0) {
                                int n36 = byArray[n + n3 + n4] & 0xFF;
                                n36 <<= 8;
                                n36 += byArray[n + n3 + ++n4] & 0xFF;
                                ++n4;
                                System.out.println("descriptor_loop_length: " + n36);
                                n18 = 0;
                                while (n36 >= 6) {
                                    SpliceDescriptor spliceDescriptor = this.splice_descriptor(byArray, n + n3 + n4);
                                    System.out.println("descriptor[" + n18 + "]: " + spliceDescriptor.toString());
                                    n4 += spliceDescriptor.bytes;
                                    n36 -= spliceDescriptor.bytes;
                                    ++n18;
                                }
                            }
                        } else if (this.audioPID != -1 && n11 == this.audioPID || this.videoPID != -1 && n11 == this.videoPID) {
                            n10 = 188 - n4;
                            if (this.debugDetails) {
                                if (n11 == this.audioPID) {
                                    System.out.println("**** PES:AUDIO ****");
                                } else if (n11 == this.videoPID) {
                                    System.out.println("**** PES:VIDEO ****");
                                } else if (n11 == this.scte35PID) {
                                    System.out.println("**** PES:SCTE35 ****");
                                } else {
                                    System.out.println("**** PES:UNKNOWN ****");
                                }
                            }
                            if (bl2) {
                                int n37;
                                int n38;
                                n9 = 0;
                                n8 = n4;
                                while (n4 < 185 && (byArray[n + n3 + n4] != 0 || byArray[n + n3 + n4 + 1] != 0 || byArray[n + n3 + n4 + 2] != 1)) {
                                    ++n4;
                                    ++n9;
                                }
                                if (n9 > 0) {
                                    if (n11 == this.audioPID) {
                                        this.addToAudioBuffer(rTPTrack, n14, byArray, n + n3 + n8, n9);
                                    } else if (n11 == this.videoPID) {
                                        if (this.videoTrackIsMPEG2) {
                                            this.addToVideoBufferTranscode(rTPTrack, byArray, n + n3 + n8, n9);
                                        } else {
                                            this.addToVideoBuffer(rTPTrack, n14, byArray, n + n3 + n8, n9);
                                        }
                                    }
                                }
                                if (n11 == this.audioPID) {
                                    this.flushAudioBuffer(rTPTrack);
                                } else if (n11 == this.videoPID) {
                                    if (this.videoTrackIsMPEG2) {
                                        this.flushVideoBufferTranscode(rTPTrack);
                                    } else {
                                        this.flushVideoBuffer(rTPTrack);
                                    }
                                }
                                n7 = BufferUtils.byteArrayToInt(byArray, n + n3 + n4, 3);
                                int n39 = byArray[n + n3 + (n4 += 3)] & 0xFF;
                                n6 = BufferUtils.byteArrayToInt(byArray, n + n3 + ++n4, 2);
                                n26 = n4 += 2;
                                n25 = byArray[n + n3 + n4] >> 4 & 3;
                                boolean bl15 = (byArray[n + n3 + n4] & 8) == 8;
                                n24 = (byArray[n + n3 + n4] & 4) == 4 ? 1 : 0;
                                n23 = (byArray[n + n3 + n4] & 2) == 2 ? 1 : 0;
                                n22 = (byArray[n + n3 + n4] & 1) == 1 ? 1 : 0;
                                n21 = byArray[n + n3 + ++n4] & 0xFF;
                                n20 = byArray[n + n3 + n4] >> 6 & 3;
                                n19 = (byArray[n + n3 + n4] & 0x20) == 32;
                                n18 = (byArray[n + n3 + n4] & 0x10) == 16 ? 1 : 0;
                                n17 = (byArray[n + n3 + n4] & 8) == 8 ? 1 : 0;
                                bl12 = (byArray[n + n3 + n4] & 4) == 4;
                                n16 = (byArray[n + n3 + n4] & 2) == 2;
                                n15 = (byArray[n + n3 + n4] & 1) == 1 ? 1 : 0;
                                int n40 = byArray[n + n3 + ++n4] & 0xFF;
                                int n41 = ++n4;
                                if ((n6 -= n40 + 3) < 0) {
                                    n6 = 0;
                                }
                                if (this.debugDetails) {
                                    System.out.println("pesByte: 0x" + Integer.toHexString(n21));
                                    System.out.println("pesStartCode: " + n7);
                                    System.out.println("pesStreamId: 0x" + Integer.toHexString(n39));
                                    System.out.println("pesPacketLen: " + n6);
                                    System.out.println("pesScramblingControl: " + n25);
                                    System.out.println("pesPriority: " + bl15);
                                    System.out.println("pesDataAlignment: " + (n24 != 0));
                                    System.out.println("pesCopyright: " + (n23 != 0));
                                    System.out.println("pesOriginalOrCopy: " + (n22 != 0));
                                    System.out.println("pesPTSDTSFlags: " + n20);
                                    System.out.println("pesESCRFlag: " + n19);
                                    System.out.println("pesESRateFlag: " + (n18 != 0));
                                    System.out.println("pesDSMTrickMode: " + (n17 != 0));
                                    System.out.println("pesAdditionalCopyInfoFlag: " + bl12);
                                    System.out.println("pesPESCRCFlag: " + n16);
                                    System.out.println("pesPESExtFlag: " + (n15 != 0));
                                    System.out.println("pesHeaderDataLen: " + n40);
                                    if (n40 > 0) {
                                        byte[] byArray3 = new byte[n40];
                                        System.arraycopy(byArray, n + n3 + n4, byArray3, 0, byArray3.length);
                                        System.out.println("pesHeaderData: " + DebugUtils.formatBytes(byArray3));
                                    }
                                }
                                long l8 = -1L;
                                long l9 = -1L;
                                if ((n20 & 2) == 2) {
                                    n38 = n + n3 + n4;
                                    l8 = 0L;
                                    l8 += (long)(byArray[n + n3 + n4] >> 1 & 7);
                                    l8 <<= 8;
                                    l8 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                    l8 <<= 7;
                                    l8 += (long)(byArray[n + n3 + ++n4] >> 1 & 0x7F);
                                    l8 <<= 8;
                                    l8 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                    l8 <<= 7;
                                    l8 += (long)(byArray[n + n3 + ++n4] >> 1 & 0x7F);
                                    l8 += debugTSOffset;
                                    n37 = n + n3 + ++n4;
                                    if ((n20 & 1) == 1) {
                                        l9 = 0L;
                                        l9 += (long)(byArray[n + n3 + n4] >> 1 & 7);
                                        l9 <<= 8;
                                        l9 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        l9 <<= 7;
                                        l9 += (long)(byArray[n + n3 + ++n4] >> 1 & 0x7F);
                                        l9 <<= 8;
                                        l9 += (long)(byArray[n + n3 + ++n4] & 0xFF);
                                        l9 <<= 7;
                                        l9 += (long)(byArray[n + n3 + ++n4] >> 1 & 0x7F);
                                        ++n4;
                                        l9 += debugTSOffset;
                                    }
                                }
                                if (this.debugDetails) {
                                    System.out.println("pesPTSDTSFlags[0x" + Integer.toHexString(n11) + "]: " + n20 + " pesPTS: " + l8 + " pesDTS:" + l9);
                                }
                                n38 = 0;
                                n37 = 0;
                                if (n19) {
                                    byte[] byArray4 = new byte[6];
                                    System.arraycopy(byArray, n + n3 + n4, byArray4, 0, byArray4.length);
                                    n4 += byArray4.length;
                                    BitReader bitReader = new BitReader(byArray4);
                                    bitReader.skip(2);
                                    n38 += bitReader.getInt(3);
                                    n38 <<= 15;
                                    bitReader.skip(1);
                                    n38 += bitReader.getInt(15);
                                    n38 <<= 15;
                                    bitReader.skip(1);
                                    n38 += bitReader.getInt(15);
                                    bitReader.skip(1);
                                    n37 += bitReader.getInt(9);
                                }
                                if (this.debugDetails) {
                                    System.out.println("pesESCRBase: " + n38);
                                }
                                int n42 = 0;
                                if (n18 != 0) {
                                    n42 = BufferUtils.byteArrayToInt(byArray, n + n3 + n4, 3);
                                    n4 += 3;
                                    n42 >>= 1;
                                    n42 &= 0x3FFFFF;
                                }
                                if (this.debugDetails) {
                                    System.out.println("pesESRate: " + n42);
                                }
                                if (n17 != 0) {
                                    if (this.logThrottle.doLog()) {
                                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: Packet decode error. The pesDSMTrickMode is not supported");
                                    }
                                    ++n4;
                                }
                                if (bl12) {
                                    if (this.logThrottle.doLog()) {
                                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: Packet decode error. The pesAdditionalCopyInfoFlag is not supported");
                                    }
                                    ++n4;
                                }
                                int n43 = 0;
                                if (n16) {
                                    n43 = BufferUtils.byteArrayToInt(byArray, n + n3 + n4, 2);
                                    n4 += 2;
                                }
                                if (this.debugDetails) {
                                    System.out.println("previousPacketCRC: " + n43);
                                }
                                boolean bl16 = false;
                                boolean bl17 = false;
                                boolean bl18 = false;
                                boolean bl19 = false;
                                boolean bl20 = false;
                                byte[] byArray5 = null;
                                byte[] byArray6 = null;
                                int n44 = 0;
                                int n45 = 0;
                                int n46 = 0;
                                byte[] byArray7 = null;
                                if (n15 != 0) {
                                    int n47;
                                    bl16 = (byArray[n + n3 + n4] & 0x80) == 128;
                                    bl17 = (byArray[n + n3 + n4] & 0x40) == 64;
                                    bl18 = (byArray[n + n3 + n4] & 0x20) == 32;
                                    bl19 = (byArray[n + n3 + n4] & 0x10) == 16;
                                    bl20 = (byArray[n + n3 + n4] & 1) == 1;
                                    ++n4;
                                    if (bl16) {
                                        byArray5 = new byte[16];
                                        System.arraycopy(byArray, n + n3 + n4, byArray5, 0, byArray5.length);
                                        n4 += byArray5.length;
                                    }
                                    if (bl17) {
                                        n47 = byArray[n + n3 + n4] & 0xFF;
                                        ++n4;
                                        byArray6 = new byte[n47];
                                        if (n47 > 0) {
                                            System.arraycopy(byArray, n + n3 + n4, byArray6, 0, byArray6.length);
                                            n4 += byArray6.length;
                                        }
                                    }
                                    if (bl18) {
                                        n44 = byArray[n + n3 + n4] & 0x7F;
                                        n45 = byArray[n + n3 + ++n4] & 0x3F;
                                        ++n4;
                                    }
                                    if (bl19) {
                                        n46 = byArray[n + n3 + n4] & 0x1F;
                                        n46 = (byArray[n + n3 + n4] & 0x20) == 32 ? (n46 *= 1024) : (n46 *= 128);
                                        ++n4;
                                    }
                                    if (bl20) {
                                        n47 = byArray[n + n3 + n4] & 0x7F;
                                        ++n4;
                                        byArray7 = new byte[n47];
                                        if (n47 > 0) {
                                            System.arraycopy(byArray, n + n3 + n4, byArray7, 0, byArray7.length);
                                            n4 += byArray7.length;
                                        }
                                    }
                                }
                                if (this.debugDetails) {
                                    System.out.println("pesPrivateDataFlag: " + bl16);
                                    System.out.println("pesPrivateData" + (byArray5 == null ? ": null" : "[" + byArray5.length + "]: " + DebugUtils.formatBytesShort(byArray5)));
                                    System.out.println("pesPackHeaderFieldFlag: " + bl17);
                                    System.out.println("pesPacketHeader" + (byArray6 == null ? ": null" : "[" + byArray6.length + "]: " + DebugUtils.formatBytesShort(byArray6)));
                                    System.out.println("pesProgramPacketSeqCounterFlag: " + bl18);
                                    System.out.println("pesProgramPacketSequenceCounter: " + n44);
                                    System.out.println("pesOrginalStuffLen: " + n45);
                                    System.out.println("pesPSTDBufferFlag: " + bl19);
                                    System.out.println("PSTDBufferSize: " + n46);
                                    System.out.println("pesPES2ExtFlag: " + bl20);
                                    System.out.println("pesPESExt2Data" + (byArray7 == null ? ": null" : "[" + byArray7.length + "]: " + DebugUtils.formatBytesShort(byArray7)));
                                }
                                if (n4 - n41 != n40) {
                                    if (n4 - n41 > n40 && this.logThrottle.doLog()) {
                                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: PES Packet length problem: " + (n4 - n41) + ":" + n40);
                                    }
                                    n4 = n41 + n40;
                                }
                                if (n11 == this.audioPID) {
                                    this.startAudioBuffer(rTPTrack, n6, l8, l9);
                                } else if (n11 == this.videoPID) {
                                    if (this.videoTrackIsMPEG2) {
                                        this.startVideoBufferTranscode(rTPTrack, n6, l8, l9);
                                    } else {
                                        this.startVideoBuffer(rTPTrack, n6, l8, l9);
                                    }
                                }
                            }
                            if (n11 == this.audioPID) {
                                this.addToAudioBuffer(rTPTrack, n14, byArray, n + n3 + n4, 188 - n4);
                            } else if (n11 == this.videoPID) {
                                if (this.videoTrackIsMPEG2) {
                                    this.addToVideoBufferTranscode(rTPTrack, byArray, n + n3 + n4, 188 - n4);
                                } else {
                                    this.addToVideoBuffer(rTPTrack, n14, byArray, n + n3 + n4, 188 - n4);
                                }
                            }
                        }
                    }
                }
                if ((n3 += 188) == n2) break block128;
            } while (n3 + 188 <= n2);
            if (this.logThrottle.doLog()) {
                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.handleRTPPacket: Incomplete packet: " + (n3 + 188) + ":" + n2);
            }
        }
    }

    private void flushAudioBuffer(RTPTrack rTPTrack) {
        block38: {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                if (this.audioBufferSize <= 0 || this.audioBufferPos != this.audioBufferSize) break block38;
                int n6 = rTPTrack.getTimescale();
                long l = Math.round((double)this.audioTC.get() * 1000.0 / (double)n6);
                if (!this.audioIsAligned && this.audioBuffer != null) {
                    if (this.audioBufferLeftover != null) {
                        System.arraycopy(this.audioBufferLeftover, 0, this.audioBuffer, 0, this.audioBufferLeftover.length);
                        this.audioBufferLeftover = null;
                    }
                    int n7 = 0;
                    long l2 = this.audioTC.get();
                    if (this.audioCodec == 10) {
                        n5 = 0;
                        while (true) {
                            n4 = 0;
                            AACFrame aACFrame = AACUtils.decodeFrame(this.audioBuffer, n5);
                            if (aACFrame == null) {
                                ++n5;
                                continue;
                            }
                            n3 = aACFrame.getSize();
                            if (n3 <= 0) {
                                ++n5;
                                continue;
                            }
                            n2 = n5 + n3;
                            if (n2 + 2 >= this.audioBuffer.length) break;
                            if ((this.audioBuffer[n2 + 0] & 0xFF) == 255 && (this.audioBuffer[n2 + 1] & 0xF0) == 240) {
                                Object object;
                                n4 = this.audioCodecStreamRate >= 0 ? (!AACUtils.compareFrameParams(this.audioBuffer, n5, this.audioCodecStreamRate, this.audioCodecChannels) ? 1 : 0) : 1;
                                int n8 = n = aACFrame.isErrorBitsAbsent() ? 0 : 2;
                                if (n4 != 0) {
                                    this.audioCodecStreamRate = aACFrame.getRateIndex();
                                    this.audioCodecChannels = aACFrame.getChannelIndex();
                                    object = new byte[2];
                                    AACUtils.encodeAACCodecConfig(aACFrame, object, 0);
                                    this.audioRTPtrack.setCodecConfig((byte[])object);
                                    rTPTrack.getStream().resetSentMetadataFlag();
                                    this.audioSendCodeConfig = true;
                                }
                                l = Math.round((double)l2 * 1000.0 / (double)n6);
                                if (this.audioSendCodeConfig) {
                                    if (this.audioCodec == 10) {
                                        object = this.audioRTPtrack.getCodecConfig();
                                        if (this.debugLog) {
                                            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushAudioBuffer: audioCodecConfig: " + DebugUtils.formatBytesShort(object));
                                        }
                                        RTPUtils.writeCodecConfig(this.audioRTPtrack, l, object);
                                    }
                                    this.audioSendCodeConfig = false;
                                }
                                this.audioWorkingPacket.clearFragments();
                                this.audioWorkingPacket.setTimecode(l);
                                object = new RTPPacketFragment(this.audioBuffer, n5 + (7 + n), n3 - (7 + n));
                                this.audioWorkingPacket.addFragment((RTPPacketFragment)object);
                                this.audioWorkingPacket.write(this.audioRTPtrack, l);
                                int n9 = aACFrame.getSampleRate();
                                l2 = n9 > 0 ? (l2 += (long)(aACFrame.getSampleCount() * n6 / n9)) : (l2 += (long)aACFrame.getSampleCount());
                                n7 = n5 += n3;
                                this.audioBufferMaxSize = Math.max(this.audioBufferMaxSize, n3);
                            } else {
                                ++n5;
                            }
                            if (n5 >= this.audioBuffer.length - 7) break;
                        }
                    } else if (this.audioCodec == 2) {
                        n5 = 0;
                        while (n5 + 4 < this.audioBuffer.length) {
                            if (this.mp3HeaderData == null) {
                                this.mp3HeaderData = new MP3HeaderData();
                                this.mp3HeaderBuffer = new byte[4];
                            }
                            System.arraycopy(this.audioBuffer, n5, this.mp3HeaderBuffer, 0, this.mp3HeaderBuffer.length);
                            n4 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.mp3HeaderBuffer, (MP3HeaderData)this.mp3HeaderData);
                            if (n4 == 0) {
                                ++n5;
                                continue;
                            }
                            MP3BufferedDecoder.decodeHeader((int)n4, (int)0, (MP3HeaderData)this.mp3HeaderData);
                            int n10 = MP3BufferedDecoder.calculateFrameSize((MP3HeaderData)this.mp3HeaderData);
                            if (n10 <= 0) {
                                ++n5;
                                continue;
                            }
                            if (n5 + n10 + 4 > this.audioBuffer.length) {
                                ++n5;
                                continue;
                            }
                            l = Math.round((double)l2 * 1000.0 / (double)n6);
                            this.audioWorkingPacket.clearFragments();
                            this.audioWorkingPacket.setTimecode(l);
                            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.audioBuffer, n5, n10 + 4);
                            this.audioWorkingPacket.addFragment(rTPPacketFragment);
                            this.audioWorkingPacket.write(this.audioRTPtrack, l);
                            n2 = MP3BufferedDecoder.frequency((MP3HeaderData)this.mp3HeaderData);
                            n = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)this.mp3HeaderData);
                            l2 = n2 > 0 ? (l2 += (long)(n * n6 / n2)) : (l2 += (long)n);
                            n7 = n5 += n10 + 4;
                            this.audioBufferMaxSize = Math.max(this.audioBufferMaxSize, n10);
                        }
                    }
                    if ((n5 = this.audioBuffer.length - n7) > 0 && (this.audioBufferMaxSize <= 0 || n5 <= this.audioBufferMaxSize * 3)) {
                        this.audioBufferLeftover = new byte[n5];
                        System.arraycopy(this.audioBuffer, n7, this.audioBufferLeftover, 0, this.audioBufferLeftover.length);
                    }
                    this.audioBuffer = null;
                }
                if (this.audioFirstPacket && (this.audioCodec != 10 || this.audioRTPtrack.isCodecConfig())) {
                    this.audioFirstPacket = false;
                }
                if (this.audioSendCodeConfig) {
                    if (this.audioCodec == 10) {
                        byte[] byArray = this.audioRTPtrack.getCodecConfig();
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushAudioBuffer: audioCodecConfig: " + DebugUtils.formatBytesShort(byArray));
                        }
                        RTPUtils.writeCodecConfig(this.audioRTPtrack, l, byArray);
                    }
                    this.audioSendCodeConfig = false;
                }
                if (this.audioFirstPacket || !this.audioIsAligned) break block38;
                if (this.audioBuffer != null) {
                    long l3 = this.audioTC.get();
                    int n11 = 0;
                    n5 = this.audioBufferPos;
                    if (this.audioCodec == 10) {
                        while (n5 > 7) {
                            l = Math.round((double)l3 * 1000.0 / (double)n6);
                            AACFrame aACFrame = AACUtils.decodeFrame(this.audioBuffer, n11);
                            if (aACFrame == null) break block38;
                            n11 += 7;
                            int n12 = aACFrame.getSize();
                            if (n12 > 7 && (n5 -= 7) >= n12 - 7) {
                                if (this.debugLog) {
                                    WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushAudioBuffer: packet: " + l);
                                }
                                n3 = aACFrame.isErrorBitsAbsent() ? 0 : 2;
                                this.audioWorkingPacket.clearFragments();
                                this.audioWorkingPacket.setTimecode(l);
                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.audioBuffer, n11 + n3, n12 - 7 - n3);
                                this.audioWorkingPacket.addFragment(rTPPacketFragment);
                                this.audioWorkingPacket.write(this.audioRTPtrack, l);
                                n11 += n12 - 7;
                                if ((n5 -= n12 - 7) > 0) {
                                    n = aACFrame.getSampleRate();
                                    if (n > 0) {
                                        l3 += (long)(aACFrame.getSampleCount() * n6 / n);
                                        continue;
                                    }
                                    l3 += (long)aACFrame.getSampleCount();
                                    continue;
                                }
                            }
                            break block38;
                        }
                        break block38;
                    }
                    if (this.audioCodec != 2) break block38;
                    while (n11 + 4 < this.audioBuffer.length) {
                        if (this.mp3HeaderData == null) {
                            this.mp3HeaderData = new MP3HeaderData();
                            this.mp3HeaderBuffer = new byte[4];
                        }
                        System.arraycopy(this.audioBuffer, n11, this.mp3HeaderBuffer, 0, this.mp3HeaderBuffer.length);
                        n4 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.mp3HeaderBuffer, (MP3HeaderData)this.mp3HeaderData);
                        if (n4 != 0) {
                            MP3BufferedDecoder.decodeHeader((int)n4, (int)0, (MP3HeaderData)this.mp3HeaderData);
                            int n13 = MP3BufferedDecoder.calculateFrameSize((MP3HeaderData)this.mp3HeaderData);
                            if (n13 > 0 && n11 + n13 + 4 <= this.audioBuffer.length) {
                                l = Math.round((double)l3 * 1000.0 / (double)n6);
                                this.audioWorkingPacket.clearFragments();
                                this.audioWorkingPacket.setTimecode(l);
                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.audioBuffer, n11, n13 + 4);
                                this.audioWorkingPacket.addFragment(rTPPacketFragment);
                                this.audioWorkingPacket.write(this.audioRTPtrack, l);
                                n2 = MP3BufferedDecoder.frequency((MP3HeaderData)this.mp3HeaderData);
                                n = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)this.mp3HeaderData);
                                l3 = n2 > 0 ? (l3 += (long)(n * n6 / n2)) : (l3 += (long)n);
                                n11 += n13 + 4;
                                if ((n5 -= n13 + 4) > 0) continue;
                            }
                        }
                        break block38;
                    }
                    break block38;
                }
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushAudioBuffer: packet: " + l);
                }
                this.audioWorkingPacket.setTimecode(l);
                this.audioWorkingPacket.write(this.audioRTPtrack, l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.audioBufferSize = -1;
        this.audioBufferPos = 0;
        this.audioWorkingPacket.clearFragments();
        this.audioIsMultiplePerPacket = 0;
        this.audioBuffer = null;
        this.audioNextContinuityCounter = -1;
        this.audioContinuityCounterGood = true;
    }

    private void flushVideoBuffer(RTPTrack rTPTrack) {
        if (this.videoTempChunkLen > 0) {
            this.videoBufferSize = this.videoTempChunkLen;
            try {
                for (TempChunk tempChunk : this.videoTempChunks) {
                    this.addToVideoBuffer(rTPTrack, -1, tempChunk.bytes, tempChunk.offset, tempChunk.len, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.videoTempChunks.clear();
            this.videoTempChunkLen = 0;
        }
        try {
            if (this.videoBufferPos != this.videoBufferSize || this.dropIncompleteVideoFrames && !this.videoContinuityCounterGood) {
                if (this.logIncompleteVideoFrames) {
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEGTS.flushVideoBuffer: Video frame incomplete, dropping[" + this.videoBufferPos + ":" + this.videoBufferSize + ":" + this.videoContinuityCounterGood + "]: " + this.videoTC.get());
                }
            } else {
                long l;
                long l2;
                int n = rTPTrack.getTimescale();
                long l3 = Math.round((double)this.videoTC.get() * 1000.0 / (double)n);
                long l4 = 0L;
                if (this.isVideoPTS && this.isVideoDTS) {
                    l2 = Math.round((double)this.videoPTS.get() * 1000.0 / (double)n);
                    l3 = l = Math.round((double)this.videoDTS.get() * 1000.0 / (double)n);
                    l4 = l2 - l;
                }
                if (this.videoFirstPacket) {
                    RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo;
                    byte[] byArray = this.videoRTPtrack.getCodecConfig();
                    if (byArray == null && (rTPPacketCodecConfigInfo = this.videoWorkingPacket.getH264CodecConfigInfo(this.videoRTPtrack)) != null) {
                        byte[] byArray2 = null;
                        String string = rTPTrack.getTrackInfo("profile-level-id");
                        if (string != null) {
                            byArray2 = BufferUtils.decodeHexString(string);
                        }
                        byArray = RTPUtils.formatH264CodecConfig(rTPPacketCodecConfigInfo.sps, rTPPacketCodecConfigInfo.ppss, byArray2);
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushVideoBuffer: videoCodecConfig: " + DebugUtils.formatBytesShort(byArray));
                        }
                        this.videoRTPtrack.setCodecConfig(byArray);
                        rTPTrack.getStream().resetSentMetadataFlag();
                    }
                    if (byArray != null) {
                        RTPUtils.writeCodecConfig(this.videoRTPtrack, l3, byArray);
                        this.videoFirstPacket = false;
                    }
                }
                if (!this.videoFirstPacket) {
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEGTS.flushVideoBuffer: packet: " + l3);
                    }
                    this.videoWorkingPacket.setTimecode(l3);
                    this.videoWorkingPacket.setTimeoffset(l4);
                    if (this.adjustBFrameTimecodes) {
                        if (this.videoAdjustBFramePacket != null) {
                            l2 = this.videoAdjustBFramePacket.getTimecode();
                            if (l3 < l2) {
                                l = (l3 + this.lastAdjustBFrameTimecode) / 2L;
                                long l5 = l2 - l;
                                this.videoAdjustBFramePacket.setTimecode(l);
                                this.videoAdjustBFramePacket.setTimeoffset(l5);
                            }
                            this.lastAdjustBFrameTimecode = Math.max(this.lastAdjustBFrameTimecode, this.videoAdjustBFramePacket.getTimecode());
                            this.videoAdjustBFramePacket.write(this.videoRTPtrack, this.videoAdjustBFramePacket.getTimecode());
                        }
                        this.videoAdjustBFramePacket = this.videoWorkingPacket.clone();
                    } else {
                        this.videoWorkingPacket.write(this.videoRTPtrack, l3);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.videoBufferSize = -1;
        this.videoBufferPos = 0;
        this.videoStartCodes = 0;
        this.videoWorkingPacket.clearFragments();
        this.videoPendingFragment.clear();
        this.videoNALSizeFragment = null;
        this.videoInNALUnit = false;
        this.videoNALSize = 0;
        this.videoTempChunks.clear();
        this.videoTempChunkLen = 0;
        this.videoNextContinuityCounter = -1;
        this.videoContinuityCounterGood = true;
    }

    private void startAudioBuffer(RTPTrack rTPTrack, int n, long l, long l2) {
        this.audioBufferSize = n;
        this.audioBufferPos = 0;
        this.audioBytesToSkip = this.audioCodec == 10 ? 7 : 0;
        this.audioWorkingPacket.clearFragments();
        this.audioTC.set(l2 >= 0L ? l2 : l);
        this.audioIsMultiplePerPacket = 0;
        this.audioBuffer = null;
    }

    private void startVideoBuffer(RTPTrack rTPTrack, int n, long l, long l2) {
        this.videoBufferSize = n;
        this.videoBufferPos = 0;
        this.videoWorkingPacket.clearFragments();
        this.videoStartCodes = 0;
        if (l2 >= 0L || l >= 0L) {
            this.videoTC.set(l2 >= 0L ? l2 : l);
        }
        this.isVideoPTS = false;
        if (l >= 0L) {
            this.videoPTS.set(l);
            this.isVideoPTS = true;
        }
        this.isVideoDTS = false;
        if (l2 >= 0L) {
            this.videoDTS.set(l2);
            this.isVideoDTS = true;
        }
        this.videoPendingFragment.clear();
        this.videoNALSizeFragment = null;
        this.videoInNALUnit = false;
        this.videoNALSize = 0;
        this.videoTempChunks.clear();
        this.videoTempChunkLen = 0;
    }

    private void addToAudioBuffer(RTPTrack rTPTrack, int n, byte[] byArray, int n2, int n3) {
        block22: {
            int n4;
            if (n >= 0) {
                if (this.audioNextContinuityCounter >= 0) {
                    if (this.audioNextContinuityCounter % 16 != n) {
                        this.audioContinuityCounterGood = false;
                    }
                    ++this.audioNextContinuityCounter;
                } else {
                    this.audioNextContinuityCounter = n + 1;
                    this.audioContinuityCounterGood = true;
                }
            }
            if (this.audioRTPtrack == null || this.audioBufferSize < 0 || this.audioBufferPos + n3 > this.audioBufferSize) break block22;
            int n5 = n3;
            int n6 = n2;
            if (this.audioIsAligned) {
                if (this.audioCodec == 10) {
                    n4 = 0;
                    AACFrame aACFrame = null;
                    if (this.audioBufferPos == 0 && n5 >= 7) {
                        aACFrame = AACUtils.decodeFrame(byArray, n6);
                        n4 = this.audioCodecStreamRate >= 0 ? (!AACUtils.compareFrameParams(byArray, n6, this.audioCodecStreamRate, this.audioCodecChannels) ? 1 : 0) : 1;
                        this.audioBytesToSkip = 7;
                        if (aACFrame != null) {
                            this.audioBytesToSkip += aACFrame.isErrorBitsAbsent() ? 0 : 2;
                        }
                    }
                    if (this.audioIsMultiplePerPacket == 0 && aACFrame != null) {
                        int n7 = this.audioIsMultiplePerPacket = this.audioBufferSize > aACFrame.getSize() ? 1 : -1;
                    }
                    if (n4 != 0 && aACFrame != null) {
                        this.audioCodecStreamRate = aACFrame.getRateIndex();
                        this.audioCodecChannels = aACFrame.getChannelIndex();
                        byte[] byArray2 = new byte[2];
                        AACUtils.encodeAACCodecConfig(aACFrame, byArray2, 0);
                        this.audioRTPtrack.setCodecConfig(byArray2);
                        rTPTrack.getStream().resetSentMetadataFlag();
                        this.audioSendCodeConfig = true;
                    }
                } else if (this.audioCodec == 2 && this.audioBufferPos == 0 && n5 >= 4) {
                    if (this.mp3HeaderData == null) {
                        this.mp3HeaderData = new MP3HeaderData();
                        this.mp3HeaderBuffer = new byte[4];
                    }
                    System.arraycopy(byArray, n6, this.mp3HeaderBuffer, 0, this.mp3HeaderBuffer.length);
                    n4 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.mp3HeaderBuffer, (MP3HeaderData)this.mp3HeaderData);
                    if (n4 != 0) {
                        MP3BufferedDecoder.decodeHeader((int)n4, (int)0, (MP3HeaderData)this.mp3HeaderData);
                        int n8 = MP3BufferedDecoder.calculateFrameSize((MP3HeaderData)this.mp3HeaderData);
                        int n9 = this.audioIsMultiplePerPacket = this.audioBufferSize > n8 + 4 ? 1 : -1;
                    }
                }
            }
            if (!this.audioIsAligned || this.audioIsMultiplePerPacket > 0) {
                int n10 = n4 = this.audioBufferLeftover != null ? this.audioBufferLeftover.length : 0;
                if (this.audioBuffer == null) {
                    this.audioBuffer = new byte[this.audioBufferSize + n4];
                }
                System.arraycopy(byArray, n2, this.audioBuffer, n4 + this.audioBufferPos, n3);
            } else {
                if (this.audioBytesToSkip > 0) {
                    if (this.audioBytesToSkip <= n5) {
                        n5 -= this.audioBytesToSkip;
                        n6 += this.audioBytesToSkip;
                        this.audioBytesToSkip = 0;
                    } else {
                        this.audioBytesToSkip -= n5;
                        n6 += n5;
                        n5 = 0;
                    }
                }
                if (n5 > 0) {
                    RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n6, n5);
                    this.audioWorkingPacket.addFragment(rTPPacketFragment);
                }
            }
            this.audioBufferPos += n3;
            if (this.audioBufferPos == this.audioBufferSize) {
                this.flushAudioBuffer(rTPTrack);
            }
        }
    }

    private void closeVideoNALUnit(int n) {
        if (this.videoPendingFragment.bytes != null) {
            int n2 = n - this.videoPendingFragment.i;
            int n3 = this.videoPendingFragment.offset + this.videoPendingFragment.i;
            if (n2 > 0) {
                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.videoPendingFragment.bytes, n3, n2);
                this.videoWorkingPacket.addFragment(rTPPacketFragment);
                this.videoNALSize += n2;
            }
            this.videoPendingFragment.clear();
        }
        if (this.videoNALSizeFragment != null) {
            byte[] byArray = this.videoNALSizeFragment.getBuffer();
            byArray[0] = (byte)(this.videoNALSize >> 24 & 0xFF);
            byArray[1] = (byte)(this.videoNALSize >> 16 & 0xFF);
            byArray[2] = (byte)(this.videoNALSize >> 8 & 0xFF);
            byArray[3] = (byte)(this.videoNALSize >> 0 & 0xFF);
            this.videoNALSizeFragment = null;
        }
        this.videoNALSize = 0;
    }

    private void addToVideoBuffer(RTPTrack rTPTrack, int n, byte[] byArray, int n2, int n3) {
        this.addToVideoBuffer(rTPTrack, n, byArray, n2, n3, false);
    }

    private void addToVideoBuffer(RTPTrack rTPTrack, int n, byte[] byArray, int n2, int n3, boolean bl) {
        block46: {
            block45: {
                if (n >= 0) {
                    if (this.videoNextContinuityCounter >= 0) {
                        if (this.videoNextContinuityCounter % 16 != n) {
                            this.videoContinuityCounterGood = false;
                        }
                        ++this.videoNextContinuityCounter;
                    } else {
                        this.videoNextContinuityCounter = n + 1;
                        this.videoContinuityCounterGood = true;
                    }
                }
                if (this.videoBufferSize != 0) break block45;
                this.videoTempChunks.add(new TempChunk(byArray, n2, n3));
                this.videoTempChunkLen += n3;
                break block46;
            }
            if (this.videoBufferSize < 0 || this.videoBufferPos + n3 > this.videoBufferSize) break block46;
            boolean bl2 = false;
            if (bl2) {
                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n2, n3);
                this.videoWorkingPacket.addFragment(rTPPacketFragment);
            } else {
                int n4;
                int n5;
                int n6 = 0;
                if (this.videoStartCodes > 0) {
                    n5 = 0;
                    n4 = 0;
                    if (this.videoStartCodes == 3) {
                        this.videoPendingFragment.bytes = byArray;
                        this.videoPendingFragment.offset = n2;
                        this.videoPendingFragment.len = n3;
                        this.videoPendingFragment.i = 0;
                    } else if (n3 >= 1 && this.videoStartCodes == 2 && (byArray[n2 + 0] & 0xFF) == 1) {
                        this.closeVideoNALUnit(this.videoPendingFragment.len - 2);
                        ++n6;
                        n4 = 1;
                    } else if (n3 >= 2 && (this.videoStartCodes == 1 || this.videoStartCodes == 2) && (byArray[n2 + 0] & 0xFF) == 0 && (byArray[n2 + 1] & 0xFF) == 1) {
                        this.closeVideoNALUnit(this.videoPendingFragment.len - 1);
                        n6 += 2;
                        n4 = 1;
                    } else {
                        n5 = 1;
                    }
                    if (n5 != 0) {
                        if (this.videoPendingFragment.bytes != null) {
                            int n7 = this.videoPendingFragment.len - this.videoPendingFragment.i;
                            int n8 = this.videoPendingFragment.offset + this.videoPendingFragment.i;
                            if (n7 > 0) {
                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.videoPendingFragment.bytes, n8, n7);
                                this.videoWorkingPacket.addFragment(rTPPacketFragment);
                                this.videoNALSize += n7;
                            }
                        }
                        this.videoPendingFragment.clear();
                        this.videoPendingFragment.bytes = byArray;
                        this.videoPendingFragment.offset = n2;
                        this.videoPendingFragment.len = n3;
                        this.videoPendingFragment.i = 0;
                    }
                    if (n4 != 0) {
                        this.videoInNALUnit = true;
                        this.videoPendingFragment.bytes = byArray;
                        this.videoPendingFragment.offset = n2;
                        this.videoPendingFragment.len = n3;
                        this.videoPendingFragment.i = n6;
                        byte[] byArray2 = new byte[4];
                        this.videoNALSizeFragment = new RTPPacketFragment(byArray2, 0, byArray2.length);
                        this.videoWorkingPacket.addFragment(this.videoNALSizeFragment);
                    }
                    this.videoStartCodes = 0;
                } else if (this.videoInNALUnit) {
                    this.videoPendingFragment.bytes = byArray;
                    this.videoPendingFragment.offset = n2;
                    this.videoPendingFragment.len = n3;
                    this.videoPendingFragment.i = 0;
                }
                while (n6 < n3) {
                    if ((byArray[n2 + n6] & 0xFF) == 0) {
                        if (n6 <= n3 - 3) {
                            if ((byArray[n2 + n6 + 1] & 0xFF) == 0 && (byArray[n2 + n6 + 2] & 0xFF) == 1) {
                                if (this.videoInNALUnit) {
                                    this.closeVideoNALUnit(n6);
                                }
                                this.videoInNALUnit = true;
                                if (n6 < n3 - 3) {
                                    this.videoPendingFragment.bytes = byArray;
                                    this.videoPendingFragment.offset = n2;
                                    this.videoPendingFragment.len = n3;
                                    this.videoPendingFragment.i = n6 + 3;
                                } else {
                                    this.videoStartCodes = 3;
                                }
                                byte[] byArray3 = new byte[4];
                                this.videoNALSizeFragment = new RTPPacketFragment(byArray3, 0, byArray3.length);
                                this.videoWorkingPacket.addFragment(this.videoNALSizeFragment);
                            }
                        } else if (n6 == n3 - 2 && (byArray[n2 + n6 + 1] & 0xFF) == 0) {
                            if (this.videoBufferPos + n3 != this.videoBufferSize) {
                                this.videoStartCodes = 2;
                                break;
                            }
                        } else if (n6 == n3 - 1 && this.videoBufferPos + n3 != this.videoBufferSize) {
                            this.videoStartCodes = 1;
                            break;
                        }
                    }
                    ++n6;
                }
                if (this.videoStartCodes == 0) {
                    if (this.videoPendingFragment.bytes != null) {
                        n5 = n3 - this.videoPendingFragment.i;
                        n4 = this.videoPendingFragment.offset + this.videoPendingFragment.i;
                        if (n5 > 0) {
                            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.videoPendingFragment.bytes, n4, n5);
                            this.videoWorkingPacket.addFragment(rTPPacketFragment);
                            this.videoNALSize += n5;
                        }
                        this.videoPendingFragment.clear();
                    }
                    if (this.videoBufferPos + n3 == this.videoBufferSize) {
                        this.closeVideoNALUnit(0);
                    }
                }
            }
            this.videoBufferPos += n3;
            if (this.videoBufferPos == this.videoBufferSize && bl2) {
                int n9 = this.videoWorkingPacket.getSize();
                List<RTPPacketFragment> list = this.videoWorkingPacket.getFragments();
                RTPPacketFragmentListReader rTPPacketFragmentListReader = new RTPPacketFragmentListReader(list, n9);
                if (rTPPacketFragmentListReader.remaining() >= 4) {
                    byte[] byArray4 = new byte[4];
                    rTPPacketFragmentListReader.get(byArray4);
                    if (byArray4[0] == 0 && byArray4[1] == 0 && byArray4[2] == 0 && byArray4[3] == 1) {
                        try {
                            int n10;
                            byte[] byArray5 = new byte[n9];
                            int n11 = 0;
                            for (RTPPacketFragment rTPPacketFragment : list) {
                                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray5, n11, rTPPacketFragment.getLen());
                                n11 += rTPPacketFragment.getLen();
                            }
                            int n12 = -1;
                            for (n10 = 0; n10 < byArray5.length - 4; ++n10) {
                                if (byArray5[n10] != 0 || byArray5[n10 + 1] != 0 || byArray5[n10 + 2] != 0 || byArray5[n10 + 3] != 1) continue;
                                if (n12 >= 0) {
                                    int n13 = n10 - n12 - 4;
                                    BufferUtils.intToByteArray(n13, byArray5, n12, 4);
                                }
                                n12 = n10;
                            }
                            if (n12 >= 0) {
                                n10 = byArray5.length - n12 - 4;
                                BufferUtils.intToByteArray(n10, byArray5, n12, 4);
                            }
                            list.clear();
                            list.add(new RTPPacketFragment(byArray5, 0, byArray5.length));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.videoBufferPos == this.videoBufferSize && bl) {
                this.flushVideoBuffer(rTPTrack);
            }
        }
    }

    private ITranscode getTranscode(RTPTrack rTPTrack) {
        if (this.videoTranscode == null) {
            // empty if block
        }
        return this.videoTranscode;
    }

    private void addToVideoBufferTranscode(RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.addToVideoBufferTranscode(rTPTrack, byArray, n, n2, false);
    }

    private void addToVideoBufferTranscode(RTPTrack rTPTrack, byte[] byArray, int n, int n2, boolean bl) {
        ITranscode iTranscode = this.getTranscode(rTPTrack);
        iTranscode.addToVideoBuffer(rTPTrack, byArray, n, n2, bl);
    }

    private void flushVideoBufferTranscode(RTPTrack rTPTrack) {
        ITranscode iTranscode = this.getTranscode(rTPTrack);
        iTranscode.flushVideoBuffer(rTPTrack);
    }

    private void startVideoBufferTranscode(RTPTrack rTPTrack, int n, long l, long l2) {
        if (l2 >= 0L || l >= 0L) {
            this.videoTC.set(l2 >= 0L ? l2 : l);
        }
        boolean bl = false;
        if (l2 >= 0L && l >= 0L) {
            this.videoPTS.set(l);
            this.videoDTS.set(l2);
        } else if (l >= 0L) {
            this.videoPTS.set(l);
            this.videoDTS.set(l);
        } else {
            bl = true;
        }
        ITranscode iTranscode = this.getTranscode(rTPTrack);
        iTranscode.startVideoBuffer(rTPTrack, n, this.videoDTS.get(), this.videoDTS.get(), bl);
    }

    class H222Descriptor {
        public int descriptorTag = 0;
        public int descriptorLen = 0;
        public int systemId = 0;
        public int pid = 0;
        public byte[] data = null;
        public int totalLen = 0;

        H222Descriptor() {
        }

        public String toString() {
            return "tag: " + this.descriptorTag + " len:" + this.descriptorLen + " systemId:" + this.systemId + " pid:0x" + Integer.toHexString(this.pid) + " data" + (this.data == null ? ":null" : "[" + this.data.length + "]:" + DebugUtils.formatBytesShort(this.data));
        }
    }

    class PendingFragment {
        public byte[] bytes = null;
        public int offset = 0;
        public int len = 0;
        public int i = 0;

        PendingFragment() {
        }

        public void clear() {
            this.bytes = null;
            this.offset = 0;
            this.len = 0;
            this.i = 0;
        }
    }

    class SpliceDescriptor {
        int splice_descriptor_tag = 0;
        int descriptor_length = 0;
        long identifier = 0L;
        byte[] privateBytes = null;
        int bytes = 0;

        SpliceDescriptor() {
        }

        public String toString() {
            return "splice_descriptor_tag:" + this.splice_descriptor_tag + " descriptor_length:" + this.descriptor_length + " identifier:" + this.identifier + " privateBytes:" + (this.privateBytes == null ? "null" : DebugUtils.formatBytesShort(this.privateBytes));
        }
    }

    class SpliceTime {
        boolean time_specified_flag = false;
        long pts_time = 0L;
        int bytes = 0;

        SpliceTime() {
        }

        public String toString() {
            return "pts_time: " + this.pts_time;
        }
    }

    class TempChunk {
        public byte[] bytes = null;
        public int offset = 0;
        public int len = 0;

        public TempChunk(byte[] byArray, int n, int n2) {
            this.bytes = byArray;
            this.offset = n;
            this.len = n2;
        }
    }
}

