/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizerWrapper;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPCore;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class RTPDePacketizerWrapperPacketSorter
implements IRTPDePacketizerWrapper {
    public static long debugTSOffset = 0L;
    private IRTPDePacketizer rtpDePacketizer = null;
    private RTPSequence seq = new RTPSequence();
    private PacketSender packetSender = null;
    private SortedMap<Long, PacketItem> packetMap = new TreeMap<Long, PacketItem>();
    private long startRTTimecode = -1L;
    private long startRTPTimecode = -1L;
    private int rtpDePacketizerPacketSorterBufferTime = 500;
    private int rtpDePacketizerPacketSorterFlushTime = 10;
    private int rtpDePacketizerPacketSorterOutOfBoundsTime = 2000;
    private boolean rtpDePacketizerPacketSorterLogPacketLoss = false;
    private WMSProperties properties = new WMSProperties();
    private String contextStr = "";
    private boolean initContext = true;

    public static void setDebugTSOffset(long l) {
        System.out.println("RTPDePacketizerWrapperPacketSorter.setDebugTSOffset: " + l);
        debugTSOffset = l;
    }

    public WMSProperties getProperties() {
        return this.rtpDePacketizer.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPacketMapDuration() {
        long l = -1L;
        SortedMap<Long, PacketItem> sortedMap = this.packetMap;
        synchronized (sortedMap) {
            if (this.packetMap.size() > 0) {
                PacketItem packetItem = (PacketItem)this.packetMap.get(this.packetMap.firstKey());
                PacketItem packetItem2 = (PacketItem)this.packetMap.get(this.packetMap.lastKey());
                l = packetItem2.adjTimecode - packetItem.adjTimecode;
            }
        }
        return l;
    }

    public void setDePacketizer(IRTPDePacketizer iRTPDePacketizer) {
        this.rtpDePacketizer = iRTPDePacketizer;
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return this.rtpDePacketizer.canHandle(rTPTrack);
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.rtpDePacketizer.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        Object object;
        Object object2;
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        int n3 = rTPTrack.getTimescale();
        long l2 = Math.round((double)(l += debugTSOffset) * 1000.0 / (double)n3);
        if (this.initContext && (object2 = rTPTrack.getStream()) != null && (object = ((RTPStream)object2).getAppInstance()) != null) {
            this.contextStr = object.getContextStr() + "/" + ((RTPStream)object2).getStreamName();
            this.initContext = false;
        }
        if (this.startRTTimecode == -1L) {
            this.startRTTimecode = System.currentTimeMillis();
            this.startRTPTimecode = l2;
            this.packetSender = new PacketSender();
            this.packetSender.setDaemon(true);
            this.packetSender.setName("RTPDePacketizerWrapperPacketSorter");
            this.packetSender.start();
        }
        object2 = new PacketItem();
        ((PacketItem)object2).socketAddr = socketAddress;
        ((PacketItem)object2).rtpTrack = rTPTrack;
        ((PacketItem)object2).bytes = byArray;
        ((PacketItem)object2).offset = n;
        ((PacketItem)object2).len = n2;
        ((PacketItem)object2).adjTimecode = l2;
        ((PacketItem)object2).seq = this.seq.longValue();
        object = this.packetMap;
        synchronized (object) {
            this.packetMap.put(new Long(this.seq.longValue()), (PacketItem)object2);
        }
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        this.rtpDePacketizer.init(rTPContext, rTPDePacketizerItem);
        this.rtpDePacketizerPacketSorterBufferTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterBufferTime", this.rtpDePacketizerPacketSorterBufferTime);
        this.rtpDePacketizerPacketSorterFlushTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterFlushTime", this.rtpDePacketizerPacketSorterFlushTime);
        this.rtpDePacketizerPacketSorterOutOfBoundsTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterOutOfBoundsTime", this.rtpDePacketizerPacketSorterOutOfBoundsTime);
        this.rtpDePacketizerPacketSorterLogPacketLoss = this.properties.getPropertyBoolean("rtpDePacketizerPacketSorterLogPacketLoss", this.rtpDePacketizerPacketSorterLogPacketLoss);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterBufferTime: " + this.rtpDePacketizerPacketSorterBufferTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterFlushTime: " + this.rtpDePacketizerPacketSorterFlushTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterLogPacketLoss: " + this.rtpDePacketizerPacketSorterLogPacketLoss);
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.rtpDePacketizer.setProperties(wMSProperties);
        this.properties.putAll(wMSProperties);
    }

    public void shutdown(RTPTrack rTPTrack) {
        this.rtpDePacketizer.shutdown(rTPTrack);
        if (this.packetSender != null) {
            this.packetSender.quit();
        }
        this.packetSender = null;
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtpDePacketizer.startup(rTPTrack);
    }

    class PacketItem {
        public SocketAddress socketAddr = null;
        public RTPTrack rtpTrack = null;
        public byte[] bytes = null;
        public int offset = 0;
        public int len = 0;
        public long adjTimecode = 0L;
        public long seq = 0L;

        PacketItem() {
        }
    }

    class PacketSender
    extends Thread {
        private boolean running = true;
        private boolean quit = false;
        private long lastPacketSeq = -1L;

        PacketSender() {
        }

        public synchronized void quit() {
            this.quit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object;
                        Iterator iterator;
                        Object object2;
                        Object object3;
                        long l = System.currentTimeMillis();
                        long l2 = RTPDePacketizerWrapperPacketSorter.this.startRTPTimecode + (l - RTPDePacketizerWrapperPacketSorter.this.startRTTimecode);
                        boolean bl = false;
                        String string = null;
                        while (true) {
                            object3 = null;
                            object2 = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                            synchronized (object2) {
                                if (RTPDePacketizerWrapperPacketSorter.this.packetMap.size() != 0) {
                                    iterator = (Long)RTPDePacketizerWrapperPacketSorter.this.packetMap.firstKey();
                                    object = (PacketItem)RTPDePacketizerWrapperPacketSorter.this.packetMap.get(iterator);
                                    long l3 = Math.abs(((PacketItem)object).adjTimecode + (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime - l2);
                                    if (l3 > (long)(RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterOutOfBoundsTime + RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime)) {
                                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerWrapperPacketSorter.resetSortBuffer[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + ":" + ((PacketItem)object).rtpTrack.getTrackId() + "]: diff:" + l3);
                                        RTPDePacketizerWrapperPacketSorter.this.startRTTimecode = System.currentTimeMillis();
                                        RTPDePacketizerWrapperPacketSorter.this.startRTPTimecode = ((PacketItem)object).adjTimecode + (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime;
                                        bl = true;
                                        string = ((PacketItem)object).rtpTrack.getTrackId();
                                    } else if (((PacketItem)object).adjTimecode + (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime < l2) {
                                        object3 = object;
                                        RTPDePacketizerWrapperPacketSorter.this.packetMap.remove(iterator);
                                    }
                                }
                                if (object3 == null) break;
                            }
                            ((PacketItem)object3).rtpTrack.getRTPStream().touch();
                            object2 = ((PacketItem)object3).rtpTrack.getRTPStream().getStreamLock();
                            iterator = object2;
                            synchronized (iterator) {
                                RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizer.handleRTPPacket(((PacketItem)object3).socketAddr, ((PacketItem)object3).rtpTrack, ((PacketItem)object3).bytes, ((PacketItem)object3).offset, ((PacketItem)object3).len);
                                if (RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterLogPacketLoss) {
                                    if (this.lastPacketSeq != -1L && ((PacketItem)object3).seq != this.lastPacketSeq + 1L) {
                                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("packetLoss[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + ":" + ((PacketItem)object3).rtpTrack.getTrackId() + "]: last:" + this.lastPacketSeq + " curr:" + ((PacketItem)object3).seq);
                                    }
                                    this.lastPacketSeq = ((PacketItem)object3).seq;
                                }
                            }
                            iterator = this;
                            synchronized (iterator) {
                                if (this.quit) {
                                    this.running = false;
                                    break;
                                }
                            }
                        }
                        if (bl) {
                            int n = 0;
                            object2 = new ArrayList();
                            iterator = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                            synchronized (iterator) {
                                object2.addAll(RTPDePacketizerWrapperPacketSorter.this.packetMap.keySet());
                            }
                            l2 = RTPDePacketizerWrapperPacketSorter.this.startRTPTimecode + (l - RTPDePacketizerWrapperPacketSorter.this.startRTTimecode);
                            iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                long l4;
                                object = (Long)iterator.next();
                                PacketItem packetItem = (PacketItem)RTPDePacketizerWrapperPacketSorter.this.packetMap.get(object);
                                if (packetItem == null || (l4 = Math.abs(packetItem.adjTimecode + (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime - l2)) < (long)(RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterOutOfBoundsTime + RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime)) continue;
                                SortedMap sortedMap = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                                synchronized (sortedMap) {
                                    RTPDePacketizerWrapperPacketSorter.this.packetMap.remove(object);
                                }
                                ++n;
                            }
                            if (n > 0) {
                                int n2 = 0;
                                SortedMap sortedMap = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                                synchronized (sortedMap) {
                                    n2 = RTPDePacketizerWrapperPacketSorter.this.packetMap.size();
                                }
                                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerWrapperPacketSorter.resetSortBufferClean[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + ":" + string + "]: removed:" + n + " remaining:" + n2);
                            }
                        }
                        object3 = this;
                        synchronized (object3) {
                            if (this.quit) {
                                this.running = false;
                                return;
                            }
                        }
                        PacketSender.sleep(RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterFlushTime);
                        object3 = this;
                        synchronized (object3) {
                            if (this.quit) {
                                this.running = false;
                                return;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPacketSorter.PacketSender.run[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + "]: " + exception.toString());
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

