/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentListReader;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.RTPUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPPacket {
    protected List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();
    protected long seq = 0L;
    protected long timecode = 0L;
    protected long timeoffset = 0L;
    protected int size = 0;
    protected int type = 9;
    protected int codec = 7;
    protected int frameType = 0;
    protected boolean debugLog = false;
    protected boolean isRTPPacketDebug = false;
    protected int nalUnitFilter = -1;
    protected boolean isISliceKey = true;
    protected boolean isAllISliceKey = false;
    protected boolean getProperties = true;
    private static long saveStartTimecode = -1L;
    private static boolean wroteVideoConfig = false;
    private static boolean wroteAudioConfig = false;
    private static long lastVideoTC = -1L;

    public RTPPacket() {
    }

    public RTPPacket clone() {
        RTPPacket rTPPacket = new RTPPacket();
        rTPPacket.seq = this.seq;
        rTPPacket.timecode = this.timecode;
        rTPPacket.timeoffset = this.timeoffset;
        rTPPacket.size = this.size;
        rTPPacket.type = this.type;
        rTPPacket.codec = this.codec;
        rTPPacket.frameType = this.frameType;
        rTPPacket.debugLog = this.debugLog;
        rTPPacket.nalUnitFilter = this.nalUnitFilter;
        rTPPacket.fragments.addAll(this.fragments);
        return rTPPacket;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean bl) {
        this.debugLog = bl;
    }

    public RTPPacket(long l, long l2) {
        this.seq = l;
        this.timecode = l2;
    }

    public List<RTPPacketFragment> getFragments() {
        return this.fragments;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long l) {
        this.seq = l;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }

    public void addFragment(RTPPacketFragment rTPPacketFragment) {
        this.fragments.add(rTPPacketFragment);
        this.size += rTPPacketFragment.size();
    }

    public void clearFragments() {
        this.fragments.clear();
        this.size = 0;
    }

    public long getTimeoffset() {
        return this.timeoffset;
    }

    public void setTimeoffset(long l) {
        this.timeoffset = l;
    }

    public void write(RTPTrack rTPTrack, long l) {
        this.write(rTPTrack, l, false);
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        for (RTPPacketFragment rTPPacketFragment : this.fragments) {
            if (byArray == null) continue;
            System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n, rTPPacketFragment.getLen());
            n += rTPPacketFragment.getLen();
        }
        return byArray;
    }

    public RTPPacketCodecConfigInfo getH264CodecConfigInfo(RTPTrack rTPTrack) {
        RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = null;
        byte[] byArray = new byte[5];
        int n = this.getSize();
        RTPPacketFragmentListReader rTPPacketFragmentListReader = new RTPPacketFragmentListReader(this.fragments, n);
        while (rTPPacketFragmentListReader.remaining() >= 5) {
            byte[] byArray2;
            rTPPacketFragmentListReader.get(byArray);
            int n2 = BufferUtils.byteArrayToInt(byArray, 0, 4);
            byte by = byArray[4];
            int n3 = by & 0x1F;
            int n4 = 0;
            if (n2 > 1 && (n3 == 7 || n3 == 8)) {
                if (rTPPacketFragmentListReader.remaining() >= n2 - 1 - n4) {
                    byArray2 = new byte[n2];
                    byArray2[0] = byArray[4];
                    n4 = n2 - 1;
                    rTPPacketFragmentListReader.get(byArray2, 1, n4);
                    if (rTPPacketCodecConfigInfo == null) {
                        rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                    }
                    if (n3 == 7) {
                        rTPPacketCodecConfigInfo.sps = byArray2;
                    } else if (n3 == 8) {
                        if (rTPPacketCodecConfigInfo.ppss == null) {
                            rTPPacketCodecConfigInfo.ppss = new ArrayList<byte[]>();
                        }
                        rTPPacketCodecConfigInfo.ppss.add(byArray2);
                    }
                }
            } else if (n2 > 1 && n3 == 9 && rTPPacketFragmentListReader.remaining() >= n2 - 1 - n4) {
                byArray2 = new byte[n2];
                byArray2[0] = byArray[4];
                rTPPacketFragmentListReader.get(byArray2, 1, n4 += n2 - 1);
                AudDecode audDecode = this.decodeAud(byArray2, 3, byArray2.length - 3);
                if (audDecode.isKeyFrame) {
                    this.frameType = 1;
                }
                if (audDecode.codecConfigInfo != null) {
                    rTPPacketCodecConfigInfo = audDecode.codecConfigInfo;
                }
            }
            if (rTPPacketFragmentListReader.remaining() < n2 - 1 - n4) break;
            rTPPacketFragmentListReader.skip(n2 - 1 - n4);
            if (rTPPacketFragmentListReader.remaining() != 0) continue;
            break;
        }
        if (rTPPacketCodecConfigInfo != null) {
            if (rTPPacketCodecConfigInfo.sps == null && rTPTrack != null) {
                rTPPacketCodecConfigInfo.sps = rTPTrack.getSPS();
            }
            if (rTPPacketCodecConfigInfo.ppss == null && rTPTrack != null) {
                rTPPacketCodecConfigInfo.ppss = rTPTrack.getPPS();
            }
            if (rTPPacketCodecConfigInfo.sps == null || rTPPacketCodecConfigInfo.ppss == null) {
                rTPPacketCodecConfigInfo = null;
            }
        }
        return rTPPacketCodecConfigInfo;
    }

    public void decodeAudNALUnit(AudDecode audDecode, byte[] byArray, int n, int n2) {
        if (n2 >= 1) {
            int n3 = byArray[n] & 0x1F;
            if (n3 == 5) {
                audDecode.isKeyFrame = true;
            } else if (n3 == 7 || n3 == 8) {
                if (audDecode.codecConfigInfo == null) {
                    audDecode.codecConfigInfo = new RTPPacketCodecConfigInfo();
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                if (n3 == 7) {
                    audDecode.codecConfigInfo.sps = byArray2;
                } else if (n3 == 8) {
                    if (audDecode.codecConfigInfo.ppss == null) {
                        audDecode.codecConfigInfo.ppss = new ArrayList<byte[]>();
                    }
                    audDecode.codecConfigInfo.ppss.add(byArray2);
                }
            } else if (n3 == 1) {
                byte[] byArray3 = new byte[20];
                int n4 = 0;
                for (int i = 1; i < byArray3.length + 1; ++i) {
                    if (i >= 2 && byArray[i] == 3 && byArray[i - 1] == 0 && byArray[i - 2] == 0) continue;
                    byArray3[n4] = byArray[i];
                    ++n4;
                }
                BitReader bitReader = new BitReader(byArray3, n4);
                int n5 = bitReader.readExpGolomb();
                int n6 = bitReader.readExpGolomb();
                if (n6 == 2 || n6 == 7) {
                    audDecode.isKeyFrame = true;
                }
            }
        }
    }

    public AudDecode decodeAud(byte[] byArray, int n, int n2) {
        AudDecode audDecode = new AudDecode();
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n2 - 3; ++i) {
            if (byArray[n + i] != 0 || byArray[n + i + 1] != 0 || byArray[n + i + 2] != 1) continue;
            if (n4 >= 0) {
                ++n3;
                this.decodeAudNALUnit(audDecode, byArray, n + n4, i - n4);
            }
            n4 = i + 3;
        }
        if (n4 > 0) {
            ++n3;
            this.decodeAudNALUnit(audDecode, byArray, n + n4, n2 - n4);
        }
        return audDecode;
    }

    private void init(IMediaStream iMediaStream) {
        if (this.getProperties && iMediaStream != null) {
            this.nalUnitFilter = iMediaStream.getProperties().getPropertyInt("nalUnitFilter", 0);
            this.isISliceKey = iMediaStream.getProperties().getPropertyBoolean("isISliceKey", this.isISliceKey);
            this.isAllISliceKey = iMediaStream.getProperties().getPropertyBoolean("isAllISliceKey", this.isAllISliceKey);
            this.isRTPPacketDebug = iMediaStream.getProperties().getPropertyBoolean("isRTPPacketDebug", this.isRTPPacketDebug);
            if (this.isRTPPacketDebug) {
                this.debugLog = true;
            }
            this.getProperties = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(RTPTrack rTPTrack, long l, boolean bl) {
        if (bl) {
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Object object;
            byte[] byArray = null;
            IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
            boolean bl2 = true;
            this.init(iMediaStream);
            if (this.type == 9) {
                if (this.codec == 7) {
                    void var12_16;
                    int n6;
                    int n7;
                    this.frameType = 2;
                    byte[] byArray2 = new byte[5];
                    object = new byte[20];
                    byte[] byArray3 = new byte[20];
                    n5 = this.getSize();
                    Object var12_15 = null;
                    n4 = 1;
                    n3 = 0;
                    n2 = 0;
                    ArrayList<RTPPacketFragment> arrayList = this.nalUnitFilter > 0 ? new ArrayList<RTPPacketFragment>() : null;
                    RTPPacketFragmentListReader rTPPacketFragmentListReader = new RTPPacketFragmentListReader(this.fragments, n5);
                    bl2 = false;
                    n = 0;
                    boolean bl3 = false;
                    do {
                        Object object2;
                        int n8;
                        if (rTPPacketFragmentListReader.remaining() < 5) {
                            n8 = rTPPacketFragmentListReader.count();
                            if (n8 < 0) {
                                n8 = 0;
                            }
                            if (n8 > 0) {
                                RTPPacketFragmentListReader.trim(this.fragments, n8);
                            }
                            this.size = n8;
                            if (!bl) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).warn("RTPPacket.write: Bad packet: Incomplete NAL Units.");
                            }
                            break;
                        }
                        n8 = rTPPacketFragmentListReader.count();
                        rTPPacketFragmentListReader.get(byArray2);
                        n7 = BufferUtils.byteArrayToInt(byArray2, 0, 4);
                        byte by = byArray2[4];
                        int n9 = by & 0x1F;
                        if (n7 - 1 > rTPPacketFragmentListReader.remaining() || n7 < 0) break;
                        n6 = n7 + 4;
                        if (this.debugLog) {
                            String string = "  nalUnit: hdr:" + Integer.toHexString(by & 0xFF) + " sz:" + n7 + ":" + n5 + " typ:" + H264Utils.nalUnitTypeToStr(n9);
                            if (this.isRTPPacketDebug) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).info(string);
                            } else {
                                WMSLoggerFactory.getLogger(RTPPacket.class).debug(string);
                            }
                        }
                        int n10 = 0;
                        if (n9 == 12) {
                            n3 = 1;
                        } else {
                            n4 = 0;
                        }
                        if (n9 == 5) {
                            this.frameType = 1;
                            bl2 = true;
                        } else if (n9 == 9) {
                            bl2 = true;
                            if (rTPPacketFragmentListReader.remaining() >= n7 - 1 - n10) {
                                byte[] byArray4 = new byte[n7];
                                byArray4[0] = byArray2[4];
                                rTPPacketFragmentListReader.get(byArray4, 1, n10 += n7 - 1);
                                object2 = this.decodeAud(byArray4, 3, byArray4.length - 3);
                                if (((AudDecode)object2).isKeyFrame) {
                                    this.frameType = 1;
                                }
                                if (((AudDecode)object2).codecConfigInfo != null) {
                                    RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = ((AudDecode)object2).codecConfigInfo;
                                }
                            }
                        } else if (n9 == 7 || n9 == 8) {
                            if (rTPPacketFragmentListReader.remaining() >= n7 - 1 - n10) {
                                byte[] byArray5 = new byte[n7];
                                byArray5[0] = byArray2[4];
                                rTPPacketFragmentListReader.get(byArray5, 1, n10 += n7 - 1);
                                if (var12_16 == null) {
                                    RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                                }
                                if (n9 == 7) {
                                    var12_16.sps = byArray5;
                                    bl3 = true;
                                } else if (n9 == 8) {
                                    if (var12_16.ppss == null) {
                                        var12_16.ppss = new ArrayList<byte[]>();
                                    }
                                    var12_16.ppss.add(byArray5);
                                    n = 1;
                                }
                            }
                        } else if (n9 == 1) {
                            bl2 = true;
                            n10 = ((byte[])object).length;
                            if (n10 > rTPPacketFragmentListReader.remaining()) {
                                n10 = rTPPacketFragmentListReader.remaining();
                            }
                            if (n10 > n7 - 1) {
                                n10 = n7 - 1;
                            }
                            rTPPacketFragmentListReader.get((byte[])object, 0, n10);
                            int n11 = 0;
                            for (int i = 0; i < n10; ++i) {
                                if (i >= 2 && object[i] == 3 && object[i - 1] == 0 && object[i - 2] == 0) continue;
                                byArray3[n11] = object[i];
                                ++n11;
                            }
                            object2 = new BitReader(byArray3, n11);
                            int n12 = ((BitReader)object2).readExpGolomb();
                            int n13 = ((BitReader)object2).readExpGolomb();
                            if (n13 == 2 || n13 == 7) {
                                this.frameType = this.isISliceKey ? 1 : 2;
                            } else if (n13 == 1 || n13 == 6) {
                                this.frameType = 3;
                            }
                            if (this.isAllISliceKey) {
                                this.frameType = 1;
                            }
                            if (this.debugLog) {
                                String string = "  sliceType:" + n13 + " frameType:" + this.frameType + ":" + FLVUtils.frameTypeToString(this.frameType) + " isISliceIsKey:" + this.isISliceKey + " isAllISliceKey:" + this.isAllISliceKey;
                                if (this.isRTPPacketDebug) {
                                    WMSLoggerFactory.getLogger(RTPPacket.class).info(string);
                                } else {
                                    WMSLoggerFactory.getLogger(RTPPacket.class).debug(string);
                                }
                            }
                        } else if (n9 <= 6) {
                            bl2 = true;
                        }
                        if (arrayList != null) {
                            if (n9 < this.nalUnitFilter) {
                                arrayList.add(new RTPPacketFragment(null, n8, n6));
                            } else {
                                n2 = 1;
                            }
                        }
                        if (rTPPacketFragmentListReader.remaining() < n7 - 1 - n10) {
                            int n14 = rTPPacketFragmentListReader.count() - 5 - n10;
                            if (n14 < 0) {
                                n14 = 0;
                            }
                            if (n14 > 0) {
                                RTPPacketFragmentListReader.trim(this.fragments, n14);
                            }
                            this.size = n14;
                            if (!bl) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).warn("RTPPacket.write: Bad packet: Incomplete NAL Units.");
                            }
                            break;
                        }
                        rTPPacketFragmentListReader.skip(n7 - 1 - n10);
                    } while (rTPPacketFragmentListReader.remaining() != 0);
                    if (arrayList != null && n2 != 0 && this.getSize() >= 0) {
                        byte[] byArray6 = new byte[this.getSize()];
                        n7 = 0;
                        for (RTPPacketFragment rTPPacketFragment : this.fragments) {
                            n6 = rTPPacketFragment.getLen();
                            System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray6, n7, n6);
                            n7 += n6;
                        }
                        this.size = 0;
                        for (RTPPacketFragment rTPPacketFragment : arrayList) {
                            rTPPacketFragment.setBuffer(byArray6);
                            this.size += rTPPacketFragment.getLen();
                        }
                        this.fragments = arrayList;
                    }
                    if (var12_16 != null) {
                        boolean bl4 = false;
                        n7 = 0;
                        byte[] byArray7 = null;
                        if (var12_16.sps != null && var12_16.ppss != null) {
                            byte[] byArray8 = null;
                            String string = rTPTrack.getTrackInfo("profile-level-id");
                            if (string != null) {
                                byArray8 = BufferUtils.decodeHexString(string);
                            }
                            if ((byArray7 = RTPUtils.formatH264CodecConfig(var12_16.sps, var12_16.ppss, byArray8)) != null) {
                                byte[] byArray9 = rTPTrack.getCodecConfig();
                                if (byArray9 == null) {
                                    bl4 = true;
                                    n7 = 1;
                                } else {
                                    int n15 = n7 = !Arrays.equals(byArray9, byArray7) ? 1 : 0;
                                }
                            }
                        }
                        if (this.debugLog && (n7 != 0 || bl4)) {
                            String string = "RTPPacket.write: videoCodecConfig[set:" + (n7 != 0) + " send:" + bl4 + "]: " + DebugUtils.formatBytesShort(byArray7);
                            if (this.isRTPPacketDebug) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).info(string);
                            } else {
                                WMSLoggerFactory.getLogger(RTPPacket.class).debug(string);
                            }
                        }
                        if (n7 != 0) {
                            rTPTrack.setCodecConfig(byArray7);
                        }
                        if (bl4) {
                            RTPUtils.writeCodecConfig(rTPTrack, l, byArray7);
                        }
                    }
                }
                switch (this.codec) {
                    case 7: {
                        byArray = new byte[]{(byte)(this.codec + (this.frameType << 4)), 1, (byte)(this.timeoffset >> 16 & 0xFFL), (byte)(this.timeoffset >> 8 & 0xFFL), (byte)(this.timeoffset >> 0 & 0xFFL)};
                        break;
                    }
                    default: {
                        byArray = new byte[]{(byte)(this.codec + (this.frameType << 4))};
                        break;
                    }
                }
            } else if (this.type == 8) {
                switch (this.codec) {
                    case 10: {
                        byArray = new byte[]{(byte)((this.codec << 4) + this.frameType), 1};
                        break;
                    }
                    default: {
                        byArray = new byte[]{(byte)((this.codec << 4) + this.frameType)};
                    }
                }
            }
            if (!bl2 || this.getSize() <= 0) return;
            int n16 = this.getSize() + (byArray == null ? 0 : byArray.length);
            if (iMediaStream == null) return;
            rTPTrack.checkSendMetadata(l);
            if (this.debugLog) {
                object = "  writePacket[" + (this.type == 9 ? "vid" : "aud") + "]: sz:" + n16 + " tc:" + l + ":" + this.timecode + ":" + System.currentTimeMillis() + ":" + this.timeoffset + (this.type == 9 ? " key:" + (this.frameType == 1) : "");
                if (this.isRTPPacketDebug) {
                    WMSLoggerFactory.getLogger(RTPPacket.class).info((String)object);
                } else {
                    WMSLoggerFactory.getLogger(RTPPacket.class).debug((String)object);
                }
            }
            object = null;
            int n17 = 0;
            if (this.type == 9) {
                n5 = byArray.length;
                for (RTPPacketFragment rTPPacketFragment : this.fragments) {
                    n5 += rTPPacketFragment.getLen();
                }
                iMediaStream.setVideoTC(l, true);
                iMediaStream.setVideoSize(n16);
                iMediaStream.startVideoPacket();
                iMediaStream.addVideoData(byArray, 0, byArray.length);
            } else if (this.type == 8) {
                iMediaStream.setAudioTC(l, true);
                iMediaStream.setAudioSize(n16);
                iMediaStream.startAudioPacket();
                iMediaStream.addAudioData(byArray, 0, byArray.length);
            } else if (this.type == 18 || this.type == 15) {
                iMediaStream.setDataType(this.type);
                iMediaStream.setDataTC(l, true);
                iMediaStream.setDataSize(n16);
                iMediaStream.startDataPacket();
                if (byArray != null) {
                    iMediaStream.addDataData(byArray, 0, byArray.length);
                }
            }
            for (RTPPacketFragment rTPPacketFragment : this.fragments) {
                if (rTPPacketFragment.getLen() <= 0) continue;
                if (this.type == 9) {
                    if (object != null) {
                        System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), object, n17, rTPPacketFragment.getLen());
                        n17 += rTPPacketFragment.getLen();
                    }
                    iMediaStream.addVideoData(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), rTPPacketFragment.getLen());
                    continue;
                }
                if (this.type != 8) continue;
                iMediaStream.addAudioData(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), rTPPacketFragment.getLen());
            }
            if (object == null) return;
            boolean bl5 = false;
            n4 = 0;
            n3 = 0;
            while (((byte[])object).length - n4 >= 5) {
                int n18;
                n2 = BufferUtils.byteArrayToInt(object, n4, 4);
                byte by = object[n4 + 4];
                int n19 = by & 0x1F;
                n = by >> 5 & 7;
                if (n > n18) {
                    n18 = n;
                }
                ++n3;
                if ((n4 += n2 + 4) < ((byte[])object).length) continue;
                break;
            }
            if (n4 == ((byte[])object).length) return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacket.class).error("RTPPacket.write: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class AudDecode {
        public boolean isKeyFrame = false;
        public RTPPacketCodecConfigInfo codecConfigInfo = null;

        AudDecode() {
        }
    }
}

