/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.IRTSPActionNotify;
import com.wowza.wms.rtp.model.RTPIdleHandler;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPWriteListener;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.vhost.IVHost;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPSession {
    public static final int AUTHMETHOD_UNKNOWN = 0;
    public static final int AUTHMETHOD_PLAY = 1;
    public static final int AUTHMETHOD_PUBLISH = 2;
    protected String sessionId = null;
    protected String rtspTunnelingSessionId = null;
    protected Map<String, RTPStream> streams = new HashMap<String, RTPStream>();
    protected List<RTPStream> streamsOrder = new ArrayList<RTPStream>();
    protected IVHost vhost = null;
    protected String userAgent = "known";
    protected String cookieStr = null;
    protected String ip = "127.0.0.1";
    protected boolean isSessionValid = true;
    protected IAuthenticateRTSP authenticatePlayHandler = null;
    protected IAuthenticateRTSP authenticatePublishHandler = null;
    protected int lastAuthenticateMethod = 0;
    protected IApplicationInstance appInstance = null;
    protected IApplicationInstance appInstanceShutdown = null;
    protected boolean loggedConnect = false;
    protected WMSProperties properties = new WMSProperties();
    protected boolean isDescribe = false;
    protected boolean isAnnounce = false;
    protected RTPWriteListener rtpWriteListener = new RTPWriteListener(this);
    protected long timeCreated = -1L;
    protected IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    protected IOPerformanceCounter totalIOPerformanceLast = new IOPerformanceCounter();
    protected IOPerformanceCounter totalIOPerformance2Last = new IOPerformanceCounter();
    protected ConnectionHolder connectionHolder = new ConnectionHolder(null);
    protected boolean isConnected = false;
    protected RTPIdleHandler idleHandler = null;
    protected String serverIp = null;
    protected int serverPort = 80;
    protected String uri = null;
    protected String referrer = null;
    protected String queryStr = null;
    protected List<IRTSPActionNotify> actionListeners = new ArrayList<IRTSPActionNotify>();
    protected ElapsedTimer elapsedTime = new ElapsedTimer();
    protected int idleFrequency = -1;
    protected boolean debugRTSPSession = false;
    protected double rtspPlayRangeStart = -1.0;
    protected double rtspPlayRangeStop = -1.0;
    protected boolean shutdownClient = false;

    public RTPSession(String string) {
        this.sessionId = string;
        this.timeCreated = System.currentTimeMillis();
        this.connectionHolder.setConnectionType(1);
    }

    public void acceptSession() {
        this.isSessionValid = true;
    }

    public void rejectSession() {
        this.isSessionValid = false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public void addRTSPStream(RTPStream rTPStream) {
        rTPStream.setSession(this);
        this.streams.put(rTPStream.getStreamId(), rTPStream);
        this.streamsOrder.add(rTPStream);
    }

    public RTPStream removeRTSPStream(String string) {
        RTPStream rTPStream = this.streams.remove(string);
        if (rTPStream != null) {
            this.streamsOrder.remove(rTPStream);
        }
        return rTPStream;
    }

    public RTPStream getRTSPStream(String string) {
        return this.streams.get(string);
    }

    public RTPStream getRTSPStream() {
        RTPStream rTPStream = null;
        if (this.streamsOrder.size() > 0) {
            rTPStream = this.streamsOrder.get(this.streamsOrder.size() - 1);
        }
        return rTPStream;
    }

    public synchronized IVHost getVHost() {
        return this.vhost;
    }

    public synchronized void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public synchronized String getUserAgent() {
        return this.userAgent;
    }

    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void touch() {
        for (RTPStream rTPStream : this.streams.values()) {
            rTPStream.touch();
        }
    }

    public void shutdown() {
        RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
        this.shutdown(rTPRequestStatus);
    }

    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        if (this.appInstanceShutdown != null) {
            Object object;
            if (this.isConnected()) {
                object = this.disconnectConnection();
                if (object != null) {
                    this.checkDisconnectLicense((byte[])object);
                }
                this.setConnected(false);
            }
            this.appInstance.removeRTPSession(this);
            object = this.streams.values().iterator();
            while (object.hasNext()) {
                RTPStream rTPStream = (RTPStream)object.next();
                try {
                    rTPStream.shutdown(rTPRequestStatus);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPSession.shutdown: " + exception.toString());
                }
            }
            this.streams.clear();
            this.streamsOrder.clear();
            if (this.rtpWriteListener != null) {
                this.rtpWriteListener.unhook();
            }
            this.rtpWriteListener = null;
            this.appInstanceShutdown = null;
        }
    }

    private byte[] disconnectConnection() {
        byte[] byArray = null;
        byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
            }
            this.appInstance.getConnectionCounter().disconnect(this.getConnectionHolder(), byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private void checkDisconnectLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bail1:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    public boolean isSessionValid() {
        return this.isSessionValid;
    }

    public void setSessionValid(boolean bl) {
        this.isSessionValid = bl;
    }

    public IAuthenticateRTSP getAuthenticatePublishHandler() {
        return this.authenticatePublishHandler;
    }

    public void setAuthenticatePublishHandler(IAuthenticateRTSP iAuthenticateRTSP) {
        this.authenticatePublishHandler = iAuthenticateRTSP;
    }

    public IAuthenticateRTSP getAuthenticatePlayHandler() {
        return this.authenticatePlayHandler;
    }

    public void setAuthenticatePlayHandler(IAuthenticateRTSP iAuthenticateRTSP) {
        this.authenticatePlayHandler = iAuthenticateRTSP;
    }

    public int getLastAuthenticateMethod() {
        return this.lastAuthenticateMethod;
    }

    public void setLastAuthenticateMethod(int n) {
        this.lastAuthenticateMethod = n;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        if (iApplicationInstance != null) {
            iApplicationInstance.addRTPSession(this);
        }
        this.appInstance = iApplicationInstance;
        this.appInstanceShutdown = iApplicationInstance;
        if (iApplicationInstance != null) {
            this.setIdleFrequency(iApplicationInstance.getRTPIdleFrequency());
        }
    }

    public boolean isLoggedConnect() {
        return this.loggedConnect;
    }

    public void setLoggedConnect(boolean bl) {
        this.loggedConnect = bl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    public void setDescribe(boolean bl) {
        this.isDescribe = bl;
    }

    public boolean isAnnounce() {
        return this.isAnnounce;
    }

    public void setAnnounce(boolean bl) {
        this.isAnnounce = bl;
    }

    public boolean isAnnounceOrDescribe() {
        return this.isAnnounce | this.isDescribe;
    }

    public RTPWriteListener getRTPWriteListener() {
        return this.rtpWriteListener;
    }

    public void addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        RTPStream rTPStream = this.getRTSPStream();
        if (rTPStream == null) {
            return;
        }
        IMediaStream iMediaStream = rTPStream.getStream();
        if (iMediaStream != null) {
            IOPerformanceCounter iOPerformanceCounter2 = this.getIOPerformanceCounter().clone();
            iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformanceLast);
            this.totalIOPerformanceLast = iOPerformanceCounter2;
        }
    }

    public void addIOPerformance2(IOPerformanceCounter iOPerformanceCounter) {
        RTPStream rTPStream = this.getRTSPStream();
        if (rTPStream == null) {
            return;
        }
        IMediaStream iMediaStream = rTPStream.getStream();
        if (iMediaStream != null) {
            IOPerformanceCounter iOPerformanceCounter2 = this.getIOPerformanceCounter().clone();
            iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformance2Last);
            this.totalIOPerformance2Last = iOPerformanceCounter2;
        }
    }

    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public RTPIdleHandler getIdleHandler() {
        return this.idleHandler;
    }

    public void setIdleHandler(RTPIdleHandler rTPIdleHandler) {
        this.idleHandler = rTPIdleHandler;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String string) {
        this.serverIp = string;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getQueryStr() {
        return this.queryStr;
    }

    public void setQueryStr(String string) {
        this.queryStr = string;
    }

    public void updateLoggingValues() {
        block10: {
            IMediaReader iMediaReader;
            String string;
            WMSLoggerFactory.putGlobalLogValue("c-client-id", new Integer(Integer.parseInt(this.getSessionId())));
            WMSLoggerFactory.putGlobalLogValue("c-ip", this.ip);
            WMSLoggerFactory.putGlobalLogValue("c-proto", "rtsp");
            WMSLoggerFactory.putGlobalLogValue("x-app", this.appInstance.getApplication().getName());
            WMSLoggerFactory.putGlobalLogValue("x-appinst", this.appInstance.getName());
            WMSLoggerFactory.putGlobalLogValue("x-vhost", this.getVHost().getName());
            String string2 = this.getUri();
            String string3 = this.getQueryStr();
            if (string3 != null && string3.length() > 0) {
                string2 = string2 + "?" + string3;
            }
            if ((string = this.getReferrer()) == null) {
                string = "";
            }
            string.replace("|", "%7c");
            String string4 = "";
            if (string2 != null && string2.toLowerCase().indexOf("://") < 0) {
                string4 = "rtsp://" + this.serverIp + ":" + this.serverPort;
                if (!string2.startsWith("/")) {
                    string4 = "/" + string4;
                }
            }
            String string5 = null;
            RTPStream rTPStream = this.getRTSPStream();
            if (rTPStream != null) {
                string5 = rTPStream.getStreamNameLogging();
            }
            WMSLoggerFactory.putGlobalLogValue("s-uri", string4 + string2);
            WMSLoggerFactory.putGlobalLogValue("cs-uri-stem", string4 + this.uri);
            WMSLoggerFactory.putGlobalLogValue("x-suri", string4 + string2);
            WMSLoggerFactory.putGlobalLogValue("x-suri-stem", string4 + this.uri);
            if (string5 != null) {
                WMSLoggerFactory.putGlobalLogValue("x-sname", string5);
            } else {
                WMSLoggerFactory.removeGlobalLogValue("x-sname");
            }
            if (string3 != null) {
                WMSLoggerFactory.putGlobalLogValue("x-suri-query", string3);
                WMSLoggerFactory.putGlobalLogValue("x-sname-query", string3);
                WMSLoggerFactory.putGlobalLogValue("cs-uri-query", string3);
            } else {
                WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
                WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
                WMSLoggerFactory.removeGlobalLogValue("cs-uri-query");
            }
            WMSLoggerFactory.putGlobalLogValue("c-referrer", this.referrer);
            WMSLoggerFactory.putGlobalLogValue("c-user-agent", this.userAgent);
            WMSLoggerFactory.putGlobalLogValue("s-ip", this.serverIp);
            WMSLoggerFactory.putGlobalLogValue("s-port", this.serverPort);
            long l = 0L;
            long l2 = 0L;
            if (rTPStream != null) {
                l2 = this.getIOPerformanceCounter().getMessagesOutBytes();
                l = this.getIOPerformanceCounter().getMessagesInBytes();
            }
            WMSLoggerFactory.putGlobalLogValue("sc-bytes", new Long(l2));
            WMSLoggerFactory.putGlobalLogValue("cs-bytes", new Long(l));
            WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
            if (rTPStream == null || (iMediaReader = rTPStream.getMediaReader()) == null) break block10;
            WMSLoggerFactory.putGlobalLogValue("x-file-name", iMediaReader.getPath());
            WMSLoggerFactory.putGlobalLogValue("x-file-ext", iMediaReader.getMediaExtension());
            WMSLoggerFactory.putGlobalLogValue("x-file-size", new Long(iMediaReader.getLength()));
            WMSLoggerFactory.putGlobalLogValue("x-file-length", new Double((double)iMediaReader.getDuration() / 1000.0));
            WMSLoggerFactory.putGlobalLogValue("x-spos", new Long(rTPStream.getVODLastTimeTC()));
        }
    }

    public void clearLoggingValues() {
        WMSLoggerFactory.removeGlobalLogValue("c-client-id");
        WMSLoggerFactory.removeGlobalLogValue("c-ip");
        WMSLoggerFactory.removeGlobalLogValue("c-proto");
        WMSLoggerFactory.removeGlobalLogValue("x-app");
        WMSLoggerFactory.removeGlobalLogValue("x-appinst");
        WMSLoggerFactory.removeGlobalLogValue("x-vhost");
        WMSLoggerFactory.removeGlobalLogValue("s-uri");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-stem");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-query");
        WMSLoggerFactory.removeGlobalLogValue("c-referrer");
        WMSLoggerFactory.removeGlobalLogValue("c-user-agent");
        WMSLoggerFactory.removeGlobalLogValue("s-ip");
        WMSLoggerFactory.removeGlobalLogValue("s-port");
        WMSLoggerFactory.removeGlobalLogValue("x-file-name");
        WMSLoggerFactory.removeGlobalLogValue("x-file-ext");
        WMSLoggerFactory.removeGlobalLogValue("x-file-size");
        WMSLoggerFactory.removeGlobalLogValue("x-file-length");
        WMSLoggerFactory.removeGlobalLogValue("sc-bytes");
        WMSLoggerFactory.removeGlobalLogValue("cs-bytes");
        WMSLoggerFactory.removeGlobalLogValue("x-spos");
        WMSLoggerFactory.removeGlobalLogValue("x-suri");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-stem");
        WMSLoggerFactory.removeGlobalLogValue("x-sname");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
        WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(IRTSPActionNotify iRTSPActionNotify) {
        List<IRTSPActionNotify> list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(iRTSPActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(IRTSPActionNotify iRTSPActionNotify) {
        List<IRTSPActionNotify> list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.remove(iRTSPActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IRTSPActionNotify> getLocalActionListeners() {
        ArrayList<IRTSPActionNotify> arrayList = null;
        List<IRTSPActionNotify> list = this.actionListeners;
        synchronized (list) {
            if (this.actionListeners.size() > 0) {
                arrayList = new ArrayList<IRTSPActionNotify>();
                arrayList.addAll(this.actionListeners);
            }
        }
        return arrayList;
    }

    public void onDescribe(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onDescribe(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onAnnounce(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onAnnounce(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onGetParameter(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onGetParameter(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onSetParameter(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onSetParameter(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onOptions(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onOptions(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onPause(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onPause(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onPlay(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onPlay(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onRecord(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onRecord(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onRedirect(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onRedirect(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onSetup(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onSetup(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public void onTeardown(RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        List<IRTSPActionNotify> list = this.getLocalActionListeners();
        if (list != null) {
            for (IRTSPActionNotify iRTSPActionNotify : list) {
                iRTSPActionNotify.onTeardown(this, rTSPRequestMessage, rTSPResponseMessages);
            }
        }
    }

    public int getIdleFrequency() {
        return this.idleFrequency;
    }

    public void setIdleFrequency(int n) {
        this.idleFrequency = n;
    }

    public boolean isDebugRTSPSession() {
        return this.debugRTSPSession;
    }

    public void setDebugRTSPSession(boolean bl) {
        this.debugRTSPSession = bl;
    }

    public String getRTSPTunnelingSessionId() {
        return this.rtspTunnelingSessionId;
    }

    public void setRTSPTunnelingSessionId(String string) {
        this.rtspTunnelingSessionId = string;
    }

    public double getRTSPPlayRangeStart() {
        return this.rtspPlayRangeStart;
    }

    public void setRTSPPlayRangeStart(double d) {
        this.rtspPlayRangeStart = d;
    }

    public double getRTSPPlayRangeStop() {
        return this.rtspPlayRangeStop;
    }

    public void setRTSPPlayRangeStop(double d) {
        this.rtspPlayRangeStop = d;
    }

    public String getCookieStr() {
        return this.cookieStr;
    }

    public void setCookieStr(String string) {
        this.cookieStr = string;
    }

    public IOPerformanceCounter getIOPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    public void setIOPerformanceCounter(IOPerformanceCounter iOPerformanceCounter) {
        this.ioPerformanceCounter = iOPerformanceCounter;
    }

    public boolean isShutdownClient() {
        return this.shutdownClient;
    }

    public void setShutdownClient(boolean bl) {
        this.shutdownClient = bl;
    }
}

