/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class UDPRunner
implements Runnable {
    private long packetCount = 0L;
    private boolean running = false;
    private List<UDPMessage> messages = new ArrayList<UDPMessage>();
    private Executor executor = null;

    public long incPacketCount() {
        return ++this.packetCount;
    }

    public synchronized void handleMessage(SocketAddress socketAddress, IUDPMessageHandler iUDPMessageHandler, Object object) {
        this.messages.add(new UDPMessage(socketAddress, iUDPMessageHandler, object));
        if (!this.running) {
            this.running = true;
            this.executor.execute(this);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            UDPMessage uDPMessage = null;
            int n = 0;
            UDPRunner uDPRunner = this;
            synchronized (uDPRunner) {
                n = this.messages.size();
                if (n <= 0) {
                    this.running = false;
                    break;
                }
                uDPMessage = this.messages.remove(0);
            }
            if (uDPMessage == null) continue;
            uDPMessage.handler.handleMessage(uDPMessage.socketAddr, uDPMessage.message);
        }
    }

    class UDPMessage {
        public SocketAddress socketAddr = null;
        public Object message = null;
        private IUDPMessageHandler handler = null;

        public UDPMessage(SocketAddress socketAddress, IUDPMessageHandler iUDPMessageHandler, Object object) {
            this.socketAddr = socketAddress;
            this.handler = iUDPMessageHandler;
            this.message = object;
        }
    }
}

