/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.Server;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.CharsetUtil;

public class CommandInterface
extends IoHandlerAdapter {
    private CharsetDecoder decoder = CharsetUtil.getDefaultCharset().newDecoder();
    IServer server = null;
    ByteBuffer msg = ByteBuffer.allocate((int)100);

    public CommandInterface(IServer iServer) {
        this.server = iServer;
    }

    public void sessionCreated(IoSession ioSession) {
    }

    public void sessionOpened(IoSession ioSession) {
    }

    public void messageReceived(IoSession ioSession, Object object) {
        if (!(object instanceof ByteBuffer)) {
            return;
        }
        try {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            this.msg.put(byteBuffer);
            if (this.msg.position() > 0 && this.msg.get(this.msg.position() - 1) == 0) {
                int n = this.msg.position() - 1;
                this.msg.rewind();
                String string = this.msg.getString(n, this.decoder);
                this.processCommand(string);
                this.msg.clear();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("messageReceived: " + exception.toString());
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        ioSession.close();
    }

    private void processCommand(String string) {
        if (string.equals("shutdown") && this.server != null) {
            ((Server)this.server).stopServer();
        }
    }
}

