/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.hint;

import com.wowza.util.DebugUtils;
import com.wowza.wms.mediareader.h264.atom.QTMediaCursor;
import com.wowza.wms.mediareader.h264.hint.QTHintDataEntry;
import java.io.RandomAccessFile;

public class QTHintEntry {
    public static final byte DATAMODE_NOOP = 0;
    public static final byte DATAMODE_IMMEDIATE = 1;
    public static final byte DATAMODE_SAMPLE = 2;
    public static final byte DATAMODE_SAMPLEDESCRIPTION = 3;
    private static final int DATAENTRY_MINSIZE = 8;
    public QTHintDataEntry[] dataEntries = null;
    public int dataCount = 0;
    public int relativeTransmissionTime = 0;
    public int timecodeOffset = 0;
    public byte[] headerInfo = new byte[2];
    public int seqNum = 0;
    public byte[] flags = new byte[2];
    public boolean hasTLV = false;
    public boolean isBFrame = false;
    public boolean isRFrame = false;

    public QTHintEntry() {
        this.dataEntries = new QTHintDataEntry[8];
        for (int i = 0; i < this.dataEntries.length; ++i) {
            this.dataEntries[i] = new QTHintDataEntry();
        }
    }

    private void checkDataCount() {
        if (this.dataCount > this.dataEntries.length) {
            QTHintDataEntry[] qTHintDataEntryArray = new QTHintDataEntry[this.dataCount];
            for (int i = 0; i < qTHintDataEntryArray.length; ++i) {
                qTHintDataEntryArray[i] = i < this.dataEntries.length ? this.dataEntries[i] : new QTHintDataEntry();
            }
            this.dataEntries = qTHintDataEntryArray;
        }
    }

    public void setDataCount(int n) {
        this.dataCount = n;
        this.checkDataCount();
    }

    public int getPacketSize() {
        int n = 12;
        for (int i = 0; i < this.dataCount; ++i) {
            n += this.dataEntries[i].getPacketSize();
        }
        return n;
    }

    public int getPacketOffset() {
        int n = 0;
        for (int i = 0; i < this.dataCount; ++i) {
            int n2 = this.dataEntries[i].getPacketOffset();
            if (n2 <= 0) continue;
            n = n2;
            break;
        }
        return n;
    }

    public void fillPacket(byte[] byArray, byte[] byArray2, int n, long l, int n2, RandomAccessFile randomAccessFile, QTMediaCursor qTMediaCursor) {
        int n3 = n;
        System.arraycopy(this.headerInfo, 0, byArray, n3, this.headerInfo.length);
        byArray[(n3 += this.headerInfo.length) + 0] = (byte)(0xFF & this.seqNum >> 8);
        byArray[n3 + 1] = (byte)(0xFF & this.seqNum);
        byArray[(n3 += 2) + 0] = (byte)(0xFFL & l >> 24);
        byArray[n3 + 1] = (byte)(0xFFL & l >> 16);
        byArray[n3 + 2] = (byte)(0xFFL & l >> 8);
        byArray[n3 + 3] = (byte)(0xFFL & l);
        byArray[(n3 += 4) + 0] = (byte)(0xFF & n2 >> 24);
        byArray[n3 + 1] = (byte)(0xFF & n2 >> 16);
        byArray[n3 + 2] = (byte)(0xFF & n2 >> 8);
        byArray[n3 + 3] = (byte)(0xFF & n2);
        n3 += 4;
        for (int i = 0; i < this.dataCount; ++i) {
            try {
                n3 += this.dataEntries[i].fillPacket(byArray, byArray2, n3, randomAccessFile, qTMediaCursor);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error: QTHintEntry.fillPacket: " + exception.toString());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  relativeTransmissionTime: " + this.relativeTransmissionTime + "\n");
        stringBuffer.append("  headerInfo: " + DebugUtils.formatBytesShort((byte[])this.headerInfo) + "\n");
        stringBuffer.append("  seqNum: " + this.seqNum + "\n");
        stringBuffer.append("  flags: " + DebugUtils.formatBytesShort((byte[])this.flags) + "\n");
        stringBuffer.append("  hasTLV: " + this.hasTLV + "\n");
        stringBuffer.append("  isBFrame: " + this.isBFrame + "\n");
        stringBuffer.append("  isRFrame: " + this.isRFrame + "\n");
        stringBuffer.append("  timecodeOffset: " + this.timecodeOffset + "\n");
        stringBuffer.append("  dataCount: " + this.dataCount + "\n");
        for (int i = 0; i < this.dataCount; ++i) {
            stringBuffer.append("  data: " + i + "\n");
            stringBuffer.append(this.dataEntries[i].toString());
        }
        return stringBuffer.toString();
    }
}

