/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.util;

import com.wowza.io.IRandomAccessReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.FastIntBuffer;
import com.wowza.util.FastIntDirect;
import com.wowza.util.FastLongBuffer;
import com.wowza.util.FastLongDirect;
import com.wowza.util.IFastIntBuffer;
import com.wowza.util.IFastLongBuffer;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadySampleIndex;
import com.wowza.wms.drm.playready.PlayReadyTrackInfo;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtommfhd;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoof;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomsinf;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtkhd;
import com.wowza.wms.mediareader.h264.atom.QTAtomtraf;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTAtomudta;
import com.wowza.wms.mediareader.h264.atom.QTFragmentMfhdData;
import com.wowza.wms.mediareader.h264.atom.QTFragmentTrakData;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.MP4Utils;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class QTUtils {
    public static final boolean debug = false;
    public static final int PLAYREADY_KEYIDSIZE = 16;
    public static final byte[] UUID_TRACKBOX = new byte[]{-119, 116, -37, -50, 123, -25, 76, 81, -124, -7, 113, 72, -7, -120, 37, 84};
    public static final byte[] UUID_FRAGBOX = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
    public static final byte[] UUID_PROTECTIONBOX = new byte[]{-48, -118, 79, 24, 16, -13, 74, -126, -74, -56, 50, -40, -85, -95, -125, -45};

    public static void skipBytesLong(IRandomAccessReader iRandomAccessReader, long l) {
        try {
            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + l);
        }
        catch (Exception exception) {
            System.out.println("Error: QTUtils.skipBytesLong: " + exception.toString());
        }
    }

    public static void skipBytesLong(RandomAccessFile randomAccessFile, long l) {
        try {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + l);
        }
        catch (Exception exception) {
            System.out.println("Error: QTUtils.skipBytesLong: " + exception.toString());
        }
    }

    public static QTAtom readAtomHeader(IRandomAccessReader iRandomAccessReader) throws Exception {
        QTAtom qTAtom = null;
        long l = iRandomAccessReader.getFilePointer();
        int n = 0;
        byte[] byArray = new byte[4];
        iRandomAccessReader.read(byArray, 0, 4);
        long l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
        n += 4;
        iRandomAccessReader.read(byArray, 0, 4);
        n += 4;
        String string = new String(byArray, "UTF-8");
        if (l2 == 1L) {
            byte[] byArray2 = new byte[8];
            iRandomAccessReader.read(byArray2, 0, 8);
            l2 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
            n += 8;
        }
        qTAtom = new QTAtom(string, l, l2, n);
        return qTAtom;
    }

    public static QTAtom readAtomHeader(RandomAccessFile randomAccessFile) throws Exception {
        QTAtom qTAtom = null;
        long l = randomAccessFile.getFilePointer();
        int n = 0;
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray, 0, 4);
        long l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
        n += 4;
        randomAccessFile.readFully(byArray, 0, 4);
        n += 4;
        String string = new String(byArray, "UTF-8");
        if (l2 == 1L) {
            byte[] byArray2 = new byte[8];
            randomAccessFile.readFully(byArray2, 0, 8);
            l2 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
            n += 8;
        }
        qTAtom = new QTAtom(string, l, l2, n);
        return qTAtom;
    }

    public static QTMediaContainer parseQTMediaContainer(IRandomAccessReader iRandomAccessReader, long l, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom;
        long l2;
        QTMediaContainer qTMediaContainer = null;
        qTMediaContainer = new QTMediaContainer("QTTP", iRandomAccessReader.getFilePointer(), l, 0L);
        boolean bl = false;
        boolean bl2 = false;
        QTAtommoof qTAtommoof = null;
        long l3 = -1L;
        boolean bl3 = false;
        for (long i = 0L; i < l && l - i >= 8L && (qTAtom = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l2) {
            if (qTAtom.isType("moov")) {
                QTAtommoov qTAtommoov = QTUtils.parseAtommoov(iRandomAccessReader, qTAtom, qTParseContext);
                qTMediaContainer.setMoovAtom(qTAtommoov);
                bl = true;
            } else if (qTAtom.isType("moof")) {
                qTAtommoof = QTUtils.parseAtommoof(iRandomAccessReader, qTAtom, qTParseContext, qTMediaContainer);
                if (!bl2) {
                    bl3 = l3 >= 0L;
                }
                bl2 = true;
                if (bl3 && qTAtommoof != null) {
                    qTAtommoof.setMdatFileOffset(l3, qTMediaContainer);
                }
                qTMediaContainer.setFragmented(true);
            } else if (qTAtom.isType("mdat")) {
                l3 = iRandomAccessReader.getFilePointer();
                if (!bl3 && qTAtommoof != null) {
                    qTAtommoof.setMdatFileOffset(l3, qTMediaContainer);
                }
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
            }
            l2 = qTAtom.getSize();
            if (l2 > 0L) continue;
            throw new Exception("QTUtils.parseQTMediaContainer: Atom size is invalid: " + l2);
        }
        if (!bl) {
            throw new Exception("QTUtils.parseQTMediaContainer: File is missing 'moov' atom.");
        }
        qTMediaContainer.flush();
        return qTMediaContainer;
    }

    public static QTAtomudta parseAtomudta(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtomudta qTAtomudta = null;
        qTAtomudta = new QTAtomudta(qTAtom);
        byte[] byArray = new byte[4];
        long l = iRandomAccessReader.getFilePointer();
        long l2 = qTAtom.getDataSize();
        long l3 = 0L;
        while (l3 < l2) {
            String string;
            iRandomAccessReader.read(byArray, 0, 4);
            l3 += 4L;
            int n = BufferUtils.byteArrayToInt((byte[])byArray);
            if (n <= 4) break;
            iRandomAccessReader.read(byArray, 0, 4);
            l3 += 4L;
            String string2 = new String(byArray, "UTF-8");
            if (string2.equals("hnti")) {
                int n2;
                for (int i = 0; i < n - 8; i += n2 - 8) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    i += 4;
                    n2 = BufferUtils.byteArrayToInt((byte[])byArray);
                    iRandomAccessReader.read(byArray, 0, 4);
                    i += 4;
                    string = new String(byArray, "UTF-8");
                    if (n2 < 0 || (long)n2 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomudta: [hnti]: Bad size: " + n2 + ":" + qTAtom.getDataSize());
                    }
                    QTUtils.skipBytesLong(iRandomAccessReader, (long)(n2 - 8));
                }
                l3 += (long)(n - 8);
                continue;
            }
            if (string2.equals("hinf")) {
                int n3 = 0;
                while (n3 < n - 8) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    n3 += 4;
                    int n4 = BufferUtils.byteArrayToInt((byte[])byArray);
                    iRandomAccessReader.read(byArray, 0, 4);
                    n3 += 4;
                    string = new String(byArray, "UTF-8");
                    if (n4 < 0 || (long)n4 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomudta: [" + string + "]: Bad size: " + n4 + ":" + qTAtom.getDataSize());
                    }
                    if (string.equals("payt")) {
                        iRandomAccessReader.read(byArray, 0, 4);
                        n3 += 4;
                        int n5 = BufferUtils.byteArrayToInt((byte[])byArray);
                        iRandomAccessReader.read(byArray, 0, 1);
                        ++n3;
                        byte[] byArray2 = new byte[n4 - 13];
                        iRandomAccessReader.read(byArray2, 0, n4 - 13);
                        n3 += n4 - 13;
                        String string3 = new String(byArray2, "UTF-8");
                        qTAtomudta.setPaytType(n5);
                        qTAtomudta.setPaytStr(string3);
                        continue;
                    }
                    if (n4 < 0 || (long)n4 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomudta: [" + string + "]: Bad size: " + n4 + ":" + qTAtom.getDataSize());
                    }
                    byte[] byArray3 = new byte[n4 - 8];
                    iRandomAccessReader.read(byArray3, 0, n4 - 8);
                    n3 += n4 - 8;
                    qTAtomudta.addHinfData(string, byArray3);
                    if (string.equals("maxr")) {
                        int n6 = BufferUtils.byteArrayToInt((byte[])byArray3);
                        int n7 = BufferUtils.byteArrayToInt((byte[])byArray3, (int)4);
                        continue;
                    }
                    if (n4 - 8 == 4) {
                        int n8 = BufferUtils.byteArrayToInt((byte[])byArray3);
                        continue;
                    }
                    if (n4 - 8 != 8) continue;
                    long l4 = BufferUtils.byteArrayToLong((byte[])byArray3, (int)0, (int)8);
                }
                l3 += (long)(n - 8);
                continue;
            }
            if (string2.equals("name")) {
                byte[] byArray4 = new byte[n - 8];
                iRandomAccessReader.read(byArray4, 0, n - 8);
                l3 += (long)(n - 8);
                String string4 = new String(byArray4, "UTF-8");
                qTAtomudta.setName(string4);
                continue;
            }
            QTUtils.skipBytesLong(iRandomAccessReader, (long)(n - 8));
            l3 += (long)(n - 8);
        }
        iRandomAccessReader.seek(l);
        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        return qTAtomudta;
    }

    public static QTAtommoof parseAtommoof(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext, QTMediaContainer qTMediaContainer) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtommoof qTAtommoof = null;
        qTAtommoof = new QTAtommoof(qTAtom);
        qTAtommoof.setMoofFileOffset(iRandomAccessReader.getFilePointer());
        long l2 = qTAtom.getDataSize();
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            if (qTAtom2.isType("traf")) {
                QTAtomtraf qTAtomtraf = QTUtils.parseAtomtraf(iRandomAccessReader, qTAtom2, qTParseContext, qTAtommoof, qTMediaContainer);
            } else if (qTAtom2.isType("mfhd")) {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtommoof: Atom size is invalid: " + l);
        }
        return qTAtommoof;
    }

    public static QTAtommfhd parseAtommfhd(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtommfhd qTAtommfhd = null;
        qTAtommfhd = new QTAtommfhd(qTAtom);
        byte[] byArray = new byte[4];
        long l = qTAtom.getDataSize();
        long l2 = iRandomAccessReader.getFilePointer();
        iRandomAccessReader.seek(l2);
        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        return qTAtommfhd;
    }

    public static QTAtomtraf parseAtomtraf(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext, QTAtommoof qTAtommoof, QTMediaContainer qTMediaContainer) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtomtraf qTAtomtraf = null;
        qTAtomtraf = new QTAtomtraf(qTAtom);
        byte[] byArray = new byte[4];
        long l2 = qTAtom.getDataSize();
        QTFragmentMfhdData qTFragmentMfhdData = null;
        QTFragmentTrakData qTFragmentTrakData = null;
        QTAtomtrak qTAtomtrak = null;
        QTAtomstbl qTAtomstbl = null;
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            int n;
            long l3 = iRandomAccessReader.getFilePointer();
            if (qTAtom2.isType("tfhd")) {
                iRandomAccessReader.read(byArray, 0, 4);
                int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)1, (int)3);
                iRandomAccessReader.read(byArray, 0, 4);
                int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                qTFragmentMfhdData = qTAtommoof.getFragmentTrakData(n3);
                qTFragmentTrakData = qTMediaContainer.getFragmentTrakData(n3);
                qTFragmentMfhdData.startSampleOffset = qTFragmentTrakData.getCurrentSample();
                Object object = qTMediaContainer.getMoovAtom();
                if (object != null && (qTAtomtrak = ((QTAtommoov)object).getTrackById(n3)) != null) {
                    qTAtomstbl = qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
                }
                if ((n2 & 1) == 1) {
                    object = new byte[8];
                    iRandomAccessReader.read((byte[])object, 0, 8);
                    qTFragmentMfhdData.base_data_offset = BufferUtils.byteArrayToLong((byte[])object);
                }
                if ((n2 & 2) == 2) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTFragmentMfhdData.sample_description_index = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                if ((n2 & 8) == 8) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTFragmentMfhdData.default_sample_duration = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                if ((n2 & 0x10) == 16) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTFragmentMfhdData.default_sample_size = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                if ((n2 & 0x20) == 32) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTFragmentMfhdData.default_sample_flags = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                iRandomAccessReader.seek(l3);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("trun")) {
                iRandomAccessReader.read(byArray, 0, 4);
                int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)1, (int)3);
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                iRandomAccessReader.read(byArray, 0, 4);
                n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                qTFragmentTrakData.incCurrentSample(n5);
                if ((n4 & 1) == 1) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    n6 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                if ((n4 & 4) == 4) {
                    iRandomAccessReader.read(byArray, 0, 4);
                    n7 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                }
                for (int j = 0; j < n5; ++j) {
                    n = qTFragmentMfhdData.default_sample_duration;
                    if ((n4 & 0x100) == 256) {
                        iRandomAccessReader.read(byArray, 0, 4);
                        n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    }
                    qTFragmentTrakData.addTimeToSample(n);
                    int n8 = qTFragmentMfhdData.default_sample_size;
                    if ((n4 & 0x200) == 512) {
                        iRandomAccessReader.read(byArray, 0, 4);
                        n8 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    }
                    qTFragmentTrakData.addSampleSize(n8);
                    int n9 = qTFragmentMfhdData.default_sample_flags;
                    if (j == 0 && (n4 & 4) == 4) {
                        n9 = n7;
                    }
                    if ((n4 & 0x400) == 1024) {
                        iRandomAccessReader.read(byArray, 0, 4);
                        n9 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    }
                    if ((n9 >> 24 & 3) == 2) {
                        qTFragmentTrakData.addSyncSample(qTFragmentMfhdData.startSampleOffset + (long)qTFragmentMfhdData.trunSampleOffset + (long)j);
                    }
                    int n10 = 0;
                    if ((n4 & 0x800) == 2048) {
                        iRandomAccessReader.read(byArray, 0, 4);
                        n10 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    }
                    qTFragmentTrakData.addCTTS(n10);
                }
                qTFragmentMfhdData.trunSampleOffset += n5;
                qTFragmentTrakData.addChunk(n5, qTFragmentMfhdData.sample_description_index);
                long l4 = qTFragmentMfhdData.base_data_offset;
                if (n6 > 0 && l4 <= 0L) {
                    l4 = qTAtommoof.getMoofFileOffset() - 8L;
                }
                if (l4 + (long)n6 > 0L) {
                    qTFragmentTrakData.addChunkFileOffset(l4 + (long)n6);
                } else {
                    qTFragmentMfhdData.doFileoffset = true;
                }
                iRandomAccessReader.seek(l3);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("sdtp")) {
                QTAtomtrak qTAtomtrak2;
                iRandomAccessReader.read(byArray, 0, 4);
                boolean bl = true;
                QTAtommoov qTAtommoov = qTMediaContainer.getMoovAtom();
                if (qTAtommoov != null && (qTAtomtrak2 = qTAtommoov.getTrak(qTFragmentMfhdData.trakId - 1)) != null) {
                    QTAtomtrak qTAtomtrak3 = qTAtommoov.getVideoTrack(0);
                    bl = qTAtomtrak2.equals(qTAtomtrak3);
                }
                if (bl) {
                    int n11 = (int)qTAtom2.getDataSize() - 4;
                    byte[] byArray2 = new byte[n11];
                    iRandomAccessReader.read(byArray2, 0, n11);
                    for (int j = 0; j < n11; ++j) {
                        if ((byArray2[j] >> 4 & 3) != 2) continue;
                        qTFragmentTrakData.addSyncSample(qTFragmentMfhdData.startSampleOffset + (long)j);
                    }
                }
                iRandomAccessReader.seek(l3);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("uuid")) {
                byte[] byArray3 = new byte[16];
                iRandomAccessReader.read(byArray3, 0, 16);
                iRandomAccessReader.read(byArray, 0, 1);
                iRandomAccessReader.read(byArray, 0, 3);
                int n12 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                if (Arrays.equals(UUID_FRAGBOX, byArray3)) {
                    PlayReadyTrackInfo playReadyTrackInfo;
                    PlayReadySampleIndex playReadySampleIndex = new PlayReadySampleIndex();
                    playReadySampleIndex.setFlags(n12);
                    if ((n12 & 1) == 1) {
                        iRandomAccessReader.read(byArray, 0, 3);
                        int n13 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                        iRandomAccessReader.read(byArray, 0, 1);
                        int n14 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                        byte[] byArray4 = new byte[16];
                        iRandomAccessReader.read(byArray4, 0, byArray4.length);
                        playReadySampleIndex.setAlgorithmID(n13);
                        playReadySampleIndex.setIvSize(n14);
                        playReadySampleIndex.setKeyID(byArray4);
                        playReadySampleIndex.setLocalKeyId(true);
                    } else if (qTAtomstbl != null && (playReadyTrackInfo = qTAtomstbl.getPlayReadyTrackInfo()) != null) {
                        playReadySampleIndex.setAlgorithmID(playReadyTrackInfo.getAlgorithmID());
                        playReadySampleIndex.setIvSize(playReadyTrackInfo.getIvSize());
                        playReadySampleIndex.setKeyID(playReadyTrackInfo.getKeyID());
                    }
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l5 = iRandomAccessReader.getFilePointer();
                    n = (int)(qTAtom2.getDataSize() - (l5 - l3));
                    playReadySampleIndex.setFilePos(l5);
                    playReadySampleIndex.setSize(n);
                    if (qTAtomtrak != null) {
                        qTAtomtrak.addPlayReadyIndex(qTFragmentMfhdData.startSampleOffset, playReadySampleIndex);
                        qTParseContext.incIndexRefCount();
                    }
                }
                iRandomAccessReader.seek(l3);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtomtrak: Atom size is invalid: " + l);
        }
        return qTAtomtraf;
    }

    public static QTAtommoov parseAtommoov(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtommoov qTAtommoov = null;
        qTAtommoov = new QTAtommoov(qTAtom);
        long l2 = qTAtom.getDataSize();
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            long l3 = iRandomAccessReader.getFilePointer();
            if (qTAtom2.isType("trak")) {
                QTAtomtrak qTAtomtrak = QTUtils.parseAtomtrak(iRandomAccessReader, qTAtommoov, qTAtom2, qTParseContext);
                if (qTAtomtrak.isAudio()) {
                    if (qTParseContext.isParseAudioTrack()) {
                        qTAtommoov.addTrak(qTAtomtrak);
                    } else {
                        qTAtommoov.addTrak(null);
                    }
                } else if (qTAtomtrak.isVideo()) {
                    if (qTParseContext.isParseVideoTrack()) {
                        qTAtommoov.addTrak(qTAtomtrak);
                    } else {
                        qTAtommoov.addTrak(null);
                    }
                } else {
                    qTAtommoov.addTrak(qTAtomtrak);
                }
            } else if (qTAtom2.isType("udta")) {
                QTAtomudta qTAtomudta = QTUtils.parseAtomudta(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtommoov.setUdtaAtom(qTAtomudta);
            } else if (qTAtom2.isType("uuid")) {
                byte[] byArray = new byte[16];
                iRandomAccessReader.read(byArray, 0, byArray.length);
                byte[] byArray2 = new byte[4];
                iRandomAccessReader.read(byArray2, 0, 4);
                if (Arrays.equals(byArray, UUID_PROTECTIONBOX)) {
                    byte[] byArray3 = new byte[16];
                    iRandomAccessReader.read(byArray3, 0, byArray3.length);
                    iRandomAccessReader.read(byArray2, 0, 4);
                    int n = BufferUtils.byteArrayToInt((byte[])byArray2, (int)0, (int)4);
                    byte[] byArray4 = null;
                    if (n > 0) {
                        byArray4 = new byte[n];
                        iRandomAccessReader.read(byArray4, 0, n);
                    }
                    PlayReadyMediaInfo playReadyMediaInfo = new PlayReadyMediaInfo();
                    playReadyMediaInfo.setSystemId(byArray3);
                    playReadyMediaInfo.setExtraData(byArray4);
                    qTAtommoov.setPlayReadyInfo(playReadyMediaInfo);
                }
                iRandomAccessReader.seek(l3);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtommoov: Atom size is invalid: " + l);
        }
        return qTAtommoov;
    }

    public static QTAtomtrak parseAtomtrak(IRandomAccessReader iRandomAccessReader, QTAtommoov qTAtommoov, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtomtrak qTAtomtrak = null;
        qTAtomtrak = new QTAtomtrak(qTAtom);
        byte[] byArray = new byte[4];
        long l2 = qTAtom.getDataSize();
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            if (qTAtom2.isType("mdia")) {
                QTAtommdia qTAtommdia = QTUtils.parseAtommdia(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setMdiaAtom(qTAtommdia);
            } else if (qTAtom2.isType("udta")) {
                QTAtomudta qTAtomudta = QTUtils.parseAtomudta(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setUdtaAtom(qTAtomudta);
            } else if (qTAtom2.isType("tkhd")) {
                QTAtomtkhd qTAtomtkhd = QTUtils.parseAtomtkhd(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setTkhdAtom(qTAtomtkhd);
                int n = (int)qTAtomtkhd.getTrackId();
                qTAtomtrak.setTrackId(n);
                qTAtommoov.putTrack(n, qTAtomtrak);
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtomtrak: Atom size is invalid: " + l);
        }
        return qTAtomtrak;
    }

    public static QTAtomtkhd parseAtomtkhd(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtomtkhd qTAtomtkhd = null;
        long l = iRandomAccessReader.getFilePointer();
        try {
            qTAtomtkhd = new QTAtomtkhd(qTAtom);
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[8];
            long l2 = qTAtom.getDataSize();
            long l3 = 0L;
            if (l3 < l2) {
                long l4;
                long l5;
                iRandomAccessReader.read(byArray, 0, 1);
                int n = byArray[0] & 0xFF;
                iRandomAccessReader.read(byArray, 0, 3);
                int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                qTAtomtkhd.setFlags(n2);
                if (n > 0) {
                    iRandomAccessReader.read(byArray2, 0, 8);
                    l5 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                    qTAtomtkhd.setCreationTime(l5);
                    iRandomAccessReader.read(byArray2, 0, 8);
                    l4 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                    qTAtomtkhd.setModificationTime(l4);
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l6 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setTrackId(l6);
                    iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                    iRandomAccessReader.read(byArray2, 0, 8);
                    long l7 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                    qTAtomtkhd.setDuration(l7);
                } else {
                    iRandomAccessReader.read(byArray, 0, 4);
                    l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setCreationTime(l5);
                    iRandomAccessReader.read(byArray, 0, 4);
                    l4 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setModificationTime(l4);
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l8 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setTrackId(l8);
                    iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l9 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setDuration(l9);
                }
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 8L);
                iRandomAccessReader.read(byArray, 0, 2);
                int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                qTAtomtkhd.setLayer(n3);
                iRandomAccessReader.read(byArray, 0, 2);
                int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                qTAtomtkhd.setAlternateGroup(n4);
                iRandomAccessReader.read(byArray, 0, 2);
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                qTAtomtkhd.setVolume(n5);
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 2L);
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 36L);
                iRandomAccessReader.read(byArray, 0, 4);
                long l10 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                qTAtomtkhd.setTrackWidth(l10 >>= 16);
                iRandomAccessReader.read(byArray, 0, 4);
                long l11 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                qTAtomtkhd.setTrackHeight(l11 >>= 16);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            iRandomAccessReader.seek(l);
            QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        }
        return qTAtomtkhd;
    }

    public static QTAtommdia parseAtommdia(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtommdia qTAtommdia = null;
        qTAtommdia = new QTAtommdia(qTAtom);
        byte[] byArray = new byte[4];
        long l2 = qTAtom.getDataSize();
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            if (qTAtom2.isType("mdhd")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.read(byArray, 0, 1);
                int n = byArray[0] & 0xFF;
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 3L);
                if (n == 1) {
                    iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 16L);
                } else {
                    iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 8L);
                }
                long l3 = 0L;
                long l4 = 0L;
                if (n == 1) {
                    byte[] byArray2 = new byte[8];
                    iRandomAccessReader.read(byArray2, 0, 4);
                    l3 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)4);
                    iRandomAccessReader.read(byArray2, 0, 8);
                    l4 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                } else {
                    iRandomAccessReader.read(byArray, 0, 4);
                    l3 = BufferUtils.byteArrayToInt((byte[])byArray);
                    iRandomAccessReader.read(byArray, 0, 4);
                    l4 = BufferUtils.byteArrayToInt((byte[])byArray);
                }
                qTAtommdia.setTimescale(l3);
                qTAtommdia.setDuration(l4);
                iRandomAccessReader.read(byArray, 0, 2);
                int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                qTAtommdia.setLanguage(n2);
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("hdlr")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 8L);
                iRandomAccessReader.read(byArray, 0, 4);
                String string = new String(byArray, "UTF-8");
                qTAtommdia.setSubType(string);
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("minf")) {
                QTAtomminf qTAtomminf = QTUtils.parseAtomminf(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtommdia.setMinfAtom(qTAtomminf);
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtommdia: Atom size is invalid: " + l);
        }
        return qTAtommdia;
    }

    public static QTAtomminf parseAtomminf(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        long l2;
        QTAtomminf qTAtomminf = null;
        qTAtomminf = new QTAtomminf(qTAtom);
        long l3 = iRandomAccessReader.getFilePointer();
        long l4 = qTAtom.getDataSize();
        for (l = 0L; l < l4; l += l2) {
            qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
            if (qTAtom2.isType("vmhd")) {
                qTAtomminf.setMinfType("vmhd");
            } else if (qTAtom2.isType("smhd")) {
                qTAtomminf.setMinfType("smhd");
            } else if (qTAtom2.isType("gmhd")) {
                qTAtomminf.setMinfType("gmhd");
            } else if (qTAtom2.isType("hmhd")) {
                qTAtomminf.setMinfType("hmhd");
            }
            QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            l2 = qTAtom2.getSize();
            if (l2 > 0L) continue;
            throw new Exception("QTUtils.parseAtomminf: Atom size is invalid: " + l2);
        }
        iRandomAccessReader.seek(l3);
        for (l = 0L; l < l4 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; l += l2) {
            if (qTAtom2.isType("stbl")) {
                QTAtomstbl qTAtomstbl = QTUtils.parseAtomstbl(iRandomAccessReader, qTAtom2, qTAtomminf.getMinfType(), qTParseContext);
                qTAtomminf.setStblAtom(qTAtomstbl);
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l2 = qTAtom2.getSize();
            if (l2 > 0L) continue;
            throw new Exception("QTUtils.parseAtomminf: Atom size is invalid: " + l2);
        }
        return qTAtomminf;
    }

    public static QTAtomstbl parseAtomstbl(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, String string, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        QTAtomstbl qTAtomstbl = null;
        qTAtomstbl = new QTAtomstbl(qTAtom);
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[8];
        long l2 = qTAtom.getDataSize();
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            Object object;
            Object object2;
            int n;
            if (qTAtom2.isType("stts")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                if (n > 0) {
                    int n2 = 8;
                    int n3 = n * n2;
                    if (n3 < 0 || (long)n3 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n3 + ":" + qTAtom.getDataSize());
                    }
                    IRandomAccessReader iRandomAccessReader2 = qTParseContext.getIndexFilePtr();
                    int n4 = qTParseContext.getIndexBufferSize();
                    FastIntDirect fastIntDirect = null;
                    if (iRandomAccessReader2 != null && n3 > n4) {
                        fastIntDirect = new FastIntBuffer();
                        fastIntDirect.setEntrySize(n2);
                        fastIntDirect.setDataSize(n2 / 2);
                        fastIntDirect.setBufferSize(n4);
                        fastIntDirect.setRandomAccessReader(iRandomAccessReader2);
                        fastIntDirect.setRandomAccessReaderStartPos(iRandomAccessReader.getFilePointer());
                        fastIntDirect.allocateBuffer();
                        qTParseContext.incIndexRefCount();
                    } else {
                        fastIntDirect = new FastIntDirect();
                        fastIntDirect.setEntrySize(n2);
                        fastIntDirect.setDataSize(n2 / 2);
                        object2 = new byte[n3];
                        iRandomAccessReader.read(object2, 0, ((byte[])object2).length);
                        fastIntDirect.setData(object2);
                    }
                    qTAtomstbl.setTimeToSample((IFastIntBuffer)fastIntDirect);
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("stss")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                if (n == 0) {
                    n = (int)((qTAtom2.getDataSize() - 8L) / 4L);
                }
                if (n > 0) {
                    int n5 = 4;
                    int n6 = n * n5;
                    IRandomAccessReader iRandomAccessReader3 = qTParseContext.getIndexFilePtr();
                    int n7 = qTParseContext.getIndexBufferSize();
                    if (n6 < 0 || (long)n6 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n6 + ":" + qTAtom.getDataSize());
                    }
                    FastLongDirect fastLongDirect = null;
                    if (iRandomAccessReader3 != null && n6 > n7) {
                        fastLongDirect = new FastLongBuffer();
                        fastLongDirect.setEntrySize(n5);
                        fastLongDirect.setDataSize(n5);
                        fastLongDirect.setBufferSize(n7);
                        fastLongDirect.setRandomAccessReader(iRandomAccessReader3);
                        fastLongDirect.setRandomAccessReaderStartPos(iRandomAccessReader.getFilePointer());
                        fastLongDirect.allocateBuffer();
                        fastLongDirect.generateIndex();
                        qTParseContext.incIndexRefCount();
                    } else {
                        fastLongDirect = new FastLongDirect();
                        fastLongDirect.setEntrySize(n5);
                        fastLongDirect.setDataSize(n5);
                        object2 = new byte[n6];
                        iRandomAccessReader.read(object2, 0, ((byte[])object2).length);
                        fastLongDirect.setData(object2);
                    }
                    qTAtomstbl.setSyncSamples((IFastLongBuffer)fastLongDirect);
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("stsc")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                if (n > 0) {
                    int n8 = 12;
                    int n9 = n * n8;
                    IRandomAccessReader iRandomAccessReader4 = qTParseContext.getIndexFilePtr();
                    int n10 = qTParseContext.getIndexBufferSize();
                    if (n9 < 0 || (long)n9 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n9 + ":" + qTAtom.getDataSize());
                    }
                    FastIntDirect fastIntDirect = null;
                    if (iRandomAccessReader4 != null && n9 > n10) {
                        fastIntDirect = new FastIntBuffer();
                        fastIntDirect.setEntrySize(n8);
                        fastIntDirect.setDataSize(n8 / 3);
                        fastIntDirect.setBufferSize(n10);
                        fastIntDirect.setRandomAccessReader(iRandomAccessReader4);
                        fastIntDirect.setRandomAccessReaderStartPos(iRandomAccessReader.getFilePointer());
                        fastIntDirect.allocateBuffer();
                        qTParseContext.incIndexRefCount();
                    } else {
                        fastIntDirect = new FastIntDirect();
                        fastIntDirect.setEntrySize(n8);
                        fastIntDirect.setDataSize(n8 / 3);
                        object2 = new byte[n9];
                        iRandomAccessReader.read(object2, 0, ((byte[])object2).length);
                        fastIntDirect.setData(object2);
                    }
                    qTAtomstbl.setSampleToChunk((IFastIntBuffer)fastIntDirect);
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("stsz")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                if (n != 0) {
                    qTAtomstbl.setSampleSize(n);
                } else {
                    iRandomAccessReader.read(byArray, 0, 4);
                    int n11 = BufferUtils.byteArrayToInt((byte[])byArray);
                    int n12 = 4;
                    int n13 = n11 * n12;
                    if (n13 < 0 || (long)n13 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n13 + ":" + qTAtom.getDataSize());
                    }
                    if (n11 > 0) {
                        IRandomAccessReader iRandomAccessReader5 = qTParseContext.getIndexFilePtr();
                        int n14 = qTParseContext.getIndexBufferSize();
                        object2 = null;
                        if (iRandomAccessReader5 != null && n13 > n14) {
                            object2 = new FastIntBuffer();
                            object2.setEntrySize(n12);
                            object2.setDataSize(n12);
                            object2.setBufferSize(n14);
                            object2.setRandomAccessReader(iRandomAccessReader5);
                            object2.setRandomAccessReaderStartPos(iRandomAccessReader.getFilePointer());
                            object2.allocateBuffer();
                            qTParseContext.incIndexRefCount();
                        } else {
                            object2 = new FastIntDirect();
                            object2.setEntrySize(n12);
                            object2.setDataSize(n12);
                            object = new byte[n13];
                            iRandomAccessReader.read((byte[])object, 0, ((byte[])object).length);
                            object2.setData((byte[])object);
                        }
                        qTAtomstbl.setSampleSizes((IFastIntBuffer)object2);
                    }
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("stco") || qTAtom2.isType("co64")) {
                int n15;
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                int n16 = n15 = qTAtom2.isType("co64") ? 8 : 4;
                if (n > 0) {
                    int n17 = n * n15;
                    IRandomAccessReader iRandomAccessReader6 = qTParseContext.getIndexFilePtr();
                    int n18 = qTParseContext.getIndexBufferSize();
                    if (n17 < 0 || (long)n17 > qTAtom.getDataSize()) {
                        throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n17 + ":" + qTAtom.getDataSize());
                    }
                    FastLongDirect fastLongDirect = null;
                    if (iRandomAccessReader6 != null && n17 > n18) {
                        fastLongDirect = new FastLongBuffer();
                        fastLongDirect.setEntrySize(n15);
                        fastLongDirect.setDataSize(n15);
                        fastLongDirect.setBufferSize(n18);
                        fastLongDirect.setRandomAccessReader(iRandomAccessReader6);
                        fastLongDirect.setRandomAccessReaderStartPos(iRandomAccessReader.getFilePointer());
                        fastLongDirect.allocateBuffer();
                        qTParseContext.incIndexRefCount();
                    } else {
                        fastLongDirect = new FastLongDirect();
                        fastLongDirect.setEntrySize(n15);
                        fastLongDirect.setDataSize(n15);
                        object2 = new byte[n17];
                        iRandomAccessReader.read(object2, 0, ((byte[])object2).length);
                        fastLongDirect.setData(object2);
                    }
                    qTAtomstbl.setChunkOffsets((IFastLongBuffer)fastLongDirect);
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("stsd")) {
                l = iRandomAccessReader.getFilePointer();
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray, 0, 4);
                n = BufferUtils.byteArrayToInt((byte[])byArray);
                for (int j = 0; j < n; ++j) {
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    int n24 = 0;
                    iRandomAccessReader.read(byArray, 0, 4);
                    n24 += 4;
                    int n25 = BufferUtils.byteArrayToInt((byte[])byArray);
                    iRandomAccessReader.read(byArray, 0, 4);
                    n24 += 4;
                    String string2 = new String(byArray, "UTF-8");
                    qTAtomstbl.addDataType(string2);
                    long l3 = iRandomAccessReader.getFilePointer();
                    object = null;
                    ESDSData eSDSData = null;
                    if (string.equals("vmhd")) {
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 24L);
                        n24 += 24;
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n23 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n22 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 12L);
                        n24 += 12;
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n21 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        qTAtomstbl.setFrameHeight(n22);
                        qTAtomstbl.setFrameWidth(n23);
                        qTAtomstbl.setFramesPerSample(n21);
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 32L);
                        n24 += 32;
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                        n24 += 4;
                        n20 = 0;
                        while (n25 - n24 >= 8) {
                            iRandomAccessReader.read(byArray, 0, 4);
                            n24 += 4;
                            n19 = BufferUtils.byteArrayToInt((byte[])byArray);
                            iRandomAccessReader.read(byArray, 0, 4);
                            n24 += 4;
                            String string3 = new String(byArray, "UTF-8");
                            long l4 = iRandomAccessReader.getFilePointer();
                            if (++n20 == 100) {
                                WMSLoggerFactory.getLogger(QTUtils.class).warn("QTUtils.parseAtomstbl[" + iRandomAccessReader.getPath() + "]: structCount too high[" + string3 + ":" + n20 + "]: " + string);
                            }
                            if (string3.equals("avcC")) {
                                long l5 = iRandomAccessReader.getFilePointer();
                                if (n19 < 0 || (long)n19 > qTAtom.getDataSize()) {
                                    throw new Exception("QTUtils.parseAtomstbl: [" + string3 + "]: Bad size: " + n19 + ":" + qTAtom.getDataSize());
                                }
                                byte[] byArray3 = new byte[n19 - 8];
                                iRandomAccessReader.read(byArray3, 0, n19 - 8);
                                iRandomAccessReader.seek(l5 + 1L);
                                iRandomAccessReader.read(byArray, 0, 1);
                                int n26 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                                iRandomAccessReader.read(byArray, 0, 1);
                                int n27 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                                iRandomAccessReader.read(byArray, 0, 1);
                                int n28 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                                object = new AVCCData();
                                ((AVCCData)object).setAvccBytes(byArray3);
                                ((AVCCData)object).setAvcLevel(n28);
                                ((AVCCData)object).setAvcProfile(n26);
                                ((AVCCData)object).setAvcProfileCompat(n27);
                            } else if (string3.equals("sinf")) {
                                QTAtom qTAtom3 = new QTAtom(string3, iRandomAccessReader.getFilePointer() - 8L, n19, 8L);
                                QTAtomsinf qTAtomsinf = QTUtils.parseAtomsinf(iRandomAccessReader, qTAtom3, string, qTParseContext);
                                qTAtomstbl.setSinfAtom(qTAtomsinf);
                            }
                            iRandomAccessReader.seek(l4 + (long)n19 - 8L);
                            n24 += n19 - 8;
                            if (n19 - 8 > 0) continue;
                            WMSLoggerFactory.getLogger(QTUtils.class).warn("QTUtils.parseAtomstbl[" + iRandomAccessReader.getPath() + "]: Error reading 'stsd' section. Structure is zero size: " + string + ":" + string3);
                            break;
                        }
                    } else if (string.equals("smhd")) {
                        int n29;
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 8L);
                        n24 += 8;
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n23 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 6L);
                        n24 += 6;
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n22 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n21 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n20 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.read(byArray, 0, 2);
                        n24 += 2;
                        n19 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                        iRandomAccessReader.read(byArray, 0, 4);
                        n24 += 4;
                        int n30 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                        if (n23 == 1) {
                            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 16L);
                            n24 += 16;
                        } else if (n23 == 2) {
                            int n31 = 0;
                            n29 = 36;
                            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                            n31 += 4;
                            n24 += 4;
                            iRandomAccessReader.read(byArray2, 0, 8);
                            n31 += 8;
                            n24 += 8;
                            long l6 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                            double d = Double.longBitsToDouble(l6);
                            iRandomAccessReader.read(byArray, 0, 4);
                            n24 += 4;
                            n22 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + (long)n29 - (long)(n31 += 4));
                            n24 += n29 - n31;
                        }
                        qTAtomstbl.setAudioChannels(n22);
                        int n32 = 0;
                        while (n25 - n24 >= 8) {
                            iRandomAccessReader.read(byArray, 0, 4);
                            n24 += 4;
                            n29 = BufferUtils.byteArrayToInt((byte[])byArray);
                            iRandomAccessReader.read(byArray, 0, 4);
                            n24 += 4;
                            String string4 = new String(byArray, "UTF-8");
                            long l7 = iRandomAccessReader.getFilePointer();
                            if (++n32 == 100) {
                                WMSLoggerFactory.getLogger(QTUtils.class).warn("QTUtils.parseAtomstbl[" + iRandomAccessReader.getPath() + "]: structCount too high[" + string4 + ":" + n32 + "]: " + string);
                            }
                            if (string4.equals("esds")) {
                                eSDSData = MP4Utils.decodeESDS(iRandomAccessReader);
                            } else if (string4.equals("wave")) {
                                int n33 = 0;
                                while (n29 - n33 >= 8) {
                                    iRandomAccessReader.read(byArray, 0, 4);
                                    n33 += 4;
                                    int n34 = BufferUtils.byteArrayToInt((byte[])byArray);
                                    iRandomAccessReader.read(byArray, 0, 4);
                                    n33 += 4;
                                    String string5 = new String(byArray, "UTF-8");
                                    long l8 = iRandomAccessReader.getFilePointer();
                                    if (string5.equals("esds")) {
                                        eSDSData = MP4Utils.decodeESDS(iRandomAccessReader);
                                    }
                                    iRandomAccessReader.seek(l8 + (long)n34 - 8L);
                                    n33 += n34 - 8;
                                    if (n34 - 8 > 0) continue;
                                    break;
                                }
                            } else if (string4.equals("sinf")) {
                                QTAtom qTAtom4 = new QTAtom(string4, iRandomAccessReader.getFilePointer() - 8L, n29, 8L);
                                QTAtomsinf qTAtomsinf = QTUtils.parseAtomsinf(iRandomAccessReader, qTAtom4, string, qTParseContext);
                                qTAtomstbl.setSinfAtom(qTAtomsinf);
                            }
                            iRandomAccessReader.seek(l7 + (long)n29 - 8L);
                            n24 += n29 - 8;
                            if (n29 - 8 > 0) continue;
                            WMSLoggerFactory.getLogger(QTUtils.class).warn("QTUtils.parseAtomstbl[" + iRandomAccessReader.getPath() + "]: Error reading 'stsd' section. Structure is zero size: " + string + ":" + string4);
                            break;
                        }
                    }
                    if (string.equals("vmhd")) {
                        qTAtomstbl.addAVCCData((AVCCData)object);
                    }
                    if (string.equals("smhd")) {
                        qTAtomstbl.addESDSData(eSDSData);
                    }
                    iRandomAccessReader.seek(l3 + (long)n25 - 8L);
                    if (n25 - 8 > 0) continue;
                    WMSLoggerFactory.getLogger(QTUtils.class).warn("QTUtils.parseAtomstbl[" + iRandomAccessReader.getPath() + "]: Error reading 'stsd' section. Entry is zero size.");
                    break;
                }
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else if (qTAtom2.isType("ctts")) {
                l = iRandomAccessReader.getFilePointer();
                n = (int)qTAtom2.getDataSize() - 8;
                if (n < 0 || (long)n > qTAtom.getDataSize()) {
                    throw new Exception("QTUtils.parseAtomstbl: [" + qTAtom2 + "]: Bad size: " + n + ":" + qTAtom.getDataSize());
                }
                byte[] byArray4 = new byte[n];
                iRandomAccessReader.read(byArray4, 0, byArray4.length);
                FastIntDirect fastIntDirect = new FastIntDirect();
                fastIntDirect.setData(byArray4);
                fastIntDirect.setEntrySize(8);
                fastIntDirect.setDataSize(4);
                qTAtomstbl.setCttsValues((IFastIntBuffer)fastIntDirect);
                iRandomAccessReader.seek(l);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            l = qTAtom2.getSize();
            if (l > 0L) continue;
            throw new Exception("QTUtils.parseAtomstbl: Atom size is invalid: " + l);
        }
        return qTAtomstbl;
    }

    public static QTAtomsinf parseAtomsinf(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, String string, QTParseContext qTParseContext) throws Exception {
        long l;
        QTAtomsinf qTAtomsinf = null;
        qTAtomsinf = new QTAtomsinf(qTAtom);
        long l2 = iRandomAccessReader.getFilePointer();
        long l3 = qTAtom.getDataSize();
        byte[] byArray = new byte[4];
        PlayReadyTrackInfo playReadyTrackInfo = null;
        for (long i = 0L; i < l3; i += l) {
            Object object;
            long l4 = iRandomAccessReader.getFilePointer();
            QTAtom qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
            if (qTAtom2 == null) break;
            l = qTAtom2.getSize();
            if (l <= 0L) {
                throw new Exception("parseAtomsinf: Atom size is invalid: " + l);
            }
            if (qTAtom2.isType("frma")) {
                if (qTAtom2.getDataSize() <= 4L) {
                    iRandomAccessReader.read(byArray, 0, (int)qTAtom2.getDataSize());
                    object = null;
                    try {
                        object = new String(byArray, 0, (int)qTAtom2.getDataSize());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object != null) {
                        if (playReadyTrackInfo == null) {
                            playReadyTrackInfo = new PlayReadyTrackInfo();
                        }
                        playReadyTrackInfo.setDataType((String)object);
                    }
                }
            } else if (!qTAtom2.isType("schm") && qTAtom2.isType("schi")) {
                object = QTUtils.readAtomHeader(iRandomAccessReader);
                if (object == null) break;
                if (((QTAtom)object).isType("uuid")) {
                    byte[] byArray2 = new byte[16];
                    iRandomAccessReader.read(byArray2, 0, 16);
                    iRandomAccessReader.read(byArray, 0, 4);
                    if (Arrays.equals(UUID_TRACKBOX, byArray2)) {
                        iRandomAccessReader.read(byArray, 0, 3);
                        int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                        iRandomAccessReader.read(byArray, 0, 1);
                        int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                        byte[] byArray3 = new byte[16];
                        iRandomAccessReader.read(byArray3, 0, byArray3.length);
                        if (playReadyTrackInfo == null) {
                            playReadyTrackInfo = new PlayReadyTrackInfo();
                        }
                        playReadyTrackInfo.setAlgorithmID(n);
                        playReadyTrackInfo.setIvSize(n2);
                        playReadyTrackInfo.setKeyID(byArray3);
                    }
                }
            }
            iRandomAccessReader.seek(l4);
            QTUtils.skipBytesLong(iRandomAccessReader, l);
        }
        if (playReadyTrackInfo != null) {
            qTAtomsinf.setPlayReadyTrackInfo(playReadyTrackInfo);
        }
        return qTAtomsinf;
    }
}

