/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.rtp;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.RTPResponseTracker;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.model.RTPWriteListener;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.stream.live.LivePlayer;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPPlayer
extends LivePlayer {
    private long rtpTargetPacketSeq = -1L;
    private long vodStartTimeRT = -1L;
    private long vodStartTimeTC = -1L;
    private long vodLastMaxTC = -1L;
    private PlaylistCursor flvCursor = null;
    private long[] playSizes = null;
    private PlaylistWriteControl control = null;
    private PlaylistReaderWriteResults results = null;

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        this.waitForKeyFrame = false;
        this.isEnhancedSeekCapable = false;
    }

    public RTPPlayer(IMediaStreamPlay iMediaStreamPlay) {
        super(iMediaStreamPlay);
    }

    public boolean play(IMediaStream iMediaStream) {
        return true;
    }

    public boolean play() {
        return true;
    }

    public void setRTPTargetPacketSeq(long l) {
        this.rtpTargetPacketSeq = l;
    }

    public int getNextVideoSequence() {
        IMediaStream iMediaStream = this.stream.getParent();
        RTPStream rTPStream = iMediaStream.getRTPStream();
        RTPTrack rTPTrack = null;
        RTPTrack rTPTrack2 = null;
        RTPTrack rTPTrack3 = null;
        IRTPPacketizer iRTPPacketizer = null;
        IRTPPacketizer iRTPPacketizer2 = null;
        rTPTrack3 = rTPStream.getStreamTrack();
        if (rTPTrack3 != null) {
            rTPTrack = rTPTrack3;
            rTPTrack2 = rTPTrack3;
        } else {
            rTPTrack = rTPStream.getVideoTrack();
            rTPTrack2 = rTPStream.getAudioTrack();
        }
        if (rTPTrack != null) {
            iRTPPacketizer = rTPTrack.getRTPPacketizer();
        }
        if (rTPTrack2 != null) {
            iRTPPacketizer2 = rTPTrack2.getRTPPacketizer();
        }
        return iRTPPacketizer == null ? 1 : iRTPPacketizer.getNextSequence();
    }

    public int getNextAudioSequence() {
        IMediaStream iMediaStream = this.stream.getParent();
        RTPStream rTPStream = iMediaStream.getRTPStream();
        RTPTrack rTPTrack = null;
        RTPTrack rTPTrack2 = null;
        RTPTrack rTPTrack3 = null;
        IRTPPacketizer iRTPPacketizer = null;
        IRTPPacketizer iRTPPacketizer2 = null;
        rTPTrack3 = rTPStream.getStreamTrack();
        if (rTPTrack3 != null) {
            rTPTrack = rTPTrack3;
            rTPTrack2 = rTPTrack3;
        } else {
            rTPTrack = rTPStream.getVideoTrack();
            rTPTrack2 = rTPStream.getAudioTrack();
        }
        if (rTPTrack != null) {
            iRTPPacketizer = rTPTrack.getRTPPacketizer();
        }
        if (rTPTrack2 != null) {
            iRTPPacketizer2 = rTPTrack2.getRTPPacketizer();
        }
        return iRTPPacketizer2 == null ? 1 : iRTPPacketizer2.getNextSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.rtpTargetPacketSeq = -1L;
            this.vodStartTimeRT = -1L;
            this.vodStartTimeTC = -1L;
            this.vodLastMaxTC = -1L;
            this.flvCursor = null;
            this.playSizes = null;
            this.control = null;
            this.results = null;
            super.resetInternal(bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startVODStreaming(RTPStream rTPStream) {
        Object object = this.lock;
        synchronized (object) {
            if (this.flvCursor == null) {
                this.vodStartTimeTC = rTPStream.getVODStartTimeTC();
                this.vodLastMaxTC = -1L;
                this.playLen = rTPStream.getVODPlayLen();
                this.flvCursor = new PlaylistCursor();
                this.playSizes = new long[8];
                this.control = this.flvCursor.getWriteControl();
                this.results = this.flvCursor.getWriteResults();
                this.waitForBufferFill = false;
                this.instantOn = false;
                this.waitForKeyFrame = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AMFPacket> peekVODPackets(RTPStream rTPStream, long l) {
        ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
        Object object = this.lock;
        synchronized (object) {
            this.startVODStreaming(rTPStream);
            long l2 = (this.vodLastMaxTC >= 0L ? this.vodLastMaxTC : this.vodStartTimeTC) + l;
            this.control.setMaxTC(l2);
            IMediaReader iMediaReader = rTPStream.getMediaReader();
            IMediaReaderStreamPosition iMediaReaderStreamPosition = iMediaReader.getStreamPosition();
            iMediaReader.writePackets(arrayList, this.flvCursor, this.control, this.results, this.playSizes, null);
            iMediaReader.setStreamPosition(iMediaReaderStreamPosition);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetVODThrottling(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.vodStartTimeTC = this.vodLastMaxTC >= 0L ? this.vodLastMaxTC : l;
            this.vodStartTimeRT = System.currentTimeMillis() - 500L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        boolean bl;
        int n;
        int n2 = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        IMediaStream iMediaStream2 = this.stream.getParent();
        RTPStream rTPStream = iMediaStream2.getRTPStream();
        RTPSession rTPSession = rTPStream.getSession();
        ArrayList arrayList = null;
        AMFPacket aMFPacket = null;
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        RTPTrack rTPTrack = null;
        RTPTrack rTPTrack2 = null;
        RTPTrack rTPTrack3 = null;
        IRTPPacketizer iRTPPacketizer = null;
        IRTPPacketizer iRTPPacketizer2 = null;
        rTPTrack3 = rTPStream.getStreamTrack();
        if (rTPTrack3 != null) {
            rTPTrack = rTPTrack3;
            rTPTrack2 = rTPTrack3;
        } else {
            rTPTrack = rTPStream.getVideoTrack();
            rTPTrack2 = rTPStream.getAudioTrack();
        }
        if (rTPTrack != null) {
            iRTPPacketizer = rTPTrack.getRTPPacketizer();
            if (rTPTrack.isInterleaved()) {
                bl3 = true;
            }
        }
        if (rTPTrack2 != null) {
            iRTPPacketizer2 = rTPTrack2.getRTPPacketizer();
            if (rTPTrack2.isInterleaved()) {
                bl3 = true;
            }
        }
        long l2 = -1L;
        int n5 = 7;
        boolean bl4 = false;
        long l3 = 0L;
        AMFPacket aMFPacket2 = null;
        LivePlayer.LiveTracker liveTracker = null;
        RTPWriteListener rTPWriteListener = null;
        String string = "stream" + this.stream.getParent().getSrc();
        AMFPacket aMFPacket3 = null;
        long l4 = 0L;
        int n6 = 0;
        int n7 = 0;
        boolean bl5 = true;
        Object object = this.lock;
        synchronized (object) {
            block110: {
                try {
                    long l5;
                    boolean bl6 = rTPStream.isResetPlayStream();
                    if (bl6) {
                        this.resetInternal(true, false);
                        rTPStream.setResetPlayStream(false);
                    }
                    bl2 = rTPStream.isLive();
                    n = rTPStream.isPaused();
                    bl = rTPStream.isStreamStarted();
                    if (n != 0 || !bl || bl2 && iMediaStream == null) break block110;
                    if (this.vodStartTimeRT < 0L) {
                        this.vodStartTimeRT = l;
                    }
                    if (bl2) {
                        arrayList = this.getPlayPackets(iMediaStream);
                        aMFPacket = iMediaStream.getLastKeyFrame();
                    } else {
                        this.startVODStreaming(rTPStream);
                        l5 = this.vodStartTimeTC + (l - this.vodStartTimeRT);
                        this.control.setMaxTC(l5);
                        this.vodLastMaxTC = l5;
                        arrayList = new ArrayList();
                        rTPStream.getMediaReader().writePackets(arrayList, this.flvCursor, this.control, this.results, this.playSizes, null);
                    }
                    if (arrayList == null) break block110;
                    n7 = arrayList.size();
                    if (n7 <= 0) {
                        this.bufferEmptyOnce = true;
                        break block110;
                    }
                    if (this.sendFirstKeyFrame) {
                        this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                        this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                    }
                    if (bl3) {
                        rTPWriteListener = rTPSession.getRTPWriteListener();
                    }
                    aMFPacket3 = (AMFPacket)arrayList.get(0);
                    if (this.waitForBufferFill && this.sendFirstKeyFrame) {
                        boolean bl7 = true;
                        long l6 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                        if (this.waitForBufferFillStarTime == -1L) {
                            this.waitForBufferFillStarTime = l;
                        } else if (l - this.waitForBufferFillStarTime > l6 && !this.waitForBufferKeyFrame) {
                            bl7 = false;
                        }
                        if (bl7 && l6 > 0L) {
                            AMFPacket aMFPacket4 = (AMFPacket)arrayList.get(n7 - 1);
                            if (aMFPacket4.getAbsTimecode() - aMFPacket3.getAbsTimecode() < l6) break block110;
                            if (this.waitForBufferKeyFrame && aMFPacket == null) {
                                AMFPacket aMFPacket5;
                                int n8 = 0;
                                for (int i = 0; i < n7 && ((aMFPacket5 = (AMFPacket)arrayList.get(i)).getType() != 9 || ++n8 <= 2); ++i) {
                                }
                                if (n8 > 2) break block110;
                            }
                        }
                    }
                    l4 = aMFPacket3.getSeq();
                    n6 = 0;
                    if (bl2) {
                        int n9 = n6 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - l4 + 1L);
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        if (n6 >= n7) break block110;
                    }
                    if ((!this.bufferEmptyOnce || this.waitForBufferFill) && this.instantOn && this.sendFirstKeyFrame) {
                        l5 = -1L;
                        int n10 = -1;
                        this.trackerBufferTime = 0L;
                        long l7 = 0L;
                        for (int i = n7 - 1; i >= 0; --i) {
                            boolean bl8;
                            aMFPacket3 = (AMFPacket)arrayList.get(i);
                            int n11 = aMFPacket3.getType();
                            if (n11 != 9 && n11 != 8) continue;
                            long l8 = aMFPacket3.getAbsTimecode();
                            long l9 = aMFPacket3.getSeq();
                            if (l5 == -1L) {
                                l5 = l8;
                            } else {
                                if (n10 == -1) {
                                    this.trackerBufferTime = l5 - l8;
                                }
                                if (n10 == -1) {
                                    if (this.rtpTargetPacketSeq >= 0L) {
                                        if (l9 >= this.rtpTargetPacketSeq) {
                                            n10 = i;
                                        }
                                    } else if (l5 - l8 > l7) {
                                        n10 = i;
                                    }
                                }
                            }
                            if (n11 == 9 && (bl8 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket3))) {
                                aMFPacket2 = aMFPacket3;
                            }
                            if (n10 != -1) break;
                        }
                        int n12 = n6 = n10 < 0 ? 0 : n10;
                    }
                    if (bl2 && n6 == 0 && this.lastSeq != -1L && (aMFPacket3 = (AMFPacket)arrayList.get(n6)).getSeq() != this.lastSeq + 1L) {
                        this.waitForKeyFrame = true;
                    }
                    if (bl3) {
                        LivePlayer.LiveTracker liveTracker2;
                        RTPResponseTracker rTPResponseTracker = rTPWriteListener.getLastTracker();
                        LivePlayer.LiveTracker liveTracker3 = liveTracker2 = rTPResponseTracker == null ? null : (LivePlayer.LiveTracker)rTPResponseTracker.getInfo(string);
                        if (liveTracker2 != null && this.lastSentLiveTracker != null && liveTracker2.trackerSeq >= this.trackerStartSeq) {
                            long l10;
                            long l11 = rTPResponseTracker.getSent();
                            long l12 = liveTracker2.firstTC + (liveTracker2.lastTC - liveTracker2.firstTC) * l11 / (l10 = rTPResponseTracker.getSize());
                            l3 = this.lastSentLiveTracker.lastTC - l12 - this.trackerBufferTime;
                            if (l3 > (long)this.behindDropAudio) {
                                bl4 = true;
                            }
                            if (l3 > (long)this.behindDropKFrames) {
                                n5 = 0;
                            } else if (l3 > (long)this.behindDropPFrames) {
                                n5 = 1;
                            } else if (l3 > (long)this.behindDropDFrames) {
                                n5 = 3;
                            }
                            if (this.lastTCFilter != n5) {
                                WMSLoggerFactory.getLogger(LivePlayer.class).debug("Filter[" + string + "]: filter:(" + this.lastTCFilter + "-" + n5 + ") offset:" + l3 + " sentTC:" + this.lastSentLiveTracker.lastTC + " receivedTC:" + liveTracker2.lastTC + " bufferTime:" + this.trackerBufferTime + " tc:" + this.lastTC);
                            }
                            this.lastTCFilter = n5;
                            if (this.disableLowBandwidthThrottling) {
                                n5 = 7;
                            }
                        }
                    }
                    this.lastTCOffset = l3;
                    int n13 = this.stream.getParent().getReceiveVideoFPS();
                    if (n13 < -1) {
                        if (n13 == -2 && n5 == 7) {
                            n5 = 3;
                        } else if (n13 == -3 && (n5 == 7 || n5 == 3)) {
                            n5 = 1;
                            this.waitForKeyFrame = true;
                        }
                    }
                    bl5 = false;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPPlayer.class).error("RTPPlayer.playAll: " + exception.toString());
                }
            }
        }
        if (bl5) {
            return 0;
        }
        long l13 = -1L;
        n = n6;
        do {
            bl = true;
            Object object2 = this.lock;
            synchronized (object2) {
                boolean bl9 = rTPStream.isResetPlayStream();
                if (!bl9 && n < n7) {
                    aMFPacket3 = (AMFPacket)arrayList.get(n);
                    if (this.lastReceiveVideo != this.stream.getParent().isReceiveVideo() && this.stream.getParent().isReceiveVideo()) {
                        this.waitForKeyFrame = true;
                    }
                    long l14 = aMFPacket3.getAbsTimecode();
                    long l15 = 0L;
                    int n14 = aMFPacket3.getType();
                    boolean bl10 = false;
                    boolean bl11 = true;
                    switch (n14) {
                        case 8: {
                            if (!this.stream.getParent().isReceiveAudio() || bl4) break;
                            this.lastTC = l15 = l14;
                            this.lastAudioTC = l15;
                            lArray[0] = lArray[0] + (long)aMFPacket3.getSize();
                            lArray[1] = lArray[1] + 1L;
                            bl10 = true;
                            break;
                        }
                        case 9: {
                            if (!this.stream.getParent().isReceiveVideo()) break;
                            int n15 = aMFPacket3.getFirstByte();
                            boolean bl12 = bl11 = n5 == 7;
                            if (!bl11) {
                                bl11 = this.testVideoFrame(n5, n15);
                            }
                            if (bl11) {
                                if (this.waitForKeyFrame) {
                                    if (!FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket3)) break;
                                    WMSLoggerFactory.getLogger(LivePlayer.class).debug("waitForKeyFrame: found");
                                    this.waitForKeyFrame = false;
                                }
                                this.lastTC = l15 = l14;
                                this.lastVideoTC = l15;
                                lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
                                lArray[3] = lArray[3] + 1L;
                                bl10 = true;
                                break;
                            }
                            lArray[6] = lArray[6] + (long)aMFPacket3.getSize();
                            lArray[7] = lArray[7] + 1L;
                            break;
                        }
                        case 15: 
                        case 18: {
                            this.lastTC = l15 = l14;
                            this.lastDataTC = l15;
                            lArray[4] = lArray[4] + (long)aMFPacket3.getSize();
                            lArray[5] = lArray[5] + 1L;
                            bl10 = true;
                            break;
                        }
                        default: {
                            WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info("Info: WMSRespStreams: outputSingle: unkown packet type: " + aMFPacket3.getType());
                        }
                    }
                    if (bl10) {
                        AMFPacket aMFPacket6;
                        if (!this.sentPlayStart) {
                            if (this.sendPlayStop) {
                                this.sendPlayStop = false;
                            }
                            this.sentPlayStart = true;
                            this.sendPlayStop = true;
                        }
                        if (bl3) {
                            if (liveTracker == null) {
                                liveTracker = new LivePlayer.LiveTracker((LivePlayer)this);
                                liveTracker.firstTC = l14;
                            }
                            liveTracker.lastTC = l14;
                        }
                        if (this.sendFirstKeyFrame) {
                            if (bl2 && aMFPacket2 == null) {
                                aMFPacket2 = this.getLastKeyFrame(iMediaStream);
                            }
                            if (!this.stream.getParent().isReceiveVideo()) {
                                aMFPacket2 = null;
                            }
                            if (aMFPacket2 != null) {
                                if (this.sendFirstVideoFrame) {
                                    AMFPacket aMFPacket7;
                                    if (bl2 && (aMFPacket7 = iMediaStream.getVideoCodecConfigPacket(aMFPacket2.getAbsTimecode())) != null && iRTPPacketizer != null) {
                                        n2 += iRTPPacketizer.handleAMFPacket(outputStream, iMediaStream, rTPTrack, aMFPacket7, l15);
                                    }
                                    this.sendFirstVideoFrame = false;
                                }
                                lArray[2] = lArray[2] + (long)aMFPacket2.getSize();
                                lArray[3] = lArray[3] + 1L;
                            }
                            if (bl3) {
                                this.trackerStartSeq = liveTracker.trackerSeq;
                            }
                            this.sendFirstKeyFrame = false;
                        } else if (this.lastReceiveAudio != this.stream.getParent().isReceiveAudio() && (aMFPacket6 = new AMFPacket(8, bl2 ? iMediaStream.getSrc() : 0, 0)) != null) {
                            lArray[0] = lArray[0] + 0L;
                            lArray[1] = lArray[1] + 1L;
                        }
                        if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) {
                            if (n14 == 8 && this.sendFirstAudioFrame) {
                                AMFPacket aMFPacket8;
                                AMFPacket aMFPacket9 = new AMFPacket(8, bl2 ? iMediaStream.getSrc() : 0, 0);
                                if (aMFPacket9 != null) {
                                    lArray[0] = lArray[0] + 0L;
                                    lArray[1] = lArray[1] + 1L;
                                }
                                if (bl2 && (aMFPacket8 = iMediaStream.getAudioCodecConfigPacket(aMFPacket3.getAbsTimecode())) != null && iRTPPacketizer2 != null) {
                                    n2 += iRTPPacketizer2.handleAMFPacket(outputStream, iMediaStream, rTPTrack2, aMFPacket8, l15);
                                }
                                this.sendFirstAudioFrame = false;
                            } else if (n14 == 9 && this.sendFirstVideoFrame) {
                                AMFPacket aMFPacket10;
                                if (bl2 && (aMFPacket10 = iMediaStream.getVideoCodecConfigPacket(aMFPacket3.getAbsTimecode())) != null && iRTPPacketizer != null) {
                                    n2 += iRTPPacketizer.handleAMFPacket(outputStream, iMediaStream, rTPTrack, aMFPacket10, l15);
                                }
                                this.sendFirstVideoFrame = false;
                            }
                        }
                        if (n14 == 9) {
                            if (iRTPPacketizer != null) {
                                n2 += iRTPPacketizer.handleAMFPacket(outputStream, iMediaStream, rTPTrack, aMFPacket3, l15);
                            }
                            ++n4;
                            l2 = l15;
                        } else if (n14 == 8) {
                            if (iRTPPacketizer2 != null) {
                                n2 += iRTPPacketizer2.handleAMFPacket(outputStream, iMediaStream, rTPTrack2, aMFPacket3, l15);
                            }
                            ++n3;
                            l2 = l15;
                        }
                        this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                        this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                    }
                    this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                    this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                    l13 = aMFPacket3.getSeq();
                    if (this.playLen > 0.0 && l15 >= Math.round(this.playLen)) {
                        if (this.stream.getParent().isSendPlayStopLogEvent()) {
                            this.stream.getParent().setSendPlayStopLogEvent(false);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
                            this.stream.getParent().notifyActionStop();
                        }
                        this.playlistEnd = true;
                    } else {
                        ++n;
                        bl = false;
                    }
                }
                if (bl) {
                    if (n5 == 0 || n5 == 1) {
                        this.waitForKeyFrame = true;
                    }
                    if (l13 != -1L) {
                        this.lastSeq = l13;
                    }
                    if (rTPTrack3 != null) {
                        n2 += iRTPPacketizer.flushPackets(outputStream, iMediaStream, rTPTrack3);
                    } else {
                        if (iRTPPacketizer != null) {
                            n2 += iRTPPacketizer.flushPackets(outputStream, iMediaStream, rTPTrack);
                        }
                        if (iRTPPacketizer2 != null) {
                            n2 += iRTPPacketizer2.flushPackets(outputStream, iMediaStream, rTPTrack2);
                        }
                    }
                    if (!bl2 && l2 >= 0L) {
                        rTPStream.setVODLastTimeTC(l2);
                    }
                    if (this.isDebugLog) {
                        long l16 = System.currentTimeMillis();
                        long l17 = this.lastSendTime == -1L ? 0L : l16 - this.lastSendTime;
                        this.lastSendTime = l16;
                        WMSLoggerFactory.getLogger(LivePlayer.class).debug("send[" + this.stream.getParent().getClientId() + "]: size:" + n2 + " filter:" + n5 + " time:" + l17 + " tOffset:" + l3);
                    }
                    if (bl3 && liveTracker != null) {
                        liveTracker.totalLen = n2;
                        this.lastSentLiveTracker = liveTracker;
                        rTPWriteListener.getPendingTracker().putInfo(string, liveTracker);
                    }
                    break;
                }
            }
        } while (!bl);
        return n2;
    }

    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        IMediaStream iMediaStream;
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream2 = this.stream.getParent();
        RTPStream rTPStream = iMediaStream2.getRTPStream();
        IMediaStream iMediaStream3 = iMediaStream = rTPStream.isLive() ? this.stream.getParent().getStreams().getStream(this.stream.getParent().getName()) : null;
        if (iMediaStream != null || !rTPStream.isLive()) {
            n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return n;
    }
}

