/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayWriteControl;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderH264
implements IMediaReader {
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = "mp4";
    protected String mediaReaderExt = "mp4";
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = "mp4";
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 16384;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = new int[5];
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = "com.wowza.io.DirectRandomAccessReader";
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = 0;

    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt("mp4ReadAheadSize", this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt("mp4ReadAheadTrigger", this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt("mp4IndexBufferSize", this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean("mp4CacheReadAhead", this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr("randomAccessReaderClass", this.randomAccessReaderClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean("mp4UseDisplaySize", this.useDisplaySize);
        if (WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("MediaReaderH264.mp4ReadAheadSize: " + this.readAheadSize);
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("MediaReaderH264.mp4ReadAheadTrigger: " + this.readAheadTrigger);
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("MediaReaderH264.mp4IndexBufferSize: " + this.indexBufferSize);
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("MediaReaderH264.randomAccessReaderClass: " + this.randomAccessReaderClass);
        }
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.metaFileStream.isOpen()) {
                this.close();
            }
            try {
                this.metaFileStream.open();
                this.videoFileStream.open();
                this.errorReported = false;
            }
            catch (Exception exception) {
                if (!this.errorReported) {
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, "MediaReaderH264.open[1]: " + exception.toString(), null, "server", "comment", 404, this.mediaName);
                }
                this.errorReported = true;
            }
            if (this.metaFileStream != null && this.metaFileStream.isOpen()) {
                try {
                    this.length = this.metaFileStream.length();
                    QTParseContext qTParseContext = new QTParseContext();
                    qTParseContext.setClientId(this.stream.getClientId());
                    qTParseContext.setIndexBufferSize(this.indexBufferSize);
                    qTParseContext.setParseAudioTrack(this.openAudioTrack);
                    qTParseContext.setParseVideoTrack(this.openVideoTrack);
                    this.container = QTUtils.parseQTMediaContainer(this.metaFileStream, this.metaFileStream.length(), qTParseContext);
                    if (this.container != null) {
                        this.appInstance.notifyMediaReaderOpen((IMediaReader)this, this.stream);
                        this.readMetadata();
                        this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)this, this.stream);
                        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                        this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, 2);
                        if (this.cursor != null) {
                            this.videoSampleCount = this.cursor.getVideoSampleCount();
                            this.audioSampleCount = this.cursor.getAudioSampleCount();
                        }
                        if (qTParseContext.getIndexRefCount() <= 0) {
                            this.metaFileStream.close();
                            this.metaFileStream = null;
                        }
                    }
                    if (this.container == null) {
                        if (!this.errorReported) {
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, "MediaReaderH264..open: Error parsing file format [MP4]", null, "server", "comment", 500, this.mediaName);
                        }
                        this.errorReported = true;
                    }
                }
                catch (Exception exception) {
                    if (!this.errorReported) {
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, "MediaReaderH264.open[2]: " + exception.toString(), null, "server", "comment", 404, this.mediaName);
                    }
                    this.errorReported = true;
                    this.container = null;
                }
            }
        }
    }

    public boolean isOpen() {
        return this.container != null;
    }

    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.open: " + exception.toString());
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        this.appInstance.notifyMediaReaderClose((IMediaReader)this, this.stream);
    }

    protected void readMetadata() {
        List<String> list;
        AVCCData aVCCData;
        Object object;
        if (this.container == null) {
            this.metaData = null;
            return;
        }
        this.metaData = new ArrayList();
        AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        QTAtomtrak qTAtomtrak2 = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        QTAtomstbl qTAtomstbl2 = qTAtomtrak2 == null ? null : qTAtomtrak2.getMdiaAtom().getMinfAtom().getStblAtom();
        AMFDataArray aMFDataArray = new AMFDataArray();
        int n = qTAtommoov.getTrakCount();
        for (int i = 0; i < n; ++i) {
            QTAtomtrak qTAtomtrak3 = qTAtommoov.getTrak(i);
            if (qTAtomtrak3 == null) continue;
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataObj.put("timescale", (AMFData)new AMFDataItem(qTAtomtrak3.getMdiaAtom().getTimescale()));
            aMFDataObj.put("length", (AMFData)new AMFDataItem(qTAtomtrak3.getMdiaAtom().getDuration()));
            aMFDataObj.put("language", (AMFData)new AMFDataItem("eng"));
            AMFDataArray aMFDataArray2 = new AMFDataArray();
            List<String> list2 = qTAtomtrak3.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
            Iterator<String> iterator = list2.iterator();
            while (iterator.hasNext()) {
                AMFDataObj aMFDataObj2 = new AMFDataObj();
                object = iterator.next();
                aMFDataObj2.put("sampletype", (AMFData)new AMFDataItem((String)object));
                aMFDataArray2.add((AMFData)aMFDataObj2);
            }
            aMFDataObj.put("sampledescription", (AMFData)aMFDataArray2);
            aMFDataArray.add((AMFData)aMFDataObj);
        }
        aMFDataMixedArray.put("trackinfo", (AMFData)aMFDataArray);
        if (qTAtomstbl2 != null) {
            aMFDataMixedArray.put("audiochannels", (AMFData)new AMFDataItem(qTAtomstbl2.getAudioChannels()));
            aMFDataMixedArray.put("audiosamplerate", (AMFData)new AMFDataItem(qTAtomtrak2.getMdiaAtom().getTimescale()));
        }
        if (qTAtomstbl != null) {
            long l = qTAtomtrak.getMdiaAtom().getTimescale();
            double d = 0.0;
            if (qTAtomstbl.getTimeToSample() != null) {
                long l2 = qTAtomstbl.getTimeToSample().get(0, 1);
                d = (double)l / (double)l2;
            }
            aMFDataMixedArray.put("videoframerate", (AMFData)new AMFDataItem(d));
        }
        aMFDataMixedArray.put("aacaot", (AMFData)new AMFDataItem(2.0));
        if (qTAtomstbl != null && (aVCCData = qTAtomstbl.getAVCCData()) != null) {
            aMFDataMixedArray.put("avclevel", (AMFData)new AMFDataItem(aVCCData.getAvcLevel()));
            aMFDataMixedArray.put("avcprofile", (AMFData)new AMFDataItem(aVCCData.getAvcProfile()));
        }
        if (qTAtomstbl2 != null) {
            aMFDataMixedArray.put("audiocodecid", (AMFData)new AMFDataItem(qTAtomstbl2.getDataTypes().get(0)));
        }
        if (qTAtomstbl != null) {
            aMFDataMixedArray.put("videocodecid", (AMFData)new AMFDataItem(qTAtomstbl.getDataTypes().get(0)));
        }
        if (qTAtomstbl != null) {
            if (this.useDisplaySize) {
                aMFDataMixedArray.put("width", (AMFData)new AMFDataItem(qTAtomstbl.getDisplayWidth()));
                aMFDataMixedArray.put("height", (AMFData)new AMFDataItem(qTAtomstbl.getDisplayHeight()));
            } else {
                aMFDataMixedArray.put("width", (AMFData)new AMFDataItem(qTAtomstbl.getFrameWidth()));
                aMFDataMixedArray.put("height", (AMFData)new AMFDataItem(qTAtomstbl.getFrameHeight()));
            }
            aMFDataMixedArray.put("frameWidth", (AMFData)new AMFDataItem(qTAtomstbl.getFrameWidth()));
            aMFDataMixedArray.put("frameHeight", (AMFData)new AMFDataItem(qTAtomstbl.getFrameHeight()));
            aMFDataMixedArray.put("displayWidth", (AMFData)new AMFDataItem(qTAtomstbl.getDisplayWidth()));
            aMFDataMixedArray.put("displayHeight", (AMFData)new AMFDataItem(qTAtomstbl.getDisplayHeight()));
            double d = qTAtomstbl.getFrameRate();
            if (d > 0.0) {
                aMFDataMixedArray.put("framerate", (AMFData)new AMFDataItem(d));
            }
        }
        aMFDataMixedArray.put("moovposition", (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
        double d = 0.0;
        if (qTAtomtrak2 != null) {
            long l = qTAtomtrak2.getMdiaAtom().getTimescale();
            long l3 = qTAtomtrak2.getMdiaAtom().getDuration();
            d = (double)l3 / (double)l;
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("audioDuration:" + d + ":" + l + ":" + l3);
        }
        double d2 = 0.0;
        if (qTAtomtrak != null) {
            long l = qTAtomtrak.getMdiaAtom().getTimescale();
            long l4 = qTAtomtrak.getMdiaAtom().getDuration();
            d2 = (double)l4 / (double)l;
            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("videoDuration:" + d2 + ":" + l + ":" + l4);
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("duration:" + Math.max(d, d2));
        double d3 = Math.max(d, d2);
        this.duration = Math.round(d3 * 1000.0);
        aMFDataMixedArray.put("duration", (AMFData)new AMFDataItem(d3));
        AMFDataList aMFDataList = new AMFDataList();
        aMFDataList.add((AMFData)new AMFDataItem("onMetaData"));
        aMFDataList.add((AMFData)aMFDataMixedArray);
        object = aMFDataList.serialize();
        this.metaData.add(ByteBuffer.wrap((byte[])object));
        if (qTAtomstbl2 != null && (list = qTAtomstbl2.getDataTypes()).contains(".mp3")) {
            this.audioType = 47;
            this.audioExtraSize = 1;
            this.audioCodec = 2;
        }
    }

    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader, iRandomAccessReader.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("audioDuration:" + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug("videoDuration:" + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container == null) {
            return new H264StreamPosition();
        }
        return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample());
    }

    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
    }

    public long getLength() {
        return this.videoFileStream != null ? this.videoFileStream.length() : 0L;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.basePath;
    }

    public void rewind() {
        if (this.container == null) {
            return;
        }
        this.cursor.setAudioSample(0L);
        this.cursor.setVideoSample(0L);
    }

    public PlaylistSeekResult seek(long l, int n) {
        if (l <= 0L) {
            l = 0L;
        }
        return this.internalSeek(l, n);
    }

    protected PlaylistSeekResult internalSeek(long l, int n) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        PlaylistSeekResult playlistSeekResult = new PlaylistSeekResult(l);
        if (this.container == null) {
            return playlistSeekResult;
        }
        long l7 = -1L;
        long l8 = -1L;
        long l9 = -1L;
        if (this.cursor.containsAudio()) {
            l7 = this.cursor.audioTimecodeToSample(this.cursor.audioTimeMillisToTimecode(l));
        }
        if (this.cursor.containsVideo()) {
            l9 = this.cursor.videoTimecodeToSample(this.cursor.videoTimeMillisToTimecode(l));
            switch (n) {
                case 4: {
                    break;
                }
                case 1: {
                    l8 = this.cursor.videoFindKeySample(l9, 1);
                    break;
                }
                case 2: {
                    l8 = this.cursor.videoFindKeySample(l9, 2);
                    break;
                }
                case 3: {
                    l8 = this.cursor.videoFindKeySample(l9, 3);
                }
            }
        }
        if (l8 >= 0L) {
            l6 = this.cursor.videoSampleToTimecode(l8);
            l5 = this.cursor.videoTimecodeToTimeMillis(l6);
            l4 = this.cursor.audioTimeMillisToTimecode(l5);
            l3 = this.cursor.audioTimecodeToSample(l4);
            if ((l4 = this.cursor.audioSampleToTimecode(l3)) < l6 && this.cursor.getAudioSampleValid(l3 + 1L)) {
                l4 = this.cursor.audioSampleToTimecode(++l3);
            }
            playlistSeekResult.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(l3, l8));
            if (l7 >= 0L) {
                l2 = this.cursor.audioTimecodeToTimeMillis(l4);
                playlistSeekResult.setResultVideoTimecode(Math.min(l2, l5));
            } else {
                playlistSeekResult.setResultVideoTimecode(l5);
            }
            this.cursor.resetVideoAtEnd();
        } else {
            playlistSeekResult.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L));
        }
        l6 = 0L;
        if (l7 >= 0L && l9 >= 0L) {
            l5 = this.cursor.audioSampleToTimecode(l7);
            l4 = this.cursor.audioTimecodeToTimeMillis(l5);
            l3 = this.cursor.videoSampleToTimecode(l9);
            l2 = this.cursor.videoTimecodeToTimeMillis(l3);
            l6 = Math.min(l4, l2);
            this.cursor.resetAudioAtEnd();
            this.cursor.resetVideoAtEnd();
        } else if (l9 >= 0L) {
            l5 = this.cursor.videoSampleToTimecode(l9);
            l6 = this.cursor.videoTimecodeToTimeMillis(l5);
            this.cursor.resetVideoAtEnd();
        } else if (l7 >= 0L) {
            l5 = this.cursor.audioSampleToTimecode(l7);
            l6 = this.cursor.audioTimecodeToTimeMillis(l5);
            this.cursor.resetAudioAtEnd();
        }
        playlistSeekResult.setResults((IMediaReaderStreamPosition)new H264StreamPosition(l7, l9), l6, 8, 1);
        playlistSeekResult.setResultTimecode(l6);
        playlistSeekResult.setSearchTimecode(l);
        return playlistSeekResult;
    }

    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.chunkWorkBuffer = new byte[n];
        }
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{9, 0, 0, 0};
            return iClient.testFlashVersion(nArray) >= 0;
        }
        return false;
    }

    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        l2 = h264ReadAheadPacket != null ? h264ReadAheadPacket.getSampleDesc() : h264Cursor.getSampleDesc();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        boolean bl2 = this.doSendEnhanceSeek;
        this.doSendEnhanceSeek = false;
        long l = playlistCursor.getSeekStartStreamPos() == null ? -1L : ((H264StreamPosition)playlistCursor.getSeekStartStreamPos()).getVideoSample();
        int n3 = playlistCursor.getSeekTarget();
        long l2 = playlistCursor.getForceVideoTC();
        playlistCursor.setForceVideoTC(-1L);
        boolean bl3 = this.isEnhancedSeekCapable(iMediaStream);
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        this.videoFileStream.setDirecton(1);
        boolean bl4 = true;
        long l3 = 0L;
        long l4 = 0L;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                if (this.cursor.isAtEnd()) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.isCurrentAudio() ? 8 : 9;
                this.chunkHeaderValues[3] = this.getFirstByte(this.cursor);
                l3 = this.cursor.getSample();
                l4 = this.getSampleDesc(this.cursor, l3, this.chunkHeaderValues[0]);
                boolean bl5 = false;
                long l5 = 0L;
                long l6 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        if (!iMediaStream.isReceiveVideo()) break;
                        boolean bl6 = playlistCursor.isSendAbsVideoTC();
                        if (bl6) {
                            this.chunkHeaderValues[2] = (int)(l2 + playlistCursor.getStartTCOffset());
                            l6 = l2;
                            playlistCursor.setSendAbsVideoTC(false);
                        } else {
                            this.chunkHeaderValues[2] = 0;
                        }
                        playlistCursor.setLastVideoTC(l2);
                        playlistCursor.incVideoPacketCount();
                        l5 = l6;
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        if (bl4) {
                            if (bl3 && bl2) {
                                n += this.writeEnhancedCmd(87, 0, this.chunkHeaderValues[2], bl6, iMediaStream, outputStream, aMFObj2, lArray, n4);
                            }
                            bl4 = false;
                        }
                        if (l4 != playlistCursor.getVideoSampleDesc()) {
                            int n5;
                            byte[] byArray = this.getVideoCodecConfig(l4);
                            boolean bl7 = playlistCursor.compareAndSetVideoCodecConfig(byArray);
                            if (!bl7 && (n5 = this.sendVideoTrakData(this.chunkHeaderValues[2], bl6, iMediaStream, outputStream, aMFObj2, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, byArray)) > 0) {
                                bl6 = false;
                                this.chunkHeaderValues[2] = 0;
                            }
                            playlistCursor.setVideoSampleDesc(l4);
                        }
                        int n6 = this.directOutput(this.chunkHeaderValues, l3, bl6, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n4, this.cursor, false);
                        n += n6;
                        bl5 = true;
                        playlistReaderWriteResults.incVideoPackets();
                        playlistReaderWriteResults.setLastTC(l2);
                        lArray[2] = lArray[2] + (long)n6;
                        lArray[3] = lArray[3] + 1L;
                        ++n2;
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 15: 
                    case 18: {
                        break;
                    }
                }
                this.cursor.moveNextSample();
                if (n3 != 4) {
                    if (n2 > 0) {
                        break;
                    }
                } else {
                    long l7 = this.cursor.getVideoSample();
                    if (l7 >= l) {
                        break;
                    }
                }
            }
        }
        if (!bl4 && bl3 && bl2) {
            n += this.writeEnhancedCmd(87, 1, 0, false, iMediaStream, outputStream, aMFObj2, lArray, n4);
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    public byte getFirstByte(H264Cursor h264Cursor) {
        byte by = 0;
        by = h264Cursor.isCurrentAudio() ? (byte)this.audioType : (byte)(h264Cursor.isKeyFrame() ? 23 : 39);
        return by;
    }

    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), true, n2 == 0 ? 1 : 2, null);
            }
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            n5 += n6;
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), false, n2 == 0 ? 1 : 2, null);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.enhancedCmd: " + exception.toString());
        }
        return n5;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        int n3 = 0;
        switch (n) {
            case 8: {
                break;
            }
            case 9: {
                Object object;
                QTAtommdia qTAtommdia;
                Object object2;
                QTAtomstbl qTAtomstbl = null;
                byte[] byArray = null;
                QTAtommoov qTAtommoov = this.container.getMoovAtom();
                if (qTAtommoov != null && (object2 = qTAtommoov.getVideoTrack(this.trackIndexVideo)) != null && (qTAtommdia = ((QTAtomtrak)object2).getMdiaAtom()) != null && (object = qTAtommdia.getMinfAtom()) != null && (qTAtomstbl = ((QTAtomminf)object).getStblAtom()) != null) {
                    AVCCData aVCCData;
                    long l = playlistCursor.getVideoSampleDesc();
                    if (l < 0L) {
                        l = 0L;
                    }
                    if ((aVCCData = qTAtomstbl.getAVCCData((int)l)) != null) {
                        byArray = aVCCData.getAvccBytes();
                    }
                }
                int n4 = playlistCursor.getWriteControl().getChunkSize();
                this.checkWorkBuffer(n4);
                object2 = new byte[5];
                int n5 = 0;
                object = new int[5];
                object[1] = false;
                object[2] = n2;
                object[0] = 9;
                object2[0] = 23;
                object2[1] = true;
                object2[2] = false;
                object2[3] = false;
                object2[4] = false;
                object[1] = 5;
                n5 = this.directOutputBuf((int[])object, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, (byte[])object2);
                n3 += n5;
                lArray[2] = lArray[2] + (long)n5;
                lArray[3] = lArray[3] + 1L;
            }
        }
        return n3;
    }

    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray;
        block0: {
            AVCCData aVCCData;
            QTAtomminf qTAtomminf;
            QTAtommdia qTAtommdia;
            QTAtomtrak qTAtomtrak;
            byArray = null;
            QTAtomstbl qTAtomstbl = null;
            Object var5_4 = null;
            QTAtommoov qTAtommoov = this.container.getMoovAtom();
            if (qTAtommoov == null || (qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo)) == null || (qTAtommdia = qTAtomtrak.getMdiaAtom()) == null || (qTAtomminf = qTAtommdia.getMinfAtom()) == null || (qTAtomstbl = qTAtomminf.getStblAtom()) == null || (aVCCData = qTAtomstbl.getAVCCData((int)l)) == null) break block0;
            byArray = aVCCData.getAvccBytes();
        }
        return byArray;
    }

    public int sendVideoTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        boolean bl3 = this.doSendEnhanceSeek;
        this.doSendEnhanceSeek = false;
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        byte[] byArray2 = new byte[(byArray == null ? 0 : byArray.length) + 5];
        int n4 = 0;
        if (bl3) {
            n2 += this.writeEnhancedCmd(82, 0, n, bl, iMediaStream, outputStream, aMFObj, lArray, n3);
        }
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 9;
        byArray2[0] = 23;
        byArray2[1] = 2;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        nArray[1] = 5;
        n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[2] = lArray[2] + (long)n4;
        lArray[3] = lArray[3] + 1L;
        if (bl3) {
            n2 += this.writeEnhancedCmd(82, 1, n, bl, iMediaStream, outputStream, aMFObj, lArray, n3);
        }
        if (byArray != null) {
            byArray2[0] = 23;
            byArray2[1] = 0;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray2[4] = 0;
            System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
            nArray[1] = byArray.length + 5;
            nArray[2] = 0;
            bl = false;
            for (int i = 0; i < (bl3 ? 2 : 1); ++i) {
                n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
                n2 += n4;
                lArray[2] = lArray[2] + (long)n4;
                lArray[3] = lArray[3] + 1L;
            }
        }
        return n2;
    }

    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray;
        block0: {
            QTAtomminf qTAtomminf;
            QTAtommdia qTAtommdia;
            QTAtomtrak qTAtomtrak;
            byArray = null;
            QTAtomstbl qTAtomstbl = null;
            ESDSData eSDSData = null;
            QTAtommoov qTAtommoov = this.container.getMoovAtom();
            if (qTAtommoov == null || (qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio)) == null || (qTAtommdia = qTAtomtrak.getMdiaAtom()) == null || (qTAtomminf = qTAtommdia.getMinfAtom()) == null || (qTAtomstbl = qTAtomminf.getStblAtom()) == null || (eSDSData = qTAtomstbl.getESDSData((int)l)) == null) break block0;
            byArray = eSDSData.specData;
        }
        return byArray;
    }

    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray != null) {
            int n3 = playlistCursor.getWriteControl().getChunkSize();
            this.checkWorkBuffer(n3);
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n;
            nArray[0] = 8;
            byte[] byArray2 = new byte[byArray.length + 2];
            byArray2[0] = -81;
            byArray2[1] = 0;
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            nArray[1] = byArray.length + 2;
            int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
            n2 += n4;
            lArray[0] = lArray[0] + (long)n4;
            lArray[1] = lArray[1] + 1L;
        }
        return n2;
    }

    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings != null) {
            if (fastPlaySettings.getDirection() < 0) {
                return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
            }
            return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        }
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        this.videoFileStream.setDirecton(1);
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        long l2 = 0L;
        long l3 = 0L;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                if (this.cursor.isAtEnd()) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.isCurrentAudio() ? 8 : 9;
                this.chunkHeaderValues[3] = this.getFirstByte(this.cursor);
                l2 = this.cursor.getSample();
                l3 = this.getSampleDesc(this.cursor, l2, this.chunkHeaderValues[0]);
                boolean bl5 = false;
                long l4 = 0L;
                long l5 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (l > 0L && l5 >= l) {
                    break;
                }
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        boolean bl6;
                        int n4;
                        int n5;
                        int n6;
                        if (!iMediaStream.isReceiveVideo() && this.videoCodec != 7) break;
                        if (playlistCursor.isWaitForKeyFrame()) {
                            n6 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                            if (!n6) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        n6 = playlistCursor.isSendAbsVideoTC();
                        if (playlistCursor.isSendAbsVideoTC()) {
                            long l6 = playlistCursor.getForceVideoTC();
                            if (l6 >= 0L) {
                                this.chunkHeaderValues[2] = (int)(l6 + playlistCursor.getStartTCOffset());
                                l5 = l6;
                            } else {
                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            }
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setForceVideoTC(-1L);
                            playlistCursor.setSendAbsVideoTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l5 - playlistCursor.getLastVideoTC() & 0xFFFFFFFFL);
                        }
                        boolean bl7 = playlistWriteControl.testVideoFrame(this.chunkHeaderValues[3]);
                        if (this.chunkHeaderValues[2] >= 0 && bl7) {
                            if (bl) {
                                this.chunkHeaderValues[2] = 0;
                            }
                            if (l3 != playlistCursor.getVideoSampleDesc()) {
                                byte[] byArray = this.getVideoCodecConfig(l3);
                                n5 = playlistCursor.compareAndSetVideoCodecConfig(byArray);
                                if (n5 == 0) {
                                    n4 = this.sendVideoTrakData(this.chunkHeaderValues[2], n6 != 0, iMediaStream, outputStream, aMFObj2, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, byArray);
                                    if (n4 > 0) {
                                        n6 = 0;
                                        this.chunkHeaderValues[2] = 0;
                                    }
                                    n += n4;
                                }
                                playlistCursor.setVideoSampleDesc(l3);
                            }
                            playlistCursor.setLastVideoTC(l5);
                            playlistCursor.incVideoPacketCount();
                            l4 = l5;
                            bl6 = !iMediaStream.isReceiveVideo() && this.videoCodec == 7;
                            n5 = this.directOutput(this.chunkHeaderValues, l2, n6 != 0, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n3, this.cursor, bl6);
                            n += n5;
                            bl5 = true;
                            playlistReaderWriteResults.incVideoPackets();
                            if (this.videoSampleCount > 0L && l2 == this.videoSampleCount - 1L) {
                                n4 = this.directOutput(this.chunkHeaderValues, l2, n6 != 0, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n3, this.cursor, true);
                                n += n4;
                                playlistReaderWriteResults.incVideoPackets();
                            }
                            bl2 = true;
                            bl3 = true;
                            lArray[2] = lArray[2] + (long)n5;
                            lArray[3] = lArray[3] + 1L;
                            break;
                        }
                        if (bl7) break;
                        lArray[6] = lArray[6] + (long)this.chunkHeaderValues[1];
                        lArray[7] = lArray[7] + 1L;
                        break;
                    }
                    case 8: {
                        int n4;
                        if (!iMediaStream.isReceiveAudio() || playlistWriteControl.isSkipAudio() || playlistWriteControl.isAudioFilter()) break;
                        boolean bl6 = playlistCursor.isSendAbsAudioTC();
                        if (playlistCursor.isSendAbsAudioTC()) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setSendAbsAudioTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l5 - playlistCursor.getLastAudioTC() & 0xFFFFFFFFL);
                        }
                        if (this.chunkHeaderValues[2] < 0) break;
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        if (l3 != playlistCursor.getAudioSampleDesc()) {
                            int n7;
                            byte[] byArray = this.getAudioCodecConfig(l3);
                            n4 = playlistCursor.compareAndSetAudioCodecConfig(byArray) ? 1 : 0;
                            if (n4 == 0 && (n7 = this.sendAudioTrakData(this.chunkHeaderValues[2], bl6, iMediaStream, outputStream, aMFObj, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, byArray)) > 0) {
                                bl6 = false;
                                this.chunkHeaderValues[2] = 0;
                            }
                            playlistCursor.setAudioSampleDesc(l3);
                        }
                        playlistCursor.setLastAudioTC(l5);
                        playlistCursor.incAudioPacketCount();
                        l4 = l5;
                        int n5 = this.directOutput(this.chunkHeaderValues, l2, bl6, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, this.cursor, false);
                        n += n5;
                        bl5 = true;
                        playlistReaderWriteResults.incAudioPackets();
                        bl2 = true;
                        bl4 = true;
                        lArray[0] = lArray[0] + (long)n5;
                        lArray[1] = lArray[1] + 1L;
                        break;
                    }
                    case 15: 
                    case 18: {
                        int n5 = playlistCursor.isSendAbsBroadcastTC();
                        if (playlistCursor.isSendAbsBroadcastTC()) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setSendAbsBroadcastTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l5 - playlistCursor.getLastBroadcastTC() & 0xFFFFFFFFL);
                        }
                        playlistCursor.setLastBroadcastTC(l5);
                        playlistCursor.incDataPacketCount();
                        l4 = l5;
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        int n4 = this.directOutput(this.chunkHeaderValues, l2, n5 != 0, iMediaStream.getSrc(), outputStream, aMFObj3, this.chunkWorkBuffer, n3, this.cursor, false);
                        n += n4;
                        lArray[4] = lArray[4] + (long)n4;
                        lArray[5] = lArray[5] + 1L;
                        bl5 = true;
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l5);
                ++n2;
                this.cursor.moveNextSample();
                if (l == 0L) {
                    if (bl3 || n2 > 20) {
                        break;
                    }
                } else if (l5 >= l) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePacketsFastPlay(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        double d = fastPlaySettings.getMultiplier();
        int n2 = fastPlaySettings.getDirection();
        long l = Math.round(1000.0 / (double)fastPlaySettings.getFps());
        long l2 = fastPlaySettings.getStartTC();
        this.videoFileStream.setDirecton(n2);
        if (n2 < 0) {
            playlistCursor.setVideoCanDFrame(false);
            playlistCursor.setVideoCanPFrame(false);
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        long l3 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l4 = playlistWriteControl.getMaxTC();
        long l5 = 0L;
        long l6 = 0L;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                if (this.cursor.isAtEnd()) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.isCurrentAudio() ? 8 : 9;
                this.chunkHeaderValues[3] = this.getFirstByte(this.cursor);
                l5 = this.cursor.getSample();
                l6 = this.getSampleDesc(this.cursor, l5, this.chunkHeaderValues[0]);
                boolean bl6 = false;
                long l7 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (l4 > 0L && l7 >= l4) {
                    break;
                }
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        long l8;
                        int n4 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                        if (playlistCursor.isWaitForKeyFrame()) {
                            if (n4 != 1) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        boolean bl7 = true;
                        boolean bl8 = playlistCursor.isSendAbsVideoTC();
                        boolean bl9 = playlistCursor.isSendAbsVideoTC();
                        if (bl8) {
                            l8 = playlistCursor.getForceVideoTC();
                            if (l8 >= 0L) {
                                this.chunkHeaderValues[2] = (int)(l8 + playlistCursor.getStartTCOffset());
                                l7 = l8;
                            } else {
                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            }
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setForceVideoTC(-1L);
                            playlistCursor.setSendAbsVideoTC(false);
                            playlistCursor.setLastVideoFastTC(l7);
                        } else {
                            l8 = playlistCursor.getLastVideoFastTC() - l2;
                            long l9 = Math.round((double)Math.abs(l2 - l7) / d);
                            long l10 = l9 - l8;
                            boolean bl10 = bl7 = n4 == 1;
                            if (bl7) {
                                this.chunkHeaderValues[2] = (int)(l10 & 0xFFFFFFFFL);
                                playlistCursor.incLastVideoFastTC(l10);
                            }
                        }
                        if (bl7) {
                            if (bl) {
                                this.chunkHeaderValues[2] = 0;
                            }
                            if (l6 != playlistCursor.getVideoSampleDesc()) {
                                int n5;
                                byte[] byArray = this.getVideoCodecConfig(l6);
                                boolean bl11 = playlistCursor.compareAndSetVideoCodecConfig(byArray);
                                if (!bl11 && (n5 = this.sendVideoTrakData(this.chunkHeaderValues[2], bl9, iMediaStream, outputStream, aMFObj2, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, byArray)) > 0) {
                                    bl9 = false;
                                    this.chunkHeaderValues[2] = 0;
                                }
                                playlistCursor.setVideoSampleDesc(l6);
                            }
                            playlistCursor.setLastVideoTC(l7);
                            playlistCursor.incVideoPacketCount();
                            l3 = l7;
                            int n6 = this.directOutput(this.chunkHeaderValues, l5, bl9, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n3, this.cursor, false);
                            n += n6;
                            bl2 = true;
                            bl3 = true;
                            bl6 = true;
                            lArray[2] = lArray[2] + (long)n6;
                            lArray[3] = lArray[3] + 1L;
                            playlistReaderWriteResults.incVideoPackets();
                            boolean bl12 = bl5 = n4 == 1;
                            if (n2 <= 0) break;
                            playlistCursor.setVideoCanPFrame(true);
                            if (n4 != 1) break;
                            playlistCursor.setVideoCanDFrame(true);
                            break;
                        }
                        if (n2 <= 0) break;
                        playlistCursor.setVideoCanPFrame(false);
                        if (n4 != 1) break;
                        playlistCursor.setVideoCanDFrame(false);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 15: 
                    case 18: {
                        boolean bl13 = true;
                        long l11 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                        if ((l11 += playlistCursor.getStartTCOffset()) < 0L) break;
                        this.chunkHeaderValues[2] = (int)(playlistCursor.calcTCAdj(l11) & 0xFFFFFFFFL);
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        int n7 = this.directOutput(this.chunkHeaderValues, l5, bl13, iMediaStream.getSrc(), outputStream, aMFObj3, this.chunkWorkBuffer, n3, this.cursor, false);
                        n += n7;
                        playlistCursor.setLastBroadcastTC(l7);
                        playlistCursor.incDataPacketCount();
                        l3 = l7;
                        lArray[4] = lArray[4] + (long)n7;
                        lArray[5] = lArray[5] + 1L;
                        bl6 = true;
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l7);
                if (n2 < 0) {
                    this.cursor.movePrevSample();
                } else {
                    this.cursor.moveNextSample();
                }
                if (bl2 && (l4 == 0L || playlistCursor.calcTCAdj(l7) >= l4)) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    protected int directOutput(int[] nArray, long l, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, H264Cursor h264Cursor, boolean bl2) {
        int n3;
        block40: {
            n3 = 0;
            try {
                int n4;
                int n5;
                long l2 = (long)nArray[2] & 0xFFFFFFFFL;
                int n6 = nArray[0];
                int n7 = 0;
                H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n6, l);
                if (h264ReadAheadPacket != null) {
                    n7 = (int)h264ReadAheadPacket.getSize();
                }
                if (bl2) {
                    n7 = 0;
                }
                nArray[1] = n7;
                int n8 = 5;
                if (n6 == 8) {
                    n8 = this.audioExtraSize;
                }
                n7 += n8;
                int n9 = aMFObj.getId();
                boolean bl3 = aMFObj.isNew();
                boolean bl4 = bl3 | bl;
                aMFObj.setNew(false);
                int n10 = 1;
                byArray[0] = (byte)(0xFF & n9);
                if (bl4 || aMFObj.getSrc() != n) {
                    byArray[8] = (byte)(0xFF & n);
                    byArray[9] = (byte)(0xFF & n >> 8);
                    byArray[10] = (byte)(0xFF & n >> 16);
                    byArray[11] = (byte)(0xFF & n >> 24);
                    aMFObj.setSrc(n);
                    n10 += 4;
                    bl4 = true;
                }
                if (bl4 || aMFObj.getSize() != n7 || aMFObj.getType() != n6) {
                    byArray[4] = (byte)(0xFF & n7 >> 16);
                    byArray[5] = (byte)(0xFF & n7 >> 8);
                    byArray[6] = (byte)(0xFF & n7);
                    byArray[7] = (byte)n6;
                    aMFObj.setSize(n7);
                    aMFObj.setType(n6);
                    n10 += 4;
                    bl4 = true;
                }
                boolean bl5 = false;
                if (!bl4) {
                    // empty if block
                }
                if (l2 >= 0xFFFFFFL) {
                    byArray[1] = -1;
                    byArray[2] = -1;
                    byArray[3] = -1;
                    bl5 = true;
                } else {
                    byArray[1] = (byte)(0xFFL & l2 >> 16);
                    byArray[2] = (byte)(0xFFL & l2 >> 8);
                    byArray[3] = (byte)(0xFFL & l2);
                }
                aMFObj.setTimecode(l2);
                n10 += 3;
                bl4 = true;
                if (n9 >= 64) {
                    n5 = n9 - 64;
                    n4 = n5 > 255 ? 3 : 2;
                    byte[] byArray2 = new byte[n4];
                    switch (n10) {
                        case 12: {
                            byArray2[0] = (byte)(0 + (n4 - 2));
                            break;
                        }
                        case 8: {
                            byArray2[0] = (byte)(64 + (n4 - 2));
                            break;
                        }
                        case 4: {
                            byArray2[0] = (byte)(128 + (n4 - 2));
                            break;
                        }
                        case 1: {
                            byArray2[0] = (byte)(192 + (n4 - 2));
                        }
                    }
                    byArray2[1] = (byte)(0xFF & n5);
                    if (n4 == 3) {
                        byArray2[2] = (byte)(0xFF & n5 >> 8);
                    }
                    outputStream.write(byArray2, 0, n4);
                    outputStream.write(byArray, 1, n10 - 1);
                    n3 += n10 + 1;
                } else {
                    switch (n10) {
                        case 12: {
                            break;
                        }
                        case 8: {
                            byArray[0] = (byte)(byArray[0] | 0x40);
                            break;
                        }
                        case 4: {
                            byArray[0] = (byte)(byArray[0] | 0x80);
                            break;
                        }
                        case 1: {
                            byArray[0] = (byte)(byArray[0] | 0xC0);
                        }
                    }
                    outputStream.write(byArray, 0, n10);
                    n3 += n10;
                }
                if (bl5) {
                    byArray[0] = (byte)(0xFFL & l2 >> 24);
                    byArray[1] = (byte)(0xFFL & l2 >> 16);
                    byArray[2] = (byte)(0xFFL & l2 >> 8);
                    byArray[3] = (byte)(0xFFL & l2);
                    outputStream.write(byArray, 0, 4);
                    n3 = 4;
                }
                n5 = 1;
                if (n7 <= 0) break block40;
                n4 = n7;
                int n11 = 0;
                int n12 = 0;
                byte[] byArray3 = null;
                int n13 = 0;
                if (h264ReadAheadPacket != null) {
                    byArray3 = h264ReadAheadPacket.getBuffer();
                    n13 = h264ReadAheadPacket.boffset;
                }
                do {
                    int n14;
                    if (n11 > 0) {
                        if (n9 >= 64) {
                            n14 = n9 - 64;
                            int n15 = n14 > 255 ? 3 : 2;
                            byArray[0] = (byte)(192 + (n15 - 2));
                            byArray[1] = (byte)(0xFF & n14);
                            if (n15 == 3) {
                                byArray[2] = (byte)(0xFF & n14 >> 8);
                            }
                            outputStream.write(byArray, 0, n15);
                            n3 += n15;
                        } else {
                            byArray[0] = (byte)(0xFF & n9 | 0xC0);
                            outputStream.write(byArray, 0, 1);
                            ++n3;
                        }
                        if (bl5) {
                            byArray[0] = (byte)(0xFFL & l2 >> 24);
                            byArray[1] = (byte)(0xFFL & l2 >> 16);
                            byArray[2] = (byte)(0xFFL & l2 >> 8);
                            byArray[3] = (byte)(0xFFL & l2);
                            outputStream.write(byArray, 0, 4);
                            n3 = 4;
                        }
                    }
                    if ((n12 = n2) > n4 - n11) {
                        n12 = n4 - n11;
                    }
                    try {
                        if (n5 != 0) {
                            byArray[0] = this.getFirstByte(h264Cursor);
                            byArray[1] = 1;
                            if (!h264Cursor.isCurrentAudio()) {
                                n14 = h264Cursor.getCTTSMillis();
                                byArray[2] = (byte)(n14 >> 16 & 0xFF);
                                byArray[3] = (byte)(n14 >> 8 & 0xFF);
                                byArray[4] = (byte)(n14 >> 0 & 0xFF);
                            }
                        }
                        if (n5 != 0) {
                            outputStream.write(byArray, 0, n8);
                        }
                        if (byArray3 != null) {
                            n14 = n5 != 0 ? n12 - n8 : n12;
                            outputStream.write(byArray3, n13, n14);
                            n13 += n14;
                        }
                        n5 = 0;
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.directOutput: Problem reading input file: " + exception.toString());
                        exception.printStackTrace();
                    }
                    n3 += n12;
                } while ((n11 += n12) != n4);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.directOutput: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return n3;
    }

    protected int directOutputBuf(int[] nArray, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, byte[] byArray2) {
        int n3;
        block32: {
            n3 = 0;
            try {
                int n4;
                int n5;
                long l = (long)nArray[2] & 0xFFFFFFFFL;
                int n6 = nArray[1];
                int n7 = nArray[0];
                int n8 = aMFObj.getId();
                boolean bl2 = aMFObj.isNew();
                boolean bl3 = bl2 | bl;
                aMFObj.setNew(false);
                int n9 = 1;
                byArray[0] = (byte)(0xFF & n8);
                if (bl3 || aMFObj.getSrc() != n) {
                    byArray[8] = (byte)(0xFF & n);
                    byArray[9] = (byte)(0xFF & n >> 8);
                    byArray[10] = (byte)(0xFF & n >> 16);
                    byArray[11] = (byte)(0xFF & n >> 24);
                    aMFObj.setSrc(n);
                    n9 += 4;
                    bl3 = true;
                }
                if (bl3 || aMFObj.getSize() != n6 || aMFObj.getType() != n7) {
                    byArray[4] = (byte)(0xFF & n6 >> 16);
                    byArray[5] = (byte)(0xFF & n6 >> 8);
                    byArray[6] = (byte)(0xFF & n6);
                    byArray[7] = (byte)n7;
                    aMFObj.setSize(n6);
                    aMFObj.setType(n7);
                    n9 += 4;
                    bl3 = true;
                }
                boolean bl4 = false;
                if (bl3 || aMFObj.getTimecode() != l) {
                    if (l >= 0xFFFFFFL) {
                        byArray[1] = -1;
                        byArray[2] = -1;
                        byArray[3] = -1;
                        bl4 = true;
                    } else {
                        byArray[1] = (byte)(0xFFL & l >> 16);
                        byArray[2] = (byte)(0xFFL & l >> 8);
                        byArray[3] = (byte)(0xFFL & l);
                    }
                    aMFObj.setTimecode(l);
                    n9 += 3;
                    bl3 = true;
                }
                if (n8 >= 64) {
                    n5 = n8 - 64;
                    n4 = n5 > 255 ? 3 : 2;
                    byte[] byArray3 = new byte[n4];
                    switch (n9) {
                        case 12: {
                            byArray3[0] = (byte)(0 + (n4 - 2));
                            break;
                        }
                        case 8: {
                            byArray3[0] = (byte)(64 + (n4 - 2));
                            break;
                        }
                        case 4: {
                            byArray3[0] = (byte)(128 + (n4 - 2));
                            break;
                        }
                        case 1: {
                            byArray3[0] = (byte)(192 + (n4 - 2));
                        }
                    }
                    byArray3[1] = (byte)(0xFF & n5);
                    if (n4 == 3) {
                        byArray3[2] = (byte)(0xFF & n5 >> 8);
                    }
                    outputStream.write(byArray3, 0, n4);
                    outputStream.write(byArray, 1, n9 - 1);
                    n3 += n9 + 1;
                } else {
                    switch (n9) {
                        case 12: {
                            break;
                        }
                        case 8: {
                            byArray[0] = (byte)(byArray[0] | 0x40);
                            break;
                        }
                        case 4: {
                            byArray[0] = (byte)(byArray[0] | 0x80);
                            break;
                        }
                        case 1: {
                            byArray[0] = (byte)(byArray[0] | 0xC0);
                        }
                    }
                    outputStream.write(byArray, 0, n9);
                    n3 += n9;
                }
                if (bl4) {
                    byArray[0] = (byte)(0xFFL & l >> 24);
                    byArray[1] = (byte)(0xFFL & l >> 16);
                    byArray[2] = (byte)(0xFFL & l >> 8);
                    byArray[3] = (byte)(0xFFL & l);
                    outputStream.write(byArray, 0, 4);
                    n3 = 4;
                }
                if (n6 <= 0) break block32;
                n5 = n6;
                n4 = 0;
                int n10 = 0;
                do {
                    if (n4 > 0) {
                        if (n8 >= 64) {
                            int n11 = n8 - 64;
                            int n12 = n11 > 255 ? 3 : 2;
                            byArray[0] = (byte)(192 + (n12 - 2));
                            byArray[1] = (byte)(0xFF & n11);
                            if (n12 == 3) {
                                byArray[2] = (byte)(0xFF & n11 >> 8);
                            }
                            outputStream.write(byArray, 0, n12);
                            n3 += n12;
                        } else {
                            byArray[0] = (byte)(0xFF & n8 | 0xC0);
                            outputStream.write(byArray, 0, 1);
                            ++n3;
                        }
                        if (bl4) {
                            byArray[0] = (byte)(0xFFL & l >> 24);
                            byArray[1] = (byte)(0xFFL & l >> 16);
                            byArray[2] = (byte)(0xFFL & l >> 8);
                            byArray[3] = (byte)(0xFFL & l);
                            outputStream.write(byArray, 0, 4);
                            n3 = 4;
                        }
                    }
                    if ((n10 = n2) > n5 - n4) {
                        n10 = n5 - n4;
                    }
                    try {
                        outputStream.write(byArray2, n4, n10);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.directOutputBuf: Problem reading input file: " + exception.toString());
                    }
                    n3 += n10;
                } while ((n4 += n10) != n5);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.directOutputBuf: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return n3;
    }

    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info("packet: " + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) break;
            ++n2;
        }
        wMSLogger.info("***samplecount: " + n2);
    }

    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest h264ReadAheadRequest) {
        H264ReadAheadRequest h264ReadAheadRequest2;
        block8: {
            long l;
            h264ReadAheadRequest2 = null;
            QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            if (this.cursorReadAhead == null) {
                this.cursorReadAhead = new H264Cursor(qTAtomtrak, qTAtomtrak2);
            }
            if (h264ReadAheadRequest != null) {
                this.cursorReadAhead.setCurrentPosition(h264ReadAheadRequest.getCursorPosition());
            } else {
                this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
            }
            if (this.cursorReadAhead.isAtEnd()) break block8;
            if (this.readAheadCache.size() > 0) {
                h264ReadAheadRequest2 = this.readAheadCache.remove(0);
                h264ReadAheadRequest2.clear();
            } else {
                h264ReadAheadRequest2 = new H264ReadAheadRequest();
            }
            h264ReadAheadRequest2.setFileStream(this.videoFileStream);
            h264ReadAheadRequest2.setReadAheadTrigger(this.readAheadTrigger);
            long l2 = 0L;
            do {
                l = this.cursorReadAhead.getSize();
                int n = this.cursorReadAhead.isCurrentAudio() ? 8 : 9;
                long l3 = this.cursorReadAhead.getSample();
                long l4 = this.cursorReadAhead.getSampleDesc();
                h264ReadAheadRequest2.addPacket(n, l3, this.cursorReadAhead.getFileLoc(), l, l4);
                this.cursorReadAhead.moveNextSample();
            } while ((l2 += l) <= (long)this.readAheadSize && !this.cursorReadAhead.isAtEnd());
            if (h264ReadAheadRequest2 != null) {
                h264ReadAheadRequest2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                if (this.stream != null) {
                    this.stream.getStreams().getVHost().getIOScheduler().executeRaw((Runnable)h264ReadAheadRequest2);
                }
            }
        }
        return h264ReadAheadRequest2;
    }

    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        block10: {
            block11: {
                block9: {
                    h264ReadAheadPacket = null;
                    if (this.currReadAhead == null) break block9;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block10;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.nextReadAhead;
                this.nextReadAhead = null;
                if (this.currReadAhead == null) break block11;
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket != null) break block10;
                if (this.cacheReadAhead) {
                    this.readAheadCache.add(this.currReadAhead);
                }
                this.currReadAhead = null;
            }
            this.currReadAhead = this.tiggerNextReadAhead(null);
            if (this.currReadAhead != null) {
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket == null) {
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
            }
        }
        if (h264ReadAheadPacket != null && this.nextReadAhead == null && h264ReadAheadPacket.isAfterTrigger) {
            this.nextReadAhead = this.tiggerNextReadAhead(this.currReadAhead);
        }
        return h264ReadAheadPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        this.videoFileStream.setDirecton(1);
        long l2 = 0L;
        long l3 = 0L;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                if (this.cursor == null) {
                    break;
                }
                if (this.cursor.isAtEnd()) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.isCurrentAudio() ? 8 : 9;
                this.chunkHeaderValues[3] = this.getFirstByte(this.cursor);
                l2 = this.cursor.getSample();
                l3 = this.getSampleDesc(this.cursor, l2, this.chunkHeaderValues[0]);
                long l4 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (l > 0L && l4 >= l) {
                    break;
                }
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        AMFPacket aMFPacket;
                        Object object2;
                        boolean bl2;
                        int n3;
                        if (!this.stream.isReceiveVideo()) break;
                        if (playlistCursor.isWaitForKeyFrame()) {
                            n3 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                            if (n3 != 1) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        if ((n3 = (int)(playlistWriteControl.testVideoFrame(this.chunkHeaderValues[3]) ? 1 : 0)) != 0) {
                            if (l3 != playlistCursor.getVideoSampleDesc() && !(bl2 = playlistCursor.compareAndSetVideoCodecConfig(object2 = this.getVideoCodecConfig(l3))) && (aMFPacket = this.getVideoTrakDataPacket(this.chunkHeaderValues[2], (byte[])object2)) != null) {
                                aMFPacket.setAbsTimecode(l4);
                                list.add(aMFPacket);
                                ++n2;
                                n += aMFPacket.getSize();
                                playlistReaderWriteResults.incVideoPackets();
                                lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                                lArray[3] = lArray[3] + 1L;
                                playlistCursor.setVideoSampleDesc(l3);
                            }
                            playlistCursor.setLastVideoTC(l4);
                            playlistCursor.incVideoPacketCount();
                            object2 = this.getFramePacket(this.chunkHeaderValues, l2);
                            if (object2 == null) break;
                            object2.setAbsTimecode(l4);
                            list.add((AMFPacket)object2);
                            ++n2;
                            n += object2.getSize();
                            playlistReaderWriteResults.incVideoPackets();
                            lArray[2] = lArray[2] + (long)object2.getSize();
                            lArray[3] = lArray[3] + 1L;
                            bl = true;
                            break;
                        }
                        if (n3 != 0) break;
                        lArray[6] = lArray[6] + (long)this.chunkHeaderValues[1];
                        lArray[7] = lArray[7] + 1L;
                        break;
                    }
                    case 8: {
                        AMFPacket aMFPacket;
                        Object object2;
                        boolean bl2;
                        if (!this.stream.isReceiveAudio() || playlistWriteControl.isSkipAudio() || playlistWriteControl.isAudioFilter()) break;
                        playlistCursor.setLastAudioTC(l4);
                        playlistCursor.incAudioPacketCount();
                        if (l3 != playlistCursor.getAudioSampleDesc() && !(bl2 = playlistCursor.compareAndSetAudioCodecConfig(object2 = this.getAudioCodecConfig(l3))) && (aMFPacket = this.getAudioTrakDataPacket(this.chunkHeaderValues[2], (byte[])object2)) != null) {
                            aMFPacket.setAbsTimecode(l4);
                            list.add(aMFPacket);
                            ++n2;
                            n += aMFPacket.getSize();
                            lArray[0] = lArray[0] + (long)aMFPacket.getSize();
                            lArray[1] = lArray[1] + 1L;
                            playlistCursor.setAudioSampleDesc(l3);
                        }
                        if ((object2 = (Object)this.getFramePacket(this.chunkHeaderValues, l2)) == null) break;
                        object2.setAbsTimecode(l4);
                        list.add((AMFPacket)object2);
                        ++n2;
                        n += object2.getSize();
                        playlistReaderWriteResults.incAudioPackets();
                        bl = false;
                        lArray[0] = lArray[0] + (long)object2.getSize();
                        lArray[1] = lArray[1] + 1L;
                        break;
                    }
                    case 15: 
                    case 18: {
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l4);
                this.cursor.moveNextSample();
                if (l == 0L) {
                    if (bl || n2 > 20) {
                        break;
                    }
                } else if (l4 >= l) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    private AMFPacket getVideoTrakDataPacket(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray != null) {
            aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
            byte[] byArray2 = aMFPacket.getData();
            byArray2[0] = 23;
            byArray2[1] = 0;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray2[4] = 0;
            aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        }
        return aMFPacket;
    }

    private AMFPacket getAudioTrakDataPacket(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray != null) {
            aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
            byte[] byArray2 = aMFPacket.getData();
            byArray2[0] = -81;
            byArray2[1] = 0;
            aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        }
        return aMFPacket;
    }

    protected AMFPacket getFramePacket(int[] nArray, long l) {
        AMFPacket aMFPacket = null;
        try {
            int n = nArray[0];
            int n2 = 0;
            H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
            if (h264ReadAheadPacket != null) {
                n2 = (int)h264ReadAheadPacket.getSize();
            }
            if (n2 > 0) {
                int n3 = 5;
                if (n == 8) {
                    n3 = this.audioExtraSize;
                }
                aMFPacket = new AMFPacket(nArray[0], 0, n2 + n3);
                byte[] byArray = aMFPacket.getData();
                byArray[0] = (byte)this.chunkHeaderValues[3];
                byArray[1] = 1;
                if (n3 == 5) {
                    int n4 = this.cursor.getCTTSMillis();
                    byArray[2] = (byte)(n4 >> 16 & 0xFF);
                    byArray[3] = (byte)(n4 >> 8 & 0xFF);
                    byArray[4] = (byte)(n4 >> 0 & 0xFF);
                }
                byte[] byArray2 = null;
                int n5 = 0;
                if (h264ReadAheadPacket != null) {
                    byArray2 = h264ReadAheadPacket.getBuffer();
                    n5 = h264ReadAheadPacket.boffset;
                }
                if (n3 == 5) {
                    aMFPacket.addDataEx(byArray2, n5, 5, n2);
                } else {
                    aMFPacket.addDataEx(byArray2, n5, 2, n2);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error("MediaReaderH264.getFramePacket: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    public int getTrackCountVideo() {
        int n = 0;
        if (this.container != null) {
            n = this.container.getMoovAtom().getVideoTrackCount();
        }
        return n;
    }

    public int getTrackCountAudio() {
        int n = 0;
        if (this.container != null) {
            n = this.container.getMoovAtom().getAudioTrackCount();
        }
        return n;
    }

    public int getTrackCountData() {
        int n = 0;
        if (this.container != null) {
            n = this.container.getMoovAtom().getDataTrackCount();
        }
        return n;
    }

    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container != null) {
            string = this.container.getMoovAtom().getAudioTrackLanguage(n);
        }
        return string;
    }

    public long getTrackAudioTrackId(int n) {
        long l;
        block0: {
            QTAtomtrak qTAtomtrak;
            l = -1L;
            if (this.container == null || (qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("smhd", n)) == null) break block0;
            l = qTAtomtrak.getTkhdAtom().getTrackId();
        }
        return l;
    }

    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) {
            qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("smhd", n);
        }
        return qTAtomtrak;
    }

    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) {
            qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("vmhd", n);
        }
        return qTAtomtrak;
    }

    public long getTrackVideoTrackId(int n) {
        long l;
        block0: {
            QTAtomtrak qTAtomtrak;
            l = -1L;
            if (this.container == null || (qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("vmhd", n)) == null) break block0;
            l = qTAtomtrak.getTkhdAtom().getTrackId();
        }
        return l;
    }

    public long getTrackVideoWidth(int n) {
        long l;
        block0: {
            QTAtomtrak qTAtomtrak;
            l = -1L;
            if (this.container == null || (qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("vmhd", n)) == null) break block0;
            l = qTAtomtrak.getTkhdAtom().getTrackWidth();
        }
        return l;
    }

    public long getTrackVideoHeight(int n) {
        long l;
        block0: {
            QTAtomtrak qTAtomtrak;
            l = -1L;
            if (this.container == null || (qTAtomtrak = this.container.getMoovAtom().getTrackByMinf("vmhd", n)) == null) break block0;
            l = qTAtomtrak.getTkhdAtom().getTrackHeight();
        }
        return l;
    }
}

