/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkCreator;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrPlayerAdapter;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.http.HTTPCrossdomainHandler;
import com.wowza.wms.http.HTTPRequestAdapter;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.smoothstreaming.dvr.DvrPlayerAdapterSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerApplicationContextSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamerFragmentId;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamingURL;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriter;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylist;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylistEntry;
import com.wowza.wms.httpstreamer.smoothstreaming.util.LiveStreamPacketizerSmoothStreamerUtils;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.parsers.atom.AtomBytesToTree;
import com.wowza.wms.parsers.atom.AtomTreeToBytes;
import com.wowza.wms.parsers.atom.IAtom;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerAdapterSmoothStreamer
extends HTTPStreamerAdapterBase {
    public static boolean doDebug = false;
    public static final int CLIENTACCESSPOLICY_READ_FREQUENCY = 5000;
    public static final String CLASSNAME = "HttpStreamerAdapterSmoothStreamer";
    protected String clientAccessPolicyPath = "${com.wowza.wms.context.VHostConfigHome}/conf/clientaccesspolicy.xml";
    protected boolean clientAccessPolicyResolved = false;
    protected long lastClientAccessPolicyRead = -1L;
    protected String clientAccessPolicyStr = null;
    protected boolean debugLog = false;
    protected int requestTimeout = 12000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    private Map<String, DebugSession> debugRequests = null;
    private DebugThread debugThread = null;
    private IDvrPlayerAdapter dvrPlayerAdapter = new DvrPlayerAdapterSmoothStreaming();

    public HTTPStreamerAdapterSmoothStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        if (this.debugRequests != null) {
            this.debugThread.start();
        }
    }

    public void init() {
        super.init();
        this.clientAccessPolicyPath = this.properties.getPropertyStr("clientAccessPolicyPath", this.clientAccessPolicyPath);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.debugLog = WMSLoggerFactory.getLogger(null).isDebugEnabled();
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (doDebug) {
            WMSLoggerFactory.getLogger(null).info("HTTPStreamerAdapterSmoothStreamer.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebugRequests() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dumpDebugRequests:\n");
        Map<String, DebugSession> map = this.debugRequests;
        synchronized (map) {
            for (String string : this.debugRequests.keySet()) {
                DebugSession debugSession = this.debugRequests.get(string);
                if (debugSession == null) continue;
                for (String string2 : debugSession.debugRequests.keySet()) {
                    DebugRequest debugRequest = debugSession.debugRequests.get(string2);
                    stringBuffer.append("  " + string + ":" + string2 + ":" + debugRequest.type + "\n");
                }
            }
        }
        if (stringBuffer.length() > 0) {
            System.out.println(stringBuffer.toString());
        }
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterSmoothStreamer.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            int n = string.indexOf("?");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string2 != null && string2.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            if (string.endsWith("Manifest")) {
                this.onManifest(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ismv") || string.endsWith(".isma")) {
                this.onISMVData(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith("clientaccesspolicy.xml")) {
                this.onClientAccessPolicy(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public File getClientAccessPolicyFile() {
        if (!this.clientAccessPolicyResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.clientAccessPolicyPath = SystemUtils.expandEnvironmentVariables((String)this.clientAccessPolicyPath, hashMap);
            this.clientAccessPolicyResolved = true;
        }
        return new File(this.clientAccessPolicyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientAccessPolicy(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        block23: {
            try {
                Object object;
                Closeable closeable;
                File file;
                if ((this.clientAccessPolicyStr == null || l - this.lastClientAccessPolicyRead > 5000L) && (file = this.getClientAccessPolicyFile()).exists()) {
                    closeable = null;
                    try {
                        object = new StringBuffer();
                        closeable = new BufferedReader(new FileReader(file));
                        String string = null;
                        while ((string = ((BufferedReader)closeable).readLine()) != null) {
                            ((StringBuffer)object).append(string + "\n");
                        }
                        this.clientAccessPolicyStr = ((StringBuffer)object).toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                ((BufferedReader)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.lastClientAccessPolicyRead = l;
                }
                boolean bl = true;
                if (this.clientAccessPolicyStr == null) {
                    bl = false;
                } else if (this.clientAccessPolicyStr.length() == 0) {
                    bl = false;
                }
                try {
                    if (bl) {
                        iHTTPResponse.setHeader("Content-Type", "text/xml");
                        closeable = iHTTPResponse.getOutputStream();
                        object = this.clientAccessPolicyStr.getBytes();
                        ((OutputStream)closeable).write((byte[])object);
                        break block23;
                    }
                    iHTTPResponse.setResponseCode(404);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPCrossdomainHandler.class).error("HTTPCrossdomainHandler.onClientAccessPolicy: " + exception.toString());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.onClientAccessPolicy: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionSmoothStreamer hTTPStreamerSessionSmoothStreamer = new HTTPStreamerSessionSmoothStreamer();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionSmoothStreamer.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = iHTTPRequest.getServerPort();
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionSmoothStreamer.setServerIp(string4);
        hTTPStreamerSessionSmoothStreamer.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionSmoothStreamer.setUri(string5);
        hTTPStreamerSessionSmoothStreamer.setQueryStr(string6);
        hTTPStreamerSessionSmoothStreamer.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionSmoothStreamer.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionSmoothStreamer.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionSmoothStreamer, iApplicationInstance, string);
        return hTTPStreamerSessionSmoothStreamer;
    }

    public void onManifest(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block65: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                String string;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                boolean bl3;
                int n;
                MediaStreamMap mediaStreamMap;
                SmoothStreamingURL smoothStreamingURL;
                String string2 = iHTTPRequest.getHeader("context");
                if (string2 == null) break block65;
                string2 = HTTPStreamerUtils.urlDecode((String)string2);
                if (doDebug) {
                    System.out.println("onManifest: " + string2);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string2, true)) == null) break block65;
                String string3 = smoothStreamingURL.getAppName();
                String string4 = smoothStreamingURL.getAppInstanceName();
                String string5 = smoothStreamingURL.getStreamName();
                String string6 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string6);
                String string7 = HTTPUtils.assembleQueryStr((Map)map);
                String string8 = this.determineDvrId(map);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string3, string4, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Application context not loaded [" + string2 + "]: " + string3 + "/" + string4);
                    break block65;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string9 = this.getStreamDomainStr(iApplicationInstance, string5);
                boolean bl4 = this.isDvr(iApplicationInstance, string8);
                boolean bl5 = this.isLive(iApplicationInstance);
                boolean bl6 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl6, string5);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block65;
                ILiveStreamPacketizer iLiveStreamPacketizer = null;
                SmoothStreamingLivePlaylist smoothStreamingLivePlaylist = null;
                boolean bl7 = false;
                if (bl5) {
                    mediaStreamMap = iApplicationInstance.getStreams();
                    bl7 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    int n2 = n = hTTPStreamerApplicationContextSmoothStreamer != null ? hTTPStreamerApplicationContextSmoothStreamer.getMinPlaylistStartDuration() : 20000;
                    if (bl7) {
                        smoothStreamingLivePlaylist = LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: Playlist cound not be parsed: " + string2);
                            break block65;
                        }
                        bl3 = false;
                        object4 = smoothStreamingLivePlaylist.getBitrates();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            String string10 = object3.next();
                            object2 = smoothStreamingLivePlaylist.get(string10);
                            object = this.resolveStreamName(null, iApplicationInstance, bl6, ((SmoothStreamingLivePlaylistEntry)object2).getStreamName());
                            if (object.resolvedName == null) break;
                            if (bl6) {
                                this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, object.repeaterName);
                            }
                            if ((string = mediaStreamMap.getLiveStreamPacketizer(object.resolvedName, this.liveStreamPacketizer, false)) == null) {
                                if (bl6) {
                                    bl = true;
                                } else {
                                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + object.resolvedName + "]: " + this.liveStreamPacketizer);
                                }
                                bl3 = true;
                                continue;
                            }
                            if (((LiveStreamPacketizerSmoothStreaming)((Object)string)).testPlaylistDuration(n)) continue;
                            bl = true;
                            bl3 = true;
                        }
                        if (bl3) {
                            break block65;
                        }
                    } else if (!bl4) {
                        if (hTTPStreamerStreamNameParts.resolvedName == null) break block65;
                        if (bl6) {
                            this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                        }
                        if ((iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                            if (bl6) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + string2 + "]: " + this.liveStreamPacketizer);
                            }
                            break block65;
                        }
                        if (!((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).testPlaylistDuration(n)) {
                            bl = true;
                            break block65;
                        }
                    }
                }
                mediaStreamMap = null;
                n = 0;
                if (mediaStreamMap == null) {
                    n = 1;
                    mediaStreamMap = this.createSession(iHTTPRequest, iApplicationInstance, null, string9);
                }
                if (n != 0) {
                    mediaStreamMap.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    mediaStreamMap.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                if (mediaStreamMap == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Should not get here [" + string2 + "]: " + string3 + "/" + string4);
                    break block65;
                }
                rtmpSessionInfo.addHTTPSession((IHTTPStreamerSession)mediaStreamMap);
                if (!mediaStreamMap.isValidated()) {
                    mediaStreamMap.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string6, "smoothstreaming", (IHTTPStreamerSession)mediaStreamMap, iHTTPRequest.getRemoteAddr());
                    mediaStreamMap.setSessionType(bl5 ? 1 : 2);
                }
                if (n != 0) {
                    this.notifySessionCreate((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance);
                }
                if (!mediaStreamMap.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block65;
                }
                if (!mediaStreamMap.isValidStreamDomainStr(string9)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block65;
                }
                mediaStreamMap.touch(l);
                if (bl7) {
                    ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).setLivePlaylist(smoothStreamingLivePlaylist);
                }
                if (!(bl3 = mediaStreamMap.isActive())) break block65;
                object4 = mediaStreamMap.getUserQueryStr();
                if (object4 != null) {
                    if (string7.length() > 0) {
                        string7 = string7 + "&";
                    }
                    string7 = string7 + (String)object4;
                }
                object3 = "";
                boolean bl8 = true;
                if (!bl5) {
                    object2 = ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).getIndex((IHTTPStreamerSession)mediaStreamMap, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object2 == null) break block65;
                    object = object2.getStreamNames();
                    mediaStreamMap.addStreamDomainStrs((List)object);
                    object3 = object2.getPlaylistStr();
                } else if (bl5) {
                    if (bl7) {
                        if (smoothStreamingLivePlaylist != null) {
                            Object object5;
                            LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming;
                            ILiveStreamPacketizer iLiveStreamPacketizer2;
                            Object object6;
                            Object object7;
                            object2 = "";
                            boolean bl9 = false;
                            string = "";
                            String string11 = "";
                            String string12 = "";
                            boolean bl10 = false;
                            boolean bl11 = false;
                            boolean bl12 = false;
                            String string13 = "";
                            String string14 = "";
                            String string15 = "";
                            String string16 = "";
                            String string17 = "";
                            MediaStreamMap mediaStreamMap2 = iApplicationInstance.getStreams();
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            boolean bl13 = true;
                            boolean bl14 = ((HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext).isSmoothStreamingUseSMILBitrates();
                            String string18 = null;
                            String string19 = smoothStreamingLivePlaylist.getAudioStreamName();
                            String string20 = null;
                            List<String> list = smoothStreamingLivePlaylist.getBitrates();
                            for (String string21 : list) {
                                object7 = smoothStreamingLivePlaylist.get(string21);
                                object6 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl6, ((SmoothStreamingLivePlaylistEntry)object7).getStreamName());
                                if (((HTTPStreamerStreamNameParts)object6).resolvedName == null) break;
                                iLiveStreamPacketizer2 = mediaStreamMap2.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object6).resolvedName, this.liveStreamPacketizer, false);
                                if (iLiveStreamPacketizer2 == null) continue;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer2;
                                if (string20 == null) {
                                    string20 = ((HTTPStreamerStreamNameParts)object6).resolvedName;
                                }
                                if (((HTTPStreamerStreamNameParts)object6).resolvedName.equals(string19)) {
                                    string18 = ((HTTPStreamerStreamNameParts)object6).resolvedName;
                                }
                                Object object8 = object5 = bl14 ? string21 : liveStreamPacketizerSmoothStreaming.getVideoBitrate() + "";
                                if (!hashMap.containsKey(object5)) {
                                    hashMap.put(string21, (String)object5);
                                    continue;
                                }
                                bl13 = false;
                            }
                            if (bl13) {
                                smoothStreamingLivePlaylist.remapBitrates(hashMap);
                            }
                            if (string18 == null) {
                                string18 = string20;
                            }
                            list = smoothStreamingLivePlaylist.getBitrates();
                            Iterator<String> iterator = list.iterator();
                            int n3 = 0;
                            while (iterator.hasNext()) {
                                object7 = iterator.next();
                                object6 = smoothStreamingLivePlaylist.get((String)object7);
                                iLiveStreamPacketizer2 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl6, ((SmoothStreamingLivePlaylistEntry)object6).getStreamName());
                                if (iLiveStreamPacketizer2.resolvedName == null) break;
                                liveStreamPacketizerSmoothStreaming = mediaStreamMap2.getLiveStreamPacketizer(iLiveStreamPacketizer2.resolvedName, this.liveStreamPacketizer, false);
                                if (liveStreamPacketizerSmoothStreaming == null) continue;
                                object5 = liveStreamPacketizerSmoothStreaming;
                                String string22 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLQualityLevelVideo();
                                string22 = string22.replace("{videobitrate}", (CharSequence)object7);
                                string22 = string22.replace("Index=\"0\"", "Index=\"" + n3 + "\"");
                                ++n3;
                                if (iLiveStreamPacketizer2.resolvedName.equals(string18)) {
                                    bl9 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).isXMLIsVideo();
                                    bl10 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).isXMLIsAudio();
                                    bl11 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).isXMLIsData();
                                    bl12 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).isXMLIsProtection();
                                    String string23 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLQualityLevelAudio();
                                    int n4 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getAudioBitrate();
                                    String string24 = n4 + "";
                                    if (bl14 && smoothStreamingLivePlaylist.getAudioBitrate() != null) {
                                        string24 = smoothStreamingLivePlaylist.getAudioBitrate();
                                    }
                                    string23 = string23.replace("{audiobitrate}", string24);
                                    object2 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLSmoothStreamingMedia();
                                    string = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLStreamIndexVideo();
                                    string11 = string22;
                                    string12 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLSamplesVideo();
                                    string13 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLStreamIndexAudio();
                                    string14 = string23;
                                    string15 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLSamplesAudio();
                                    string16 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLData();
                                    string17 = ((LiveStreamPacketizerSmoothStreaming)((Object)object5)).getXMLProtection();
                                    continue;
                                }
                                string11 = string11 + string22;
                            }
                            object7 = new StringBuffer();
                            ((StringBuffer)object7).append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                            ((StringBuffer)object7).append((String)object2);
                            if (bl10) {
                                ((StringBuffer)object7).append(string13);
                                ((StringBuffer)object7).append(string14);
                                ((StringBuffer)object7).append(string15);
                                ((StringBuffer)object7).append("</StreamIndex>\n");
                            }
                            if (bl9) {
                                ((StringBuffer)object7).append(string);
                                ((StringBuffer)object7).append(string11);
                                ((StringBuffer)object7).append(string12);
                                ((StringBuffer)object7).append("</StreamIndex>\n");
                            }
                            if (bl11) {
                                ((StringBuffer)object7).append(string16);
                            }
                            if (bl12) {
                                ((StringBuffer)object7).append(string17);
                            }
                            ((StringBuffer)object7).append("</SmoothStreamingMedia>\n");
                            object3 = ((StringBuffer)object7).toString();
                        }
                        if (mediaStreamMap != null) {
                            object2 = smoothStreamingLivePlaylist.getStreamNames();
                            mediaStreamMap.addStreamDomainStrs(object2);
                            if (bl6) {
                                mediaStreamMap.lockRepeaterStreams(object2, this.liveStreamPacketizer, this.liveStreamRepeater, iHTTPStreamerApplicationContext.getStreamTypeStr());
                            }
                        }
                    } else if (bl4) {
                        if (map.containsKey("delta") && map.containsKey("time")) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HttpStreamerAdapterSmoothStreamer.onManifest()  Either 'delta' or 'time' param should be specified.");
                        }
                        if (map.containsKey("delta")) {
                            long l2 = this.parseLongQueryParam(map, "delta");
                            object3 = this.dvrPlayerAdapter.getDeltaPlaylist(string2, iApplicationInstance, string8, string5, l2);
                        } else if (map.containsKey("time")) {
                            long l3 = this.parseLongQueryParam(map, "time");
                            object3 = this.dvrPlayerAdapter.getAbsolutePlaylist(string2, iApplicationInstance, string8, string5, l3);
                        } else {
                            object3 = this.dvrPlayerAdapter.getAbsolutePlaylist(string2, iApplicationInstance, string8, string5, 0L);
                        }
                    } else {
                        if (iLiveStreamPacketizer == null) break block65;
                        object3 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getXMLISMC();
                        int n5 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getVideoBitrate();
                        int n6 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getAudioBitrate();
                        object3 = ((String)object3).replace("{videobitrate}", n5 + "");
                        object3 = ((String)object3).replace("{audiobitrate}", n6 + "");
                    }
                }
                mediaStreamMap.touch(l);
                if (bl8) {
                    String string25 = string7.replace("&", "&amp;");
                    object3 = ((String)object3).replace("{query}", string25.length() > 0 ? "?" + string25 : "");
                    object3 = ((String)object3).replace("{sessionid}", mediaStreamMap.getSessionId());
                }
                if (doDebug) {
                    System.out.println((String)object3);
                }
                iHTTPResponse.setHeader("Content-Type", "text/xml");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache,no-store");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                byte[] byArray = ((String)object3).getBytes();
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(byArray);
                bl2 = true;
                mediaStreamMap.touch(l);
                if (byArray != null && mediaStreamMap != null) {
                    mediaStreamMap.getIOPerformanceCounter().incrementMessagesOut((long)(byArray.length + iHTTPResponse.getHeaderSize()), 1L);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onManifest: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onISMVData(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block49: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                SmoothStreamingURL smoothStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block49;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (doDebug) {
                    System.out.println("onISMVData[" + ioSession.hashCode() + "]: " + string);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string, true)) == null) break block49;
                String string2 = smoothStreamingURL.getAppName();
                String string3 = smoothStreamingURL.getAppInstanceName();
                String string4 = smoothStreamingURL.getStreamName();
                String string5 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                String string6 = this.determineDvrId(map);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onISMVData: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block49;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string7 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                boolean bl5 = false;
                boolean bl6 = this.isDvr(iApplicationInstance, string6);
                SmoothStreamerFragmentId smoothStreamerFragmentId = SmoothStreamerFragmentId.parseURL(string);
                if (smoothStreamerFragmentId == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: Error decoding fragment name [" + string + "]");
                    break block49;
                }
                DebugSession debugSession = null;
                DebugRequest debugRequest = null;
                if (this.debugRequests != null) {
                    object5 = this.debugRequests;
                    synchronized (object5) {
                        debugSession = this.debugRequests.get(smoothStreamerFragmentId.getSessionId());
                        if (debugSession == null) {
                            debugSession = new DebugSession();
                            debugSession.sessionId = smoothStreamerFragmentId.getSessionId();
                            this.debugRequests.put(debugSession.sessionId, debugSession);
                        }
                        if ((debugRequest = debugSession.debugRequests.get(smoothStreamerFragmentId.getChunkId() + "")) == null) {
                            debugRequest = new DebugRequest();
                            debugRequest.type = smoothStreamerFragmentId.getFragmentType();
                            debugRequest.requestId = smoothStreamerFragmentId.getStartTimecode() + "";
                            debugSession.debugRequests.put(debugRequest.requestId, debugRequest);
                        }
                    }
                }
                object5 = smoothStreamerFragmentId.getSessionId();
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                boolean bl7 = false;
                if (object5 != null && (iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession((String)object5)) == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, (String)object5, string7);
                    bl7 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block49;
                if (bl7) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl8 = true;
                int n = 0;
                if (iHTTPStreamerSession == null) break block49;
                if (!iHTTPStreamerSession.isValidated()) {
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "smoothstreaming", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                }
                iHTTPStreamerSession.touch(l);
                bl8 = iHTTPStreamerSession.isActive();
                n = iHTTPStreamerSession.getSessionType();
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (!bl8) break block49;
                if (bl7) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block49;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string7)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block49;
                }
                RTPPacketFragmentList rTPPacketFragmentList = null;
                if (!bl3) {
                    object4 = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getIndex(iHTTPStreamerSession, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object4 == null) break block49;
                    rTPPacketFragmentList = object4.getFragment(smoothStreamerFragmentId.getFragmentType(), smoothStreamerFragmentId.getBitrate(), smoothStreamerFragmentId.getChunkId(), smoothStreamerFragmentId.isInfo());
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logVODFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                } else {
                    SmoothStreamingLivePlaylist smoothStreamingLivePlaylist;
                    bl5 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    object4 = iApplicationInstance.getStreams();
                    int n2 = hTTPStreamerApplicationContextSmoothStreamer.getKeyFrameAlignmentTolerance();
                    if (bl5) {
                        LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming;
                        smoothStreamingLivePlaylist = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getLivePlaylist();
                        if (smoothStreamingLivePlaylist == null) break block49;
                        if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            object3 = smoothStreamingLivePlaylist.get(0);
                            object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                            if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block49;
                            liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                            rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getAudioPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo());
                        } else if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            object3 = smoothStreamingLivePlaylist.get(smoothStreamerFragmentId.getBitrate() + "");
                            if (object3 == null) {
                                object3 = smoothStreamingLivePlaylist.get(0);
                            }
                            object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                            if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block49;
                            liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                            rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                            if (rTPPacketFragmentList == null && ((SmoothStreamingLivePlaylistEntry)object3).getIndex() > 0) {
                                object3 = smoothStreamingLivePlaylist.get(0);
                                object2 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, ((SmoothStreamingLivePlaylistEntry)object3).getStreamName());
                                if (((HTTPStreamerStreamNameParts)object2).resolvedName == null || (object = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object2).resolvedName, this.liveStreamPacketizer, false)) == null) break block49;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)((Object)object);
                                rTPPacketFragmentList = liveStreamPacketizerSmoothStreaming.getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                            }
                        }
                    } else if (bl6) {
                        rTPPacketFragmentList = this.getDvrSmoothStreamingFragments((MediaStreamMap)object4, string6, string4, smoothStreamerFragmentId);
                    } else {
                        smoothStreamingLivePlaylist = object4.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                            break block49;
                        }
                        if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo(), n2);
                        } else if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getAudioPacket(smoothStreamerFragmentId.getStartTimecode(), smoothStreamerFragmentId.isInfo());
                        }
                    }
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logLiveFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                }
                if (rTPPacketFragmentList == null) {
                    if (doDebug) {
                        System.out.println("missing[" + string + "]");
                    }
                    bl = true;
                    break block49;
                }
                if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                }
                iHTTPResponse.setHeader("Content-Type", "video/mp4");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                object4 = iHTTPResponse.getOutputStream();
                IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
                if (object4 instanceof IFasterByteArrayWriteReference) {
                    iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)object4;
                }
                int n3 = 0;
                object3 = rTPPacketFragmentList.getFragments();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (RTPPacketFragment)object2.next();
                    if (iFasterByteArrayWriteReference != null) {
                        iFasterByteArrayWriteReference.write(object.getBuffer(), object.getOffset(), object.getLen(), true);
                    } else {
                        ((OutputStream)object4).write(object.getBuffer(), object.getOffset(), object.getLen());
                    }
                    n3 += object.getLen();
                }
                if (iHTTPStreamerSession != null) {
                    object = iHTTPStreamerSession.getStream();
                    if (object != null) {
                        object.getMediaIOPerformance().incrementMessagesOut((long)n3, 1L);
                    }
                    iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n3 + iHTTPResponse.getHeaderSize()), 1L);
                }
                if (doDebug) {
                    System.out.println("sent[" + string + "]: " + n3);
                }
                bl2 = true;
                if (this.debugRequests == null) break block49;
                object = this.debugRequests;
                synchronized (object) {
                    if (debugRequest != null) {
                        debugSession.debugRequests.remove(smoothStreamerFragmentId.getStartTimecode() + "");
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onISMVData: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    protected RTPPacketFragmentList getDvrSmoothStreamingFragments(IDvrStore iDvrStore, String string, int n, long l) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class);
        wMSLogger.info(String.format("%s.getDvrSmoothStreamingFragments: dvr=%s stream=%s t=%d", CLASSNAME, iDvrStore, string, l));
        RTPPacketFragmentList rTPPacketFragmentList = null;
        DvrChunk dvrChunk = null;
        if (iDvrStore != null) {
            List list = null;
            dvrChunk = iDvrStore.getDvrChunkAtTime(string, n, l);
            int n2 = 2;
            if (n2 > 0) {
                list = iDvrStore.getDvrEntriesAtTime(string, n, l, n2 + 1);
                if (list.size() < n2 + 1) {
                    return null;
                }
                List<DvrManifestEntry> list2 = list.subList(1, n2 + 1);
                dvrChunk = this.modifyChunkWithReadAheadInfo(dvrChunk, list2);
            }
        }
        wMSLogger.info("HTTPStreamerAdapterSmoothStreamer.getDvrSmoothStreamingFragments: chunk=" + dvrChunk);
        if (dvrChunk != null) {
            rTPPacketFragmentList = dvrChunk.getFragmentList();
        }
        return rTPPacketFragmentList;
    }

    protected RTPPacketFragmentList getDvrSmoothStreamingFragments(MediaStreamMap mediaStreamMap, String string, String string2, SmoothStreamerFragmentId smoothStreamerFragmentId) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class);
        int n = smoothStreamerFragmentId.getFragmentType();
        if (n == 9 || n == 8) {
            long l = smoothStreamerFragmentId.getStartTimecode() / 10000L;
            wMSLogger.info(String.format("HTTPStreamerAdapterSmoothStreamer.getDvrSmoothStreamingFragments: get DVR for A/V %s.", smoothStreamerFragmentId));
            IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string, false);
            return this.getDvrSmoothStreamingFragments(iDvrStore, string2, n, l);
        }
        wMSLogger.warn("HTTPStreamerAdapterSmoothStreamer.getDvrSmoothStreamingFragments.  Unable to retrieve DVR chunk of type " + smoothStreamerFragmentId.getFragmentType());
        return null;
    }

    private DvrChunk modifyChunkWithReadAheadInfo(DvrChunk dvrChunk, List<DvrManifestEntry> list) {
        RTPPacketFragmentList rTPPacketFragmentList = dvrChunk.getFragmentList();
        List list2 = rTPPacketFragmentList.getFragments();
        RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)list2.get(0);
        byte[] byArray = rTPPacketFragment.getBuffer();
        AtomBytesToTree atomBytesToTree = new AtomBytesToTree();
        IAtom iAtom = atomBytesToTree.bytesToAtoms(byArray);
        IAtom iAtom2 = iAtom.getAtom("moof");
        iAtom2.removeAtom("uuid", DvrChunkCreator.DVR_HEADER_INFO_GUID_BYTES);
        iAtom2.removeAtom("uuid", DvrChunkCreator.CODEC_INFO_GUID_BYTES);
        IAtom iAtom3 = iAtom2.getAtom("traf");
        IAtom iAtom4 = iAtom3.getAtom("uuid", SmoothStreamingFragmentWriter.READ_AHEAD_GUID_BYTES);
        if (iAtom4 != null) {
            byte[] byArray2 = this.createReadAheadData(list);
            iAtom4.setData(byArray2);
            AtomTreeToBytes atomTreeToBytes = new AtomTreeToBytes();
            byte[] byArray3 = atomTreeToBytes.toBytes(iAtom);
            RTPPacketFragment rTPPacketFragment2 = new RTPPacketFragment(byArray3);
            rTPPacketFragmentList.clearFragment();
            rTPPacketFragmentList.addPacketFragment(rTPPacketFragment2);
        }
        return dvrChunk;
    }

    private byte[] createReadAheadData(List<DvrManifestEntry> list) {
        Object object;
        int n;
        int n2 = 0;
        int n3 = list.size();
        byte[] byArray = new byte[29 + n3 * 16];
        SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
        SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia = new SmoothStreamingFragmentWriterMedia();
        smoothStreamingFragmentWriterMedia.readAheadStartTimes = new long[n3];
        smoothStreamingFragmentWriterMedia.readAheadDurations = new long[n3];
        for (n = 0; n < n3; ++n) {
            object = list.get(n);
            long l = object.getStartTimecode();
            long l2 = object.getStopTimecode();
            smoothStreamingFragmentWriterMedia.readAheadStartTimes[n] = 10000L * l;
            smoothStreamingFragmentWriterMedia.readAheadDurations[n] = 10000L * (l2 - l);
        }
        SmoothStreamingFragmentWriter.writeAtomUUIDReadAhead(byArray, n2, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
        n = byArray.length - 8;
        object = new byte[n];
        System.arraycopy(byArray, 8, object, 0, n);
        return object;
    }

    class DebugRequest {
        int type = 0;
        String requestId = null;

        DebugRequest() {
        }
    }

    class DebugSession {
        Map<String, DebugRequest> debugRequests = new HashMap<String, DebugRequest>();
        String sessionId = null;

        DebugSession() {
        }
    }

    class DebugThread
    extends Thread {
        DebugThread() {
        }

        public void run() {
            System.out.println("DebugThread.start");
            while (true) {
                try {
                    while (true) {
                        HTTPStreamerAdapterSmoothStreamer.this.dumpDebugRequests();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    System.out.println("DebugThread: " + exception.toString());
                    continue;
                }
                break;
            }
        }
    }
}

