/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.liverepeater;

import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.httpstreamer.model.HTTPStreamerMediaCasterStreamLock;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterHolder;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterHolderSerialized;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.NullLivePlayer;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothStreamerLiveRepeaterPlayer
extends NullLivePlayer {
    private IMediaStream parent = null;
    private String liveStreamPacketizer = null;
    private String liveStreamRepeater = null;
    private long lastAudioSeq = -1L;
    private long lastVideoSeq = -1L;
    private byte[] workBuffer = null;
    private int chunkSize = 0;
    private int lastPacketizerId = -1;
    private boolean reportStreamMissing = true;
    private HTTPStreamerMediaCasterStreamLock mediaCasterStreamLock = new HTTPStreamerMediaCasterStreamLock();
    private boolean isRepeater = false;
    private IApplicationInstance appInstance = null;
    private boolean startRepeater = true;
    private boolean sendPlayReadyKeyInfo = true;

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        this.parent = iMediaStream;
        this.liveStreamPacketizer = this.parent.getLiveStreamPacketizer();
        this.liveStreamRepeater = this.parent.getLiveStreamRepeater();
        this.appInstance = mediaStreamMap.getAppInstance();
        this.isRepeater = this.appInstance.containsLiveStreamPacketizer(this.liveStreamRepeater);
    }

    public void close() {
        this.mediaCasterStreamLock.unlockRepeaterStreams(this.appInstance);
        super.close();
    }

    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.workBuffer = new byte[n];
        }
    }

    public boolean play(IMediaStream iMediaStream) {
        return true;
    }

    public boolean play() {
        return true;
    }

    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        return n;
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        String string;
        Object object;
        int n = 0;
        if (this.startRepeater) {
            if (this.isRepeater) {
                object = this.parent.getName();
                object = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)this.appInstance, null, (String)object);
                string = "httprepeater-edge";
                this.mediaCasterStreamLock.lockRepeaterStreams((String)object, this.appInstance, this.liveStreamPacketizer, this.liveStreamRepeater, string);
            }
            this.startRepeater = false;
        }
        object = (Client)this.parent.getClient();
        this.chunkSize = object.getSendChunkSize();
        this.checkWorkBuffer(this.chunkSize);
        try {
            string = this.parent.getName();
            ILiveStreamPacketizer iLiveStreamPacketizer = this.parent.getStreams().getLiveStreamPacketizer(string, this.liveStreamPacketizer, false);
            if (iLiveStreamPacketizer == null) {
                if (this.reportStreamMissing) {
                    IApplicationInstance iApplicationInstance = this.parent.getStreams().getAppInstance();
                    WMSLoggerFactory.getLogger(SmoothStreamerLiveRepeaterPlayer.class).warn("SmoothStreamerLiveRepeaterPlayer.play[" + iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string + "]: Live stream packetizer not found: " + this.liveStreamPacketizer);
                    this.reportStreamMissing = false;
                }
            } else if (iLiveStreamPacketizer instanceof LiveStreamPacketizerSmoothStreaming) {
                int n2;
                Object object2;
                Object object3;
                Object object4;
                this.reportStreamMissing = true;
                ArrayList<SmoothStreamingRepeaterHolder> arrayList = new ArrayList<SmoothStreamingRepeaterHolder>();
                int n3 = iLiveStreamPacketizer.getLiveStreamPacketizerId();
                if (this.lastPacketizerId != n3) {
                    this.lastAudioSeq = -1L;
                    this.lastVideoSeq = -1L;
                    object4 = SmoothStreamingRepeaterHolder.createRepeaterMessage(this.lastPacketizerId > 0 ? "switchStream" : "startStream");
                    arrayList.add((SmoothStreamingRepeaterHolder)object4);
                }
                this.lastPacketizerId = n3;
                object4 = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer;
                if (this.sendPlayReadyKeyInfo) {
                    object3 = ((LiveStreamPacketizerSmoothStreaming)((Object)object4)).getPlayReadKeyInfo();
                    if (object3 != null) {
                        object2 = new SmoothStreamingRepeaterHolder();
                        ((SmoothStreamingRepeaterHolder)object2).setRepeaterType(6);
                        ((SmoothStreamingRepeaterHolder)object2).setPlayReadyKeyInfo((PlayReadyKeyInfo)object3);
                        arrayList.add((SmoothStreamingRepeaterHolder)object2);
                    }
                    this.sendPlayReadyKeyInfo = false;
                }
                object3 = new ArrayList();
                object2 = new ArrayList();
                ((LiveStreamPacketizerSmoothStreaming)((Object)object4)).getRepeaterAudioItems((List<SmoothStreamingRepeaterHolder>)object3, this.lastAudioSeq);
                ((LiveStreamPacketizerSmoothStreaming)((Object)object4)).getRepeaterVideoItems((List<SmoothStreamingRepeaterHolder>)object2, this.lastVideoSeq);
                if (object3.size() > 0) {
                    this.lastAudioSeq = ((SmoothStreamingRepeaterHolder)object3.get(object3.size() - 1)).getSequence() + 1L;
                }
                if (object2.size() > 0) {
                    this.lastVideoSeq = ((SmoothStreamingRepeaterHolder)object2.get(object2.size() - 1)).getSequence() + 1L;
                }
                if ((n2 = object3.size() + object2.size()) > 0) {
                    n += this.sendItems(arrayList, (List<SmoothStreamingRepeaterHolder>)object3, (List<SmoothStreamingRepeaterHolder>)object2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamerLiveRepeaterPlayer.class).error("SmoothStreamerLiveRepeaterPlayer.play: " + exception.toString());
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sendItems(List<SmoothStreamingRepeaterHolder> list, List<SmoothStreamingRepeaterHolder> list2, List<SmoothStreamingRepeaterHolder> list3, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        try {
            for (SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder : list) {
                SmoothStreamingRepeaterHolderSerialized smoothStreamingRepeaterHolderSerialized = smoothStreamingRepeaterHolder.serialize();
                this.packetOutput(outputStream, smoothStreamingRepeaterHolderSerialized.getHeader(), smoothStreamingRepeaterHolderSerialized.getHoffset(), smoothStreamingRepeaterHolderSerialized.getHlen(), smoothStreamingRepeaterHolderSerialized.getData(), smoothStreamingRepeaterHolderSerialized.getDoffset(), smoothStreamingRepeaterHolderSerialized.getDlen(), smoothStreamingRepeaterHolderSerialized.getTimecode(), smoothStreamingRepeaterHolderSerialized.getType(), aMFObj2, this.workBuffer, this.chunkSize);
            }
            int n2 = list2.size();
            int n3 = list3.size();
            do {
                long l;
                SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = null;
                long l2 = n2 > 0 ? list2.get(0).getTimecode() : Long.MAX_VALUE;
                long l3 = l = n3 > 0 ? list3.get(0).getTimecode() : Long.MAX_VALUE;
                if (l2 < l) {
                    smoothStreamingRepeaterHolder = list2.remove(0);
                    --n2;
                } else {
                    smoothStreamingRepeaterHolder = list3.remove(0);
                    --n3;
                }
                if (smoothStreamingRepeaterHolder == null) return n;
                SmoothStreamingRepeaterHolderSerialized smoothStreamingRepeaterHolderSerialized = smoothStreamingRepeaterHolder.serialize();
                this.packetOutput(outputStream, smoothStreamingRepeaterHolderSerialized.getHeader(), smoothStreamingRepeaterHolderSerialized.getHoffset(), smoothStreamingRepeaterHolderSerialized.getHlen(), smoothStreamingRepeaterHolderSerialized.getData(), smoothStreamingRepeaterHolderSerialized.getDoffset(), smoothStreamingRepeaterHolderSerialized.getDlen(), smoothStreamingRepeaterHolderSerialized.getTimecode(), smoothStreamingRepeaterHolderSerialized.getType(), aMFObj2, this.workBuffer, this.chunkSize);
            } while (n2 > 0 || n3 > 0);
            return n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamerLiveRepeaterPlayer.class).error("SmoothStreamerLiveRepeaterPlayer.play: " + exception.toString());
        }
        return n;
    }

    public int packetOutput(OutputStream outputStream, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, long l, int n5, AMFObj aMFObj, byte[] byArray3, int n6) {
        int n7 = 0;
        try {
            int n8;
            int n9 = aMFObj.getId();
            int n10 = 1;
            int n11 = n2 + n4;
            boolean bl = aMFObj.isNew();
            IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
            if (outputStream instanceof IFasterByteArrayWriteReference) {
                iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)outputStream;
            }
            if (!bl) {
                bl = l < aMFObj.getAbsTimecode();
            }
            long l2 = bl ? l : l - aMFObj.getAbsTimecode();
            aMFObj.setAbsTimecodeLong(l);
            boolean bl2 = bl;
            aMFObj.setNew(false);
            int n12 = 1;
            byArray3[0] = (byte)(0xFF & n9);
            if (bl2 || aMFObj.getSrc() != n10) {
                byArray3[8] = (byte)(0xFF & n10);
                byArray3[9] = (byte)(0xFF & n10 >> 8);
                byArray3[10] = (byte)(0xFF & n10 >> 16);
                byArray3[11] = (byte)(0xFF & n10 >> 24);
                aMFObj.setSrc(n10);
                n12 += 4;
                bl2 = true;
            }
            if (bl2 || aMFObj.getSize() != n11) {
                byArray3[4] = (byte)(0xFF & n11 >> 16);
                byArray3[5] = (byte)(0xFF & n11 >> 8);
                byArray3[6] = (byte)(0xFF & n11);
                byArray3[7] = (byte)n5;
                aMFObj.setSize(n11);
                aMFObj.setType(n5);
                n12 += 4;
                bl2 = true;
            }
            boolean bl3 = false;
            if (bl2 || aMFObj.getTimecode() != l2 || aMFObj.isLastSentAbsTimecode()) {
                long l3 = l2 & 0xFFFFFFL;
                if (l3 == 0xFFFFFFL) {
                    l3 = 0L;
                }
                byArray3[1] = (byte)(0xFFL & l3 >> 16);
                byArray3[2] = (byte)(0xFFL & l3 >> 8);
                byArray3[3] = (byte)(0xFFL & l3);
                aMFObj.setTimecode(bl ? 0L : l2);
                n12 += 3;
                bl2 = true;
            }
            aMFObj.setLastSentAbsTimecode(bl);
            if (n9 >= 64) {
                int n13 = n9 - 64;
                n8 = n13 > 255 ? 3 : 2;
                byte[] byArray4 = new byte[n8];
                switch (n12) {
                    case 12: {
                        byArray4[0] = (byte)(0 + (n8 - 2));
                        break;
                    }
                    case 8: {
                        byArray4[0] = (byte)(64 + (n8 - 2));
                        break;
                    }
                    case 4: {
                        byArray4[0] = (byte)(128 + (n8 - 2));
                        break;
                    }
                    case 1: {
                        byArray4[0] = (byte)(192 + (n8 - 2));
                    }
                }
                byArray4[1] = (byte)(0xFF & n13);
                if (n8 == 3) {
                    byArray4[2] = (byte)(0xFF & n13 >> 8);
                }
                if (iFasterByteArrayWriteReference != null) {
                    iFasterByteArrayWriteReference.write(byArray4, 0, n8, true);
                    byte[] byArray5 = new byte[n12 - 1];
                    System.arraycopy(byArray3, 1, byArray5, 0, n12 - 1);
                    iFasterByteArrayWriteReference.write(byArray5, 0, byArray5.length, true);
                } else {
                    outputStream.write(byArray4, 0, n8);
                    outputStream.write(byArray3, 1, n12 - 1);
                }
                n7 += n12 + n8 - 1;
            } else {
                switch (n12) {
                    case 12: {
                        break;
                    }
                    case 8: {
                        byArray3[0] = (byte)(byArray3[0] | 0x40);
                        break;
                    }
                    case 4: {
                        byArray3[0] = (byte)(byArray3[0] | 0x80);
                        break;
                    }
                    case 1: {
                        byArray3[0] = (byte)(byArray3[0] | 0xC0);
                    }
                }
                if (iFasterByteArrayWriteReference != null) {
                    byte[] byArray6 = new byte[n12];
                    System.arraycopy(byArray3, 0, byArray6, 0, n12);
                    iFasterByteArrayWriteReference.write(byArray6, 0, byArray6.length, true);
                } else {
                    outputStream.write(byArray3, 0, n12);
                }
                n7 += n12;
            }
            if (bl3) {
                byArray3[0] = (byte)(0xFFL & l2 >> 24);
                byArray3[1] = (byte)(0xFFL & l2 >> 16);
                byArray3[2] = (byte)(0xFFL & l2 >> 8);
                byArray3[3] = (byte)(0xFFL & l2);
                if (iFasterByteArrayWriteReference != null) {
                    byte[] byArray7 = new byte[4];
                    System.arraycopy(byArray3, 0, byArray7, 0, 4);
                    iFasterByteArrayWriteReference.write(byArray7, 0, byArray7.length, true);
                } else {
                    outputStream.write(byArray3, 0, 4);
                }
                n7 = 4;
            }
            if (n11 > 0) {
                int n14 = n2 + n4;
                n8 = 0;
                int n15 = 0;
                int n16 = 0;
                do {
                    int n17;
                    if (n8 + n15 > 0) {
                        if (n9 >= 64) {
                            n17 = n9 - 64;
                            int n18 = n17 > 255 ? 3 : 2;
                            byArray3[0] = (byte)(192 + (n18 - 2));
                            byArray3[1] = (byte)(0xFF & n17);
                            if (n18 == 3) {
                                byArray3[2] = (byte)(0xFF & n17 >> 8);
                            }
                            if (iFasterByteArrayWriteReference != null) {
                                byte[] byArray8 = new byte[n18];
                                System.arraycopy(byArray3, 0, byArray8, 0, n18);
                                iFasterByteArrayWriteReference.write(byArray8, 0, byArray8.length, true);
                            } else {
                                outputStream.write(byArray3, 0, n18);
                            }
                            n7 += n18;
                        } else {
                            byArray3[0] = (byte)(0xFF & n9 | 0xC0);
                            if (iFasterByteArrayWriteReference != null) {
                                byte[] byArray9 = new byte[1];
                                System.arraycopy(byArray3, 0, byArray9, 0, 1);
                                iFasterByteArrayWriteReference.write(byArray9, 0, byArray9.length, true);
                            } else {
                                outputStream.write(byArray3, 0, 1);
                            }
                            ++n7;
                        }
                        if (bl3) {
                            byArray3[0] = (byte)(0xFFL & l2 >> 24);
                            byArray3[1] = (byte)(0xFFL & l2 >> 16);
                            byArray3[2] = (byte)(0xFFL & l2 >> 8);
                            byArray3[3] = (byte)(0xFFL & l2);
                            if (iFasterByteArrayWriteReference != null) {
                                byte[] byArray10 = new byte[4];
                                System.arraycopy(byArray3, 0, byArray10, 0, 4);
                                iFasterByteArrayWriteReference.write(byArray10, 0, byArray10.length, true);
                            } else {
                                outputStream.write(byArray3, 0, 4);
                            }
                            n7 = 4;
                        }
                    }
                    if ((n16 = n6) > n14 - (n8 + n15)) {
                        n16 = n14 - (n8 + n15);
                    }
                    if (n16 > 0 && n8 < n2) {
                        n17 = n16;
                        if (n17 > n2 - n8) {
                            n17 = n2 - n8;
                        }
                        if (iFasterByteArrayWriteReference != null) {
                            iFasterByteArrayWriteReference.write(byArray, n + n8, n17, true);
                        } else {
                            outputStream.write(byArray, n + n8, n17);
                        }
                        n8 += n17;
                        n7 += n17;
                        n16 -= n17;
                    }
                    if (n16 <= 0 || n15 >= n4) continue;
                    n17 = n16;
                    if (n17 > n4 - n15) {
                        n17 = n4 - n15;
                    }
                    if (iFasterByteArrayWriteReference != null) {
                        iFasterByteArrayWriteReference.write(byArray2, n3 + n15, n17, true);
                    } else {
                        outputStream.write(byArray2, n3 + n15, n17);
                    }
                    n15 += n17;
                    n7 += n17;
                    n16 -= n17;
                } while (n8 + n15 < n14);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamerLiveRepeaterPlayer.class).error("SmoothStreamerLiveRepeaterPlayer.packetOutput: " + exception.toString());
            exception.printStackTrace();
        }
        return n7;
    }
}

