/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothStreamingFragments {
    private SortedMap<Long, SmoothStreamingFragment> fragments = new TreeMap<Long, SmoothStreamingFragment>();
    private List<FragmentOrderHolder> fragmentOrder = new ArrayList<FragmentOrderHolder>();
    private long fragmentDuration = 0L;
    private int maxFragmentCount = 0;
    private Object lock = new Object();
    private int smoothBufferTargetDuration = 30000;
    private int smoothManifestTargetDuration = 20000;
    private int smoothBufferMinFragmentCount = 3;
    private int smoothManifestMinFragmentCount = 3;
    private int contentType = 0;
    private String contextStr = "";
    private long firstTrimTime = -1L;

    public SmoothStreamingFragments(int n) {
        this.contentType = n;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.fragments.clear();
            this.fragmentOrder.clear();
            this.fragmentDuration = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long l = 0L;
        Object object = this.lock;
        synchronized (object) {
            l = this.fragmentDuration;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothStreamingMediaInfoAudio getMediaInfoAudio() {
        SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.fragments.size() > 0) {
                smoothStreamingMediaInfoAudio = ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getMediaInfoAudio();
            }
        }
        return smoothStreamingMediaInfoAudio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothStreamingMediaInfoVideo getMediaInfoVideo() {
        SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.fragments.size() > 0) {
                smoothStreamingMediaInfoVideo = ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getMediaInfoVideo();
            }
        }
        return smoothStreamingMediaInfoVideo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStopTimecode() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                l = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStopTimecode();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStartTimecode() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                l = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStartTimecode();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getStartStopTimecodes(int n) {
        long[] lArray = null;
        Object object = this.lock;
        synchronized (object) {
            int n2 = this.fragments.size();
            int n3 = n2 - n;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 > 0) {
                SmoothStreamingFragment[] smoothStreamingFragmentArray = this.fragments.values().toArray(new SmoothStreamingFragment[0]);
                lArray = new long[]{((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getStartTimecode(), ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStopTimecode(), lArray[1] - smoothStreamingFragmentArray[n3].getStartTimecode()};
            }
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(long l) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragmentOrder.size();
            if (n > this.smoothBufferMinFragmentCount) {
                int n2 = n - this.smoothBufferMinFragmentCount;
                for (int i = 0; i < n2; ++i) {
                    FragmentOrderHolder fragmentOrderHolder = this.fragmentOrder.get(0);
                    if (this.fragmentDuration - fragmentOrderHolder.fragment.getDuration() <= (long)(this.smoothBufferTargetDuration * 10000)) break;
                    this.fragmentDuration -= fragmentOrderHolder.fragment.getDuration();
                    this.fragmentOrder.remove(0);
                    this.fragments.remove(fragmentOrderHolder.timeObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFragment(long l, SmoothStreamingFragment smoothStreamingFragment) {
        Object object = this.lock;
        synchronized (object) {
            Long l2 = new Long(l);
            this.fragments.put(l2, smoothStreamingFragment);
            this.fragmentOrder.add(new FragmentOrderHolder(l2, smoothStreamingFragment));
            this.fragmentDuration += smoothStreamingFragment.getDuration();
        }
    }

    private void logMaxFragmentCount() {
        int n = this.fragments.size();
        if (n > this.maxFragmentCount) {
            this.maxFragmentCount = n;
            long l = this.fragments.firstKey();
            long l2 = this.fragments.lastKey();
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("SmoothStreamingFragments.logMaxFragmentCount[" + this.contextStr + ":" + this.contentType + "]: count:" + n + " range:" + l + "-" + l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.fragments.size();
        }
    }

    public RTPPacketFragmentList getFragmentBytes(long l, boolean bl) {
        return this.getFragmentBytes(l, bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPPacketFragmentList getFragmentBytes(long l, boolean bl, int n) {
        RTPPacketFragment rTPPacketFragment;
        Object object;
        Object object2 = null;
        SmoothStreamingFragment smoothStreamingFragment = null;
        Object object3 = this.lock;
        synchronized (object3) {
            object = new Long(l);
            smoothStreamingFragment = (SmoothStreamingFragment)this.fragments.get(object);
            if (smoothStreamingFragment == null && n > 0) {
                rTPPacketFragment = this.fragments.headMap((Long)object);
                SortedMap<Long, SmoothStreamingFragment> sortedMap = this.fragments.tailMap((Long)object);
                if (rTPPacketFragment.size() > 0 || sortedMap.size() > 0) {
                    long l2;
                    Long l3 = null;
                    if (rTPPacketFragment.size() <= 0) {
                        l3 = sortedMap.firstKey();
                    } else if (sortedMap.size() <= 0) {
                        l3 = rTPPacketFragment.lastKey();
                    } else {
                        long l4;
                        Long l5 = sortedMap.firstKey();
                        Long l6 = (Long)rTPPacketFragment.lastKey();
                        long l7 = Math.abs(l - l5);
                        l3 = l7 < (l4 = Math.abs(l - l6)) ? l5 : l6;
                    }
                    if (l3 != null && (l2 = Math.abs(l - l3) / 10000L) <= (long)n) {
                        smoothStreamingFragment = (SmoothStreamingFragment)this.fragments.get(l3);
                    }
                }
            }
        }
        if (smoothStreamingFragment != null) {
            object2 = smoothStreamingFragment.getFragmentList();
            if (bl) {
                object3 = new RTPPacketFragmentList();
                object = object2.getFragments();
                if (object.size() > 0 && (rTPPacketFragment = (RTPPacketFragment)object.get(0)).getLen() > 8) {
                    object3.addPacketFragment(new RTPPacketFragment(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), rTPPacketFragment.getLen() - 8));
                }
                object2 = object3;
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<long[]> getTimeInfo(long l, long l2, int n) {
        Object object;
        int n2;
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object2 = this.lock;
        synchronized (object2) {
            arrayList2.addAll(this.fragments.values());
        }
        if (l >= 0L) {
            for (n2 = arrayList2.size(); n2 > 0 && n2 > n; --n2) {
                object = (SmoothStreamingFragment)arrayList2.remove(0);
                if (((SmoothStreamingFragment)object).getStopTimecode() <= l) continue;
                arrayList2.add(0, object);
                ++n2;
                break;
            }
        }
        if (l2 >= 0L) {
            while (n2 > 0 && n2 > n) {
                object = (SmoothStreamingFragment)arrayList2.remove(n2 - 1);
                --n2;
                if (((SmoothStreamingFragment)object).getStartTimecode() >= l2) continue;
                arrayList2.add(object);
                ++n2;
                break;
            }
        }
        for (SmoothStreamingFragment smoothStreamingFragment : arrayList2) {
            long[] lArray = new long[]{smoothStreamingFragment.getStartTimecode(), smoothStreamingFragment.getStopTimecode()};
            arrayList.add(lArray);
        }
        return arrayList;
    }

    public int getSmoothBufferTargetDuration() {
        return this.smoothBufferTargetDuration;
    }

    public void setSmoothBufferTargetDuration(int n) {
        this.smoothBufferTargetDuration = n;
    }

    public int getSmoothBufferMinFragmentCount() {
        return this.smoothBufferMinFragmentCount;
    }

    public void setSmoothBufferMinFragmentCount(int n) {
        this.smoothBufferMinFragmentCount = n;
    }

    public int getSmoothManifestTargetDuration() {
        return this.smoothManifestTargetDuration;
    }

    public void setSmoothManifestTargetDuration(int n) {
        this.smoothManifestTargetDuration = n;
    }

    public int getSmoothManifestMinFragmentCount() {
        return this.smoothManifestMinFragmentCount;
    }

    public void setSmoothManifestMinFragmentCount(int n) {
        this.smoothManifestMinFragmentCount = n;
    }

    public String getContextStr() {
        return this.contextStr;
    }

    public void setContextStr(String string) {
        this.contextStr = string;
    }

    class FragmentOrderHolder {
        Long timeObj = null;
        SmoothStreamingFragment fragment = null;

        public FragmentOrderHolder(Long l, SmoothStreamingFragment smoothStreamingFragment) {
            this.timeObj = l;
            this.fragment = smoothStreamingFragment;
        }
    }
}

