/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.dvr;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkToAMFPacketParser;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPlayerAdapterBase;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJosePacketHolder;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseTSHolder;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseRandomAccessBuffer;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseUtilities;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPlayerAdapterSanJose
extends DvrPlayerAdapterBase {
    private static final Object CLASSNAME = "DvrPlayerAdapterSanJose";
    private static int bootstrapVersion = 0;

    public String getAbsolutePlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        MediaStreamMap mediaStreamMap;
        IDvrStore iDvrStore;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterSanJose.class);
        wMSLogger.info(String.format("%s.getAbsolutePlaylist() appInst=%s dvr=%s streamName=%s t=%d", CLASSNAME, iApplicationInstance.getName(), string2, string3, l));
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((iDvrStore = (mediaStreamMap = iApplicationInstance.getStreams()).getDvrStore(string2, false)) == null) {
            wMSLogger.warn(String.format("%s.getAbsolutePlaylist() dvr Store '%s' not found.  Returning empty playlist.", CLASSNAME, string2));
            return null;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string3, false);
        if (iDvrStreamStore == null) {
            wMSLogger.warn(String.format("%s.getAbsolutePlaylist() dvr stream Store '%s/%s' not found.  Returning empty playlist.", CLASSNAME, string2, string3));
            return null;
        }
        long l2 = iDvrStreamStore.calculateClosestTime(9, l * 1000L);
        String string4 = null;
        string4 = string.endsWith(".f4m") ? this.getPlaylistF4M(string3, string2, iDvrStreamStore, l2) : new String(this.getPlaylistAbst(string3, string2, iDvrStreamStore, l2));
        return string4;
    }

    private void addToChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJosePacketHolder sanJosePacketHolder) {
        SanJoseTSHolder sanJoseTSHolder = null;
        if (sanJosePacketHolder.getType() == 8) {
            byte[] byArray;
            if (!sanJosePacketHolder.isCodecConfig() && (byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder)) != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                this.encryptAndAddToTS(liveStreamPacketizerSanJoseChunk, sanJoseTSHolder);
            }
        } else if (sanJosePacketHolder.getType() == 9) {
            byte[] byArray;
            if (!sanJosePacketHolder.isCodecConfig() && (byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder)) != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                if (sanJosePacketHolder.getType() == 9) {
                    sanJoseTSHolder.setKey(sanJosePacketHolder.isKey());
                }
                this.encryptAndAddToTS(liveStreamPacketizerSanJoseChunk, sanJoseTSHolder);
            }
        } else {
            byte[] byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder);
            if (byArray != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                this.encryptAndAddToTS(liveStreamPacketizerSanJoseChunk, sanJoseTSHolder);
            }
        }
    }

    private void encryptAndAddToTS(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseTSHolder sanJoseTSHolder) {
        if (sanJoseTSHolder != null) {
            this.addToChunkTS(liveStreamPacketizerSanJoseChunk, sanJoseTSHolder);
        }
    }

    private void addToChunkTS(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseTSHolder sanJoseTSHolder) {
        if (liveStreamPacketizerSanJoseChunk != null) {
            byte[] byArray = sanJoseTSHolder.getBlock();
            switch (sanJoseTSHolder.getType()) {
                case 8: {
                    liveStreamPacketizerSanJoseChunk.incAudioCount();
                    break;
                }
                case 9: {
                    liveStreamPacketizerSanJoseChunk.incVideoCount();
                    if (!sanJoseTSHolder.isKey()) break;
                    liveStreamPacketizerSanJoseChunk.incVideoKeyCount();
                }
            }
            liveStreamPacketizerSanJoseChunk.addBlock(byArray, sanJoseTSHolder.getOffset(), sanJoseTSHolder.getLen());
            liveStreamPacketizerSanJoseChunk.incDataSize(sanJoseTSHolder.getDataLen());
        }
    }

    private byte[] getPlaylistAbst(String string, String string2, IDvrStreamStore iDvrStreamStore, long l) {
        List list = iDvrStreamStore.getManifest().getDvrEntriesAtTime(9, l);
        return this.getPlaylistAbst(list, string);
    }

    public byte[] getPlaylistAbst(List<DvrManifestEntry> list, String string) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        ABSTData aBSTData = null;
        SanJoseRandomAccessBuffer sanJoseRandomAccessBuffer = null;
        int n2 = 0;
        long l = -1L;
        long l2 = -1L;
        try {
            if (n > 0) {
                int n3 = 1;
                String string2 = string;
                String string3 = "low";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                int n4 = 0;
                if (n4 < 0) {
                    n4 = 0;
                }
                DvrManifestEntry dvrManifestEntry = list.get(0);
                int n5 = n - n4;
                int n6 = dvrManifestEntry.getIndex();
                int n7 = n5;
                n2 += 8;
                n2 += 4;
                n2 += 4;
                ++n2;
                n2 += 4;
                n2 += 8;
                n2 += 8;
                n2 += SanJoseUtilities.getABSTStringLength(string2);
                ++n2;
                ++n2;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string3);
                n2 += SanJoseUtilities.getABSTStringLength(string4);
                n2 += SanJoseUtilities.getABSTStringLength(string5);
                ++n2;
                n2 += 8;
                n2 += 4;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string6);
                n2 += 4;
                n2 += n3 * 8;
                ++n2;
                n2 += 8;
                n2 += 4;
                n2 += 4;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string7);
                n2 += 4;
                sanJoseRandomAccessBuffer = new SanJoseRandomAccessBuffer(n2 += n7 * 16);
                byte[] byArray = new byte[4];
                byte[] byArray2 = new byte[8];
                long l3 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("abst".getBytes());
                int n8 = 1;
                BufferUtils.longToByteArray((long)n8, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n9 = 0;
                BufferUtils.longToByteArray((long)n9, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                BufferUtils.intToByteArray((int)bootstrapVersion++, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                int n10 = 0;
                boolean bl = true;
                boolean bl2 = true;
                int n11 = (n10 << 6) + (bl ? 32 : 0) + (bl2 ? 1 : 0);
                BufferUtils.intToByteArray((int)n11, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n12 = 1000;
                BufferUtils.longToByteArray((long)n12, (byte[])byArray2, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray2, 0, 4);
                long l4 = 0L;
                BufferUtils.longToByteArray((long)l4, (byte[])byArray2, (int)0, (int)8);
                sanJoseRandomAccessBuffer.write(byArray2);
                long l5 = 0L;
                BufferUtils.longToByteArray((long)l5, (byte[])byArray2, (int)0, (int)8);
                sanJoseRandomAccessBuffer.write(byArray2);
                sanJoseRandomAccessBuffer.write(string2.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string3.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(string4.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(string5.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                long l6 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("asrt".getBytes());
                int n13 = 1;
                BufferUtils.longToByteArray((long)n13, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n14 = 0;
                BufferUtils.longToByteArray((long)n14, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string6.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                BufferUtils.longToByteArray((long)n3, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                int n15 = 1;
                for (int i = 0; i < n3; ++i) {
                    BufferUtils.longToByteArray((long)n15, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    BufferUtils.longToByteArray((long)-1L, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    ++n15;
                }
                sanJoseRandomAccessBuffer.writeAtomSize(l6);
                sanJoseRandomAccessBuffer.write(1);
                long l7 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("afrt".getBytes());
                int n16 = 1;
                BufferUtils.longToByteArray((long)n16, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n17 = 0;
                BufferUtils.longToByteArray((long)n17, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                int n18 = 1000;
                BufferUtils.longToByteArray((long)n18, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string7.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                BufferUtils.longToByteArray((long)n7, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                for (int i = n4; i < n; ++i) {
                    int n19 = n6 + i;
                    if (l < 0L) {
                        l = n19;
                    }
                    l2 = n19;
                    DvrManifestEntry dvrManifestEntry2 = list.get(i);
                    long l8 = dvrManifestEntry2.getStopTimecode();
                    long l9 = dvrManifestEntry2.getDuration();
                    long l10 = l8;
                    BufferUtils.longToByteArray((long)n19, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    BufferUtils.longToByteArray((long)l10, (byte[])byArray2, (int)0, (int)8);
                    sanJoseRandomAccessBuffer.write(byArray2);
                    BufferUtils.longToByteArray((long)l9, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    System.out.printf("-getPlaylistAbst write %d) fragmentId=%d durationAccrued=%d duration=%d\n", i, n19, l10, l9);
                    l10 += l9;
                    ++n19;
                }
                sanJoseRandomAccessBuffer.writeAtomSize(l7);
                sanJoseRandomAccessBuffer.writeAtomSize(l3);
                sanJoseRandomAccessBuffer.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.getPlaylistAbst: " + exception.toString());
            exception.printStackTrace();
        }
        if (sanJoseRandomAccessBuffer != null) {
            aBSTData = new ABSTData();
            aBSTData.buffer = sanJoseRandomAccessBuffer.toArray();
            aBSTData.rangeStart = l;
            aBSTData.rangeStop = l2;
        }
        return sanJoseRandomAccessBuffer.toArray();
    }

    public String getDeltaPlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string3, false);
        long l2 = iDvrStreamStore.getTimeController().getCurrentTime();
        long l3 = l2 + l * 1000L;
        if (l3 < 0L) {
            l3 = 0L;
        }
        long l4 = iDvrStreamStore.calculateClosestTime(9, l3 * 1000L);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterSanJose.class);
        wMSLogger.info(String.format("%s.getDeltaPlaylist() dvrTime=%d delta=%d t=%d", CLASSNAME, l2, l, l4));
        return this.getAbsolutePlaylist(string, iApplicationInstance, string2, string3, l4);
    }

    public Object convertDvrChunks(DvrManifestEntry dvrManifestEntry, DvrChunk dvrChunk, DvrManifestEntry dvrManifestEntry2, DvrChunk dvrChunk2) {
        SanJosePacketHolder sanJosePacketHolder;
        AMFPacket aMFPacket;
        byte[] byArray;
        byte[] byArray2;
        MediaCodecInfoVideo mediaCodecInfoVideo;
        SanJosePacketHolder sanJosePacketHolder2;
        if (dvrManifestEntry == null || dvrChunk == null || dvrManifestEntry2 == null || dvrChunk2 == null) {
            return null;
        }
        int n = 1;
        long l = dvrManifestEntry.getStartTimecode();
        LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk = new LiveStreamPacketizerSanJoseChunk(dvrManifestEntry.getIndex());
        liveStreamPacketizerSanJoseChunk.setStartTimecode(l);
        liveStreamPacketizerSanJoseChunk.setCacheable(false);
        liveStreamPacketizerSanJoseChunk.setEncUrl(null);
        liveStreamPacketizerSanJoseChunk.setEncRepeaterBytes(null);
        liveStreamPacketizerSanJoseChunk.setStreamMode(n);
        liveStreamPacketizerSanJoseChunk.setDuration(dvrChunk.getStopTimecode() - l);
        liveStreamPacketizerSanJoseChunk.setCodecInfoAudio((MediaCodecInfoAudio)dvrChunk2.getMediaInfoAudio());
        liveStreamPacketizerSanJoseChunk.setCodecInfoVideo((MediaCodecInfoVideo)dvrChunk.getMediaInfoVideo());
        byte[] byArray3 = new byte[8];
        System.arraycopy("mdat".getBytes(), 0, byArray3, 4, 4);
        SanJoseTSHolder sanJoseTSHolder = new SanJoseTSHolder(18, -1, byArray3, 0, byArray3.length, l);
        this.encryptAndAddToTS(liveStreamPacketizerSanJoseChunk, sanJoseTSHolder);
        DvrChunkToAMFPacketParser dvrChunkToAMFPacketParser = new DvrChunkToAMFPacketParser();
        List list = dvrChunkToAMFPacketParser.createAMFPacketsFromAVChunk(dvrChunk);
        boolean bl = true;
        for (AMFPacket aMFPacket2 : list) {
            sanJosePacketHolder2 = this.packetToHolder(aMFPacket2);
            if (!bl) {
                this.addToChunk(liveStreamPacketizerSanJoseChunk, sanJosePacketHolder2);
                continue;
            }
            bl = false;
            if (sanJosePacketHolder2.getCodec() != 7 || (mediaCodecInfoVideo = (MediaCodecInfoVideo)sanJosePacketHolder2.getCodecInfo()) == null || (byArray2 = mediaCodecInfoVideo.getCodecConfig()) == null) continue;
            byArray = new byte[byArray2.length + 5];
            byArray[0] = 23;
            byArray[1] = 0;
            System.arraycopy(byArray2, 0, byArray, 5, byArray2.length);
            aMFPacket = new AMFPacket(9, 0, byArray.length);
            aMFPacket.setAbsTimecode(l);
            aMFPacket.addData(byArray, 0, byArray.length);
            sanJosePacketHolder = new SanJosePacketHolder(aMFPacket, 9, 7, false, l);
            this.addToChunk(liveStreamPacketizerSanJoseChunk, sanJosePacketHolder);
        }
        list = dvrChunkToAMFPacketParser.createAMFPacketsFromAVChunk(dvrChunk2);
        bl = true;
        for (AMFPacket aMFPacket2 : list) {
            sanJosePacketHolder2 = this.packetToHolder(aMFPacket2);
            if (!bl) {
                this.addToChunk(liveStreamPacketizerSanJoseChunk, sanJosePacketHolder2);
                continue;
            }
            bl = false;
            if (sanJosePacketHolder2.getCodec() != 10 || (mediaCodecInfoVideo = (MediaCodecInfoAudio)sanJosePacketHolder2.getCodecInfo()) == null || (byArray2 = mediaCodecInfoVideo.getCodecConfig()) == null) continue;
            byArray = new byte[byArray2.length + 2];
            byArray[0] = -81;
            byArray[1] = 0;
            System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
            aMFPacket = new AMFPacket(8, 0, byArray.length);
            aMFPacket.setAbsTimecode(l);
            aMFPacket.addData(byArray, 0, byArray.length);
            sanJosePacketHolder = new SanJosePacketHolder(aMFPacket, 8, 10, false, l);
            this.addToChunk(liveStreamPacketizerSanJoseChunk, sanJosePacketHolder);
        }
        LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = liveStreamPacketizerSanJoseChunk.getBlockList().get(0);
        long l2 = liveStreamPacketizerSanJoseChunk.getSize();
        BufferUtils.longToByteArray((long)l2, (byte[])liveStreamingSanJoseBlock.getBuffer(), (int)liveStreamingSanJoseBlock.getOffset(), (int)4);
        return liveStreamPacketizerSanJoseChunk;
    }

    private SanJosePacketHolder packetToHolder(AMFPacket aMFPacket) {
        long l = aMFPacket.getAbsTimecode();
        boolean bl = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket) || FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket);
        boolean bl2 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
        int n = aMFPacket.getType();
        int n2 = 0;
        if (n == 8) {
            n2 = FLVUtils.getAudioCodec((AMFPacket)aMFPacket);
        } else if (n == 9) {
            n2 = FLVUtils.getVideoCodec((AMFPacket)aMFPacket);
        }
        SanJosePacketHolder sanJosePacketHolder = new SanJosePacketHolder(aMFPacket, n, n2, bl, l);
        sanJosePacketHolder.setKey(bl2);
        if (bl) {
            if (n == 9) {
                H264CodecConfigInfo h264CodecConfigInfo;
                H264CodecConfigInfo h264CodecConfigInfo2 = h264CodecConfigInfo = aMFPacket.getSize() > 5 ? H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5) : null;
                if (h264CodecConfigInfo != null) {
                    byte[] byArray = new byte[aMFPacket.getSize() - 5];
                    System.arraycopy(aMFPacket.getData(), 5, byArray, 0, byArray.length);
                    MediaCodecInfoVideo mediaCodecInfoVideo = new MediaCodecInfoVideo();
                    mediaCodecInfoVideo.setCodecId(7);
                    mediaCodecInfoVideo.setVideoLevel(h264CodecConfigInfo.levelIDC);
                    mediaCodecInfoVideo.setVideoProfile(h264CodecConfigInfo.profileIDC);
                    mediaCodecInfoVideo.setVideoWidth(h264CodecConfigInfo.width);
                    mediaCodecInfoVideo.setVideoHeight(h264CodecConfigInfo.height);
                    mediaCodecInfoVideo.setDisplayWidth(h264CodecConfigInfo.displayWidth);
                    mediaCodecInfoVideo.setDisplayHeight(h264CodecConfigInfo.displayHeight);
                    mediaCodecInfoVideo.setCodecConfig(byArray);
                    sanJosePacketHolder.setCodecInfo((IMediaCodecInfo)mediaCodecInfoVideo);
                }
            } else if (n == 8) {
                AACFrame aACFrame;
                AACFrame aACFrame2 = aACFrame = aMFPacket.getSize() >= 4 ? AACUtils.decodeAACCodecConfig((byte[])aMFPacket.getData(), (int)2) : null;
                if (aACFrame != null) {
                    byte[] byArray = new byte[aMFPacket.getSize() - 2];
                    System.arraycopy(aMFPacket.getData(), 2, byArray, 0, byArray.length);
                    MediaCodecInfoAudio mediaCodecInfoAudio = new MediaCodecInfoAudio();
                    mediaCodecInfoAudio.setCodecId(10);
                    mediaCodecInfoAudio.setAudioObjectType(aACFrame.getProfileObjectType());
                    mediaCodecInfoAudio.setAudioSamplesPerFrame(aACFrame.getSampleCount());
                    mediaCodecInfoAudio.setAudioChannels(aACFrame.getChannels());
                    mediaCodecInfoAudio.setAudioSampleFrequency(aACFrame.getSampleRate());
                    mediaCodecInfoAudio.setCodecConfig(byArray);
                    sanJosePacketHolder.setCodecInfo((IMediaCodecInfo)mediaCodecInfoAudio);
                }
            }
        }
        return sanJosePacketHolder;
    }

    public String getPlaylistF4M(String string, String string2, IDvrStreamStore iDvrStreamStore, long l) {
        if (string == null || string2 == null || iDvrStreamStore == null) {
            return null;
        }
        DvrChunk dvrChunk = null;
        DvrChunk dvrChunk2 = iDvrStreamStore.getDvrChunkAtTime(9, l);
        List list = iDvrStreamStore.getManifest().getDvrEntriesAtTime(9, l);
        DvrManifestEntry dvrManifestEntry = iDvrStreamStore.getManifest().getMetadataEntryForTime(l);
        if (dvrManifestEntry != null) {
            dvrChunk = iDvrStreamStore.getDvrChunkAtTime(0, dvrManifestEntry.getStartTimecode());
        }
        String string3 = this.getPlaylistF4M(list, dvrChunk2, dvrChunk, string, string2, l);
        System.out.println("F4M playlist:\n" + string3);
        return string3;
    }

    public String getPlaylistF4M(List<DvrManifestEntry> list, DvrChunk dvrChunk, DvrChunk dvrChunk2, String string, String string2, long l) {
        if (list == null || dvrChunk == null) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = l / 1000L;
        int n = list.size();
        if (n > 1) {
            l2 = list.get(0).getStartTimecode() / 1000L;
            l3 = list.get(n - 1).getStopTimecode() / 1000L;
            l4 = l3 - l2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object;
            int n2 = 0;
            int n3 = 0;
            String string3 = "named";
            MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)dvrChunk.getMediaInfoVideo();
            if (mediaCodecInfoVideo != null && mediaCodecInfoVideo.isVideo()) {
                n2 = mediaCodecInfoVideo.getVideoWidth();
                n3 = mediaCodecInfoVideo.getVideoHeight();
                int n4 = mediaCodecInfoVideo.getVideoProfile();
                if (n4 > 0) {
                    string3 = "" + n4;
                }
            }
            byte[] byArray = null;
            int n5 = 0;
            int n6 = 0;
            if (dvrChunk2 == null) {
                System.out.println("metadataChunk null !!!");
            } else {
                object = new DvrChunkToAMFPacketParser();
                AMFPacket aMFPacket = object.createAMFPacketFromMetadataChunk(dvrChunk2);
                if (aMFPacket == null) {
                    System.out.println("packet == null !!!");
                } else {
                    System.out.println("metaPacket=" + aMFPacket);
                    SanJosePacketHolder sanJosePacketHolder = new SanJosePacketHolder(aMFPacket, 18, -1, false, l);
                    byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder);
                    n5 = 11;
                    n6 = byArray.length - 15;
                    System.out.printf("-updatePlaylistF4M getMetaDataChunk block: %s\n", DebugUtils.formatBytes((byte[])byArray).replaceAll("\n", ""));
                    int n7 = 0;
                    if (byArray[n5 + n7] == 0) {
                        ++n7;
                    }
                    AMFDataList aMFDataList = null;
                    try {
                        aMFDataList = new AMFDataList(byArray, n5, n6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (aMFDataList != null && aMFDataList.size() >= 2) {
                        int n8 = aMFDataList.getType(1);
                        if (n8 == 3) {
                            AMFDataObj aMFDataObj = (AMFDataObj)aMFDataList.get(1);
                            n2 = aMFDataObj.getInt("width");
                            n3 = aMFDataObj.getInt("height");
                        } else if (n8 == 8) {
                            AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1);
                            n2 = aMFDataMixedArray.getInt("width");
                            n3 = aMFDataMixedArray.getInt("height");
                        }
                    }
                }
            }
            object = null;
            if (byArray != null) {
                object = Base64.encodeBytes(byArray, (int)n5, (int)n6, (int)8);
            }
            System.out.printf("-updatePlaylistF4M blockStr=%s\n", object);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuffer.append("<manifest xmlns=\"http://ns.adobe.com/f4m/1.0\">\n");
            if (string != null) {
                stringBuffer.append("\t<id>" + this.xmlCleanStr(string) + "</id>" + "\n");
            }
            if (n2 > 0 && n3 > 0) {
                stringBuffer.append("\t<width>" + n2 + "</width>" + "\n");
                stringBuffer.append("\t<height>" + n3 + "</height>" + "\n");
            }
            stringBuffer.append("\t<duration>" + l4 + "</duration>" + "\n");
            stringBuffer.append("\t<mimeType>video/mp4</mimeType>\n");
            stringBuffer.append("\t<streamType>recorded</streamType>\n");
            stringBuffer.append("\t<deliveryType>streaming</deliveryType>\n");
            stringBuffer.append(String.format("\t<dvrInfo beginOffset=\"%d\" endOffset=\"%d\" />", l5 - l2, l3 - l5)).append("\n");
            stringBuffer.append("\t<media url=\"" + this.modifyMediaUrl("media_b{bitrate}_w{session-id}.abst/", string2) + "/" + "\">" + "\n");
            if (object != null) {
                stringBuffer.append("\t\t<metadata>" + (String)object + "</metadata>" + "\n");
            }
            stringBuffer.append("\t</media>\n");
            System.out.printf("-updatePlaylistF4M profileIDCStr=%s\n", string3);
            stringBuffer.append("\t<bootstrapInfo profile=\"" + string3 + "\" url=\"" + this.modifyPlaylistUrl("playlist_b{bitrate}_w{session-id}.abst{query}", string2, l) + "\"/>" + "\n");
            stringBuffer.append("</manifest>\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.updatePlaylistF4M: " + exception.toString());
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private String modifyPlaylistUrl(String string, String string2, long l) {
        long l2 = Math.round((double)l / 1000.0);
        string = string.replace("{bitrate}", "125000");
        string = string.replace("{query}", "?DVR=" + string2 + "&time=" + l2);
        return string;
    }

    private String modifyMediaUrl(String string, String string2) {
        string = string.replace("{bitrate}", "125000");
        string = string.replace("media_", "DVR" + string2 + "_");
        return string;
    }

    private String xmlCleanStr(String string) {
        return string;
    }

    class ABSTData {
        byte[] buffer = null;
        long rangeStart = -1L;
        long rangeStop = -1L;

        ABSTData() {
        }
    }
}

