/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.ISanJoseChunkWriter;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJosePacketHolder;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class SanJosePacketHandler {
    private boolean didStreamReset = false;
    private boolean waitForKeyFrame = true;
    private long lastAudioTimecode = -1L;
    private long lastVideoTimecode = -1L;
    private long lastDataTimecode = -1L;
    private boolean reportVideoCodecInfo = true;
    private boolean reportAudioCodecInfo = true;
    private AACFrame aacFrame = null;
    private int lastAACSampleRate = -1;
    private long lastAACTimecode = -1L;
    private SanJosePacketHolder audioGroupPacket = null;
    private int videoCodec = -1;
    private int audioCodec = -1;
    private boolean codecIsLocked = false;
    private long codecLockStartTimecode = -1L;
    private int streamMode = 1;
    private List<SanJosePacketHolder> savedHolders = new ArrayList<SanJosePacketHolder>();
    private int waitForCodecTime = 9000;
    private int chunkDurationTarget = 10000;
    private int chunkDurationTolerance = 500;
    private int maxSaveHolderSize = 500;
    private int maxChunkKeyCount = 50;
    private boolean debugAACTimecodes = false;
    private long chunkLastAudioTimecode = -1L;
    private long chunkHitEndKeyTimecode = -1L;
    private boolean chunkHitEndKey = false;
    private long chunkStartTimecode = -1L;
    private long chunkStartKeyTimecode = -1L;
    private long chunkStopKeyTimecode = -1L;
    private long chunkKeyCount = 0L;
    private boolean isChunkOpen = false;
    private boolean sendEndChunk = false;
    private ISanJoseChunkWriter chunkWriter = null;
    private int pendingAudioChunkCount = 0;
    private int pendingVideoChunkCount = 0;
    private int pendingDataChunkCount = 0;
    private boolean doSetMetaData = true;
    private MediaCodecInfoAudio codecInfoAudio = null;
    private MediaCodecInfoVideo codecInfoVideo = null;
    private MediaCodecInfoAudio chunkCodecInfoAudio = null;
    private boolean chunkCodecInfoAudioSent = false;
    private MediaCodecInfoVideo chunkCodecInfoVideo = null;
    private boolean chunkCodecInfoVideoSent = false;
    private AMFPacket metaDataPacket = null;
    private boolean chunkMetaDataPacketSent = false;
    private int lastAdjAudioTimecodeBackwardsCount = 0;
    private int lastAdjVideoTimecodeBackwardsCount = 0;
    private boolean lastAdjAudioTimecodeWarning = true;
    private boolean lastAdjVideoTimecodeWarning = true;

    private IMediaReader getMediaReader(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2) {
        String string3 = string.toLowerCase();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)iApplicationInstance, (MediaReaderList)iApplicationInstance.getVHost().getMediaReaders(), (String)string3);
        if (iMediaReader != null) {
            String string4 = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, iMediaStream, string, string4, string2);
            iMediaReader.open(string4, string2);
        }
        return iMediaReader;
    }

    private void doPreroll(IMediaStream iMediaStream) {
        try {
            IMediaReader iMediaReader = null;
            PlaylistCursor playlistCursor = null;
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            String string = "mp4";
            String string2 = "preroll.mov";
            iMediaReader = this.getMediaReader(iApplicationInstance, iMediaStream, string, string2);
            playlistCursor = new PlaylistCursor();
            long[] lArray = new long[8];
            PlaylistWriteControl playlistWriteControl = playlistCursor.getWriteControl();
            PlaylistReaderWriteResults playlistReaderWriteResults = playlistCursor.getWriteResults();
            playlistWriteControl.setMaxTC(10000L);
            iMediaReader.seek(0L, 3);
            ArrayList arrayList = new ArrayList();
            iMediaReader.writePackets(arrayList, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, null);
            long l = 0L;
            int n = 5;
            for (int i = 0; i < n; ++i) {
                long l2 = 0L;
                System.out.println("****START: " + i);
                int n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    AMFPacket aMFPacket = (AMFPacket)arrayList.get(j);
                    l2 = aMFPacket.getAbsTimecode();
                    long l3 = l2 + l;
                    aMFPacket.setAbsTimecode(l3);
                    switch (aMFPacket.getType()) {
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.handlePacket(iMediaStream, aMFPacket, false);
                            break;
                        }
                    }
                    aMFPacket.setAbsTimecode(l2);
                }
                l += l2;
            }
            iMediaReader.close();
            this.waitForKeyFrame = true;
            this.reportVideoCodecInfo = true;
            this.reportAudioCodecInfo = true;
            System.out.println("****DONE: ");
        }
        catch (Exception exception) {
            System.out.println("doPreroll: " + exception.toString());
        }
    }

    public void startStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("SanJosePacketHandler.startStream[" + this.getContextStr(iMediaStream) + "]");
    }

    public void resetStream(IMediaStream iMediaStream) {
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAudioTimecode = -1L;
        this.lastVideoTimecode = -1L;
        this.waitForKeyFrame = true;
        this.didStreamReset = true;
    }

    private void doStreamReset() {
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAudioTimecode = -1L;
        this.lastVideoTimecode = -1L;
        this.waitForKeyFrame = true;
    }

    private String getContextStr(IMediaStream iMediaStream) {
        String string = iMediaStream.getStreams().getAppInstance().getApplication().getName() + "/" + iMediaStream.getStreams().getAppInstance().getName() + "/" + iMediaStream.getName();
        return string;
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        this.handlePacket(iMediaStream, aMFPacket, false);
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket, boolean bl) {
        block64: {
            try {
                Object object;
                Object object2;
                Object object3;
                long l = aMFPacket.getAbsTimecode();
                int n = aMFPacket.getType();
                int n2 = aMFPacket.getSize();
                if (n2 <= 0) break block64;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                boolean bl5 = false;
                if (n == 18) {
                    try {
                        object3 = aMFPacket.getData();
                        if (object3 != null && ((byte[])object3).length > 0) {
                            int n3 = 0;
                            if (object3[0] == 0) {
                                ++n3;
                            }
                            if ((object2 = new AMFDataList(object3, n3, ((byte[])object3).length - n3)).size() > 1 && object2.get(0).getType() == 2) {
                                object = object2.getString(0);
                                if (((String)object).equals("@setDataFrame")) {
                                    object2.remove(0);
                                }
                                if (object2.size() > 1 && object2.get(0).getType() == 2 && ((String)(object = object2.getString(0))).equalsIgnoreCase("onMetaData")) {
                                    this.metaDataPacket = aMFPacket;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(SanJosePacketHandler.class).error("SanJosePacketHandler.handlePacket: " + exception.toString());
                    }
                }
                if (this.metaDataPacket == null && (object3 = (Object)iMediaStream.getMetaDataProvider()) != null) {
                    ArrayList arrayList = new ArrayList();
                    object3.onStreamStart(arrayList, l);
                    if (arrayList.size() > 0 && (object2 = (AMFPacket)arrayList.get(0)) != null) {
                        this.metaDataPacket = object2;
                    }
                }
                if (!this.codecIsLocked) {
                    int n4;
                    int n5;
                    if (this.videoCodec == -1 && (n5 = iMediaStream.getPublishVideoCodecId()) != -1) {
                        this.videoCodec = n5;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.handlePacket: Video codec: " + FLVUtils.videoCodecToString((int)n5));
                    }
                    if (this.audioCodec == -1 && (n4 = iMediaStream.getPublishAudioCodecId()) != -1) {
                        this.audioCodec = n4;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.handlePacket: Audio codec: " + FLVUtils.audioCodecToString((int)n4));
                    }
                }
                int n6 = -1;
                int n7 = -1;
                if (n == 9) {
                    bl3 = FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket);
                    bl2 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
                    n6 = FLVUtils.getVideoCodec((int)aMFPacket.getFirstByte());
                    if (bl3) {
                        Object object4 = object2 = aMFPacket.getSize() > 5 ? H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5) : null;
                        if (object2 != null) {
                            object = new byte[aMFPacket.getSize() - 5];
                            System.arraycopy(aMFPacket.getData(), 5, object, 0, ((Object)object).length);
                            this.codecInfoVideo = new MediaCodecInfoVideo();
                            this.codecInfoVideo.setCodecId(7);
                            this.codecInfoVideo.setVideoLevel(((H264CodecConfigInfo)object2).levelIDC);
                            this.codecInfoVideo.setVideoProfile(((H264CodecConfigInfo)object2).profileIDC);
                            this.codecInfoVideo.setVideoWidth(((H264CodecConfigInfo)object2).width);
                            this.codecInfoVideo.setVideoHeight(((H264CodecConfigInfo)object2).height);
                            this.codecInfoVideo.setDisplayWidth(((H264CodecConfigInfo)object2).displayWidth);
                            this.codecInfoVideo.setDisplayHeight(((H264CodecConfigInfo)object2).displayHeight);
                            this.codecInfoVideo.setCodecConfig((byte[])object);
                            if (this.reportVideoCodecInfo) {
                                this.reportVideoCodecInfo = false;
                            }
                        }
                    }
                    if (this.waitForKeyFrame) {
                        if (bl2) {
                            this.waitForKeyFrame = false;
                        } else {
                            bl4 = false;
                        }
                    }
                } else if (n == 8) {
                    bl3 = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket);
                    n7 = FLVUtils.getAudioCodec((int)aMFPacket.getFirstByte());
                    if (bl3) {
                        if (n7 == 10) {
                            AACFrame aACFrame = this.aacFrame = aMFPacket.getSize() >= 4 ? AACUtils.decodeAACCodecConfig((byte[])aMFPacket.getData(), (int)2) : null;
                            if (this.aacFrame != null) {
                                object2 = new byte[aMFPacket.getSize() - 2];
                                System.arraycopy(aMFPacket.getData(), 2, object2, 0, ((Object)object2).length);
                                this.codecInfoAudio = new MediaCodecInfoAudio();
                                this.codecInfoAudio.setCodecId(10);
                                this.codecInfoAudio.setAudioObjectType(this.aacFrame.getProfileObjectType());
                                this.codecInfoAudio.setAudioSamplesPerFrame(this.aacFrame.getSampleCount());
                                this.codecInfoAudio.setAudioChannels(this.aacFrame.getChannels());
                                this.codecInfoAudio.setAudioSampleFrequency(this.aacFrame.getSampleRate());
                                this.codecInfoAudio.setCodecConfig((byte[])object2);
                                if (this.reportAudioCodecInfo) {
                                    this.reportAudioCodecInfo = false;
                                }
                            }
                        } else if (n7 == 2) {
                            if (this.codecInfoAudio == null && aMFPacket.getSize() >= 5) {
                                object2 = new byte[4];
                                object = new MP3HeaderData();
                                System.arraycopy(aMFPacket.getData(), 1, object2, 0, 4);
                                int n8 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])object2, (MP3HeaderData)object);
                                if (n8 != 0) {
                                    MP3BufferedDecoder.decodeHeader((int)n8, (int)0, (MP3HeaderData)object);
                                    int n9 = 2;
                                    switch (((MP3HeaderData)object).h_mode) {
                                        case 0: {
                                            n9 = 2;
                                            break;
                                        }
                                        case 1: {
                                            n9 = 2;
                                            break;
                                        }
                                        case 2: {
                                            n9 = 2;
                                            break;
                                        }
                                        case 3: {
                                            n9 = 1;
                                        }
                                    }
                                    this.codecInfoAudio = new MediaCodecInfoAudio();
                                    this.codecInfoAudio.setCodecId(2);
                                    this.codecInfoAudio.setAudioObjectType(34);
                                    this.codecInfoAudio.setAudioSamplesPerFrame(MP3BufferedDecoder.samples_per_frame((MP3HeaderData)object));
                                    this.codecInfoAudio.setAudioChannels(n9);
                                    this.codecInfoAudio.setAudioSampleFrequency(MP3BufferedDecoder.frequency((MP3HeaderData)object));
                                }
                            }
                            if (this.reportAudioCodecInfo) {
                                this.reportAudioCodecInfo = false;
                            }
                        }
                    }
                } else if (n != 18) {
                    bl4 = false;
                }
                if (bl4) {
                    if (n == 9) {
                        if (this.lastVideoTimecode >= 0L && l < this.lastVideoTimecode) {
                            if (this.lastAdjVideoTimecodeWarning) {
                                WMSLoggerFactory.getLogger(SanJosePacketHandler.class).warn("SanJosePacketHandler.handlePacket[" + this.getContextStr(iMediaStream) + "]: Timecode out of order [video]: " + l + ":" + this.lastVideoTimecode);
                                this.lastAdjVideoTimecodeWarning = false;
                            }
                            ++this.lastAdjVideoTimecodeBackwardsCount;
                        } else {
                            this.lastVideoTimecode = l;
                            this.lastAdjVideoTimecodeBackwardsCount = 0;
                            if (bl4) {
                                object2 = new SanJosePacketHolder(aMFPacket, 9, n6, bl3, l);
                                ((SanJosePacketHolder)object2).setKey(bl2);
                                ((SanJosePacketHolder)object2).setCodecInfo((IMediaCodecInfo)this.codecInfoVideo);
                                ((SanJosePacketHolder)object2).setMetaDataPacket(this.metaDataPacket);
                                this.handleHolder((SanJosePacketHolder)object2);
                            }
                        }
                    } else if (n == 8) {
                        if (this.lastAudioTimecode >= 0L && l < this.lastAudioTimecode) {
                            if (this.lastAdjAudioTimecodeWarning) {
                                WMSLoggerFactory.getLogger(SanJosePacketHandler.class).warn("SanJosePacketHandler.handlePacket[" + this.getContextStr(iMediaStream) + "]: Timecode out of order [audio]: " + l + ":" + this.lastAudioTimecode);
                                this.lastAdjAudioTimecodeWarning = false;
                            }
                            ++this.lastAdjAudioTimecodeBackwardsCount;
                        } else {
                            this.lastAudioTimecode = l;
                            this.lastAdjAudioTimecodeBackwardsCount = 0;
                            long l2 = l * 90L;
                            if (!bl3 && n7 == 10 && this.aacFrame != null) {
                                if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.aacFrame.getSampleRate()) {
                                    this.lastAACSampleRate = this.aacFrame.getSampleRate();
                                    this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                } else {
                                    long l3 = this.lastAACTimecode + (long)this.aacFrame.getSampleCount();
                                    long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastAACSampleRate);
                                    int n10 = (int)Math.abs(l4 - l);
                                    if (this.debugAACTimecodes) {
                                        System.out.println("tc[" + n10 + "]: " + l4 + ":" + l + ":" + this.lastAACSampleRate);
                                    }
                                    if (n10 <= 1) {
                                        l2 = Math.round((double)(l3 * 90000L) / (double)this.lastAACSampleRate);
                                        this.lastAACTimecode = l3;
                                    } else {
                                        this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                        if (this.debugAACTimecodes) {
                                            System.out.println("reset: " + this.lastAACTimecode);
                                        }
                                    }
                                }
                            }
                            if (bl4) {
                                SanJosePacketHolder sanJosePacketHolder = new SanJosePacketHolder(aMFPacket, 8, n7, bl3, l);
                                sanJosePacketHolder.setCodecInfo((IMediaCodecInfo)this.codecInfoAudio);
                                sanJosePacketHolder.setMetaDataPacket(this.metaDataPacket);
                                this.handleHolder(sanJosePacketHolder);
                            }
                        }
                    } else if (n == 18 && (this.lastDataTimecode < 0L || l >= this.lastDataTimecode)) {
                        this.lastDataTimecode = l;
                        if (bl4) {
                            object2 = new SanJosePacketHolder(aMFPacket, 18, -1, false, l);
                            ((SanJosePacketHolder)object2).setMetaDataPacket(this.metaDataPacket);
                            this.handleHolder((SanJosePacketHolder)object2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.handlePacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (this.lastAdjAudioTimecodeBackwardsCount > 10 || this.lastAdjVideoTimecodeBackwardsCount > 10) {
            WMSLoggerFactory.getLogger(SanJosePacketHandler.class).warn("SanJosePacketHandler.resetStream[" + this.getContextStr(iMediaStream) + "][" + this.lastAdjAudioTimecodeBackwardsCount + ":" + this.lastAdjVideoTimecodeBackwardsCount + "]: Timecodes jumped back in time.");
            this.lastAdjAudioTimecodeBackwardsCount = 0;
            this.lastAdjVideoTimecodeBackwardsCount = 0;
            this.resetStream(iMediaStream);
        }
    }

    public void handleHolder(SanJosePacketHolder sanJosePacketHolder) {
        try {
            int n = this.savedHolders.size();
            HandlerHolderResult handlerHolderResult = this.handleHolderInternal(sanJosePacketHolder, false, n);
            if (handlerHolderResult.saveHolder) {
                this.savedHolders.add(sanJosePacketHolder);
            }
            if (handlerHolderResult.flushSavedHolders) {
                ArrayList<SanJosePacketHolder> arrayList = new ArrayList<SanJosePacketHolder>();
                for (SanJosePacketHolder sanJosePacketHolder2 : this.savedHolders) {
                    HandlerHolderResult handlerHolderResult2 = this.handleHolderInternal(sanJosePacketHolder2, true, 0);
                    if (!handlerHolderResult2.saveHolder) continue;
                    arrayList.add(sanJosePacketHolder);
                }
                this.savedHolders.clear();
                this.savedHolders = arrayList;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.handleHolder: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public HandlerHolderResult handleHolderInternal(SanJosePacketHolder sanJosePacketHolder, boolean bl, int n) {
        HandlerHolderResult handlerHolderResult;
        block52: {
            boolean bl2;
            boolean bl3;
            long l;
            int n2;
            long l2;
            long l3;
            block51: {
                handlerHolderResult = new HandlerHolderResult();
                l3 = sanJosePacketHolder.getTimecode();
                l2 = l3 + (long)sanJosePacketHolder.getDuration();
                n2 = sanJosePacketHolder.getType();
                int n3 = sanJosePacketHolder.getCodec();
                l = sanJosePacketHolder.getTimecode();
                long l4 = 0L;
                if (n2 == 9 && sanJosePacketHolder.getPacket() != null) {
                    l4 = FLVUtils.getVideoTimecodeOffset((AMFPacket)sanJosePacketHolder.getPacket());
                }
                l += l4;
                if (this.codecIsLocked) break block51;
                bl3 = false;
                if (this.codecLockStartTimecode == -1L) {
                    this.codecLockStartTimecode = l3;
                }
                if (this.videoCodec != -1 && this.audioCodec != -1) {
                    this.codecIsLocked = true;
                    handlerHolderResult.saveHolder = true;
                    handlerHolderResult.flushSavedHolders = true;
                    bl3 = true;
                } else if (n > this.maxSaveHolderSize || l3 - this.codecLockStartTimecode > (long)this.waitForCodecTime) {
                    this.codecIsLocked = true;
                    handlerHolderResult.saveHolder = true;
                    handlerHolderResult.flushSavedHolders = true;
                    bl3 = true;
                } else {
                    handlerHolderResult.saveHolder = true;
                    bl3 = true;
                }
                if (bl3) break block52;
            }
            if (this.sendEndChunk) {
                this.endChunk(l3);
                this.chunkLastAudioTimecode = -1L;
                this.chunkHitEndKeyTimecode = -1L;
                this.chunkStartTimecode = -1L;
                this.chunkStartKeyTimecode = -1L;
                this.chunkStopKeyTimecode = -1L;
                this.chunkHitEndKey = false;
                this.chunkCodecInfoAudio = null;
                this.chunkCodecInfoAudioSent = false;
                this.chunkCodecInfoVideo = null;
                this.chunkCodecInfoVideoSent = false;
                this.chunkMetaDataPacketSent = false;
                this.chunkKeyCount = 0L;
                this.sendEndChunk = false;
            }
            if (this.chunkStartTimecode == -1L) {
                this.chunkStartTimecode = l3;
            }
            bl3 = false;
            if (this.videoCodec != -1 && this.audioCodec != -1) {
                bl2 = false;
                if (n2 == 9) {
                    if (this.chunkHitEndKey) {
                        handlerHolderResult.saveHolder = true;
                        bl2 = sanJosePacketHolder.isKey();
                    } else if (sanJosePacketHolder.isKey()) {
                        boolean bl4 = false;
                        MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)sanJosePacketHolder.getCodecInfo();
                        if (mediaCodecInfoVideo != null) {
                            if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideo.equals(mediaCodecInfoVideo)) {
                                bl4 = true;
                            }
                            if (this.chunkCodecInfoVideo == null) {
                                this.chunkCodecInfoVideo = mediaCodecInfoVideo;
                            }
                        }
                        if (this.didStreamReset) {
                            bl4 = true;
                            this.didStreamReset = false;
                        }
                        ++this.chunkKeyCount;
                        if (this.chunkStartKeyTimecode < 0L) {
                            this.chunkStartKeyTimecode = l;
                            this.chunkStopKeyTimecode = (l / (long)this.chunkDurationTarget + 1L) * (long)this.chunkDurationTarget;
                        }
                        if (bl4 || this.chunkKeyCount > (long)this.maxChunkKeyCount || l3 < this.chunkStartTimecode || l >= this.chunkStopKeyTimecode) {
                            this.chunkHitEndKeyTimecode = l3;
                            this.chunkHitEndKey = true;
                            handlerHolderResult.saveHolder = true;
                        }
                    }
                } else if (n2 == 8) {
                    if (this.chunkCodecInfoAudio == null) {
                        this.chunkCodecInfoAudio = (MediaCodecInfoAudio)sanJosePacketHolder.getCodecInfo();
                    }
                    this.chunkLastAudioTimecode = l2;
                }
                if (this.chunkHitEndKey && (n > this.maxSaveHolderSize || bl2 || this.chunkLastAudioTimecode >= this.chunkHitEndKeyTimecode)) {
                    bl3 = true;
                    if (n2 == 8) {
                        handlerHolderResult.saveHolder = true;
                    }
                }
            } else if (this.videoCodec != -1) {
                if (sanJosePacketHolder.isKey()) {
                    bl2 = false;
                    MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)sanJosePacketHolder.getCodecInfo();
                    if (mediaCodecInfoVideo != null) {
                        if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideo.equals(mediaCodecInfoVideo)) {
                            bl2 = true;
                        }
                        if (this.chunkCodecInfoVideo == null) {
                            this.chunkCodecInfoVideo = mediaCodecInfoVideo;
                        }
                    }
                    if (this.didStreamReset) {
                        bl2 = true;
                        this.didStreamReset = false;
                    }
                    ++this.chunkKeyCount;
                    if (this.chunkStartKeyTimecode < 0L) {
                        this.chunkStartKeyTimecode = l;
                        this.chunkStopKeyTimecode = (l / (long)this.chunkDurationTarget + 1L) * (long)this.chunkDurationTarget;
                    }
                    if (bl2 || this.chunkKeyCount > (long)this.maxChunkKeyCount || l3 < this.chunkStartTimecode || l >= this.chunkStopKeyTimecode) {
                        this.chunkHitEndKeyTimecode = l3;
                        this.chunkHitEndKey = true;
                        bl3 = true;
                        handlerHolderResult.saveHolder = true;
                    }
                }
            } else {
                bl2 = false;
                if (this.didStreamReset) {
                    bl2 = true;
                    this.didStreamReset = false;
                }
                if (bl2 || n > this.maxSaveHolderSize || l2 < this.chunkStartTimecode || l2 - this.chunkStartTimecode >= (long)this.chunkDurationTarget) {
                    bl3 = true;
                }
            }
            if (!handlerHolderResult.saveHolder) {
                AMFPacket aMFPacket;
                if (!this.isChunkOpen) {
                    this.startChunk(this.chunkStartTimecode);
                    this.isChunkOpen = true;
                }
                if (!this.chunkMetaDataPacketSent && (aMFPacket = sanJosePacketHolder.getMetaDataPacket()) != null) {
                    SanJosePacketHolder sanJosePacketHolder2 = new SanJosePacketHolder(aMFPacket, 18, -1, false, sanJosePacketHolder.getTimecode());
                    this.chunkWriter.setMetaData(sanJosePacketHolder2);
                    this.chunkMetaDataPacketSent = true;
                }
                if (sanJosePacketHolder.getType() == 8 && this.chunkCodecInfoAudio == null) {
                    this.chunkCodecInfoAudio = (MediaCodecInfoAudio)sanJosePacketHolder.getCodecInfo();
                }
                if (this.chunkCodecInfoAudio != null && !this.chunkCodecInfoAudioSent) {
                    this.chunkWriter.setCodecInfoAudio(this.chunkCodecInfoAudio);
                    this.chunkCodecInfoAudioSent = true;
                }
                if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideoSent) {
                    this.chunkWriter.setCodecInfoVideo(this.chunkCodecInfoVideo);
                    this.chunkCodecInfoVideoSent = true;
                }
                boolean bl5 = true;
                switch (sanJosePacketHolder.getType()) {
                    case 8: {
                        if (this.chunkWriter.isPacketizeAudio()) break;
                        bl5 = false;
                        break;
                    }
                    case 9: {
                        if (this.chunkWriter.isPacketizeVideo()) break;
                        bl5 = false;
                        break;
                    }
                    case 18: {
                        if (this.chunkWriter.isPacketizeData()) break;
                        bl5 = false;
                    }
                }
                if (bl5) {
                    this.addToChunk(sanJosePacketHolder);
                }
            }
            if (bl3) {
                if (!this.isChunkOpen) {
                    System.out.println("*********** Why is chunk not open");
                }
                if (this.isChunkOpen) {
                    this.sendEndChunk = true;
                    this.isChunkOpen = false;
                }
                handlerHolderResult.flushSavedHolders = true;
            }
        }
        return handlerHolderResult;
    }

    private void startChunk(long l) {
        this.chunkWriter.startChunk(this.streamMode, this.videoCodec, this.audioCodec, l);
        this.pendingAudioChunkCount = 0;
        this.pendingVideoChunkCount = 0;
        this.pendingDataChunkCount = 0;
    }

    private void endChunk(long l) {
        this.chunkWriter.endChunk(l);
        this.pendingAudioChunkCount = 0;
        this.pendingVideoChunkCount = 0;
        this.pendingDataChunkCount = 0;
    }

    private void addToChunk(SanJosePacketHolder sanJosePacketHolder) {
        int n = sanJosePacketHolder.getType();
        if (this.chunkWriter != null) {
            SanJosePacketHolder sanJosePacketHolder2;
            AMFPacket aMFPacket;
            byte[] byArray;
            byte[] byArray2;
            MediaCodecInfoVideo mediaCodecInfoVideo;
            long l = sanJosePacketHolder.getTimecode();
            if (n == 9 && this.pendingVideoChunkCount == 0 && sanJosePacketHolder.getCodec() == 7 && (mediaCodecInfoVideo = (MediaCodecInfoVideo)sanJosePacketHolder.getCodecInfo()) != null && (byArray2 = mediaCodecInfoVideo.getCodecConfig()) != null) {
                byArray = new byte[byArray2.length + 5];
                byArray[0] = 23;
                byArray[1] = 0;
                System.arraycopy(byArray2, 0, byArray, 5, byArray2.length);
                aMFPacket = new AMFPacket(9, 0, byArray.length);
                aMFPacket.setAbsTimecode(l);
                aMFPacket.addData(byArray, 0, byArray.length);
                sanJosePacketHolder2 = new SanJosePacketHolder(aMFPacket, 9, 7, false, l);
                this.chunkWriter.addToChunk(sanJosePacketHolder2);
            }
            if (n == 8 && this.pendingAudioChunkCount == 0 && sanJosePacketHolder.getCodec() == 10 && (mediaCodecInfoVideo = (MediaCodecInfoAudio)sanJosePacketHolder.getCodecInfo()) != null && (byArray2 = mediaCodecInfoVideo.getCodecConfig()) != null) {
                byArray = new byte[byArray2.length + 2];
                byArray[0] = -81;
                byArray[1] = 0;
                System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
                aMFPacket = new AMFPacket(8, 0, byArray.length);
                aMFPacket.setAbsTimecode(l);
                aMFPacket.addData(byArray, 0, byArray.length);
                sanJosePacketHolder2 = new SanJosePacketHolder(aMFPacket, 8, 10, false, l);
                this.chunkWriter.addToChunk(sanJosePacketHolder2);
            }
            this.chunkWriter.addToChunk(sanJosePacketHolder);
        }
        if (n == 9) {
            ++this.pendingVideoChunkCount;
        } else if (n == 8) {
            ++this.pendingAudioChunkCount;
        } else {
            ++this.pendingDataChunkCount;
        }
    }

    public int getWaitForCodecTime() {
        return this.waitForCodecTime;
    }

    public void setWaitForCodecTime(int n) {
        this.waitForCodecTime = n;
    }

    public int getChunkDurationTarget() {
        return this.chunkDurationTarget;
    }

    public void setChunkDurationTarget(int n) {
        this.chunkDurationTarget = n;
    }

    public int getChunkDurationTolerance() {
        return this.chunkDurationTolerance;
    }

    public void setChunkDurationTolerance(int n) {
        this.chunkDurationTolerance = n;
    }

    public void setChunkWriter(ISanJoseChunkWriter iSanJoseChunkWriter) {
        this.chunkWriter = iSanJoseChunkWriter;
    }

    public boolean isDebugAACTimecodes() {
        return this.debugAACTimecodes;
    }

    public void setDebugAACTimecodes(boolean bl) {
        this.debugAACTimecodes = bl;
    }

    public int getMaxSaveHolderSize() {
        return this.maxSaveHolderSize;
    }

    public void setMaxSaveHolderSize(int n) {
        this.maxSaveHolderSize = n;
    }

    public int getMaxChunkKeyCount() {
        return this.maxChunkKeyCount;
    }

    public void setMaxChunkKeyCount(int n) {
        this.maxChunkKeyCount = n;
    }

    class HandlerHolderResult {
        boolean saveHolder = false;
        boolean flushSavedHolders = false;

        HandlerHolderResult() {
        }
    }
}

