/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.dvrpacketizer.IDvrPacketizer;
import com.wowza.wms.vhost.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPacketizerRunner
implements Runnable {
    public static final int COMMAND_PACKET = 1;
    public static final int COMMAND_RESETSTREAM = 2;
    private ThreadPool threadPool = null;
    private Map<String, IDvrPacketizer> packetizers = null;
    private Map<String, PacketizerInfo> livePacketizerInfo = new HashMap<String, PacketizerInfo>();
    private List<PacketHolder> packets = new ArrayList<PacketHolder>();
    private boolean isRunning = false;
    private Object lock = new Object();
    private int maxCycleCount = 20;
    private IMediaStream stream = null;
    private List<String> names = new ArrayList<String>();

    public DvrPacketizerRunner(IMediaStream iMediaStream, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.stream = iMediaStream;
    }

    public void setDvrPacketizers(Map<String, IDvrPacketizer> map) {
        this.packetizers = map;
        this.names.clear();
        this.names.addAll(map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimecodes() {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(2));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(AMFPacket aMFPacket) {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(aMFPacket));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickIt() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning && this.packets.size() > 0) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    public int getMaxCycleCount() {
        return this.maxCycleCount;
    }

    public void setMaxCycleCount(int n) {
        this.maxCycleCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        String string = this.stream.getName();
        MediaStreamMap mediaStreamMap = this.stream.getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(string);
        while (true) {
            try {
                Object object;
                do {
                    PacketHolder packetHolder = null;
                    object = this.lock;
                    synchronized (object) {
                        if (++n > this.maxCycleCount) {
                            bl = true;
                        } else if (this.packets.size() > 0) {
                            packetHolder = this.packets.remove(0);
                        } else {
                            bl = true;
                        }
                    }
                    if (this.stream != iMediaStream || packetHolder == null) continue;
                    for (String string2 : this.names) {
                        IDvrPacketizer iDvrPacketizer = this.packetizers.get(string2);
                        IDvrPacketizer iDvrPacketizer2 = mediaStreamMap.getDvrPacketizer(string2, string, true);
                        if (iDvrPacketizer2 == null) continue;
                        PacketizerInfo packetizerInfo = this.livePacketizerInfo.get(string2);
                        if (packetizerInfo == null) {
                            packetizerInfo = new PacketizerInfo();
                            this.livePacketizerInfo.put(string2, packetizerInfo);
                        }
                        if (iDvrPacketizer2 != iDvrPacketizer) {
                            iDvrPacketizer2.startStream(this.stream);
                            this.packetizers.put(string2, iDvrPacketizer2);
                            packetizerInfo.sendAudioCodecConfig = true;
                            packetizerInfo.sendVideoCodecConfig = true;
                        } else {
                            IMediaStream iMediaStream2 = iDvrPacketizer2.getStream();
                            if (iMediaStream2 != this.stream) {
                                this.doStreamReset(iDvrPacketizer2, packetizerInfo);
                            }
                        }
                        if (packetHolder.command == 1) {
                            boolean bl2 = false;
                            int n2 = packetHolder.packet.getType();
                            if (n2 == 8) {
                                if (packetHolder.packet.getSize() > 0) {
                                    int n3 = FLVUtils.getAudioCodec((AMFPacket)packetHolder.packet);
                                    if (packetizerInfo.audioCodec < 0) {
                                        packetizerInfo.audioCodec = n3;
                                    } else if (packetizerInfo.audioCodec != n3) {
                                        bl2 = true;
                                    }
                                }
                            } else if (n2 == 9 && packetHolder.packet.getSize() > 0) {
                                int n4 = FLVUtils.getVideoCodec((AMFPacket)packetHolder.packet);
                                if (packetizerInfo.videoCodec < 0) {
                                    packetizerInfo.videoCodec = n4;
                                } else if (packetizerInfo.videoCodec != n4) {
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                this.doStreamReset(iDvrPacketizer2, packetizerInfo);
                            }
                            AMFPacket aMFPacket = null;
                            if (packetizerInfo.sendAudioCodecConfig || packetizerInfo.sendVideoCodecConfig) {
                                if (packetizerInfo.sendAudioCodecConfig && n2 == 8) {
                                    packetizerInfo.sendAudioCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        packetizerInfo.sendAudioCodecConfig = true;
                                    } else {
                                        int n5 = FLVUtils.getAudioCodec((AMFPacket)packetHolder.packet);
                                        if (n5 == 10 && !FLVUtils.isAudioCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getAudioCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            packetizerInfo.sendAudioCodecConfig = true;
                                        }
                                    }
                                } else if (packetizerInfo.sendVideoCodecConfig && n2 == 9) {
                                    packetizerInfo.sendVideoCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        packetizerInfo.sendVideoCodecConfig = true;
                                    } else {
                                        int n6 = FLVUtils.getVideoCodec((AMFPacket)packetHolder.packet);
                                        if (n6 == 7 && !FLVUtils.isVideoCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getVideoCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            packetizerInfo.sendVideoCodecConfig = true;
                                        }
                                    }
                                }
                            }
                            if (aMFPacket != null) {
                                AMFPacket aMFPacket2 = new AMFPacket(aMFPacket.getType(), aMFPacket.getSrc(), aMFPacket.getSize());
                                aMFPacket2.setAbsTimecode(packetHolder.packet.getAbsTimecode());
                                aMFPacket2.addData(aMFPacket.getData(), 0, aMFPacket.getSize());
                                iDvrPacketizer2.handlePacket(this.stream, aMFPacket2);
                            }
                            iDvrPacketizer2.handlePacket(this.stream, packetHolder.packet);
                            continue;
                        }
                        if (packetHolder.command != 2) continue;
                        this.doStreamReset(iDvrPacketizer2, packetizerInfo);
                    }
                } while (!bl);
                object = this.lock;
                synchronized (object) {
                    this.isRunning = false;
                    this.kickIt();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(DvrPacketizerRunner.class).error("DvrPacketizerRunner.run: " + exception.toString());
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void doStreamReset(IDvrPacketizer iDvrPacketizer, PacketizerInfo packetizerInfo) {
        packetizerInfo.reset();
        iDvrPacketizer.resetStream(this.stream);
    }

    public void close() {
    }

    class PacketHolder {
        AMFPacket packet = null;
        int command = 1;

        public PacketHolder(int n) {
            this.command = n;
        }

        public PacketHolder(AMFPacket aMFPacket) {
            this.packet = aMFPacket;
            this.command = 1;
        }
    }

    class PacketizerInfo {
        boolean sendAudioCodecConfig = true;
        boolean sendVideoCodecConfig = true;
        int videoCodec = -1;
        int audioCodec = -1;

        PacketizerInfo() {
        }

        void reset() {
            this.sendAudioCodecConfig = true;
            this.sendVideoCodecConfig = true;
            this.audioCodec = -1;
            this.videoCodec = -1;
        }
    }
}

