/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerRunner
implements Runnable {
    public static final int COMMAND_PACKET = 1;
    public static final int COMMAND_RESETSTREAM = 2;
    private ThreadPool threadPool = null;
    private Map<String, ILiveStreamPacketizer> liveStreamPacektizers = null;
    private Map<String, TranscoderInfo> liveStreamPacektizerInfo = new HashMap<String, TranscoderInfo>();
    private List<PacketHolder> packets = new ArrayList<PacketHolder>();
    private boolean isRunning = false;
    private Object lock = new Object();
    private int maxCycleCount = 20;
    private IMediaStream stream = null;
    private List<String> names = new ArrayList<String>();

    public LiveStreamPacketizerRunner(IMediaStream iMediaStream, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.stream = iMediaStream;
    }

    public void setLiveStreamPacketizers(Map<String, ILiveStreamPacketizer> map) {
        this.liveStreamPacektizers = map;
        this.names.clear();
        this.names.addAll(map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimecodes() {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(2));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(AMFPacket aMFPacket) {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(aMFPacket));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickIt() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning && this.packets.size() > 0) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    public int getMaxCycleCount() {
        return this.maxCycleCount;
    }

    public void setMaxCycleCount(int n) {
        this.maxCycleCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        String string = this.stream.getName();
        MediaStreamMap mediaStreamMap = this.stream.getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(string);
        while (true) {
            try {
                Object object;
                do {
                    PacketHolder packetHolder = null;
                    object = this.lock;
                    synchronized (object) {
                        if (++n > this.maxCycleCount) {
                            bl = true;
                        } else if (this.packets.size() > 0) {
                            packetHolder = this.packets.remove(0);
                        } else {
                            bl = true;
                        }
                    }
                    if (this.stream != iMediaStream || packetHolder == null) continue;
                    for (String string2 : this.names) {
                        ILiveStreamPacketizer iLiveStreamPacketizer = this.liveStreamPacektizers.get(string2);
                        ILiveStreamPacketizer iLiveStreamPacketizer2 = mediaStreamMap.getLiveStreamPacketizer(string, string2, true);
                        if (iLiveStreamPacketizer2 == null) continue;
                        TranscoderInfo transcoderInfo = this.liveStreamPacektizerInfo.get(string2);
                        if (transcoderInfo == null) {
                            transcoderInfo = new TranscoderInfo();
                            this.liveStreamPacektizerInfo.put(string2, transcoderInfo);
                        }
                        if (iLiveStreamPacketizer2 != iLiveStreamPacketizer) {
                            iLiveStreamPacketizer2.startStream(this.stream);
                            this.liveStreamPacektizers.put(string2, iLiveStreamPacketizer2);
                            transcoderInfo.sendAudioCodecConfig = true;
                            transcoderInfo.sendVideoCodecConfig = true;
                        } else {
                            IMediaStream iMediaStream2 = iLiveStreamPacketizer2.getStartStream();
                            if (iMediaStream2 != this.stream) {
                                this.doStreamReset(iLiveStreamPacketizer2, transcoderInfo);
                            }
                        }
                        if (packetHolder.command == 1) {
                            boolean bl2 = false;
                            int n2 = packetHolder.packet.getType();
                            if (n2 == 8) {
                                if (packetHolder.packet.getSize() > 0) {
                                    int n3 = FLVUtils.getAudioCodec((AMFPacket)packetHolder.packet);
                                    if (transcoderInfo.audioCodec < 0) {
                                        transcoderInfo.audioCodec = n3;
                                    } else if (transcoderInfo.audioCodec != n3) {
                                        bl2 = true;
                                    }
                                }
                            } else if (n2 == 9 && packetHolder.packet.getSize() > 0) {
                                int n4 = FLVUtils.getVideoCodec((AMFPacket)packetHolder.packet);
                                if (transcoderInfo.videoCodec < 0) {
                                    transcoderInfo.videoCodec = n4;
                                } else if (transcoderInfo.videoCodec != n4) {
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                this.doStreamReset(iLiveStreamPacketizer2, transcoderInfo);
                            }
                            AMFPacket aMFPacket = null;
                            if (transcoderInfo.sendAudioCodecConfig || transcoderInfo.sendVideoCodecConfig) {
                                if (transcoderInfo.sendAudioCodecConfig && n2 == 8) {
                                    transcoderInfo.sendAudioCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        transcoderInfo.sendAudioCodecConfig = true;
                                    } else {
                                        int n5 = FLVUtils.getAudioCodec((AMFPacket)packetHolder.packet);
                                        if (n5 == 10 && !FLVUtils.isAudioCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getAudioCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            transcoderInfo.sendAudioCodecConfig = true;
                                        }
                                    }
                                } else if (transcoderInfo.sendVideoCodecConfig && n2 == 9) {
                                    transcoderInfo.sendVideoCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        transcoderInfo.sendVideoCodecConfig = true;
                                    } else {
                                        int n6 = FLVUtils.getVideoCodec((AMFPacket)packetHolder.packet);
                                        if (n6 == 7 && !FLVUtils.isVideoCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getVideoCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            transcoderInfo.sendVideoCodecConfig = true;
                                        }
                                    }
                                }
                            }
                            if (aMFPacket != null) {
                                AMFPacket aMFPacket2 = new AMFPacket(aMFPacket.getType(), aMFPacket.getSrc(), aMFPacket.getSize());
                                aMFPacket2.setAbsTimecode(packetHolder.packet.getAbsTimecode());
                                aMFPacket2.addData(aMFPacket.getData(), 0, aMFPacket.getSize());
                                iLiveStreamPacketizer2.handlePacket(this.stream, aMFPacket2);
                            }
                            iLiveStreamPacketizer2.handlePacket(this.stream, packetHolder.packet);
                            continue;
                        }
                        if (packetHolder.command != 2) continue;
                        this.doStreamReset(iLiveStreamPacketizer2, transcoderInfo);
                    }
                } while (!bl);
                object = this.lock;
                synchronized (object) {
                    this.isRunning = false;
                    this.kickIt();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerRunner.class).error("LiveStreamPacketizerRunner.run: " + exception.toString());
                continue;
            }
            break;
        }
    }

    private void doStreamReset(ILiveStreamPacketizer iLiveStreamPacketizer, TranscoderInfo transcoderInfo) {
        transcoderInfo.reset();
        iLiveStreamPacketizer.resetStream(this.stream);
    }

    class PacketHolder {
        AMFPacket packet = null;
        int command = 1;

        public PacketHolder(int n) {
            this.command = n;
        }

        public PacketHolder(AMFPacket aMFPacket) {
            this.packet = aMFPacket;
            this.command = 1;
        }
    }

    class TranscoderInfo {
        boolean sendAudioCodecConfig = true;
        boolean sendVideoCodecConfig = true;
        int videoCodec = -1;
        int audioCodec = -1;

        TranscoderInfo() {
        }

        void reset() {
            this.sendAudioCodecConfig = true;
            this.sendVideoCodecConfig = true;
            this.audioCodec = -1;
            this.videoCodec = -1;
        }
    }
}

