/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.StringUtils;

public class CharUtils {
    private static final String CHAR_STRING = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final Character[] CHAR_ARRAY = new Character[128];
    public static final char LF = '\n';
    public static final char CR = '\r';

    public static Character toCharacterObject(char c) {
        if (c < CHAR_ARRAY.length) {
            return CHAR_ARRAY[c];
        }
        return new Character(c);
    }

    public static Character toCharacterObject(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return CharUtils.toCharacterObject(string.charAt(0));
    }

    public static char toChar(Character c) {
        if (c == null) {
            throw new IllegalArgumentException("The Character must not be null");
        }
        return c.charValue();
    }

    public static char toChar(Character c, char c2) {
        if (c == null) {
            return c2;
        }
        return c.charValue();
    }

    public static char toChar(String string) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("The String must not be empty");
        }
        return string.charAt(0);
    }

    public static char toChar(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return c;
        }
        return string.charAt(0);
    }

    public static int toIntValue(char c) {
        if (!CharUtils.isAsciiNumeric(c)) {
            throw new IllegalArgumentException("The character " + c + " is not in the range '0' - '9'");
        }
        return c - 48;
    }

    public static int toIntValue(char c, int n) {
        if (!CharUtils.isAsciiNumeric(c)) {
            return n;
        }
        return c - 48;
    }

    public static int toIntValue(Character c) {
        if (c == null) {
            throw new IllegalArgumentException("The character must not be null");
        }
        return CharUtils.toIntValue(c.charValue());
    }

    public static int toIntValue(Character c, int n) {
        if (c == null) {
            return n;
        }
        return CharUtils.toIntValue(c.charValue(), n);
    }

    public static String toString(char c) {
        if (c < '\u0080') {
            return CHAR_STRING_ARRAY[c];
        }
        return new String(new char[]{c});
    }

    public static String toString(Character c) {
        if (c == null) {
            return null;
        }
        return CharUtils.toString(c.charValue());
    }

    public static String unicodeEscaped(char c) {
        if (c < '\u0010') {
            return "\\u000" + Integer.toHexString(c);
        }
        if (c < '\u0100') {
            return "\\u00" + Integer.toHexString(c);
        }
        if (c < '\u1000') {
            return "\\u0" + Integer.toHexString(c);
        }
        return "\\u" + Integer.toHexString(c);
    }

    public static String unicodeEscaped(Character c) {
        if (c == null) {
            return null;
        }
        return CharUtils.unicodeEscaped(c.charValue());
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean isAsciiPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    public static boolean isAsciiAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAsciiAlphaUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isAsciiNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAsciiAlphanumeric(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static {
        for (int i = 127; i >= 0; --i) {
            CharUtils.CHAR_STRING_ARRAY[i] = CHAR_STRING.substring(i, i + 1);
            CharUtils.CHAR_ARRAY[i] = new Character((char)i);
        }
    }
}

