/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

public class BitWriter {
    private byte[] bytes = null;
    private int len = 0;
    private int currIndex = -1;
    private int currBit = 8;
    private int count = 0;

    public BitWriter(byte[] byArray) {
        this.bytes = byArray;
        this.len = this.bytes.length;
    }

    public BitWriter(byte[] byArray, int n) {
        this.bytes = byArray;
        this.len = n;
    }

    public int count() {
        return this.count;
    }

    public void putBit(int n) {
        if (this.currBit >= 8) {
            ++this.currIndex;
            this.currBit = 0;
        }
        if ((n & 1) == 1) {
            int n2 = this.currIndex;
            this.bytes[n2] = (byte)(this.bytes[n2] | 1 << 7 - this.currBit);
        }
        ++this.count;
        ++this.currBit;
    }

    public void putInt(int n, int n2) {
        for (int i = n - 1; i >= 0; --i) {
            this.putBit(n2 >> i);
        }
    }

    public void putLong(int n, long l) {
        for (int i = n - 1; i >= 0; --i) {
            this.putBit((int)(l >> i));
        }
    }

    public void alignToByte() {
        if (this.count % 8 > 0) {
            int n = 8 - this.count % 8;
            this.putInt(n, 0);
        }
    }
}

