/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.admin.AdminClientListener;
import com.wowza.wms.admin.AdminMediaCasterListener;
import com.wowza.wms.admin.AdminMediaStreamListener;
import com.wowza.wms.admin.AdminModuleListener;
import com.wowza.wms.admin.AdminSharedObjectListener;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.modeler.Registry;

public class AdminApplicationInstanceListener
implements IApplicationInstanceNotify {
    public static final String APPLICATIONINSTANCE_OBJECTNAME = "applicationInstances=ApplicationInstances,applicationInstanceName=";
    public static final String APPLICATIONINSTANCE_FILTERNAME = "ApplicationInstance";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private Map clientListeners = new HashMap();
    private Map streamListeners = new HashMap();
    private Map sharedObjectListeners = new HashMap();
    private Map moduleListeners = new HashMap();
    private Map mediaCasterListeners = new HashMap();
    private boolean isActive = true;

    public AdminApplicationInstanceListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(APPLICATIONINSTANCE_FILTERNAME.toLowerCase());
    }

    private String getObjectName(IApplicationInstance iApplicationInstance) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + APPLICATIONINSTANCE_OBJECTNAME + iApplicationInstance.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance, this.getObjectName(iApplicationInstance) + ",name=ApplicationInstance", iApplicationInstance.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getProperties(), this.getObjectName(iApplicationInstance) + ",name=Properties", iApplicationInstance.getProperties().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(), this.getObjectName(iApplicationInstance) + ",name=Connections", iApplicationInstance.getConnectionCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(0), this.getObjectName(iApplicationInstance) + ",name=ConnectionsRTMP", iApplicationInstance.getConnectionCounter(0).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(1), this.getObjectName(iApplicationInstance) + ",name=ConnectionsRTP", iApplicationInstance.getConnectionCounter(1).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(2), this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPCupertino", iApplicationInstance.getConnectionCounter(2).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(4), this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPSanJose", iApplicationInstance.getConnectionCounter(4).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getConnectionCounter(3), this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPSmooth", iApplicationInstance.getConnectionCounter(3).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(), this.getObjectName(iApplicationInstance) + ",name=IOPerformance", iApplicationInstance.getIOPerformanceCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(0), this.getObjectName(iApplicationInstance) + ",name=IOPerformanceRTMP", iApplicationInstance.getIOPerformanceCounter(0).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(1), this.getObjectName(iApplicationInstance) + ",name=IOPerformanceRTP", iApplicationInstance.getIOPerformanceCounter(1).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(2), this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPCupertino", iApplicationInstance.getIOPerformanceCounter(2).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(4), this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPSanJose", iApplicationInstance.getIOPerformanceCounter(4).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getIOPerformanceCounter(3), this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPSmooth", iApplicationInstance.getIOPerformanceCounter(3).getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplicationInstance.getMediaCasterStreams().getStreamManager(), this.getObjectName(iApplicationInstance) + ",name=MediaCasterStreamManager", iApplicationInstance.getMediaCasterStreams().getStreamManager().getClass().getName());
            }
            AdminApplicationInstanceListener adminApplicationInstanceListener = this;
            synchronized (adminApplicationInstanceListener) {
                AdminClientListener adminClientListener = new AdminClientListener(this.adminAgent, this.vhost, this.application, iApplicationInstance);
                this.clientListeners.put(iApplicationInstance, adminClientListener);
                iApplicationInstance.addClientListener(adminClientListener);
                AdminMediaStreamListener adminMediaStreamListener = new AdminMediaStreamListener(this.adminAgent, this.vhost, this.application, iApplicationInstance);
                this.streamListeners.put(iApplicationInstance, adminMediaStreamListener);
                iApplicationInstance.addMediaStreamListener(adminMediaStreamListener);
                AdminSharedObjectListener adminSharedObjectListener = new AdminSharedObjectListener(this.adminAgent, this.vhost, this.application, iApplicationInstance);
                this.sharedObjectListeners.put(iApplicationInstance, adminSharedObjectListener);
                iApplicationInstance.addSharedObjectListener(adminSharedObjectListener, false);
                iApplicationInstance.addSharedObjectListener(adminSharedObjectListener, true);
                AdminModuleListener adminModuleListener = new AdminModuleListener(this.adminAgent, this.vhost, this.application, iApplicationInstance);
                this.moduleListeners.put(iApplicationInstance, adminModuleListener);
                iApplicationInstance.addModuleListener(adminModuleListener);
                AdminMediaCasterListener adminMediaCasterListener = new AdminMediaCasterListener(this.adminAgent, this.vhost, this.application, iApplicationInstance);
                this.mediaCasterListeners.put(iApplicationInstance, adminMediaCasterListener);
                iApplicationInstance.addMediaCasterListener(adminMediaCasterListener);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminApplicationInstanceListener.class).error("onApplicationInstanceCreate: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ApplicationInstance");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=Properties");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=Connections");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ConnectionsRTMP");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ConnectionsRTP");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPCupertino");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPSanJose");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=ConnectionsHTTPSmooth");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformance");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformanceRTMP");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformanceRTP");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPCupertino");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPSanJose");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=IOPerformanceHTTPSmooth");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplicationInstance) + ",name=MediaCasterStreamManager");
            }
            AdminClientListener adminClientListener = null;
            AdminMediaStreamListener adminMediaStreamListener = null;
            AdminSharedObjectListener adminSharedObjectListener = null;
            AdminModuleListener adminModuleListener = null;
            AdminMediaCasterListener adminMediaCasterListener = null;
            AdminApplicationInstanceListener adminApplicationInstanceListener = this;
            synchronized (adminApplicationInstanceListener) {
                adminClientListener = (AdminClientListener)this.clientListeners.remove(iApplicationInstance);
                adminMediaStreamListener = (AdminMediaStreamListener)this.streamListeners.remove(iApplicationInstance);
                adminSharedObjectListener = (AdminSharedObjectListener)this.sharedObjectListeners.remove(iApplicationInstance);
                adminModuleListener = (AdminModuleListener)this.moduleListeners.remove(iApplicationInstance);
                adminMediaCasterListener = (AdminMediaCasterListener)this.mediaCasterListeners.remove(iApplicationInstance);
            }
            if (adminClientListener != null) {
                iApplicationInstance.removeClientListener(adminClientListener);
            }
            if (adminMediaStreamListener != null) {
                iApplicationInstance.removeMediaStreamListener(adminMediaStreamListener);
            }
            if (adminModuleListener != null) {
                iApplicationInstance.removeModuleListener(adminModuleListener);
            }
            if (adminMediaCasterListener != null) {
                iApplicationInstance.removeMediaCasterListener(adminMediaCasterListener);
            }
            if (adminSharedObjectListener != null) {
                iApplicationInstance.removeSharedObjectListener(adminSharedObjectListener, false);
                iApplicationInstance.removeSharedObjectListener(adminSharedObjectListener, true);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminApplicationInstanceListener.class).error("onApplicationInstanceDestroy: " + exception.toString());
        }
    }
}

