/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMFObjChunk;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFObj {
    private int id;
    private int size = 0;
    private int type = 20;
    private int src = 0;
    private long timecode = 0L;
    private long absTimecode = 0L;
    private boolean isNew = true;
    private boolean isLongTimecode = false;
    private boolean isLastSentAbsTimecode = false;
    private int objectEncoding = 0;
    private List<AMFObjChunk> chunks = new ArrayList<AMFObjChunk>();
    private int byteContainerLevel = 0;

    public AMFObj(int n) {
        this.id = n;
        this.size = 0;
        this.src = 0;
        this.type = 20;
        this.isNew = true;
    }

    public AMFObj(int n, int n2) {
        this.id = n;
        this.size = 0;
        this.src = 0;
        this.type = 20;
        this.objectEncoding = n2;
        this.isNew = true;
    }

    public List<AMFObjChunk> getChunks() {
        ArrayList<AMFObjChunk> arrayList = new ArrayList<AMFObjChunk>();
        arrayList.addAll(this.chunks);
        return arrayList;
    }

    public void addChunk(byte[] byArray, int n, int n2) {
        this.chunks.add(new AMFObjChunk(byArray, n, n2));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int n) {
        this.src = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("**** amfObj:" + this.id + " ****\n");
        stringBuffer.append("size = " + this.size + "\n");
        stringBuffer.append("type = " + this.type + "\n");
        stringBuffer.append("src = " + this.src + "\n");
        stringBuffer.append("timecode = " + this.timecode + "\n");
        return stringBuffer.toString();
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public long getAbsTimecode() {
        return this.absTimecode;
    }

    public long setAbsTimecodeLong(long l) {
        this.absTimecode = l;
        return this.absTimecode;
    }

    public long setAbsTimecodeShort(long l) {
        this.absTimecode = this.absTimecode & 0xFFFFFFFFFF000000L | l & 0xFFFFFFL;
        return this.absTimecode;
    }

    public long incAbsTimecode(long l) {
        this.absTimecode += l;
        return this.absTimecode;
    }

    public int getByteContainerLevel() {
        return this.byteContainerLevel;
    }

    public void clearByteContainer() {
        this.chunks.clear();
        this.byteContainerLevel = 0;
    }

    public void setByteContainerLevel(int n) {
        this.byteContainerLevel = n;
    }

    public void incByteContainerLevel(int n) {
        this.byteContainerLevel += n;
    }

    public boolean isByteContainerEmpty() {
        return this.byteContainerLevel == 0;
    }

    public boolean isByteContainerFull() {
        return this.byteContainerLevel == this.size;
    }

    public boolean isLongTimecode() {
        return this.isLongTimecode;
    }

    public void setLongTimecode(boolean bl) {
        this.isLongTimecode = bl;
    }

    public boolean isLastSentAbsTimecode() {
        return this.isLastSentAbsTimecode;
    }

    public void setLastSentAbsTimecode(boolean bl) {
        this.isLastSentAbsTimecode = bl;
    }

    public boolean isObjectEncodingAMF3() {
        return this.objectEncoding != 0;
    }

    public boolean isObjectEncodingAMF0() {
        return this.objectEncoding == 0;
    }

    public void setObjectEncoding(int n) {
        this.objectEncoding = n;
    }

    public int getObjectEncoding() {
        return this.objectEncoding;
    }
}

