/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.commandinterface;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import com.wowza.wms.server.ICommandInterfaceCommand;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostItem;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandInterfaceCommandApplicationStatus
implements ICommandInterfaceCommand {
    public static final String COMMAND = "applicationstatus";

    private void addVHost(Server server, Map<String, VHostItem> map, StringBuffer stringBuffer, String string, String string22) {
        boolean bl = server.isVHostRunning(string);
        stringBuffer.append("<VHost>");
        stringBuffer.append("<Name><![CDATA[" + string + "]]></Name>");
        stringBuffer.append("<Status>" + (bl ? "running" : "stopped") + "</Status>");
        IVHost iVHost = VHostSingleton.getInstance(string);
        if (iVHost != null) {
            stringBuffer.append("<Applications>");
            if (string22 == null) {
                List list = iVHost.getApplicationFolderNames();
                for (String string22 : list) {
                    this.addApplication(server, map, stringBuffer, iVHost, string22);
                }
            } else {
                this.addApplication(server, map, stringBuffer, iVHost, string22);
            }
            stringBuffer.append("</Applications>");
        }
        stringBuffer.append("</VHost>");
    }

    private void addApplication(Server server, Map<String, VHostItem> map, StringBuffer stringBuffer, IVHost iVHost, String string) {
        IApplication iApplication;
        stringBuffer.append("<Application>");
        stringBuffer.append("<Name><![CDATA[" + string + "]]></Name>");
        boolean bl = false;
        String string2 = "";
        List list = iVHost.getApplicationNames();
        if (list.contains(string) && (iApplication = iVHost.getApplication(string)) != null) {
            bl = true;
            List<String> list2 = iApplication.getAppInstanceNames();
            for (String string3 : list2) {
                if (string2.length() > 0) {
                    string2 = string2 + "|";
                }
                string2 = string2 + string3;
            }
        }
        stringBuffer.append("<Status>" + (bl ? "running" : "stopped") + "</Status>");
        stringBuffer.append("<AppInstances>" + (string2.length() > 0 ? "<![CDATA[" + string2 + "]]>" : "") + "</AppInstances>");
        stringBuffer.append("</Application>");
    }

    @Override
    public void invoke(CommandInterfaceRequestMessage commandInterfaceRequestMessage, CommandInterfaceResponseMessage commandInterfaceResponseMessage) {
        try {
            String string4 = null;
            String string2 = null;
            String string3 = commandInterfaceRequestMessage.getQueryParam("vhost");
            if (string3 != null) {
                string4 = string3;
            }
            if ((string3 = commandInterfaceRequestMessage.getQueryParam("application")) != null) {
                string2 = string3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Server server = Server.getInstance();
            server.reloadVHostConfig();
            Map<String, VHostItem> map = server.getVHostList().getVHostMap();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuffer.append("<ListWmsApplicationStatusResult>");
            stringBuffer.append("<WmsName>_defaultserver_</WmsName>");
            stringBuffer.append("<VHosts>");
            if (string4 == null) {
                for (String string4 : map.keySet()) {
                    VHostItem vHostItem = server.getVHostList().getVHostMap().get(string4);
                    if (vHostItem == null) continue;
                    this.addVHost(server, map, stringBuffer, string4, null);
                }
            } else {
                this.addVHost(server, map, stringBuffer, string4, string2);
            }
            stringBuffer.append("</VHosts>");
            stringBuffer.append("</ListWmsApplicationStatusResult>");
            if (stringBuffer.length() > 0) {
                String string5 = stringBuffer.toString();
                commandInterfaceResponseMessage.setBody(string5.getBytes("UTF-8"));
            }
            commandInterfaceResponseMessage.setResponseCode(200);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterfaceCommandApplicationStatus.class).warn("CommandInterfaceCommandApplicationStatus.invoke: " + exception.toString());
        }
    }

    @Override
    public boolean canHandle(CommandInterfaceRequestMessage commandInterfaceRequestMessage) {
        return true;
    }
}

