/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.commandinterface;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import com.wowza.wms.server.ICommandInterfaceCommand;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.VHostItem;

public class CommandInterfaceCommandVHostStart
implements ICommandInterfaceCommand {
    public static final String COMMAND = "vhoststart";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(CommandInterfaceRequestMessage commandInterfaceRequestMessage, CommandInterfaceResponseMessage commandInterfaceResponseMessage) {
        try {
            Server server = Server.getInstance();
            String string = commandInterfaceRequestMessage.getQueryParam("vhost");
            if (string == null) {
                WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStart.class).warn("CommandInterfaceCommandVHostStart.invoke: VHost name not specified.");
                commandInterfaceResponseMessage.setResponseCode(400);
                return;
            }
            WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStart.class).info("CommandInterfaceCommandVHostStart.invoke: Start vhost: " + string);
            boolean bl = server.isVHostRunning(string);
            if (!bl) {
                server.reloadVHostConfig();
                VHostItem vHostItem = server.getVHostList().getVHostMap().get(string);
                if (vHostItem == null) {
                    WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStart.class).warn("CommandInterfaceCommandVHostStart.invoke: VHost name not found: " + string);
                    commandInterfaceResponseMessage.setResponseCode(404);
                    return;
                }
                server.startVHost(string);
            }
            commandInterfaceResponseMessage.setResponseCode(200);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStart.class).warn("CommandInterfaceCommandVHostStart.invoke: " + exception.toString());
            commandInterfaceResponseMessage.setResponseCode(500);
        }
    }

    public boolean canHandle(CommandInterfaceRequestMessage commandInterfaceRequestMessage) {
        return true;
    }
}

