/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.commandinterface;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import com.wowza.wms.server.ICommandInterfaceCommand;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.VHostItem;

public class CommandInterfaceCommandVHostStop
implements ICommandInterfaceCommand {
    public static final String COMMAND = "vhoststop";

    public void invoke(CommandInterfaceRequestMessage commandInterfaceRequestMessage, CommandInterfaceResponseMessage commandInterfaceResponseMessage) {
        try {
            Server server = Server.getInstance();
            String string = commandInterfaceRequestMessage.getQueryParam("vhost");
            if (string == null) {
                WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStop.class).warn("CommandInterfaceCommandVHostStop.invoke: VHost name not specified.");
                commandInterfaceResponseMessage.setResponseCode(400);
            }
            WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStop.class).info("CommandInterfaceCommandVHostStop.invoke: Stop vhost: " + string);
            boolean bl = server.isVHostRunning(string);
            if (bl) {
                VHostItem vHostItem = server.getVHostList().getVHostMap().get(string);
                if (vHostItem == null) {
                    WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStop.class).warn("CommandInterfaceCommandVHostStop.invoke: VHost name not found: " + string);
                    commandInterfaceResponseMessage.setResponseCode(404);
                }
                server.stopVHost(string);
            }
            commandInterfaceResponseMessage.setResponseCode(200);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStop.class).warn("CommandInterfaceCommandVHostStart.invoke: " + exception.toString());
            commandInterfaceResponseMessage.setResponseCode(500);
        }
    }

    public boolean canHandle(CommandInterfaceRequestMessage commandInterfaceRequestMessage) {
        return true;
    }
}

