/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.util.BufferUtils;
import com.wowza.wms.dvr.DvrChunkCreator;
import com.wowza.wms.dvr.DvrOnMetadataChunkWriter;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriter;
import com.wowza.wms.parsers.atom.AtomDetailParser;
import com.wowza.wms.parsers.atom.IAtom;
import java.util.List;

public class AtomDebugUtils {
    public static void dumpAtomTree(IAtom iAtom) {
        System.out.println(AtomDebugUtils.formatAtomTree(iAtom));
    }

    public static String formatAtomTree(IAtom iAtom) {
        return AtomDebugUtils.formatAtomTree(iAtom, "");
    }

    public static String formatAtomTree(IAtom iAtom, String string) {
        String string2 = string + AtomDebugUtils.atomToString(iAtom) + "\n";
        List<IAtom> list = iAtom.getAtoms();
        for (IAtom iAtom2 : list) {
            string2 = string2 + AtomDebugUtils.formatAtomTree(iAtom2, "  " + string);
        }
        return string2;
    }

    private static String atomToString(IAtom iAtom) {
        String string = iAtom.toString();
        if ("uuid".equals(iAtom.getId())) {
            string = string.replace("uuid", "uuid - " + AtomDebugUtils.determineUUIDType(iAtom));
        }
        return string;
    }

    private static String determineUUIDType(IAtom iAtom) {
        byte[] byArray = new byte[16];
        System.arraycopy(iAtom.getData(), 0, byArray, 0, 16);
        String string = "unknown";
        if (BufferUtils.startsWith(byArray, SmoothStreamingFragmentWriter.DURATION_GUID_BYTES)) {
            string = "duration";
        } else if (BufferUtils.startsWith(byArray, SmoothStreamingFragmentWriter.READ_AHEAD_GUID_BYTES)) {
            string = "readAhead";
        } else if (BufferUtils.startsWith(byArray, DvrChunkCreator.CODEC_INFO_GUID_BYTES)) {
            string = "codecInfo";
        } else if (BufferUtils.startsWith(byArray, DvrOnMetadataChunkWriter.METADATA_INFO_GUID_BYTES)) {
            string = "metadata";
        } else if (BufferUtils.startsWith(byArray, DvrChunkCreator.DVR_HEADER_INFO_GUID_BYTES)) {
            string = "dvr";
        }
        return string;
    }

    public static void dumpDetailedAtomTree(IAtom iAtom) {
        System.out.println(AtomDebugUtils.formatDetailedAtomTree(iAtom));
    }

    public static String formatDetailedAtomTree(IAtom iAtom) {
        return AtomDebugUtils.formatDetailedAtom(iAtom, "");
    }

    public static String formatDetailedAtom(IAtom iAtom, String string) {
        String string2 = string + AtomDebugUtils.atomToDetailedString(iAtom) + "\n";
        List<IAtom> list = iAtom.getAtoms();
        for (IAtom iAtom2 : list) {
            string2 = string2 + AtomDebugUtils.formatDetailedAtom(iAtom2, "  " + string);
        }
        return string2;
    }

    private static String atomToDetailedString(IAtom iAtom) {
        String string = iAtom.toString();
        String string2 = iAtom.getId();
        byte[] byArray = iAtom.getData();
        if ("uuid".equals(string2)) {
            if (BufferUtils.startsWith(byArray, SmoothStreamingFragmentWriter.DURATION_GUID_BYTES)) {
                return AtomDetailParser.parseUUIDDurationAtom(iAtom).toString();
            }
            if (BufferUtils.startsWith(byArray, SmoothStreamingFragmentWriter.READ_AHEAD_GUID_BYTES)) {
                return AtomDetailParser.parseUUIDReadAheadAtom(iAtom).toString();
            }
            if (BufferUtils.startsWith(byArray, DvrChunkCreator.CODEC_INFO_GUID_BYTES)) {
                return AtomDetailParser.parseUUIDCodecAtom(iAtom).toString();
            }
            if (BufferUtils.startsWith(byArray, DvrChunkCreator.DVR_HEADER_INFO_GUID_BYTES)) {
                return AtomDetailParser.parseUUIDDvrHeader(iAtom).toString();
            }
            if (BufferUtils.startsWith(byArray, DvrOnMetadataChunkWriter.METADATA_INFO_GUID_BYTES)) {
                return AtomDetailParser.parseUUIDMetadataAtom(iAtom).toString();
            }
            return iAtom.toString().replace("uuid", "uuid - unknown GUID type");
        }
        if ("mfhd".equals(string2)) {
            return AtomDetailParser.parseMfrdAtom(iAtom).toString();
        }
        if ("tfhd".equals(string2)) {
            return AtomDetailParser.parseTfhdAtom(iAtom).toString();
        }
        if ("trun".equals(string2)) {
            return AtomDetailParser.parseTrunAtom(iAtom).toString();
        }
        if ("sdtp".equals(string2)) {
            return AtomDetailParser.parseSdtpAtom(iAtom).toString();
        }
        return string;
    }
}

