/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkCreator;
import com.wowza.wms.dvr.DvrOnMetadataChunkWriter;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriter;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.parsers.atom.AtomBytesToTree;
import com.wowza.wms.parsers.atom.AtomDetailParser;
import com.wowza.wms.parsers.atom.IAtom;
import com.wowza.wms.parsers.atom.TrunDataRecord;
import com.wowza.wms.parsers.atom.UUIDCodecInfoData;
import com.wowza.wms.parsers.atom.UUIDDurationData;
import com.wowza.wms.parsers.atom.UUIDMetadataData;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrChunkToAMFPacketParser {
    private static final String CLASSNAME = "DvrChunkToAMFPacketParser";
    private static final int VIDEO_PACKET_DELTA = 5;
    private static final int AUDIO_AAC_PACKET_DELTA = 2;
    private static final int AUDIO_NON_AAC_PACKET_DELTA = 1;
    private static final byte IS_CODEC_CONFIG = 0;
    private static final byte IS_FRAME_DATA = 1;

    public List<AMFPacket> createAMFPacketsFromAVChunk(DvrChunk dvrChunk) {
        ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
        List<RTPPacketFragment> list = dvrChunk.getFragmentList().getFragments();
        for (RTPPacketFragment rTPPacketFragment : list) {
            byte[] byArray = rTPPacketFragment.getBuffer();
            AtomBytesToTree atomBytesToTree = new AtomBytesToTree();
            IAtom iAtom = atomBytesToTree.bytesToAtoms(byArray);
            IAtom iAtom2 = iAtom.getAtom("moof");
            IAtom iAtom3 = iAtom2.getAtom("traf");
            IAtom iAtom4 = iAtom2.getAtom("uuid", DvrChunkCreator.CODEC_INFO_GUID_BYTES);
            int n = 0;
            UUIDCodecInfoData uUIDCodecInfoData = AtomDetailParser.parseUUIDCodecAtom(iAtom4);
            n = uUIDCodecInfoData.type;
            AMFPacket aMFPacket = this.createCodecConfigPacket(uUIDCodecInfoData);
            if (aMFPacket != null) {
                arrayList.add(aMFPacket);
            }
            IAtom iAtom5 = iAtom3.getAtom("uuid", SmoothStreamingFragmentWriter.DURATION_GUID_BYTES);
            UUIDDurationData uUIDDurationData = AtomDetailParser.parseUUIDDurationAtom(iAtom5);
            IAtom iAtom6 = iAtom3.getAtom("sdtp");
            byte[] byArray2 = AtomDetailParser.parseSdtpAtom((IAtom)iAtom6).data;
            IAtom iAtom7 = iAtom3.getAtom("trun");
            List<TrunDataRecord> list2 = AtomDetailParser.parseTrunAtom((IAtom)iAtom7).records;
            long l = uUIDDurationData.startTime;
            long l2 = 0L;
            int n2 = list2.size();
            IAtom iAtom8 = iAtom.getAtom("mdat");
            byte[] byArray3 = iAtom8.getData();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                TrunDataRecord trunDataRecord = list2.get(i);
                int n4 = trunDataRecord.size;
                byte[] byArray4 = null;
                int n5 = 0;
                if (n == 9) {
                    n5 = 5;
                    byArray4 = new byte[n5 + n4];
                    byArray4[0] = (byte)(byArray2[i] == 36 ? 23 : 39);
                    byArray4[1] = 1;
                    BufferUtils.longToByteArray(trunDataRecord.ctts / 10000, byArray4, 2, 3);
                } else if (n == 8) {
                    if (uUIDCodecInfoData.codec == 10) {
                        n5 = 2;
                        byArray4 = new byte[n5 + n4];
                        byArray4[0] = -81;
                        byArray4[1] = 1;
                    } else {
                        n5 = 1;
                        byArray4 = new byte[n5 + n4];
                        byArray4[0] = 0;
                    }
                }
                System.arraycopy(byArray3, n3, byArray4, n5, n4);
                n3 += n4;
                AMFPacket aMFPacket2 = new AMFPacket();
                aMFPacket2.setDataBuffer(byArray4);
                aMFPacket2.setAbsTimecode(l);
                aMFPacket2.setTimecode(l2);
                aMFPacket2.setType(n);
                arrayList.add(aMFPacket2);
                l2 = trunDataRecord.duration / 10000;
                l += l2;
            }
        }
        return arrayList;
    }

    public AMFPacket createAMFPacketFromMetadataChunk(DvrChunk dvrChunk) {
        AMFPacket aMFPacket;
        block2: {
            aMFPacket = null;
            AtomBytesToTree atomBytesToTree = new AtomBytesToTree();
            RTPPacketFragment rTPPacketFragment = dvrChunk.getFragmentList().getFragments().get(0);
            byte[] byArray = rTPPacketFragment.getBuffer();
            IAtom iAtom = atomBytesToTree.bytesToAtoms(byArray);
            IAtom iAtom2 = iAtom.getAtom("moof");
            if (iAtom2 == null) break block2;
            IAtom iAtom3 = iAtom2.getAtom("uuid", DvrOnMetadataChunkWriter.METADATA_INFO_GUID_BYTES);
            System.out.println("metaAtom: " + iAtom3);
            if (iAtom3 != null) {
                int n;
                UUIDMetadataData uUIDMetadataData = AtomDetailParser.parseUUIDMetadataAtom(iAtom3);
                aMFPacket = new AMFPacket();
                byte[] byArray2 = uUIDMetadataData.data;
                if (byArray2 != null && (n = byArray2.length) > 0) {
                    byte[] byArray3 = new byte[n];
                    System.arraycopy(byArray2, 0, byArray3, 0, n);
                    aMFPacket.setDataBuffer(byArray3);
                }
            }
        }
        return aMFPacket;
    }

    private AMFPacket createCodecConfigPacket(UUIDCodecInfoData uUIDCodecInfoData) {
        AMFPacket aMFPacket = null;
        if (uUIDCodecInfoData != null) {
            IMediaCodecInfo iMediaCodecInfo = uUIDCodecInfoData.codecInfo;
            if (iMediaCodecInfo == null) {
                return null;
            }
            byte[] byArray = iMediaCodecInfo.getCodecConfig();
            if (byArray == null) {
                return null;
            }
            int n = byArray.length;
            aMFPacket = new AMFPacket();
            aMFPacket.setType(uUIDCodecInfoData.type);
            byte[] byArray2 = null;
            int n2 = 0;
            if (uUIDCodecInfoData.type == 9) {
                byArray2 = new byte[5 + n];
                byArray2[0] = (byte)(0x10 | uUIDCodecInfoData.codec);
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray2[3] = 0;
                byArray2[4] = 0;
                n2 = 5;
            } else if (uUIDCodecInfoData.type == 8) {
                if (uUIDCodecInfoData.codec == 10) {
                    byArray2 = new byte[2 + n];
                    byArray2[0] = -81;
                    byArray2[1] = 0;
                    n2 = 2;
                } else if (uUIDCodecInfoData.codec == 2) {
                    byArray2 = new byte[1 + n];
                    byArray2[0] = 0;
                    n2 = 1;
                }
            }
            if (n > 0) {
                System.arraycopy(byArray, 0, byArray2, n2, n);
            }
            aMFPacket.setDataBuffer(byArray2);
        }
        return aMFPacket;
    }
}

