/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrPlayerAdapter;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.httpstreamer.cupertinostreaming.dvr.DvrPlayerAdapterCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerAdapterSmoothStreamer;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DvrPlayerAdapterBase
implements IDvrPlayerAdapter {
    private static final Object CLASSNAME = "DvrPlayerAdapterBase";

    @Override
    public boolean isPlaylistReady(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return false;
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterCupertino.class);
        wMSLogger.info(String.format("%s.isPlaylistReady() appInst=%s dvr=%s streamName=%s t=%d", CLASSNAME, iApplicationInstance.getName(), string2, string3, l));
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.isPlaylistReady(iDvrStore, string3, l);
    }

    private boolean isPlaylistReady(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return true;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return true;
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterCupertino.class);
        wMSLogger.info(String.format("%s.isPlaylistReady() dvr=%s streamName=%s t=%d", CLASSNAME, iDvrStore, string, l));
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List<DvrManifestEntry> list = iDvrManifest.getDvrEntriesAtTime(9, l);
        return list.size() > 3;
    }

    @Override
    public boolean isPlaylistEmpty(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return true;
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterCupertino.class);
        wMSLogger.info(String.format("%s.isPlaylistEmpty() appInst=%s dvr=%s streamName=%s t=%d", CLASSNAME, iApplicationInstance.getName(), string2, string3, l));
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.isPlaylistEmpty(iDvrStore, string3, l);
    }

    private boolean isPlaylistEmpty(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return true;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return true;
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterCupertino.class);
        wMSLogger.info(String.format("%s.isPlaylistEmpty() dvr=%s streamName=%s t=%d", CLASSNAME, iDvrStore, string, l));
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List<DvrManifestEntry> list = iDvrManifest.getDvrEntriesAtTime(9, l);
        return list.isEmpty();
    }

    public long calculateDvrRequestTime(Map<String, String> map) {
        long l = 0L;
        if (map.containsKey("delta")) {
            long l2 = 0L;
            String string = map.get("delta");
            try {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info(CLASSNAME + ".calculateDvrRequestTime delta=" + string);
                l2 = Long.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn(String.format("Illegal query param: %s=%s", "delta", string));
            }
            l = l2;
        } else if (map.containsKey("time")) {
            String string = map.get("time");
            try {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info(CLASSNAME + ".calculateDvrRequestTime time=%s" + string);
                l = Long.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn(String.format("Illegal query param: %s=%s", "time", string));
            }
        }
        return l;
    }
}

