/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.io.manifest;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.IDvrTextReader;
import com.wowza.wms.dvr.io.DvrTextReaderFactory;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.dvr.io.manifest.DvrEntryHolder;
import com.wowza.wms.dvr.io.manifest.DvrManifestUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrManifestContainerParser {
    private static final Class<DvrManifestContainerParser> CLASS = DvrManifestContainerParser.class;
    private static final String CLASSNAME = "DvrManifestContainerParser";
    protected IDvrStreamStore store;
    protected IApplicationInstance appInstance;
    protected String readerClass = "com.wowza.wms.dvr.impl.io.DvrTextFileReader";
    protected String contextStr = "";

    public DvrManifestContainerParser(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance) {
        this.store = iDvrStreamStore;
        this.appInstance = iApplicationInstance;
        if (iApplicationInstance != null) {
            this.contextStr = iApplicationInstance.getContextStr();
        }
    }

    private char[] readContainerManifest(String string) {
        char[] cArray = null;
        try {
            String string2 = string + IDvrFileSystem.separator + DvrManifestUtils.createContainerManifestName(string);
            this.readerClass = this.store.getProperties().getPropertyStr("dvrTextReaderClass", this.readerClass);
            IDvrTextReader iDvrTextReader = DvrTextReaderFactory.createInstance(this.appInstance, this.readerClass, this.store.getFileSystem(), string2, null);
            if (iDvrTextReader == null) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readContainerManifest[%s]: Reader class '%s' not found.", CLASSNAME, this.contextStr, this.readerClass));
                return null;
            }
            iDvrTextReader.open();
            cArray = new char[(int)iDvrTextReader.length()];
            int n = iDvrTextReader.read(cArray, 0, cArray.length);
            if (n != cArray.length) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readContainerManifest[%s]: Error reading file: %d != %d ", CLASSNAME, this.contextStr, n, cArray.length));
                return null;
            }
            try {
                iDvrTextReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iDvrTextReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.readContainerManifest: Error reading Manifest file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return cArray;
    }

    public List<DvrEntryHolder> retrieveContainerManifest(String string) {
        ArrayList<DvrEntryHolder> arrayList = new ArrayList();
        try {
            char[] cArray = this.readContainerManifest(string);
            if (cArray == null) {
                WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveContainerManifest: Error reading Manifest.", CLASSNAME));
                return null;
            }
            arrayList = this.parseManifestContainer(cArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveContainerManifest: Error reading Manifest file.", CLASSNAME), exception);
            exception.printStackTrace();
        }
        return arrayList;
    }

    private List<DvrEntryHolder> parseManifestContainer(char[] cArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        ArrayList<DvrEntryHolder> arrayList = new ArrayList<DvrEntryHolder>();
        String string = "<Root>\n" + new String(cArray) + "\n</Root>\n";
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            NodeList nodeList = document.getElementsByTagName("dvrEntry");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    DvrEntryHolder dvrEntryHolder = this.parseDvrEntryNode(node);
                    if (dvrEntryHolder == null) continue;
                    arrayList.add(dvrEntryHolder);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.parseManifestContainer: Error parsing .", CLASSNAME), exception);
        }
        return arrayList;
    }

    private DvrEntryHolder parseDvrEntryNode(Node node) {
        DvrEntryHolder dvrEntryHolder = null;
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = Integer.decode(namedNodeMap.getNamedItem("index").getTextContent());
            int n2 = Integer.decode(namedNodeMap.getNamedItem("type").getTextContent());
            long l = Long.decode(namedNodeMap.getNamedItem("start").getTextContent());
            long l2 = Long.decode(namedNodeMap.getNamedItem("stop").getTextContent());
            int n3 = Integer.decode(namedNodeMap.getNamedItem("size").getTextContent());
            String string = namedNodeMap.getNamedItem("artifact").getTextContent();
            dvrEntryHolder = new DvrEntryHolder(n, n2, l, l2, n3, string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.parseDvrEntryNode: Error parsing entry '%s'.", CLASSNAME, node.getTextContent()), exception);
            dvrEntryHolder = null;
        }
        return dvrEntryHolder;
    }
}

