/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.io.manifest;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunkArtifact;
import com.wowza.wms.dvr.DvrManifestChannelsGroup;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.dvr.io.manifest.DvrEntryHolder;
import com.wowza.wms.dvr.io.manifest.DvrInternalManifest;
import com.wowza.wms.dvr.io.manifest.DvrManifestContainerParser;
import com.wowza.wms.dvr.io.manifest.DvrManifestHolder;
import com.wowza.wms.dvr.io.manifest.DvrPrimaryManifestParser;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrManifestReader {
    private static final Class<DvrManifestReader> CLASS = DvrManifestReader.class;
    private static final String CLASSNAME = "DvrManifestReader";
    private IDvrStreamStore store;
    private IApplicationInstance appInstance;
    private IDvrManifest manifest = new DvrInternalManifest();
    private DvrManifestHolder mainManifestInfo = null;

    public DvrManifestReader(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance) {
        this.store = iDvrStreamStore;
        this.appInstance = iApplicationInstance;
    }

    public IDvrManifest getManifest() {
        return this.manifest;
    }

    public DvrManifestHolder getMainManifestInfo() {
        return this.mainManifestInfo;
    }

    public boolean loadManifestFromFileSystem() {
        boolean bl = false;
        this.manifest = new DvrInternalManifest();
        this.mainManifestInfo = null;
        try {
            DvrPrimaryManifestParser dvrPrimaryManifestParser = new DvrPrimaryManifestParser(this.store, this.appInstance);
            this.mainManifestInfo = dvrPrimaryManifestParser.retrieveManifest();
            if (this.mainManifestInfo != null) {
                DvrManifestContainerParser dvrManifestContainerParser = new DvrManifestContainerParser(this.store, this.appInstance);
                IDvrFileSystem iDvrFileSystem = this.store.getFileSystem();
                String[] stringArray = iDvrFileSystem.listContainers();
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        List<DvrEntryHolder> list = dvrManifestContainerParser.retrieveContainerManifest(string);
                        for (DvrEntryHolder dvrEntryHolder : list) {
                            DvrChunkArtifact dvrChunkArtifact = new DvrChunkArtifact(string, dvrEntryHolder.path, dvrEntryHolder.size);
                            DvrManifestEntry dvrManifestEntry = new DvrManifestEntry(dvrChunkArtifact, dvrEntryHolder.start, dvrEntryHolder.stop, dvrEntryHolder.index, dvrEntryHolder.ty);
                            this.manifest.addToManifest(dvrManifestEntry);
                        }
                    }
                }
                DvrManifestChannelsGroup dvrManifestChannelsGroup = this.manifest.getEntriesToPurge(this.mainManifestInfo.purgeTime);
                this.manifest.purgeChunks(dvrManifestChannelsGroup);
                bl = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading Manifest file.", CLASSNAME), exception);
            exception.printStackTrace();
        }
        return bl;
    }

    private void dumpGroup(String string, DvrManifestChannelsGroup dvrManifestChannelsGroup) {
        System.out.println(string);
        this.dumpEntryList(dvrManifestChannelsGroup.vEntries);
        this.dumpEntryList(dvrManifestChannelsGroup.aEntries);
        this.dumpEntryList(dvrManifestChannelsGroup.dEntries);
        this.dumpEntryList(dvrManifestChannelsGroup.mEntries);
    }

    private void dumpEntryList(List<DvrManifestEntry> list) {
        for (DvrManifestEntry dvrManifestEntry : list) {
            System.out.println("  " + dvrManifestEntry);
        }
    }
}

