/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;

public class HTTPStreamerApplicationContextBase
implements IHTTPStreamerApplicationContext {
    protected IApplicationInstance appInstance = null;
    protected WMSProperties properties = new WMSProperties();
    protected HTTPStreamerItem httpStreamerItem = null;
    protected MediaCasterItem repeaterMediaCasterDef = null;
    protected String streamTypeStr = null;

    public void init(IApplicationInstance iApplicationInstance, HTTPStreamerItem hTTPStreamerItem) {
        this.appInstance = iApplicationInstance;
        this.httpStreamerItem = hTTPStreamerItem;
        this.properties.putAll(hTTPStreamerItem.getProperties());
        this.properties.putAll(iApplicationInstance.getHTTPStreamerProperties());
        this.streamTypeStr = this.properties.getPropertyStr("streamStreamType");
        this.streamTypeStr = this.properties.getPropertyStr("repeaterStreamType", this.streamTypeStr);
        this.repeaterMediaCasterDef = this.getMediaCasterDef(this.streamTypeStr);
    }

    protected MediaCasterItem getMediaCasterDef(String string) {
        MediaCasterItem mediaCasterItem = null;
        try {
            IVHost iVHost = this.appInstance.getVHost();
            StreamList streamList = iVHost.getStreamTypes();
            StreamItem streamItem = streamList.getStreamDef(string);
            String string2 = "httprepeater";
            string2 = streamItem.getProperties().getPropertyStr("mediaCasterType", string2);
            string2 = this.appInstance.getStreamProperties().getPropertyStr("mediaCasterType", string2);
            MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
            mediaCasterItem = mediaCasterList.getMediaCasterDef(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mediaCasterItem;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public HTTPStreamerItem getHTTPStreamerItem() {
        return this.httpStreamerItem;
    }

    public IVHost getVHost() {
        return this.appInstance.getVHost();
    }

    public MediaCasterItem getRepeaterMediaCasterDef() {
        return this.repeaterMediaCasterDef;
    }

    public void setRepeaterMediaCasterDef(MediaCasterItem mediaCasterItem) {
        this.repeaterMediaCasterDef = mediaCasterItem;
    }

    public String getStreamTypeStr() {
        return this.streamTypeStr;
    }

    public void setStreamTypeStr(String string) {
        this.streamTypeStr = string;
    }
}

