/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.h264;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.util.RTPUtils;
import java.util.ArrayList;

public class H264Utils {
    public static final int[][] pixel_aspect = new int[][]{{0, 1}, {1, 1}, {12, 11}, {10, 11}, {16, 11}, {40, 33}, {24, 11}, {20, 11}, {32, 11}, {80, 33}, {18, 11}, {15, 11}, {64, 33}, {160, 99}, {4, 3}, {3, 2}, {2, 1}};
    public static final byte[][] default_scaling4 = new byte[][]{{6, 13, 20, 28, 13, 20, 28, 32, 20, 28, 32, 37, 28, 32, 37, 42}, {10, 14, 20, 24, 14, 20, 24, 27, 20, 24, 27, 30, 24, 27, 30, 34}};
    public static final byte[][] default_scaling8 = new byte[][]{{6, 10, 13, 16, 18, 23, 25, 27, 10, 11, 16, 18, 23, 25, 27, 29, 13, 16, 18, 23, 25, 27, 29, 31, 16, 18, 23, 25, 27, 29, 31, 33, 18, 23, 25, 27, 29, 31, 33, 36, 23, 25, 27, 29, 31, 33, 36, 38, 25, 27, 29, 31, 33, 36, 38, 40, 27, 29, 31, 33, 36, 38, 40, 42}, {9, 13, 15, 17, 19, 21, 22, 24, 13, 13, 17, 19, 21, 22, 24, 25, 15, 17, 19, 21, 22, 24, 25, 27, 17, 19, 21, 22, 24, 25, 27, 28, 19, 21, 22, 24, 25, 27, 28, 30, 21, 22, 24, 25, 27, 28, 30, 32, 22, 24, 25, 27, 28, 30, 32, 33, 24, 25, 27, 28, 30, 32, 33, 35}};
    public static final byte[] zigzag_scan = new byte[]{0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15};
    public static final byte[] zigzag_scan8x8 = new byte[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public static H264CodecConfigInfo decodeAVCC(byte[] byArray) {
        return H264Utils.decodeAVCC(byArray, 0);
    }

    static String levelIDCToString(int n) {
        String string = n / 10 + "." + n % 10;
        if (n == 27) {
            string = "1b";
        }
        return string;
    }

    static String profileIDCToString(int n) {
        String string = "" + n;
        switch (n) {
            case 66: {
                string = "Baseline";
                break;
            }
            case 77: {
                string = "Main";
                break;
            }
            case 88: {
                string = "Extended";
                break;
            }
            case 100: {
                string = "High";
                break;
            }
            case 110: {
                string = "High 10 or High 10 Intra";
                break;
            }
            case 122: {
                string = "High 4:2:2 or High 4:2:2 Intra";
                break;
            }
            case 244: {
                string = "High 4:4:4 predictive or High 4:4:4 Intra";
                break;
            }
            case 44: {
                string = "CAVLC 4:4:4 Intra";
            }
        }
        return string;
    }

    public static byte[] nalUnescape(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2 * 2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        System.arraycopy(byArray, n, byArray3, 0, n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 + 2 < n2) {
            if ((0xFF & byArray2[n3 + 2]) > 3) {
                byArray3[n4++] = byArray2[n3++];
                byArray3[n4++] = byArray2[n3++];
            } else if (byArray2[n3] == 0 && byArray2[n3 + 1] == 0 && byArray2[n3 + 2] == 3) {
                byArray3[n4++] = 0;
                byArray3[n4++] = 0;
                n3 += 3;
                continue;
            }
            byArray3[n4++] = byArray2[n3++];
        }
        return byArray3;
    }

    public static H264CodecConfigInfo decodeAVCC(byte[] byArray, int n) {
        H264CodecConfigInfo h264CodecConfigInfo = new H264CodecConfigInfo();
        try {
            int n2;
            int n3 = n + 6;
            int n4 = BufferUtils.byteArrayToInt(byArray, n3, 2);
            byte[] byArray2 = H264Utils.nalUnescape(byArray, n3 += 2, n4);
            BitReader bitReader = new BitReader(byArray2);
            bitReader.skip(8);
            h264CodecConfigInfo.profileIDC = bitReader.getInt(8);
            bitReader.skip(4);
            bitReader.skip(4);
            h264CodecConfigInfo.levelIDC = bitReader.getInt(8);
            h264CodecConfigInfo.spsID = bitReader.readExpGolomb();
            if (h264CodecConfigInfo.profileIDC >= 100) {
                h264CodecConfigInfo.chromaFormatIDC = bitReader.readExpGolomb();
                h264CodecConfigInfo.residualColorTransformFlag = 0;
                if (h264CodecConfigInfo.chromaFormatIDC == 3) {
                    h264CodecConfigInfo.residualColorTransformFlag = bitReader.getInt(1);
                }
                h264CodecConfigInfo.bitDepthLumaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.bitDepthChromaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.transformBypass = bitReader.getInt(1);
                h264CodecConfigInfo.scalingMatrixFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.scalingMatrixFlag == 1) {
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    if (h264CodecConfigInfo.profileIDC >= 100) {
                        H264Utils.decode_scaling_list(bitReader, 64, default_scaling8[0]);
                        H264Utils.decode_scaling_list(bitReader, 64, default_scaling8[1]);
                    }
                }
            }
            h264CodecConfigInfo.log2MaxFrameNum = bitReader.readExpGolomb() + 4;
            h264CodecConfigInfo.pocType = bitReader.readExpGolomb();
            h264CodecConfigInfo.log2MaxPocLSB = 0;
            if (h264CodecConfigInfo.pocType == 0) {
                h264CodecConfigInfo.log2MaxPocLSB = bitReader.readExpGolomb() + 4;
            } else if (h264CodecConfigInfo.pocType == 1) {
                h264CodecConfigInfo.deltaPicOrderAlwaysZeroFlag = bitReader.getInt(1);
                h264CodecConfigInfo.offsetForNonRefPic = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.offsetForTopToBottomField = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.pocCycleLength = bitReader.readExpGolomb();
                h264CodecConfigInfo.offsetForRefFrame = new int[h264CodecConfigInfo.pocCycleLength];
                for (n2 = 0; n2 < h264CodecConfigInfo.pocCycleLength; ++n2) {
                    h264CodecConfigInfo.offsetForRefFrame[n2] = bitReader.readExpGolombSigned();
                }
            } else if (h264CodecConfigInfo.pocType != 2) {
                // empty if block
            }
            h264CodecConfigInfo.refFrameCount = bitReader.readExpGolomb();
            h264CodecConfigInfo.gapsInFrameNumAllowedFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbWidth = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.mbHeight = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.frameMBSOnlyFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbAFF = 0;
            if (h264CodecConfigInfo.frameMBSOnlyFlag == 0) {
                h264CodecConfigInfo.mbAFF = bitReader.getInt(1);
            }
            h264CodecConfigInfo.adjWidth = h264CodecConfigInfo.mbWidth;
            h264CodecConfigInfo.adjHeight = h264CodecConfigInfo.mbHeight * (2 - h264CodecConfigInfo.frameMBSOnlyFlag);
            h264CodecConfigInfo.direct8x8InferenceFlag = bitReader.getInt(1);
            h264CodecConfigInfo.crop = bitReader.getInt(1);
            h264CodecConfigInfo.cropLeft = 0;
            h264CodecConfigInfo.cropRight = 0;
            h264CodecConfigInfo.cropTop = 0;
            h264CodecConfigInfo.cropBottom = 0;
            if (h264CodecConfigInfo.crop != 0) {
                h264CodecConfigInfo.cropLeft = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropRight = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropTop = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropBottom = bitReader.readExpGolomb();
            }
            h264CodecConfigInfo.vuiParametersPresentFlag = bitReader.getInt(1);
            if (h264CodecConfigInfo.vuiParametersPresentFlag != 0) {
                int n5;
                int n6;
                int n7;
                h264CodecConfigInfo.sarNum = 0;
                h264CodecConfigInfo.sarDen = 0;
                h264CodecConfigInfo.aspectRatioIDC = 0;
                h264CodecConfigInfo.aspectRatioInfoPresentFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.aspectRatioInfoPresentFlag != 0) {
                    h264CodecConfigInfo.aspectRatioIDC = bitReader.getInt(8);
                    if (h264CodecConfigInfo.aspectRatioIDC == 255) {
                        h264CodecConfigInfo.sarNum = bitReader.getInt(16);
                        h264CodecConfigInfo.sarDen = bitReader.getInt(16);
                    } else if (h264CodecConfigInfo.aspectRatioIDC < pixel_aspect.length) {
                        h264CodecConfigInfo.sarNum = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][0];
                        h264CodecConfigInfo.sarDen = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][1];
                    }
                }
                n2 = bitReader.getInt(1);
                int n8 = 0;
                if (n2 != 0) {
                    n8 = bitReader.getInt(1);
                }
                h264CodecConfigInfo.videoSignalTypePresentFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.videoSignalTypePresentFlag != 0) {
                    h264CodecConfigInfo.videoFormat = bitReader.getInt(3);
                    h264CodecConfigInfo.videoFullRange = bitReader.getInt(1);
                    n7 = bitReader.getInt(1);
                    if (n7 != 0) {
                        n6 = bitReader.getInt(8);
                        n5 = bitReader.getInt(8);
                        int n9 = bitReader.getInt(8);
                    }
                }
                if ((n7 = bitReader.getInt(1)) != 0) {
                    n6 = bitReader.readExpGolomb() + 1;
                    n5 = bitReader.readExpGolomb();
                }
                if ((n6 = bitReader.getInt(1)) != 0) {
                    h264CodecConfigInfo.timingNumUnitsInTick = bitReader.getLong(32);
                    h264CodecConfigInfo.timingTimescale = bitReader.getLong(32);
                    h264CodecConfigInfo.timingFixedFrameRateFlag = bitReader.getInt(1);
                    if (h264CodecConfigInfo.timingNumUnitsInTick > 0L && h264CodecConfigInfo.timingTimescale > 0L) {
                        h264CodecConfigInfo.frameRate = (double)Math.round((double)(h264CodecConfigInfo.timingTimescale * 100L) / (double)(h264CodecConfigInfo.timingNumUnitsInTick * 2L)) / 100.0;
                    }
                }
            }
            h264CodecConfigInfo.height = 0;
            h264CodecConfigInfo.width = 16 * h264CodecConfigInfo.mbWidth - 2 * (h264CodecConfigInfo.cropLeft + h264CodecConfigInfo.cropRight);
            h264CodecConfigInfo.height = h264CodecConfigInfo.frameMBSOnlyFlag != 0 ? 16 * h264CodecConfigInfo.adjHeight - 2 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom) : 16 * h264CodecConfigInfo.adjHeight - 4 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom);
            h264CodecConfigInfo.displayHeight = h264CodecConfigInfo.height;
            h264CodecConfigInfo.displayWidth = h264CodecConfigInfo.width;
            if (h264CodecConfigInfo.sarNum > 0 && h264CodecConfigInfo.sarDen > 0) {
                h264CodecConfigInfo.displayWidth = h264CodecConfigInfo.width * h264CodecConfigInfo.sarNum / h264CodecConfigInfo.sarDen;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(H264Utils.class).error("H264CodecConfigInfo.decodeAVCC: " + exception.toString());
            exception.printStackTrace();
        }
        return h264CodecConfigInfo;
    }

    static void decode_scaling_list(BitReader bitReader, int n, byte[] byArray) {
        byte[] byArray2 = n == 16 ? zigzag_scan : zigzag_scan8x8;
        int n2 = bitReader.getInt(1);
        if (n2 == 1) {
            int n3 = 8;
            int n4 = 8;
            for (int i = 0; i < n; ++i) {
                if (n3 != 0) {
                    int n5 = bitReader.readExpGolombSigned();
                    n3 = n4 + n5 & 0xFF;
                }
                if (i == 0 && n3 == 0) break;
                byte by = (byte)(n3 != 0 ? n3 : n4);
                byArray[byArray2[i]] = by;
                n4 = by;
            }
        }
    }

    public static H264CodecConfigParts breakApartAVCC(byte[] byArray, int n, int n2) {
        H264CodecConfigParts h264CodecConfigParts;
        block4: {
            h264CodecConfigParts = new H264CodecConfigParts();
            try {
                int n3 = 1;
                if (n3 + 3 > n2) break block4;
                h264CodecConfigParts.profileLevel = new byte[3];
                System.arraycopy(byArray, n + n3, h264CodecConfigParts.profileLevel, 0, h264CodecConfigParts.profileLevel.length);
                n3 += h264CodecConfigParts.profileLevel.length;
                if ((n3 += 2) + 2 > n2) break block4;
                int n4 = BufferUtils.byteArrayToInt(byArray, n + n3, 2);
                if (n4 <= 0 || n4 > n2 - (n3 += 2)) break block4;
                h264CodecConfigParts.sps = new byte[n4];
                System.arraycopy(byArray, n + n3, h264CodecConfigParts.sps, 0, h264CodecConfigParts.sps.length);
                if ((n3 += h264CodecConfigParts.sps.length) + 1 > n2) break block4;
                int n5 = BufferUtils.byteArrayToInt(byArray, n + n3, 1);
                ++n3;
                for (int i = 0; i < n5 && n3 + 2 <= n2; ++i) {
                    int n6 = BufferUtils.byteArrayToInt(byArray, n + n3, 2);
                    if (n6 > 0 && n6 <= n2 - (n3 += 2)) {
                        byte[] byArray2 = new byte[n6];
                        System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
                        n3 += byArray2.length;
                        h264CodecConfigParts.addPPS(byArray2);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return h264CodecConfigParts;
    }

    public static RTPPacketFragmentList breakH264PacketIntoDelimitedNALUnits(byte[] byArray, int n, int n2, int n3, H264CodecConfigParts h264CodecConfigParts) {
        int n4;
        RTPPacketFragmentList rTPPacketFragmentList = new RTPPacketFragmentList();
        int n5 = n2;
        byte[] byArray2 = new byte[4];
        byArray2[3] = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n8 + 4 <= n5 && (n4 = BufferUtils.byteArrayToInt(byArray, n + n8, 4)) > 0 && (n8 += 4) + n4 <= n5) {
            int n9 = byArray[n + n8] & 0x1F;
            if (n9 == 7) {
                bl = true;
            } else if (n9 == 8) {
                bl2 = true;
            } else if (n9 == 9) {
                bl3 = true;
            }
            rTPPacketFragmentList.addPacketFragment(new RTPPacketFragment(byArray2, 0, byArray2.length));
            rTPPacketFragmentList.addPacketFragment(new RTPPacketFragment(byArray, n + n8, n4));
            n6 += n4 + byArray2.length;
            ++n7;
            if ((n8 += n4) < n5) continue;
            break;
        }
        n4 = 0;
        if (!bl3) {
            if (!bl3) {
                byte[] byArray3 = new byte[6];
                byArray3[3] = 1;
                byArray3[4] = 9;
                byArray3[5] = n3 == 1 ? 16 : (n3 == 3 ? 80 : 48);
                rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray3, 0, byArray3.length));
                ++n4;
                n6 += byArray3.length;
                ++n7;
            }
        } else {
            n4 += 2;
        }
        if (!(n3 != 1 || bl2 && bl3)) {
            if (n3 == 1 && !bl && h264CodecConfigParts != null && h264CodecConfigParts.sps != null) {
                byte[] byArray4 = new byte[4];
                byArray4[3] = 1;
                rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray4, 0, byArray4.length));
                rTPPacketFragmentList.addPacketFragment(++n4, new RTPPacketFragment(h264CodecConfigParts.sps, 0, h264CodecConfigParts.sps.length));
                ++n4;
                n6 += h264CodecConfigParts.sps.length + byArray4.length;
                ++n7;
            }
            if (n3 == 1 && !bl2 && h264CodecConfigParts != null && h264CodecConfigParts.ppss != null) {
                for (byte[] byArray5 : h264CodecConfigParts.ppss) {
                    byte[] byArray6 = new byte[4];
                    byArray6[3] = 1;
                    rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray6, 0, byArray6.length));
                    rTPPacketFragmentList.addPacketFragment(++n4, new RTPPacketFragment(byArray5, 0, byArray5.length));
                    ++n4;
                    n6 += byArray5.length + byArray6.length;
                    ++n7;
                }
            }
        }
        return rTPPacketFragmentList;
    }

    public static final byte[] codecConfigInfoToAVCC(RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo) {
        if (rTPPacketCodecConfigInfo.sps != null && rTPPacketCodecConfigInfo.ppss != null) {
            return RTPUtils.formatH264CodecConfig(rTPPacketCodecConfigInfo.sps, rTPPacketCodecConfigInfo.ppss, null);
        }
        return null;
    }

    public static final byte[] codecConfigInfoToAVCC(RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo, byte[] byArray) {
        if (rTPPacketCodecConfigInfo.sps != null && rTPPacketCodecConfigInfo.ppss != null) {
            return RTPUtils.formatH264CodecConfig(rTPPacketCodecConfigInfo.sps, rTPPacketCodecConfigInfo.ppss, byArray);
        }
        return null;
    }

    public static final byte[] fixH264VideoNALLenStartcodeMix(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl = false;
        byte[] byArray2 = byArray;
        int n6 = 0;
        while ((n5 = BufferUtils.byteArrayToInt(byArray, n + n6, 4)) >= 0 && n6 + n5 + 4 <= n2) {
            n4 = byArray[n + n6 + 4] & 0x1F;
            switch (n4) {
                case 9: {
                    if (n5 != n2 - (n6 + 4)) break;
                    bl = true;
                    break;
                }
                case 8: {
                    if (n5 != n2 - (n6 + 4)) break;
                    bl = true;
                }
            }
            if (!bl && (n6 += n5 + 4) < n2) continue;
            break;
        }
        if (bl) {
            if (n3 == 4) {
                n5 = n6;
                while (n6 < n2 - 4) {
                    if (byArray[n + n6 + 0] == 0 && byArray[n + n6 + 1] == 0 && byArray[n + n6 + 2] == 0 && byArray[n + n6 + 3] == 1) {
                        n4 = n6 - n5 - 4;
                        BufferUtils.intToByteArray(n4, byArray, n + n5, 4);
                        n5 = n6;
                    }
                    ++n6;
                }
                n4 = n2 - n5 - 4;
                BufferUtils.intToByteArray(n4, byArray, n + n5, 4);
            } else if (n3 == 3) {
                int[] nArray;
                int n7;
                n5 = 0;
                n4 = n6++;
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                int n8 = n6;
                while (n6 < n2 - 3) {
                    if (byArray[n + n6 + 0] == 0 && byArray[n + n6 + 1] == 0 && byArray[n + n6 + 2] == 1) {
                        ++n5;
                        n7 = n6 - n8 - 3;
                        nArray = new int[]{n8 + 3, n7};
                        arrayList.add(nArray);
                        n8 = n6;
                    }
                    ++n6;
                }
                n7 = n2 - n8 - 3;
                nArray = new int[]{n8 + 3, n7};
                arrayList.add(nArray);
                byArray2 = new byte[n + n2 + n5];
                System.arraycopy(byArray, 0, byArray2, 0, n + n4);
                n6 = n4;
                for (int[] nArray2 : arrayList) {
                    BufferUtils.intToByteArray(nArray2[1], byArray2, n + n6, 4);
                    System.arraycopy(byArray, n + nArray2[0], byArray2, n + (n6 += 4), nArray2[1]);
                    n6 += nArray2[1];
                }
            }
        }
        return byArray2;
    }

    public static final int extractFrameType(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 2;
        int n5 = 0;
        while ((n3 = BufferUtils.byteArrayToInt(byArray, n + n5, 4)) >= 0 && n5 + n3 + 4 <= n2) {
            int n6 = byArray[n + n5 + 4] & 0x1F;
            switch (n6) {
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    if (n3 < 2) break;
                    if (byArray[n + n5 + 5] == 16) {
                        n4 = 1;
                        break;
                    }
                    if (byArray[n + n5 + 5] != 80) break;
                    n4 = 3;
                    break;
                }
                case 5: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    byte[] byArray2 = new byte[20];
                    byte[] byArray3 = new byte[20];
                    int n7 = byArray2.length;
                    if (n7 > n3 - 1) {
                        n7 = n3 - 1;
                    }
                    System.arraycopy(byArray, n + n5 + 5, byArray2, 0, n7);
                    int n8 = 0;
                    for (int i = 0; i < n7; ++i) {
                        if (i >= 2 && byArray2[i] == 3 && byArray2[i - 1] == 0 && byArray2[i - 2] == 0) continue;
                        byArray3[n8] = byArray2[i];
                        ++n8;
                    }
                    BitReader bitReader = new BitReader(byArray3, n8);
                    int n9 = bitReader.readExpGolomb();
                    int n10 = bitReader.readExpGolomb();
                    if (n10 == 2 || n10 == 7) {
                        n4 = 1;
                        break;
                    }
                    if (n10 != 1 && n10 != 6) break;
                    n4 = 3;
                }
            }
            if ((n5 += n3 + 4) < n2) continue;
            break;
        }
        return n4;
    }

    public static final RTPPacketCodecConfigInfo extractCodecConfigFromFrame(byte[] byArray, int n, int n2) {
        int n3;
        RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = null;
        int n4 = 0;
        while ((n3 = BufferUtils.byteArrayToInt(byArray, n + n4, 4)) >= 0 && n4 + n3 + 4 <= n2) {
            int n5 = byArray[n + n4 + 4] & 0x1F;
            switch (n5) {
                case 7: {
                    if (rTPPacketCodecConfigInfo == null) {
                        rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                    }
                    rTPPacketCodecConfigInfo.sps = new byte[n3];
                    System.arraycopy(byArray, n + n4 + 4, rTPPacketCodecConfigInfo.sps, 0, n3);
                    break;
                }
                case 8: {
                    if (rTPPacketCodecConfigInfo == null) {
                        rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                    }
                    if (rTPPacketCodecConfigInfo.ppss == null) {
                        rTPPacketCodecConfigInfo.ppss = new ArrayList<byte[]>();
                    }
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n + n4 + 4, byArray2, 0, n3);
                    rTPPacketCodecConfigInfo.ppss.add(byArray2);
                }
            }
            if ((n4 += n3 + 4) < n2) continue;
            break;
        }
        return rTPPacketCodecConfigInfo;
    }

    public static final byte[] configPartsToSmoothPrivateData(H264CodecConfigParts h264CodecConfigParts) {
        Object object;
        int n = 0;
        n += h264CodecConfigParts.sps != null ? 4 + h264CodecConfigParts.sps.length : 0;
        if (h264CodecConfigParts.ppss != null) {
            object = h264CodecConfigParts.ppss.iterator();
            while (object.hasNext()) {
                byte[] byArray = (byte[])object.next();
                n += 4 + byArray.length;
            }
        }
        object = new byte[n];
        int n2 = 0;
        if (h264CodecConfigParts.sps != null) {
            object[n2 + 3] = true;
            System.arraycopy(h264CodecConfigParts.sps, 0, object, n2 += 4, h264CodecConfigParts.sps.length);
            n2 += h264CodecConfigParts.sps.length;
        }
        if (h264CodecConfigParts.ppss != null) {
            for (byte[] byArray : h264CodecConfigParts.ppss) {
                object[n2 + 3] = true;
                System.arraycopy(byArray, 0, object, n2 += 4, byArray.length);
                n2 += byArray.length;
            }
        }
        return object;
    }

    public static String nalUnitTypeToStr(int n) {
        String string = "" + n;
        switch (n) {
            case 1: {
                string = "SLICE";
                break;
            }
            case 2: {
                string = "DPA";
                break;
            }
            case 3: {
                string = "DPB";
                break;
            }
            case 4: {
                string = "DPC";
                break;
            }
            case 5: {
                string = "IDR_SLICE";
                break;
            }
            case 6: {
                string = "SEI";
                break;
            }
            case 7: {
                string = "SPS";
                break;
            }
            case 8: {
                string = "PPS";
                break;
            }
            case 9: {
                string = "AUD";
                break;
            }
            case 10: {
                string = "END_SEQUENCE";
                break;
            }
            case 11: {
                string = "END_STREAM";
                break;
            }
            case 12: {
                string = "FILLER_DATA";
                break;
            }
            default: {
                string = n >= 13 && n <= 23 ? "EXTENDED[" + n + "]" : "UNDEFINED[" + n + "]";
            }
        }
        return string;
    }

    public static final void debugNALUntits(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 2;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(null);
        wMSLogger.info("debugNALUntits: start: " + n2);
        int n5 = 0;
        while ((n3 = BufferUtils.byteArrayToInt(byArray, n + n5, 4)) >= 0 && n5 + n3 + 4 <= n2) {
            int n6 = byArray[n + n5 + 4] & 0x1F;
            wMSLogger.info("debugNALUntits:   nalType[" + H264Utils.nalUnitTypeToStr(n6) + "]: " + n3);
            switch (n6) {
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    if (n3 < 2) break;
                    if (byArray[n + n5 + 5] == 16) {
                        n4 = 1;
                        break;
                    }
                    if (byArray[n + n5 + 5] != 80) break;
                    n4 = 3;
                    break;
                }
                case 5: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    byte[] byArray2 = new byte[20];
                    byte[] byArray3 = new byte[20];
                    int n7 = byArray2.length;
                    if (n7 > n3 - 1) {
                        n7 = n3 - 1;
                    }
                    System.arraycopy(byArray, n + n5 + 5, byArray2, 0, n7);
                    int n8 = 0;
                    for (int i = 0; i < n7; ++i) {
                        if (i >= 2 && byArray2[i] == 3 && byArray2[i - 1] == 0 && byArray2[i - 2] == 0) continue;
                        byArray3[n8] = byArray2[i];
                        ++n8;
                    }
                    BitReader bitReader = new BitReader(byArray3, n8);
                    int n9 = bitReader.readExpGolomb();
                    int n10 = bitReader.readExpGolomb();
                    wMSLogger.info("debugNALUntits:     sliceType: " + n10);
                    if (n10 == 2 || n10 == 7) {
                        n4 = 1;
                        break;
                    }
                    if (n10 != 1 && n10 != 6) break;
                    n4 = 3;
                }
            }
            if ((n5 += n3 + 4) < n2) continue;
            break;
        }
        wMSLogger.info("debugNALUntits: frameType: " + FLVUtils.frameTypeToString(n4));
    }
}

