/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FramePrivate
extends ID3V2FrameBase {
    private String ownerIdentifier = null;
    private byte[] data = null;

    public ID3V2FramePrivate(String string, int n) {
        super(string, n);
    }

    public ID3V2FramePrivate() {
        super("PRIV", 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            int n3 = ID3V2FramePrivate.serializeString(this.ownerIdentifier, byArray, n + n2);
            n2 += n3;
            if (this.data != null) {
                System.arraycopy(this.data, 0, byArray, n + n2, this.data.length);
                n2 += this.data.length;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FramePRIV.deserializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            String string = ID3V2FramePrivate.deserializeString(byArray, n, n2);
            if (string != null) {
                this.ownerIdentifier = string;
                int n3 = n2 - (n += string.length() + 1);
                if (n3 > 0) {
                    this.data = new byte[n3];
                    System.arraycopy(byArray, n, this.data, 0, n3);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameBase.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return 1 + ID3V2FramePrivate.serializeStringLen(this.ownerIdentifier) + (this.data == null ? 0 : this.data.length);
    }
}

