/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.util.FileUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaWriterActionNotify;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleMediaWriterFileMover
extends ModuleBase
implements IMediaWriterActionNotify {
    String fileMoverDestinationPath = null;
    String fileMoverFileExtension = null;
    boolean fileMoverVersionFile = true;
    boolean fileMoverDeleteOriginal = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        iApplicationInstance.addMediaWriterListener(this);
        ModuleMediaWriterFileMover.getLogger().info("ModuleMediaWriterFileMover.onAppStart: " + iApplicationInstance.getContextStr());
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.fileMoverDestinationPath = wMSProperties.getPropertyStr("fileMoverDestinationPath", this.fileMoverDestinationPath);
        this.fileMoverFileExtension = wMSProperties.getPropertyStr("fileMoverFileExtension", this.fileMoverFileExtension);
        this.fileMoverVersionFile = wMSProperties.getPropertyBoolean("fileMoverVersionFile", this.fileMoverVersionFile);
        this.fileMoverDeleteOriginal = wMSProperties.getPropertyBoolean("fileMoverDeleteOriginal", this.fileMoverDeleteOriginal);
    }

    private String getExtension(IMediaStream iMediaStream, String string) {
        if (string == null) {
            String string2 = iMediaStream.getExt().toLowerCase();
            MediaReaderItem mediaReaderItem = iMediaStream.getStreams().getVHost().getMediaReaders().getMediaReaderDef(string2);
            return mediaReaderItem.getFileExtension();
        }
        return string;
    }

    @Override
    public void onWriteComplete(IMediaStream iMediaStream, File file) {
        if (this.fileMoverDestinationPath != null) {
            String string = FileUtils.toValidFilename(iMediaStream.getName());
            String string2 = this.getExtension(iMediaStream, this.fileMoverFileExtension);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            hashMap.put("com.wowza.wms.context.StreamName", string);
            String string3 = SystemUtils.expandEnvironmentVariables(this.fileMoverDestinationPath, hashMap);
            if (this.fileMoverDestinationPath.indexOf("com.wowza.wms.context.StreamName") < 0) {
                string3 = string3 + "/" + string + "." + string2;
            }
            File file2 = new File(string3);
            ModuleMediaWriterFileMover.getLogger().info("ModuleMediaWriterFileMover.onWriteComplete: from: " + file + " to:" + file2);
            try {
                file2.getParentFile().mkdirs();
            }
            catch (Exception exception) {
                ModuleMediaWriterFileMover.getLogger().warn("ModuleMediaWriterFileMover.onWriteComplete[mkdir]: [" + file2 + "]: " + exception.toString());
            }
            try {
                if (file2.exists()) {
                    if (this.fileMoverVersionFile) {
                        FileUtils.versionFile(file2);
                    } else {
                        file2.delete();
                    }
                }
            }
            catch (Exception exception) {
                ModuleMediaWriterFileMover.getLogger().warn("ModuleMediaWriterFileMover.onWriteComplete[version]: [" + file2 + "]: " + exception.toString());
            }
            try {
                FileUtils.copyFile2(file, file2);
            }
            catch (Exception exception) {
                ModuleMediaWriterFileMover.getLogger().warn("ModuleMediaWriterFileMover.onWriteComplete[version]: [" + file2 + "]: " + exception.toString());
            }
            try {
                if (this.fileMoverDeleteOriginal && file2.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                ModuleMediaWriterFileMover.getLogger().warn("ModuleMediaWriterFileMover.onWriteComplete[delOrig]: [" + file2 + "]: " + exception.toString());
            }
        }
    }

    @Override
    public void onFLVAddMetadata(IMediaStream iMediaStream, Map<String, Object> map) {
    }
}

