/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.parsers.atom;

import com.wowza.util.BufferUtils;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoBase;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.parsers.atom.IAtom;
import com.wowza.wms.parsers.atom.MfhdData;
import com.wowza.wms.parsers.atom.SdtpData;
import com.wowza.wms.parsers.atom.TfhdData;
import com.wowza.wms.parsers.atom.TrunData;
import com.wowza.wms.parsers.atom.TrunDataRecord;
import com.wowza.wms.parsers.atom.UUIDCodecInfoData;
import com.wowza.wms.parsers.atom.UUIDDurationData;
import com.wowza.wms.parsers.atom.UUIDDvrHeaderData;
import com.wowza.wms.parsers.atom.UUIDMetadataData;
import com.wowza.wms.parsers.atom.UUIDReadAheadData;
import java.util.ArrayList;

public class AtomDetailParser {
    public static UUIDDurationData parseUUIDDurationAtom(IAtom iAtom) {
        byte[] byArray = iAtom.getData();
        int n = 20;
        long l = BufferUtils.byteArrayToLong(byArray, n, 8);
        long l2 = BufferUtils.byteArrayToLong(byArray, n += 8, 8);
        n += 8;
        return new UUIDDurationData(l2, l);
    }

    public static UUIDReadAheadData parseUUIDReadAheadAtom(IAtom iAtom) {
        byte[] byArray = iAtom.getData();
        int n = 20;
        int n2 = BufferUtils.byteArrayToInt(byArray, n, 1);
        ++n;
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = BufferUtils.byteArrayToLong(byArray, n, 8);
            lArray2[i] = BufferUtils.byteArrayToLong(byArray, n += 8, 8);
            n += 8;
        }
        return new UUIDReadAheadData(lArray, lArray2);
    }

    public static SdtpData parseSdtpAtom(IAtom iAtom) {
        byte[] byArray = iAtom.getData();
        int n = byArray.length - 4;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 4, byArray2, 0, n);
        return new SdtpData(byArray2);
    }

    public static TrunData parseTrunAtom(IAtom iAtom) {
        ArrayList<TrunDataRecord> arrayList = new ArrayList<TrunDataRecord>();
        byte[] byArray = iAtom.getData();
        int n = 4;
        int n2 = BufferUtils.byteArrayToInt(byArray, n, 4);
        n += 4;
        for (int i = 0; i < n2; ++i) {
            int n3 = BufferUtils.byteArrayToInt(byArray, n, 4);
            int n4 = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
            int n5 = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
            n += 4;
            arrayList.add(new TrunDataRecord(n3, n4, n5));
        }
        return new TrunData(arrayList);
    }

    public static MfhdData parseMfrdAtom(IAtom iAtom) {
        byte[] byArray = iAtom.getData();
        int n = 4;
        int n2 = BufferUtils.byteArrayToInt(byArray, n, 4);
        return new MfhdData(n2);
    }

    public static TfhdData parseTfhdAtom(IAtom iAtom) {
        byte[] byArray = iAtom.getData();
        int n = 4;
        int n2 = BufferUtils.byteArrayToInt(byArray, n, 4);
        return new TfhdData(n2);
    }

    public static UUIDCodecInfoData parseUUIDCodecAtom(IAtom iAtom) {
        UUIDCodecInfoData uUIDCodecInfoData = null;
        int n = 0;
        if (iAtom != null) {
            byte[] byArray = iAtom.getData();
            if (byArray == null) {
                return null;
            }
            int n2 = BufferUtils.byteArrayToInt(byArray, n += 20, 2);
            int n3 = BufferUtils.byteArrayToInt(byArray, n += 2, 4);
            int n4 = BufferUtils.byteArrayToInt(byArray, n += 4, 2);
            n += 2;
            MediaCodecInfoBase mediaCodecInfoBase = null;
            if (n4 > 0) {
                if (n2 == 8) {
                    mediaCodecInfoBase = new MediaCodecInfoAudio();
                    mediaCodecInfoBase.deserialize(byArray, n, n4);
                } else if (n2 == 9) {
                    mediaCodecInfoBase = new MediaCodecInfoVideo();
                    mediaCodecInfoBase.deserialize(byArray, n, n4);
                }
                n += n4;
            }
            uUIDCodecInfoData = new UUIDCodecInfoData(n2, n3, mediaCodecInfoBase);
        }
        return uUIDCodecInfoData;
    }

    public static UUIDMetadataData parseUUIDMetadataAtom(IAtom iAtom) {
        UUIDMetadataData uUIDMetadataData = null;
        int n = 0;
        if (iAtom != null) {
            byte[] byArray = iAtom.getData();
            if (byArray == null) {
                return null;
            }
            int n2 = BufferUtils.byteArrayToInt(byArray, n += 20, 4);
            n += 4;
            byte[] byArray2 = new byte[n2];
            if (n2 > 0) {
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            uUIDMetadataData = new UUIDMetadataData(byArray2);
        }
        return uUIDMetadataData;
    }

    public static UUIDDvrHeaderData parseUUIDDvrHeader(IAtom iAtom) {
        UUIDDvrHeaderData uUIDDvrHeaderData = null;
        int n = 0;
        if (iAtom != null) {
            byte[] byArray = iAtom.getData();
            if (byArray == null) {
                return null;
            }
            long l = BufferUtils.byteArrayToLong(byArray, n += 20, 8);
            long l2 = BufferUtils.byteArrayToLong(byArray, n += 8, 8);
            long l3 = BufferUtils.byteArrayToLong(byArray, n += 8, 8);
            int n2 = BufferUtils.byteArrayToInt(byArray, n += 8, 4);
            int n3 = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
            n += 4;
            uUIDDvrHeaderData = new UUIDDvrHeaderData(l, l2, l3, n2, n3);
        }
        return uUIDDvrHeaderData;
    }
}

