/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.NetworkUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.IUDPTransportSession;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMinaSession;
import com.wowza.wms.transport.udp.IUDPTransportOutgoingConnection;
import com.wowza.wms.vhost.IVHost;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ByteBuffer;

public class RTPPort
implements IUDPMessageHandler {
    private RTPTrack track = null;
    private String inIpAddress = "127.0.0.1";
    private String outIpAddress = "127.0.0.1";
    private int inPort = -1;
    private int outPort = -1;
    private IRTPMessageHandler handler = null;
    private boolean isInMulticast = false;
    private boolean isOutMulticast = false;
    private boolean isMulticast = false;
    private int ttl = 63;
    private int addressCount = 1;
    private InetSocketAddress socketAddr = null;
    private IUDPTransportSession session = null;
    private IUDPTransportOutgoingConnection outgoingConnection = null;
    private int blockStreamingOut = 0;

    public RTPPort(String string, int n, String string2, int n2, boolean bl) {
        this.inIpAddress = string;
        this.inPort = n;
        this.outIpAddress = string2;
        this.outPort = n2;
        this.isMulticast = bl;
        this.isInMulticast = NetworkUtils.isAddressMulticast(this.inIpAddress);
        this.isOutMulticast = NetworkUtils.isAddressMulticast(this.outIpAddress);
    }

    public RTPTrack getTrack() {
        return this.track;
    }

    public void setTrack(RTPTrack rTPTrack) {
        this.track = rTPTrack;
    }

    public IUDPTransport getUDPTransport() {
        return this.track.getRTPStream().getUDPTransport(this.isMulticast);
    }

    public String getInIpAddress() {
        return this.inIpAddress;
    }

    public String getOutIpAddress() {
        return this.outIpAddress;
    }

    public int getInPort() {
        return this.inPort;
    }

    public int getOutPort() {
        return this.outPort;
    }

    public void bind(int n) {
        try {
            Object object;
            if (this.socketAddr != null) {
                this.unbind();
            }
            IUDPTransport iUDPTransport = this.getUDPTransport();
            IVHost iVHost = this.track.getVHost();
            iUDPTransport.setRTPContext(iVHost.getRTPContext());
            iUDPTransport.setTimeToLive(this.ttl);
            InetAddress inetAddress = null;
            try {
                String string;
                object = this.track.getRTPStream().getAppInstance();
                if (object != null && (string = object.getRTPProperties().getPropertyStr("multicastInterfaceAddress", null)) != null) {
                    inetAddress = InetAddress.getByName(string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPPort.class).warn("RTSPPort.bind: multicastInterfaceAddress: " + exception.toString());
            }
            iUDPTransport.setMulticastInterfaceAddress(inetAddress);
            object = null;
            object = n == 1 ? iVHost.getRTPDatagramConfigIncoming() : iVHost.getRTPDatagramConfigOutgoing();
            this.socketAddr = iUDPTransport.bind((RTPUDPDatagramConfig)((Object)object), this, this.inIpAddress, this.inPort, this.outIpAddress, this.outPort, n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.bind: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        try {
            if (this.socketAddr != null) {
                IUDPTransport iUDPTransport = this.getUDPTransport();
                iUDPTransport.unbind(this.socketAddr);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.unbind: " + exception.toString());
        }
        finally {
            this.socketAddr = null;
        }
    }

    public void shutdown() {
        this.unbind();
    }

    public synchronized IRTPMessageHandler getHandler() {
        return this.handler;
    }

    public synchronized void setHandler(IRTPMessageHandler iRTPMessageHandler) {
        this.handler = iRTPMessageHandler;
    }

    public void sendMessage(byte[] byArray, int n, int n2) {
        try {
            if (this.outgoingConnection != null) {
                this.outgoingConnection.sendMessage(byArray, n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendResponse(byte[] byArray) {
        this.sendResponse(byArray, 0, byArray.length, null);
    }

    public void sendResponse(byte[] byArray, int n, int n2) {
        this.sendResponse(byArray, n, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void sendResponse(byte[] byArray, int n, int n2, SocketAddress socketAddress) {
        block10: {
            block9: {
                RTPPort rTPPort = this;
                // MONITORENTER : rTPPort
                if (this.session == null) {
                    WMSLoggerFactory.getLogger(RTPPort.class).debug("RTSPPort.sendResponse: No session");
                    return;
                }
                if (this.blockStreamingOut < 0) break block9;
                if (this.blockStreamingOut != 0) break block10;
                RTPStream rTPStream = this.track.getRTPStream();
                if (rTPStream.isModePlay() && rTPStream.isForceRTSPInterleaved()) {
                    this.blockStreamingOut = 1;
                    return;
                }
                this.blockStreamingOut = -1;
            }
            try {
                this.session.write(byArray, n, n2, socketAddress);
                return;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.sendResponse: " + exception.toString());
            }
        }
        // MONITOREXIT : rTPPort
    }

    public synchronized void sessionOpened(IUDPTransportSession iUDPTransportSession) {
        block1: {
            IApplicationInstance iApplicationInstance;
            RTPStream rTPStream;
            this.session = iUDPTransportSession;
            if (this.track == null || (rTPStream = this.track.getRTPStream()) == null) break block1;
            int n = rTPStream.getUDPManagedDeliveryDelay();
            int n2 = rTPStream.getUDPManagedDeliveryCount();
            if (n > 0 && n2 > 0 && iUDPTransportSession instanceof RTPUDPTransportMinaSession && (iApplicationInstance = rTPStream.getAppInstance()) != null) {
                WMSLoggerFactory.getLogger(RTPPort.class).info("RTSPPort.sessionOpened[" + iApplicationInstance.getContextStr() + ":" + rTPStream.getStreamName() + "]: UDPManagedDelivery: count:" + n2 + " delay:" + n);
                RTPUDPTransportMinaSession rTPUDPTransportMinaSession = (RTPUDPTransportMinaSession)iUDPTransportSession;
                rTPUDPTransportMinaSession.session.setAttribute("udpManagedDeliveryDelay", (Object)new Integer(n));
                rTPUDPTransportMinaSession.session.setAttribute("udpManagedDeliveryCount", (Object)new Integer(n2));
            }
        }
    }

    public synchronized void sessionClosed(IUDPTransportSession iUDPTransportSession) {
        this.session = null;
    }

    public void handleMessage(SocketAddress socketAddress, Object object) {
        try {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            if (this.handler != null) {
                byte[] byArray = byteBuffer.array();
                this.handler.handleMessage(socketAddress, byArray, 0, byteBuffer.limit());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.handleMessage: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isInMulticast() {
        return this.isInMulticast;
    }

    public boolean isOutMulticast() {
        return this.isOutMulticast;
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public int getAddressCount() {
        return this.addressCount;
    }

    public void setAddressCount(int n) {
        this.addressCount = n;
    }
}

