/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.ts.TransportStreamUtils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.stream.IMediaStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerMPEGTS
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    public static final int PATINTERVAL = 90;
    public static final int PCRINTERVAL = 36;
    public static final int TS_PACKETLEN = 188;
    public static final int TS_RTPHEADER = 12;
    public static final int TS_SYNCBYTE = 71;
    public static final int TS_PACKETPERBLOCK = 7;
    public static final int TS_AUDIOGROUPCOUNT = 3;
    protected RTPTrack transportTrack = null;
    protected long lastPAT = -1L;
    protected byte[] block = null;
    protected int pcount = 0;
    protected int pptr = 0;
    protected int videoPID = 256;
    protected byte videoStreamID = (byte)-32;
    protected int videoCodec = -1;
    protected int audioPID = 257;
    protected byte audioStreamID = (byte)-64;
    protected int audioCodec = -1;
    protected long videoCCounter = -1L;
    protected long audioCCounter = -1L;
    protected long patCCounter = 0L;
    protected AACFrame aacFrame = null;
    protected H264CodecConfigParts h264CodecConfigPart = null;
    protected long lastAudioTimecode = -1L;
    protected long lastVideoTimecode = -1L;
    protected long lastPCRTimecode = -1L;
    protected boolean isFirstAudioPacket = true;
    protected boolean isFirstVideoPacket = true;
    protected WaitingAAC waitingAAC = new WaitingAAC();
    protected boolean inited = false;
    protected int pcrBufferTime = 750;
    protected boolean mpegtsFlushEveryPacket = false;
    protected int mpegtsPacketsPerBlock = 7;
    protected int mpegtsAudioGroupCount = 3;
    protected boolean mpegtsAlwaysSendZeroPacketLen = false;
    protected int lastAACSampleRate = -1;
    protected long lastAACTimecode = -1L;
    protected boolean debugAACTimecodes = false;

    public RTPPacketizerMPEGTS() {
        this.sdpTypeId = 98;
    }

    private void nextBlock(OutputStream outputStream, RTPTrack rTPTrack, long l) {
        if (this.block == null || this.pcount >= this.mpegtsPacketsPerBlock) {
            if (this.block != null) {
                this.flushBlock(outputStream, rTPTrack, false, l);
            }
            this.block = new byte[(this.isRTPWrapped ? 12 : 0) + this.mpegtsPacketsPerBlock * 188];
            this.pcount = 1;
            this.pptr = this.isRTPWrapped ? 12 : 0;
        } else {
            ++this.pcount;
            this.pptr += 188;
        }
    }

    private void forceFlush(OutputStream outputStream, RTPTrack rTPTrack, boolean bl, long l) {
        if (this.block != null) {
            this.flushBlock(outputStream, rTPTrack, bl, l);
        }
        this.block = null;
    }

    private void flushBlock(OutputStream outputStream, RTPTrack rTPTrack, boolean bl, long l) {
        block1: {
            if (this.block == null) break block1;
            if (this.isRTPWrapped) {
                long l2 = rTPTrack.getSSRC();
                this.fillHeader(this.block, false, this.sequence, l, l2, this.sdpTypeId);
                ++this.sequence;
            }
            int n = (this.isRTPWrapped ? 12 : 0) + this.pcount * 188;
            rTPTrack.sendRTPMessage(outputStream, this.block, 0, n);
        }
    }

    private int sendPAT(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, long l) {
        int n = 0;
        this.nextBlock(outputStream, this.transportTrack, l);
        n += 188;
        TransportStreamUtils.fillPAT(this.block, this.pptr, this.patCCounter);
        n += 188;
        int n2 = TransportStreamUtils.videoCodecToStreamType(this.videoCodec);
        int n3 = TransportStreamUtils.audioCodecToStreamType(this.audioCodec);
        this.nextBlock(outputStream, this.transportTrack, l);
        n += 188;
        TransportStreamUtils.fillPMT(this.block, this.pptr, this.patCCounter, this.videoPID, this.audioPID, n2, n3);
        ++this.patCCounter;
        return n += 188;
    }

    private long getPCRTimecode() {
        long l = -1L;
        if (this.lastAudioTimecode >= 0L && this.lastVideoTimecode >= 0L) {
            l = Math.min(this.lastAudioTimecode, this.lastVideoTimecode);
        } else if (this.lastAudioTimecode >= 0L) {
            l = this.lastAudioTimecode;
        } else if (this.lastVideoTimecode >= 0L) {
            l = this.lastVideoTimecode;
        }
        if (this.lastPCRTimecode != -1L && l < this.lastPCRTimecode) {
            l = this.lastPCRTimecode;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l >= (long)this.pcrBufferTime) {
            l -= (long)this.pcrBufferTime;
        }
        this.lastPCRTimecode = l;
        return l;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        long l2;
        int n;
        block78: {
            int n2;
            int n3;
            boolean bl;
            boolean bl2;
            int n4;
            int n5;
            int n6;
            Object object;
            boolean bl3;
            long l3;
            long l4;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            long l5;
            block79: {
                block82: {
                    int n12;
                    byte[] byArray;
                    block81: {
                        block80: {
                            n = 0;
                            l2 = l5 = l * 90L;
                            if (!this.inited) {
                                WMSProperties wMSProperties;
                                if (iMediaStream != null && (wMSProperties = iMediaStream.getProperties()) != null) {
                                    this.pcrBufferTime = wMSProperties.getPropertyInt("pcrBufferTime", this.pcrBufferTime);
                                    this.pcrBufferTime = wMSProperties.getPropertyInt("mpegtsPCRBufferTime", this.pcrBufferTime);
                                    this.mpegtsPacketsPerBlock = wMSProperties.getPropertyInt("mpegtsPacketsPerBlock", this.mpegtsPacketsPerBlock);
                                    this.mpegtsAudioGroupCount = wMSProperties.getPropertyInt("mpegtsAudioGroupCount", this.mpegtsAudioGroupCount);
                                    this.mpegtsFlushEveryPacket = wMSProperties.getPropertyBoolean("mpegtsFlushEveryPacket", this.mpegtsFlushEveryPacket);
                                    this.debugAACTimecodes = wMSProperties.getPropertyBoolean("mpegtsDebugAACTimecodes", this.debugAACTimecodes);
                                    this.mpegtsAlwaysSendZeroPacketLen = wMSProperties.getPropertyBoolean("mpegtsAlwaysSendZeroPacketLen", this.mpegtsAlwaysSendZeroPacketLen);
                                    if (this.mpegtsFlushEveryPacket) {
                                        WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).info("RTPPacketizerMPEGTS.handleAMFPacket: mpegtsFlushEveryPacket:" + this.mpegtsFlushEveryPacket);
                                    }
                                }
                                this.inited = true;
                            }
                            long l6 = System.currentTimeMillis();
                            if (this.lastPAT == -1L || l6 - this.lastPAT > 90L) {
                                this.lastPAT = l6;
                                n += this.sendPAT(outputStream, iMediaStream, rTPTrack, l5);
                            }
                            if (this.transportTrack == null) {
                                this.transportTrack = rTPTrack.getRTPStream().getTrack("mpegts-transport");
                            }
                            if (this.transportTrack == null) break block78;
                            RTPStream rTPStream = rTPTrack.getRTPStream();
                            if (aMFPacket.getSize() < 2) break block78;
                            n11 = aMFPacket.getType();
                            n10 = aMFPacket.getFirstByte();
                            n9 = aMFPacket.getSecondByte();
                            if (n11 != 8) break block79;
                            byArray = aMFPacket.getData();
                            n12 = aMFPacket.getSize();
                            n8 = FLVUtils.getAudioCodec(n10);
                            if (n8 != 10 || n9 == 1) break block80;
                            if (n9 == 0) {
                                this.aacFrame = AACUtils.decodeAACCodecConfig(byArray, 2);
                            }
                            break block78;
                        }
                        if (n8 == 10 && this.aacFrame == null) break block78;
                        if (n8 != 10) break block81;
                        if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.aacFrame.getSampleRate()) {
                            this.lastAACSampleRate = this.aacFrame.getSampleRate();
                            this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                        } else {
                            long l7 = this.lastAACTimecode + (long)this.aacFrame.getSampleCount();
                            long l8 = Math.round((double)l7 * 1000.0 / (double)this.lastAACSampleRate);
                            int n13 = (int)Math.abs(l8 - l);
                            if (this.debugAACTimecodes) {
                                System.out.println("tc[" + n13 + "]: " + l8 + ":" + l + ":" + this.lastAACSampleRate);
                            }
                            if (n13 <= 1) {
                                l5 = Math.round((double)(l7 * 90000L) / (double)this.lastAACSampleRate);
                                this.lastAACTimecode = l7;
                            } else {
                                this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                if (this.debugAACTimecodes) {
                                    System.out.println("reset: " + this.lastAACTimecode);
                                }
                            }
                        }
                        this.aacFrame.setSize(n12 - 2 + 7);
                        byte[] byArray2 = new byte[7];
                        AACUtils.frameToDTSBuffer(this.aacFrame, byArray2, 0);
                        this.waitingAAC.fragments.add(new RTPPacketFragment(byArray2, 0, byArray2.length));
                        this.waitingAAC.size += byArray2.length;
                        this.waitingAAC.fragments.add(new RTPPacketFragment(byArray, 2, n12 - 2));
                        this.waitingAAC.size += n12 - 2;
                        ++this.waitingAAC.count;
                        if (this.waitingAAC.timecode == -1L) {
                            this.waitingAAC.timecode = l;
                            this.waitingAAC.timecode90 = l5;
                        }
                        this.waitingAAC.lastTimecode = l;
                        this.waitingAAC.lastTimecode90 = l5;
                        break block82;
                    }
                    if (n8 != 2) break block78;
                    this.waitingAAC.fragments.add(new RTPPacketFragment(byArray, 1, n12 - 1));
                    this.waitingAAC.size += n12 - 1;
                    ++this.waitingAAC.count;
                    if (this.waitingAAC.timecode == -1L) {
                        this.waitingAAC.timecode = l;
                        this.waitingAAC.timecode90 = l5;
                    }
                    this.waitingAAC.lastTimecode = l;
                    this.waitingAAC.lastTimecode90 = l5;
                }
                if (this.waitingAAC.count < this.mpegtsAudioGroupCount) break block78;
                this.lastAudioTimecode = this.waitingAAC.timecode;
                n7 = this.waitingAAC.size;
                l3 = l4 = this.waitingAAC.timecode90;
                bl3 = false;
                int n14 = 0;
                object = this.waitingAAC.fragments.remove(0);
                n6 = 0;
                n5 = ((RTPPacketFragment)object).getOffset();
                n4 = ((RTPPacketFragment)object).getLen();
                byte[] byArray = ((RTPPacketFragment)object).getBuffer();
                bl2 = true;
                bl = false;
                long l9 = l4;
                if (this.videoCodec == -1) {
                    l9 = this.getPCRTimecode();
                    bl = true;
                }
                do {
                    long l10;
                    int n15;
                    int n16;
                    n3 = 0;
                    l2 = l4;
                    this.nextBlock(outputStream, this.transportTrack, l2);
                    n += 188;
                    this.block[this.pptr + n3] = 71;
                    this.block[this.pptr + ++n3] = (byte)((bl2 ? 64 : 0) + (0x1F & this.audioPID >> 8));
                    this.block[this.pptr + ++n3] = (byte)(this.audioPID & 0xFF);
                    this.audioCCounter = this.audioCCounter == -1L ? 1L : ++this.audioCCounter;
                    this.block[this.pptr + ++n3] = (byte)(16L + (this.audioCCounter & 0xFL));
                    ++n3;
                    int n17 = 0;
                    if (bl2) {
                        n17 = 9 + (bl3 ? 10 : 5);
                    }
                    if ((n16 = 188 - n3 - n17) > n7 - n14) {
                        n16 = n7 - n14;
                    }
                    if (bl) {
                        int n18 = this.pptr + 3;
                        this.block[n18] = (byte)(this.block[n18] | 0x20);
                        n15 = 8;
                        n16 = 188 - n3 - n17 - n15;
                        if (n16 > n7 - n14) {
                            n16 = n7 - n14;
                        }
                        if ((n2 = 188 - (n3 + n16 + n17 + n15)) < 0) {
                            n2 = 0;
                        }
                        this.block[this.pptr + n3] = (byte)(n15 - 1 + n2 & 0xFF);
                        this.block[this.pptr + ++n3] = (byte)(this.isFirstAudioPacket ? 144 : 16);
                        l10 = l9 * 90L;
                        byte[] byArray3 = BufferUtils.longToByteArray(l10 <<= 7);
                        this.block[this.pptr + ++n3 + 4] = (byte)((byArray3[7] & 0x80) + 126);
                        this.block[this.pptr + n3 + 3] = (byte)(byArray3[6] & 0xFF);
                        this.block[this.pptr + n3 + 2] = (byte)(byArray3[5] & 0xFF);
                        this.block[this.pptr + n3 + 1] = (byte)(byArray3[4] & 0xFF);
                        this.block[this.pptr + n3 + 0] = (byte)(byArray3[3] & 0xFF);
                        n3 += 6;
                        if (n2 > 0) {
                            System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n3, n2);
                            n3 += n2;
                        }
                        if ((n16 = 188 - n3 - n17) > n7 - n14) {
                            n16 = n7 - n14;
                        }
                    } else if (n3 + n16 + n17 < 188) {
                        n15 = 188 - (n3 + n16 + n17);
                        int n19 = this.pptr + 3;
                        this.block[n19] = (byte)(this.block[n19] | 0x20);
                        if (n15 > 1) {
                            this.block[this.pptr + n3] = (byte)(--n15 & 0xFF);
                            this.block[this.pptr + ++n3] = 0;
                            ++n3;
                            if (--n15 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n3, n15);
                            }
                            n3 += n15;
                        } else {
                            this.block[this.pptr + n3] = 0;
                            ++n3;
                        }
                    }
                    bl = false;
                    if (bl2) {
                        this.block[this.pptr + n3] = 0;
                        this.block[this.pptr + ++n3] = 0;
                        this.block[this.pptr + ++n3] = 1;
                        this.block[this.pptr + ++n3] = this.audioStreamID;
                        ++n3;
                        n15 = bl3 ? 10 : 5;
                        n2 = n7 + n15 + 3;
                        if (this.mpegtsAlwaysSendZeroPacketLen) {
                            n2 = 0;
                        }
                        BufferUtils.intToByteArray(n2, this.block, this.pptr + n3, 2);
                        this.block[this.pptr + (n3 += 2)] = -128;
                        this.block[this.pptr + ++n3] = (byte)(bl3 ? 192 : 128);
                        this.block[this.pptr + ++n3] = (byte)n15;
                        l10 = l3;
                        this.block[this.pptr + ++n3 + 4] = (byte)(((l10 & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n3 + 3] = (byte)((l10 >>= 7) & 0xFFL);
                        this.block[this.pptr + n3 + 2] = (byte)((((l10 >>= 8) & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n3 + 1] = (byte)((l10 >>= 7) & 0xFFL);
                        this.block[this.pptr + n3 + 0] = (byte)((((l10 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                        n3 += 5;
                        if (bl3) {
                            l10 = l4;
                            this.block[this.pptr + n3 + 4] = (byte)(((l10 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n3 + 3] = (byte)((l10 >>= 7) & 0xFFL);
                            this.block[this.pptr + n3 + 2] = (byte)((((l10 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n3 + 1] = (byte)((l10 >>= 7) & 0xFFL);
                            this.block[this.pptr + n3 + 0] = (byte)((((l10 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                            n3 += 5;
                        }
                    }
                    do {
                        if ((n15 = n16) > n4 - n6) {
                            n15 = n4 - n6;
                        }
                        System.arraycopy(byArray, n5 + n6, this.block, this.pptr + n3, n15);
                        n3 += n15;
                        n14 += n15;
                        n16 -= n15;
                        if ((n6 += n15) < n4) continue;
                        n6 = 0;
                        if (this.waitingAAC.fragments.size() <= 0) continue;
                        object = this.waitingAAC.fragments.remove(0);
                        n5 = ((RTPPacketFragment)object).getOffset();
                        n4 = ((RTPPacketFragment)object).getLen();
                        byArray = ((RTPPacketFragment)object).getBuffer();
                    } while (n3 < 188 && n14 < n7);
                    bl2 = false;
                    this.isFirstAudioPacket = false;
                } while (n14 < n7);
                this.waitingAAC.clear();
            }
            if (n11 == 9) {
                this.lastVideoTimecode = l;
                int n20 = FLVUtils.getVideoCodec(n10);
                byte[] byArray = aMFPacket.getData();
                n8 = aMFPacket.getSize();
                if (n20 == 7 && n9 != 1) {
                    if (n9 == 0) {
                        this.h264CodecConfigPart = H264Utils.breakApartAVCC(byArray, 5, n8 - 5);
                        H264CodecConfigInfo h264CodecConfigInfo = H264Utils.decodeAVCC(byArray, 5);
                    }
                } else {
                    int n21;
                    int n22;
                    n7 = BufferUtils.byteArrayToInt(byArray, 2, 3);
                    if ((n7 & 0x800000) == 0x800000) {
                        n7 |= 0xFF000000;
                    }
                    l4 = l * 90L;
                    l3 = n7 == 0 ? l4 : (l + (long)n7) * 90L;
                    bl3 = n7 != 0;
                    ArrayList<RTPPacketFragment> arrayList = new ArrayList<RTPPacketFragment>();
                    object = new byte[4];
                    object[3] = 1;
                    n6 = 0;
                    n5 = 0;
                    n4 = 5;
                    boolean bl4 = false;
                    bl2 = false;
                    bl = false;
                    while (n4 + 4 <= n8 && (n22 = BufferUtils.byteArrayToInt(byArray, n4, 4)) > 0 && (n4 += 4) + n22 <= n8) {
                        n21 = byArray[n4] & 0x1F;
                        if (n21 == 7) {
                            bl4 = true;
                        } else if (n21 == 8) {
                            bl2 = true;
                        } else if (n21 == 9) {
                            bl = true;
                        }
                        arrayList.add(new RTPPacketFragment((byte[])object, 0, ((Object)object).length));
                        arrayList.add(new RTPPacketFragment(byArray, n4, n22));
                        n6 += n22 + ((Object)object).length;
                        ++n5;
                        if ((n4 += n22) < n8) continue;
                        break;
                    }
                    boolean bl5 = false;
                    n21 = FLVUtils.getFrameType(n10);
                    n3 = 0;
                    if (!bl) {
                        if (!bl) {
                            byte[] byArray4 = new byte[6];
                            byArray4[3] = 1;
                            byArray4[4] = 9;
                            byArray4[5] = n21 == 1 ? 16 : (n21 == 3 ? 80 : 48);
                            arrayList.add(n3, new RTPPacketFragment(byArray4, 0, byArray4.length));
                            ++n3;
                            n6 += byArray4.length;
                            ++n5;
                            bl5 = true;
                        }
                    } else {
                        n3 += 2;
                    }
                    if (!(n21 != 1 || bl2 && bl)) {
                        if (n21 == 1 && !bl4 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.sps != null) {
                            byte[] byArray5 = new byte[4];
                            byArray5[3] = 1;
                            arrayList.add(n3, new RTPPacketFragment(byArray5, 0, byArray5.length));
                            arrayList.add(++n3, new RTPPacketFragment(this.h264CodecConfigPart.sps, 0, this.h264CodecConfigPart.sps.length));
                            ++n3;
                            n6 += this.h264CodecConfigPart.sps.length + byArray5.length;
                            ++n5;
                            bl5 = true;
                        }
                        if (n21 == 1 && !bl2 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.ppss != null) {
                            for (byte[] byArray6 : this.h264CodecConfigPart.ppss) {
                                byte[] byArray7 = new byte[4];
                                byArray7[3] = 1;
                                arrayList.add(n3, new RTPPacketFragment(byArray7, 0, byArray7.length));
                                arrayList.add(++n3, new RTPPacketFragment(byArray6, 0, byArray6.length));
                                ++n3;
                                n6 += byArray6.length + byArray7.length;
                                ++n5;
                                bl5 = true;
                            }
                        }
                    }
                    if (n5 > 0) {
                        int n23 = 0;
                        RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                        int n24 = 0;
                        n2 = rTPPacketFragment.getOffset();
                        int n25 = rTPPacketFragment.getLen();
                        byte[] byArray8 = rTPPacketFragment.getBuffer();
                        long l11 = this.getPCRTimecode();
                        boolean bl6 = true;
                        boolean bl7 = true;
                        int n26 = 65522;
                        if (this.mpegtsAlwaysSendZeroPacketLen) {
                            n26 = Integer.MAX_VALUE;
                        }
                        do {
                            bl6 = true;
                            bl7 = true;
                            int n27 = 0;
                            int n28 = n6 - n23;
                            if (n28 > n26) {
                                n28 = n26;
                            }
                            do {
                                long l12;
                                int n29;
                                int n30;
                                int n31;
                                int n32 = 0;
                                l2 = l5;
                                this.nextBlock(outputStream, this.transportTrack, l2);
                                n += 188;
                                this.block[this.pptr + n32] = 71;
                                this.block[this.pptr + ++n32] = (byte)((bl6 ? 64 : 0) + (0x1F & this.videoPID >> 8));
                                this.block[this.pptr + ++n32] = (byte)(this.videoPID & 0xFF);
                                this.videoCCounter = this.videoCCounter == -1L ? 1L : ++this.videoCCounter;
                                this.block[this.pptr + ++n32] = (byte)(16L + (this.videoCCounter & 0xFL));
                                ++n32;
                                int n33 = 0;
                                if (bl6) {
                                    n33 = 9 + (bl3 ? 10 : 5);
                                }
                                if ((n31 = 188 - n32 - n33) > n28 - n27) {
                                    n31 = n28 - n27;
                                }
                                if (bl7) {
                                    int n34 = this.pptr + 3;
                                    this.block[n34] = (byte)(this.block[n34] | 0x20);
                                    n30 = 8;
                                    n31 = 188 - n32 - n33 - n30;
                                    if (n31 > n28 - n27) {
                                        n31 = n28 - n27;
                                    }
                                    n29 = 0;
                                    if (n32 + n31 + n33 + n30 < 188) {
                                        n29 = 188 - (n32 + n31 + n33 + n30);
                                    }
                                    this.block[this.pptr + n32] = (byte)(n30 - 1 + n29 & 0xFF);
                                    this.block[this.pptr + ++n32] = (byte)((this.isFirstVideoPacket ? 144 : 16) | (n21 == 1 ? 64 : 0));
                                    l12 = l11 * 90L;
                                    byte[] byArray9 = BufferUtils.longToByteArray(l12 <<= 7);
                                    this.block[this.pptr + ++n32 + 4] = (byte)((byArray9[7] & 0x80) + 126);
                                    this.block[this.pptr + n32 + 3] = (byte)(byArray9[6] & 0xFF);
                                    this.block[this.pptr + n32 + 2] = (byte)(byArray9[5] & 0xFF);
                                    this.block[this.pptr + n32 + 1] = (byte)(byArray9[4] & 0xFF);
                                    this.block[this.pptr + n32 + 0] = (byte)(byArray9[3] & 0xFF);
                                    n32 += 6;
                                    if (n29 > 0) {
                                        System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n32, n29);
                                        n32 += n29;
                                    }
                                    if ((n31 = 188 - n32 - n33) > n28 - n27) {
                                        n31 = n28 - n27;
                                    }
                                } else if (n32 + n31 + n33 < 188) {
                                    n30 = 188 - (n32 + n31 + n33);
                                    int n35 = this.pptr + 3;
                                    this.block[n35] = (byte)(this.block[n35] | 0x20);
                                    if (n30 > 1) {
                                        this.block[this.pptr + n32] = (byte)(--n30 & 0xFF);
                                        this.block[this.pptr + ++n32] = 0;
                                        ++n32;
                                        if (--n30 > 0) {
                                            System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n32, n30);
                                        }
                                        n32 += n30;
                                    } else {
                                        this.block[this.pptr + n32] = 0;
                                        ++n32;
                                    }
                                }
                                bl7 = false;
                                if (bl6) {
                                    this.block[this.pptr + n32] = 0;
                                    this.block[this.pptr + ++n32] = 0;
                                    this.block[this.pptr + ++n32] = 1;
                                    this.block[this.pptr + ++n32] = this.videoStreamID;
                                    ++n32;
                                    n30 = bl3 ? 10 : 5;
                                    n29 = n28 + n30 + 3;
                                    if (this.mpegtsAlwaysSendZeroPacketLen) {
                                        n29 = 0;
                                    }
                                    if (n29 >= 65536) {
                                        System.out.println("toolong: " + n29);
                                    }
                                    BufferUtils.intToByteArray(n29, this.block, this.pptr + n32, 2);
                                    this.block[this.pptr + (n32 += 2)] = -124;
                                    this.block[this.pptr + ++n32] = (byte)(bl3 ? 192 : 128);
                                    this.block[this.pptr + ++n32] = (byte)n30;
                                    l12 = l3;
                                    this.block[this.pptr + ++n32 + 4] = (byte)(((l12 & 0x7FL) << 1) + 1L);
                                    this.block[this.pptr + n32 + 3] = (byte)((l12 >>= 7) & 0xFFL);
                                    this.block[this.pptr + n32 + 2] = (byte)((((l12 >>= 8) & 0x7FL) << 1) + 1L);
                                    this.block[this.pptr + n32 + 1] = (byte)((l12 >>= 7) & 0xFFL);
                                    this.block[this.pptr + n32 + 0] = (byte)((((l12 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                                    n32 += 5;
                                    if (bl3) {
                                        l12 = l4;
                                        this.block[this.pptr + n32 + 4] = (byte)(((l12 & 0x7FL) << 1) + 1L);
                                        this.block[this.pptr + n32 + 3] = (byte)((l12 >>= 7) & 0xFFL);
                                        this.block[this.pptr + n32 + 2] = (byte)((((l12 >>= 8) & 0x7FL) << 1) + 1L);
                                        this.block[this.pptr + n32 + 1] = (byte)((l12 >>= 7) & 0xFFL);
                                        this.block[this.pptr + n32 + 0] = (byte)((((l12 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                                        n32 += 5;
                                    }
                                }
                                do {
                                    if ((n30 = n31) > n25 - n24) {
                                        n30 = n25 - n24;
                                    }
                                    System.arraycopy(byArray8, n2 + n24, this.block, this.pptr + n32, n30);
                                    n32 += n30;
                                    n23 += n30;
                                    n31 -= n30;
                                    n27 += n30;
                                    if ((n24 += n30) < n25) continue;
                                    n24 = 0;
                                    if (arrayList.size() <= 0) continue;
                                    rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                                    n2 = rTPPacketFragment.getOffset();
                                    n25 = rTPPacketFragment.getLen();
                                    byArray8 = rTPPacketFragment.getBuffer();
                                } while (n32 < 188 && n27 < n28 && n23 < n6);
                                bl6 = false;
                                this.isFirstVideoPacket = false;
                            } while (n27 < n28 && n23 < n6);
                        } while (n23 < n6);
                    }
                }
            }
        }
        if (this.transportTrack != null && n > 0 && this.mpegtsFlushEveryPacket) {
            this.forceFlush(outputStream, this.transportTrack, false, l2);
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        int n = 0;
        return n;
    }

    public void extractStreamInfo(RTPTrack rTPTrack, AMFPacket aMFPacket, AMFPacket aMFPacket2) {
        if (aMFPacket != null) {
            if (aMFPacket.getType() == 8) {
                this.audioCodec = FLVUtils.getAudioCodec(aMFPacket);
            } else if (aMFPacket.getType() == 9) {
                this.videoCodec = FLVUtils.getVideoCodec(aMFPacket);
            }
        }
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 90000;
        try {
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " MP2T/" + n2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(n2);
        rTPDescribeInfo.setSDPTypeId(this.sdpTypeId);
        return rTPDescribeInfo;
    }

    class WaitingAAC {
        long timecode = -1L;
        long timecode90 = -1L;
        long lastTimecode = -1L;
        long lastTimecode90 = -1L;
        int count = 0;
        int size = 0;
        List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();

        WaitingAAC() {
        }

        public void clear() {
            this.timecode = -1L;
            this.lastTimecode = -1L;
            this.count = 0;
            this.size = 0;
            this.fragments.clear();
        }
    }
}

