/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.HostPortConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramSessionConfigImpl;

public class RTPUDPDatagramConfig
extends DatagramSessionConfigImpl {
    private int multicastTimeout = 250;
    private boolean multicastBindToAddress = true;
    private int datagramMaximumPacketSize = 8192;
    private String multicastInterfaceAddress = null;

    public RTPUDPDatagramConfig clone() {
        return this.clone();
    }

    public void configureSessionConfig(DatagramSessionConfig datagramSessionConfig) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HostPortConfig.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        try {
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setReuseAddress: from:" + datagramSessionConfig.isReuseAddress() + " to:" + this.isReuseAddress());
            }
            datagramSessionConfig.setReuseAddress(this.isReuseAddress());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setReceiveBufferSize: from:" + datagramSessionConfig.getReceiveBufferSize() + " to:" + this.getReceiveBufferSize());
            }
            datagramSessionConfig.setReceiveBufferSize(this.getReceiveBufferSize());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setSendBufferSize: from:" + datagramSessionConfig.getSendBufferSize() + " to:" + this.getSendBufferSize());
            }
            datagramSessionConfig.setSendBufferSize(this.getSendBufferSize());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setTrafficClass: from:" + datagramSessionConfig.getTrafficClass() + " to:" + this.getTrafficClass());
            }
            datagramSessionConfig.setTrafficClass(this.getTrafficClass());
            datagramSessionConfig.setDatagramMaximumPacketSize(this.getDatagramMaximumPacketSize());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPortConfig.class).error("configureSessionConfig: " + exception.toString());
        }
    }

    public int getMulticastTimeout() {
        return this.multicastTimeout;
    }

    public void setMulticastTimeout(int n) {
        this.multicastTimeout = n;
    }

    public boolean isMulticastBindToAddress() {
        return this.multicastBindToAddress;
    }

    public void setMulticastBindToAddress(boolean bl) {
        this.multicastBindToAddress = bl;
    }

    public int getDatagramMaximumPacketSize() {
        return this.datagramMaximumPacketSize;
    }

    public void setDatagramMaximumPacketSize(int n) {
        this.datagramMaximumPacketSize = n;
    }

    public String getMulticastInterfaceAddress() {
        return this.multicastInterfaceAddress;
    }

    public void setMulticastInterfaceAddress(String string) {
        this.multicastInterfaceAddress = string;
    }
}

