/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.rtp.transport.UDPTransportUnicastAcceptor;
import com.wowza.wms.rtp.transport.UDPTransportUnicastConnector;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.IoSession;

public class UDPTransportManager {
    private IVHost vhost = null;
    private int unicastIncomingProcessorCount = 2;
    private int unicastOutgoingProcessorCount = 4;
    private int multicastIncomingProcessorCount = 1;
    private int multicastOutgoingProcessorCount = 1;
    private Object lock = new Object();
    private List<UDPTransportUnicastAcceptor> unicastAcceptors = new ArrayList<UDPTransportUnicastAcceptor>();
    private int acceptorIndex = 0;
    private List<UDPTransportUnicastConnector> unicastConnectors = new ArrayList<UDPTransportUnicastConnector>();
    private int connectorIndex = 0;
    private List<IoSession> sessionsToKill = new ArrayList<IoSession>();

    public void init(IVHost iVHost) {
        this.vhost = iVHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSession(IoSession ioSession) {
        List<IoSession> list = this.sessionsToKill;
        synchronized (list) {
            this.sessionsToKill.add(ioSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIdle() {
        ArrayList<IoSession> arrayList = new ArrayList<IoSession>();
        List<IoSession> list = this.sessionsToKill;
        synchronized (list) {
            arrayList.addAll(this.sessionsToKill);
            this.sessionsToKill.clear();
        }
        for (IoSession ioSession : arrayList) {
            try {
                ioSession.close();
            }
            catch (Exception exception) {}
        }
        arrayList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPTransportUnicastAcceptor getNextAcceptor() {
        UDPTransportUnicastAcceptor uDPTransportUnicastAcceptor = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.acceptorIndex >= this.unicastAcceptors.size()) {
                this.unicastAcceptors.add(UDPTransportUnicastAcceptor.newInstance(this.vhost));
            }
            uDPTransportUnicastAcceptor = this.unicastAcceptors.get(this.acceptorIndex);
            this.acceptorIndex = (this.acceptorIndex + 1) % this.unicastIncomingProcessorCount;
        }
        return uDPTransportUnicastAcceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPTransportUnicastConnector getNextConnector() {
        UDPTransportUnicastConnector uDPTransportUnicastConnector = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectorIndex >= this.unicastConnectors.size()) {
                this.unicastConnectors.add(UDPTransportUnicastConnector.newInstance(this.vhost));
            }
            uDPTransportUnicastConnector = this.unicastConnectors.get(this.connectorIndex);
            this.connectorIndex = (this.connectorIndex + 1) % this.unicastOutgoingProcessorCount;
        }
        return uDPTransportUnicastConnector;
    }

    public int getUnicastIncomingProcessorCount() {
        return this.unicastIncomingProcessorCount;
    }

    public void setUnicastIncomingProcessorCount(int n) {
        this.unicastIncomingProcessorCount = n;
    }

    public int getUnicastOutgoingProcessorCount() {
        return this.unicastOutgoingProcessorCount;
    }

    public void setUnicastOutgoingProcessorCount(int n) {
        this.unicastOutgoingProcessorCount = n;
    }

    public int getMulticastIncomingProcessorCount() {
        return this.multicastIncomingProcessorCount;
    }

    public void setMulticastIncomingProcessorCount(int n) {
        this.multicastIncomingProcessorCount = n;
    }

    public int getMulticastOutgoingProcessorCount() {
        return this.multicastOutgoingProcessorCount;
    }

    public void setMulticastOutgoingProcessorCount(int n) {
        this.multicastOutgoingProcessorCount = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{UDPTransportManager: ");
        stringBuffer.append("unicastIncomingProcessorCount: " + this.unicastIncomingProcessorCount + ",");
        stringBuffer.append("unicastOutgoingProcessorCount: " + this.unicastOutgoingProcessorCount + ",");
        stringBuffer.append("multicastIncomingProcessorCount: " + this.multicastIncomingProcessorCount + ",");
        stringBuffer.append("multicastOutgoingProcessorCount: " + this.multicastOutgoingProcessorCount + ",");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

