/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceCommandHandler;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.Server;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class CommandInterface
extends IoHandlerAdapter {
    public static final String DATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss";
    public static final String QUERY_ACTION = "action";
    public static final int MESSAGE_DATE_TOLERANCE = 60000;
    private IServer server = null;
    private CommandInterfaceCommandHandler handler = null;
    private int messageDateTolerance = 60000;
    private boolean secure = true;
    private FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);

    public CommandInterface(IServer iServer) {
        this.server = iServer;
        this.handler = iServer.getCommandInterfaceCommandHandler();
        WMSProperties wMSProperties = this.server.getProperties();
        this.messageDateTolerance = wMSProperties.getPropertyInt("commandInterfaceMessageDateTolerance", this.messageDateTolerance);
        this.secure = wMSProperties.getPropertyBoolean("commandInterfaceMessageSecure", this.secure);
    }

    public void sessionCreated(IoSession ioSession) {
    }

    public void sessionOpened(IoSession ioSession) {
        ioSession.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, 10000L);
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
    }

    public String getHTTPDate() {
        return this.fastDateFormat.format(new Date()) + " GMT";
    }

    private static byte[] getServerCommandEncryptionKey(String string, String string2) {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest((string + ":" + string2).getBytes("UTF-8"));
            if (byArray2 != null) {
                byArray = new byte[16];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.getServerCommandEncryptionKey: " + exception.toString());
        }
        return byArray;
    }

    private static String signServerCommand(String string) {
        String string2 = null;
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.signServerCommand: " + exception.toString());
        }
        if (byArray != null) {
            string2 = BufferUtils.encodeHexString(byArray);
        }
        return string2;
    }

    public static String httpDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + "GMT";
    }

    public static Date parseHTTPDate(String string) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.parseHTTPDate[" + string + "]: " + exception.toString());
        }
        return date;
    }

    private static byte[] decryptMessageServerCommand(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.decryptMessageServerCommand: " + exception.toString());
        }
        return byArray3;
    }

    private static byte[] encryptMessageServerCommand(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.encryptMessageServerCommand: " + exception.toString());
        }
        return byArray3;
    }

    private boolean validateAndDecryptMessage(CommandInterfaceRequestMessage commandInterfaceRequestMessage, CommandInterfaceResponseMessage commandInterfaceResponseMessage) {
        boolean bl = false;
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5 = ((Server)this.server).getGUID();
            if (string5 != null && (string4 = commandInterfaceRequestMessage.getMethod()) != null && (string3 = commandInterfaceRequestMessage.getPath()) != null && (string2 = commandInterfaceRequestMessage.getProtocolStr()) != null && (string = commandInterfaceRequestMessage.getHeader("date")) != null) {
                long l = commandInterfaceRequestMessage.getContentLength();
                Date date = CommandInterface.parseHTTPDate(string);
                if (date != null) {
                    Date date2 = new Date();
                    long l2 = Math.abs(date2.getTime() - date.getTime());
                    if (this.messageDateTolerance <= 0 || l2 <= (long)this.messageDateTolerance) {
                        String[] stringArray;
                        String string6;
                        String string7 = string4 + "\n" + string3 + "\n" + string2 + "\n" + string + "\n" + l + "\n" + string5;
                        String string8 = CommandInterface.signServerCommand(string7);
                        byte[] byArray = CommandInterface.getServerCommandEncryptionKey(string5, string8);
                        if (commandInterfaceResponseMessage != null) {
                            commandInterfaceResponseMessage.setEncryptionKey(byArray);
                        }
                        if ((string6 = commandInterfaceRequestMessage.getHeader("authorization")) != null && (stringArray = (string6 = string6.trim()).split(" ")).length >= 2 && stringArray[1].equals(string8)) {
                            boolean bl2 = true;
                            if (l > 0L) {
                                byte[] byArray2;
                                byte[] byArray3;
                                bl2 = false;
                                if (byArray != null && (byArray3 = commandInterfaceRequestMessage.getBody()) != null && (byArray2 = CommandInterface.decryptMessageServerCommand(byArray, byArray3)) != null) {
                                    commandInterfaceRequestMessage.setBody(byArray2);
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.validateAndDecryptMessage: " + exception.toString());
        }
        return bl;
    }

    public void messageReceived(IoSession ioSession, Object object) {
        Object object2;
        boolean bl;
        if (!(object instanceof CommandInterfaceRequestMessage)) {
            return;
        }
        CommandInterfaceRequestMessage commandInterfaceRequestMessage = (CommandInterfaceRequestMessage)object;
        CommandInterfaceResponseMessage commandInterfaceResponseMessage = null;
        commandInterfaceRequestMessage.setIoSession(ioSession);
        commandInterfaceResponseMessage = new CommandInterfaceResponseMessage();
        if (this.secure && !(bl = this.validateAndDecryptMessage(commandInterfaceRequestMessage, commandInterfaceResponseMessage))) {
            WMSLoggerFactory.getLogger(CommandInterface.class).warn("CommandInterface.messageReceived: Message authorization failed.");
            commandInterfaceResponseMessage.setResponseCode(404);
        } else {
            String string = commandInterfaceRequestMessage.getQueryParam(QUERY_ACTION);
            if (string == null) {
                WMSLoggerFactory.getLogger(CommandInterface.class).warn("CommandInterface.messageReceived: Command not specified [query param action].");
                commandInterfaceResponseMessage.setResponseCode(404);
            } else {
                object2 = this.handler.getCommand(string = string.toLowerCase(), commandInterfaceRequestMessage);
                if (object2 == null) {
                    WMSLoggerFactory.getLogger(CommandInterface.class).warn("CommandInterface.messageReceived: Command not found: " + string);
                    commandInterfaceResponseMessage.setResponseCode(404);
                } else {
                    try {
                        object2.invoke(commandInterfaceRequestMessage, commandInterfaceResponseMessage);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(CommandInterface.class).warn("CommandInterface.messageReceived[invoke]: " + exception.toString());
                        commandInterfaceResponseMessage.setResponseCode(500);
                    }
                }
            }
        }
        if (commandInterfaceResponseMessage != null) {
            byte[] byArray;
            byte[] byArray2 = commandInterfaceResponseMessage.getBody();
            object2 = commandInterfaceResponseMessage.getEncryptionKey();
            if (byArray2 != null && object2 != null && (byArray = CommandInterface.encryptMessageServerCommand((byte[])object2, byArray2)) != null) {
                commandInterfaceResponseMessage.setBody(byArray);
            }
            try {
                ioSession.write((Object)commandInterfaceResponseMessage);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CommandInterface.class).error("CommandInterface.messageReceived[write]: " + exception.toString());
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        ioSession.close();
    }

    public int getMessageDateTolerance() {
        return this.messageDateTolerance;
    }

    public void setMessageDateTolerance(int n) {
        this.messageDateTolerance = n;
    }
}

