/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.ICommandInterfaceCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandInterfaceCommandHandler {
    private Map<String, List<ICommandInterfaceCommand>> commands = new HashMap<String, List<ICommandInterfaceCommand>>();
    private Object lock = new Object();

    public void addCommand(String string, String string2) {
        this.addCommand(string, string2, -1);
    }

    public void addCommand(String string, ICommandInterfaceCommand iCommandInterfaceCommand) {
        this.addCommand(string, iCommandInterfaceCommand, -1);
    }

    public void addCommand(String string, String string2, int n) {
        ICommandInterfaceCommand iCommandInterfaceCommand;
        block4: {
            iCommandInterfaceCommand = null;
            try {
                Class<?> clazz;
                do {
                    if ((clazz = Class.forName(string2)) != null) continue;
                    WMSLoggerFactory.getLogger(CommandInterfaceCommandHandler.class).warn("CommandInterfaceCommandHandler.addCommand: Class path not found: " + string2);
                    break block4;
                } while ((iCommandInterfaceCommand = (ICommandInterfaceCommand)clazz.newInstance()) != null);
                WMSLoggerFactory.getLogger(CommandInterfaceCommandHandler.class).warn("CommandInterfaceCommandHandler.addCommand: Class count not be instantiated: " + string2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CommandInterfaceCommandHandler.class).error("CommandInterfaceCommandHandler.addCommand: " + exception.toString());
            }
        }
        if (iCommandInterfaceCommand != null) {
            this.addCommand(string, iCommandInterfaceCommand, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(String string, ICommandInterfaceCommand iCommandInterfaceCommand, int n) {
        Object object = this.lock;
        synchronized (object) {
            List<ICommandInterfaceCommand> list = this.commands.get(string);
            if (list == null) {
                list = new ArrayList<ICommandInterfaceCommand>();
                this.commands.put(string, list);
            }
            if (n < 0 || n >= list.size()) {
                list.add(iCommandInterfaceCommand);
            } else {
                list.add(n, iCommandInterfaceCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCommandNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            hashSet.addAll(this.commands.keySet());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICommandInterfaceCommand> getCommands(String string) {
        ArrayList<ICommandInterfaceCommand> arrayList = new ArrayList<ICommandInterfaceCommand>();
        Object object = this.lock;
        synchronized (object) {
            List<ICommandInterfaceCommand> list = this.commands.get(string);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommandInterfaceCommand getCommand(String string, CommandInterfaceRequestMessage commandInterfaceRequestMessage) {
        ICommandInterfaceCommand iCommandInterfaceCommand = null;
        Object object = this.lock;
        synchronized (object) {
            List<ICommandInterfaceCommand> list = this.commands.get(string);
            if (list != null) {
                for (ICommandInterfaceCommand iCommandInterfaceCommand2 : list) {
                    boolean bl = false;
                    try {
                        bl = iCommandInterfaceCommand2.canHandle(commandInterfaceRequestMessage);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) continue;
                    iCommandInterfaceCommand = iCommandInterfaceCommand2;
                    break;
                }
            }
        }
        return iCommandInterfaceCommand;
    }
}

