/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderItem;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiveStreamTranscoderUtils {
    public static LiveStreamTranscoderItem loadLiveStreamTranscoderItem(IVHost iVHost, Element element) {
        LiveStreamTranscoderItem liveStreamTranscoderItem = null;
        try {
            Element element2 = element;
            Node node = XMLUtils.getNodeByTagName(element2, "Name");
            Node node2 = XMLUtils.getNodeByTagName(element2, "Description");
            Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
            Node node4 = XMLUtils.getNodeByTagName(element2, "ProfileDir");
            Node node5 = XMLUtils.getNodeByTagName(element2, "TemplateDir");
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "Properties/Property";
            XPathExpression xPathExpression = xPath.compile(string);
            if (node != null && node3 != null) {
                String string2 = XMLUtils.getNodeValue(node);
                String string3 = XMLUtils.getNodeValue(node2);
                String string4 = XMLUtils.getNodeValue(node3);
                liveStreamTranscoderItem = new LiveStreamTranscoderItem(string2, string4);
                if (string3 != null) {
                    liveStreamTranscoderItem.setDescription(string3);
                }
                WMSProperties wMSProperties = liveStreamTranscoderItem.getProperties();
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                if (nodeList != null) {
                    XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(liveStreamTranscoderItem.toString());
            } else {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("LiveStreamTranscoderUtils.loadMediaCaster: Error parsing server properties: Name, BaseClass, ProfileDir and TemplateDir are required.");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("LiveStreamTranscoderUtils.loadMediaCaster: Error parsing properties: " + exception.toString());
            exception.printStackTrace();
        }
        return liveStreamTranscoderItem;
    }

    public static void loadLiveStreamTranscoderList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    LiveStreamTranscoderItem liveStreamTranscoderItem = LiveStreamTranscoderUtils.loadLiveStreamTranscoderItem(iVHost, element2);
                    iVHost.getLiveStreamTranscoderList().getLiveStreamTranscoderDefs().put(liveStreamTranscoderItem.getName(), liveStreamTranscoderItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("LiveStreamTranscoderUtils.loadLiveStreamTranscoderList: Error load LiveStreamTranscoderList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/LiveStreamTranscoders/LiveStreamTranscoder";
                LiveStreamTranscoderUtils.loadLiveStreamTranscoderList(element, string2, iVHost);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("LiveStreamTranscoderUtils.loadConfigFile: Error parsing LiveStreamTranscoders config file (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }
}

